/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.core.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.migrationhub.model.MigrationHubRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class CreateProgressUpdateStreamRequest
extends MigrationHubRequest
implements ToCopyableBuilder<Builder, CreateProgressUpdateStreamRequest> {
    private final String progressUpdateStreamName;
    private final Boolean dryRun;

    private CreateProgressUpdateStreamRequest(BuilderImpl builder) {
        super(builder);
        this.progressUpdateStreamName = builder.progressUpdateStreamName;
        this.dryRun = builder.dryRun;
    }

    public String progressUpdateStreamName() {
        return this.progressUpdateStreamName;
    }

    public Boolean dryRun() {
        return this.dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.progressUpdateStreamName());
        hashCode = 31 * hashCode + Objects.hashCode(this.dryRun());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateProgressUpdateStreamRequest)) {
            return false;
        }
        CreateProgressUpdateStreamRequest other = (CreateProgressUpdateStreamRequest)((Object)obj);
        return Objects.equals(this.progressUpdateStreamName(), other.progressUpdateStreamName()) && Objects.equals(this.dryRun(), other.dryRun());
    }

    public String toString() {
        return ToString.builder((String)"CreateProgressUpdateStreamRequest").add("ProgressUpdateStreamName", (Object)this.progressUpdateStreamName()).add("DryRun", (Object)this.dryRun()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProgressUpdateStreamName": {
                return Optional.of(clazz.cast(this.progressUpdateStreamName()));
            }
            case "DryRun": {
                return Optional.of(clazz.cast(this.dryRun()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MigrationHubRequest.BuilderImpl
    implements Builder {
        private String progressUpdateStreamName;
        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateProgressUpdateStreamRequest model) {
            this.progressUpdateStreamName(model.progressUpdateStreamName);
            this.dryRun(model.dryRun);
        }

        public final String getProgressUpdateStreamName() {
            return this.progressUpdateStreamName;
        }

        @Override
        public final Builder progressUpdateStreamName(String progressUpdateStreamName) {
            this.progressUpdateStreamName = progressUpdateStreamName;
            return this;
        }

        public final void setProgressUpdateStreamName(String progressUpdateStreamName) {
            this.progressUpdateStreamName = progressUpdateStreamName;
        }

        public final Boolean getDryRun() {
            return this.dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public CreateProgressUpdateStreamRequest build() {
            return new CreateProgressUpdateStreamRequest(this);
        }
    }

    public static interface Builder
    extends MigrationHubRequest.Builder,
    CopyableBuilder<Builder, CreateProgressUpdateStreamRequest> {
        public Builder progressUpdateStreamName(String var1);

        public Builder dryRun(Boolean var1);

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);
    }
}

