/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.migrationhub.model.ResourceAttribute;

@SdkInternalApi
public class ResourceAttributeMarshaller {
    private static final MarshallingInfo<String> TYPE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Type").build();
    private static final MarshallingInfo<String> VALUE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Value").build();
    private static final ResourceAttributeMarshaller INSTANCE = new ResourceAttributeMarshaller();

    public static ResourceAttributeMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResourceAttribute resourceAttribute, ProtocolMarshaller protocolMarshaller) {
        if (resourceAttribute == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)resourceAttribute.typeString(), TYPE_BINDING);
            protocolMarshaller.marshall((Object)resourceAttribute.value(), VALUE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

