/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.transform;

import java.time.Instant;
import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.migrationhub.model.MigrationTask;

@SdkInternalApi
public class MigrationTaskMarshaller {
    private static final MarshallingInfo<String> PROGRESSUPDATESTREAM_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ProgressUpdateStream").build();
    private static final MarshallingInfo<String> MIGRATIONTASKNAME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("MigrationTaskName").build();
    private static final MarshallingInfo<StructuredPojo> TASK_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Task").build();
    private static final MarshallingInfo<Instant> UPDATEDATETIME_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.INSTANT).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("UpdateDateTime").build();
    private static final MarshallingInfo<List> RESOURCEATTRIBUTELIST_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResourceAttributeList").build();
    private static final MigrationTaskMarshaller INSTANCE = new MigrationTaskMarshaller();

    public static MigrationTaskMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(MigrationTask migrationTask, ProtocolMarshaller protocolMarshaller) {
        if (migrationTask == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        try {
            protocolMarshaller.marshall((Object)migrationTask.progressUpdateStream(), PROGRESSUPDATESTREAM_BINDING);
            protocolMarshaller.marshall((Object)migrationTask.migrationTaskName(), MIGRATIONTASKNAME_BINDING);
            protocolMarshaller.marshall((Object)migrationTask.task(), TASK_BINDING);
            protocolMarshaller.marshall((Object)migrationTask.updateDateTime(), UPDATEDATETIME_BINDING);
            protocolMarshaller.marshall(migrationTask.resourceAttributeList(), RESOURCEATTRIBUTELIST_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

