/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import software.amazon.awssdk.services.migrationhub.model.CreatedArtifact;
import software.amazon.awssdk.services.migrationhub.model.CreatedArtifactListCopier;
import software.amazon.awssdk.services.migrationhub.model.MigrationHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListCreatedArtifactsResponse
extends MigrationHubResponse
implements ToCopyableBuilder<Builder, ListCreatedArtifactsResponse> {
    private final String nextToken;
    private final List<CreatedArtifact> createdArtifactList;

    private ListCreatedArtifactsResponse(BuilderImpl builder) {
        super(builder);
        this.nextToken = builder.nextToken;
        this.createdArtifactList = builder.createdArtifactList;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public List<CreatedArtifact> createdArtifactList() {
        return this.createdArtifactList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdArtifactList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListCreatedArtifactsResponse)) {
            return false;
        }
        ListCreatedArtifactsResponse other = (ListCreatedArtifactsResponse)((Object)obj);
        return Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.createdArtifactList(), other.createdArtifactList());
    }

    public String toString() {
        return ToString.builder((String)"ListCreatedArtifactsResponse").add("NextToken", (Object)this.nextToken()).add("CreatedArtifactList", this.createdArtifactList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NextToken": {
                return Optional.of(clazz.cast(this.nextToken()));
            }
            case "CreatedArtifactList": {
                return Optional.of(clazz.cast(this.createdArtifactList()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MigrationHubResponse.BuilderImpl
    implements Builder {
        private String nextToken;
        private List<CreatedArtifact> createdArtifactList;

        private BuilderImpl() {
        }

        private BuilderImpl(ListCreatedArtifactsResponse model) {
            this.nextToken(model.nextToken);
            this.createdArtifactList(model.createdArtifactList);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public final Collection<CreatedArtifact.Builder> getCreatedArtifactList() {
            return this.createdArtifactList != null ? (Collection)this.createdArtifactList.stream().map(CreatedArtifact::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder createdArtifactList(Collection<CreatedArtifact> createdArtifactList) {
            this.createdArtifactList = CreatedArtifactListCopier.copy(createdArtifactList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder createdArtifactList(CreatedArtifact ... createdArtifactList) {
            this.createdArtifactList(Arrays.asList(createdArtifactList));
            return this;
        }

        public final void setCreatedArtifactList(Collection<CreatedArtifact.BuilderImpl> createdArtifactList) {
            this.createdArtifactList = CreatedArtifactListCopier.copyFromBuilder(createdArtifactList);
        }

        @Override
        public ListCreatedArtifactsResponse build() {
            return new ListCreatedArtifactsResponse(this);
        }
    }

    public static interface Builder
    extends MigrationHubResponse.Builder,
    CopyableBuilder<Builder, ListCreatedArtifactsResponse> {
        public Builder nextToken(String var1);

        public Builder createdArtifactList(Collection<CreatedArtifact> var1);

        public Builder createdArtifactList(CreatedArtifact ... var1);
    }
}

