/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.migrationhub.model.LatestResourceAttributeListCopier;
import software.amazon.awssdk.services.migrationhub.model.ResourceAttribute;
import software.amazon.awssdk.services.migrationhub.model.Task;
import software.amazon.awssdk.services.migrationhub.transform.MigrationTaskMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class MigrationTask
implements StructuredPojo,
ToCopyableBuilder<Builder, MigrationTask> {
    private final String progressUpdateStream;
    private final String migrationTaskName;
    private final Task task;
    private final Instant updateDateTime;
    private final List<ResourceAttribute> resourceAttributeList;

    private MigrationTask(BuilderImpl builder) {
        this.progressUpdateStream = builder.progressUpdateStream;
        this.migrationTaskName = builder.migrationTaskName;
        this.task = builder.task;
        this.updateDateTime = builder.updateDateTime;
        this.resourceAttributeList = builder.resourceAttributeList;
    }

    public String progressUpdateStream() {
        return this.progressUpdateStream;
    }

    public String migrationTaskName() {
        return this.migrationTaskName;
    }

    public Task task() {
        return this.task;
    }

    public Instant updateDateTime() {
        return this.updateDateTime;
    }

    public List<ResourceAttribute> resourceAttributeList() {
        return this.resourceAttributeList;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.progressUpdateStream());
        hashCode = 31 * hashCode + Objects.hashCode(this.migrationTaskName());
        hashCode = 31 * hashCode + Objects.hashCode(this.task());
        hashCode = 31 * hashCode + Objects.hashCode(this.updateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceAttributeList());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MigrationTask)) {
            return false;
        }
        MigrationTask other = (MigrationTask)obj;
        return Objects.equals(this.progressUpdateStream(), other.progressUpdateStream()) && Objects.equals(this.migrationTaskName(), other.migrationTaskName()) && Objects.equals(this.task(), other.task()) && Objects.equals(this.updateDateTime(), other.updateDateTime()) && Objects.equals(this.resourceAttributeList(), other.resourceAttributeList());
    }

    public String toString() {
        return ToString.builder((String)"MigrationTask").add("ProgressUpdateStream", (Object)this.progressUpdateStream()).add("MigrationTaskName", (Object)this.migrationTaskName()).add("Task", (Object)this.task()).add("UpdateDateTime", (Object)this.updateDateTime()).add("ResourceAttributeList", this.resourceAttributeList()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ProgressUpdateStream": {
                return Optional.ofNullable(clazz.cast(this.progressUpdateStream()));
            }
            case "MigrationTaskName": {
                return Optional.ofNullable(clazz.cast(this.migrationTaskName()));
            }
            case "Task": {
                return Optional.ofNullable(clazz.cast(this.task()));
            }
            case "UpdateDateTime": {
                return Optional.ofNullable(clazz.cast(this.updateDateTime()));
            }
            case "ResourceAttributeList": {
                return Optional.ofNullable(clazz.cast(this.resourceAttributeList()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        MigrationTaskMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private String progressUpdateStream;
        private String migrationTaskName;
        private Task task;
        private Instant updateDateTime;
        private List<ResourceAttribute> resourceAttributeList = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(MigrationTask model) {
            this.progressUpdateStream(model.progressUpdateStream);
            this.migrationTaskName(model.migrationTaskName);
            this.task(model.task);
            this.updateDateTime(model.updateDateTime);
            this.resourceAttributeList(model.resourceAttributeList);
        }

        public final String getProgressUpdateStream() {
            return this.progressUpdateStream;
        }

        @Override
        public final Builder progressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
            return this;
        }

        public final void setProgressUpdateStream(String progressUpdateStream) {
            this.progressUpdateStream = progressUpdateStream;
        }

        public final String getMigrationTaskName() {
            return this.migrationTaskName;
        }

        @Override
        public final Builder migrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
            return this;
        }

        public final void setMigrationTaskName(String migrationTaskName) {
            this.migrationTaskName = migrationTaskName;
        }

        public final Task.Builder getTask() {
            return this.task != null ? this.task.toBuilder() : null;
        }

        @Override
        public final Builder task(Task task) {
            this.task = task;
            return this;
        }

        public final void setTask(Task.BuilderImpl task) {
            this.task = task != null ? task.build() : null;
        }

        public final Instant getUpdateDateTime() {
            return this.updateDateTime;
        }

        @Override
        public final Builder updateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
            return this;
        }

        public final void setUpdateDateTime(Instant updateDateTime) {
            this.updateDateTime = updateDateTime;
        }

        public final Collection<ResourceAttribute.Builder> getResourceAttributeList() {
            return this.resourceAttributeList != null ? (Collection)this.resourceAttributeList.stream().map(ResourceAttribute::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder resourceAttributeList(Collection<ResourceAttribute> resourceAttributeList) {
            this.resourceAttributeList = LatestResourceAttributeListCopier.copy(resourceAttributeList);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAttributeList(ResourceAttribute ... resourceAttributeList) {
            this.resourceAttributeList(Arrays.asList(resourceAttributeList));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceAttributeList(Consumer<ResourceAttribute.Builder> ... resourceAttributeList) {
            this.resourceAttributeList(Stream.of(resourceAttributeList).map(c -> (ResourceAttribute)((ResourceAttribute.Builder)ResourceAttribute.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setResourceAttributeList(Collection<ResourceAttribute.BuilderImpl> resourceAttributeList) {
            this.resourceAttributeList = LatestResourceAttributeListCopier.copyFromBuilder(resourceAttributeList);
        }

        public MigrationTask build() {
            return new MigrationTask(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, MigrationTask> {
        public Builder progressUpdateStream(String var1);

        public Builder migrationTaskName(String var1);

        public Builder task(Task var1);

        default public Builder task(Consumer<Task.Builder> task) {
            return this.task((Task)((Task.Builder)Task.builder().applyMutation(task)).build());
        }

        public Builder updateDateTime(Instant var1);

        public Builder resourceAttributeList(Collection<ResourceAttribute> var1);

        public Builder resourceAttributeList(ResourceAttribute ... var1);

        public Builder resourceAttributeList(Consumer<ResourceAttribute.Builder> ... var1);
    }
}

