/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.model;

import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.services.migrationhub.model.ApplicationStatus;
import software.amazon.awssdk.services.migrationhub.model.MigrationHubResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeApplicationStateResponse
extends MigrationHubResponse
implements ToCopyableBuilder<Builder, DescribeApplicationStateResponse> {
    private final String applicationStatus;
    private final Instant lastUpdatedTime;

    private DescribeApplicationStateResponse(BuilderImpl builder) {
        super(builder);
        this.applicationStatus = builder.applicationStatus;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public ApplicationStatus applicationStatus() {
        return ApplicationStatus.fromValue(this.applicationStatus);
    }

    public String applicationStatusAsString() {
        return this.applicationStatus;
    }

    public Instant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeApplicationStateResponse)) {
            return false;
        }
        DescribeApplicationStateResponse other = (DescribeApplicationStateResponse)((Object)obj);
        return Objects.equals(this.applicationStatusAsString(), other.applicationStatusAsString()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public String toString() {
        return ToString.builder((String)"DescribeApplicationStateResponse").add("ApplicationStatus", (Object)this.applicationStatusAsString()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ApplicationStatus": {
                return Optional.ofNullable(clazz.cast(this.applicationStatusAsString()));
            }
            case "LastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends MigrationHubResponse.BuilderImpl
    implements Builder {
        private String applicationStatus;
        private Instant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeApplicationStateResponse model) {
            super(model);
            this.applicationStatus(model.applicationStatus);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final String getApplicationStatus() {
            return this.applicationStatus;
        }

        @Override
        public final Builder applicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
            return this;
        }

        @Override
        public final Builder applicationStatus(ApplicationStatus applicationStatus) {
            this.applicationStatus(applicationStatus.toString());
            return this;
        }

        public final void setApplicationStatus(String applicationStatus) {
            this.applicationStatus = applicationStatus;
        }

        public final Instant getLastUpdatedTime() {
            return this.lastUpdatedTime;
        }

        @Override
        public final Builder lastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public final void setLastUpdatedTime(Instant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
        }

        @Override
        public DescribeApplicationStateResponse build() {
            return new DescribeApplicationStateResponse(this);
        }
    }

    public static interface Builder
    extends MigrationHubResponse.Builder,
    CopyableBuilder<Builder, DescribeApplicationStateResponse> {
        public Builder applicationStatus(String var1);

        public Builder applicationStatus(ApplicationStatus var1);

        public Builder lastUpdatedTime(Instant var1);
    }
}

