/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.migrationhub.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.core.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.core.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.migrationhub.model.Task;

public class TaskUnmarshaller
implements Unmarshaller<Task, JsonUnmarshallerContext> {
    private static final TaskUnmarshaller INSTANCE = new TaskUnmarshaller();

    public Task unmarshall(JsonUnmarshallerContext context) throws Exception {
        Task.Builder taskBuilder = Task.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Status", targetDepth)) {
                    context.nextToken();
                    taskBuilder.status((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("StatusDetail", targetDepth)) {
                    context.nextToken();
                    taskBuilder.statusDetail((String)context.getUnmarshaller(String.class).unmarshall((Object)context));
                }
                if (context.testExpression("ProgressPercent", targetDepth)) {
                    context.nextToken();
                    taskBuilder.progressPercent((Integer)context.getUnmarshaller(Integer.class).unmarshall((Object)context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (Task)taskBuilder.build();
    }

    public static TaskUnmarshaller getInstance() {
        return INSTANCE;
    }
}

