/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequestApplicationIDsCopier;
import software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequestFiltersIDsCopier;
import software.amazon.awssdk.services.mgn.model.LifeCycleState;
import software.amazon.awssdk.services.mgn.model.LifeCycleStatesCopier;
import software.amazon.awssdk.services.mgn.model.ReplicationType;
import software.amazon.awssdk.services.mgn.model.ReplicationTypesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeSourceServersRequestFilters
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DescribeSourceServersRequestFilters> {
    private static final SdkField<List<String>> SOURCE_SERVER_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceServerIDs").getter(DescribeSourceServersRequestFilters.getter(DescribeSourceServersRequestFilters::sourceServerIDs)).setter(DescribeSourceServersRequestFilters.setter(Builder::sourceServerIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Boolean> IS_ARCHIVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isArchived").getter(DescribeSourceServersRequestFilters.getter(DescribeSourceServersRequestFilters::isArchived)).setter(DescribeSourceServersRequestFilters.setter(Builder::isArchived)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isArchived").build()}).build();
    private static final SdkField<List<String>> REPLICATION_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("replicationTypes").getter(DescribeSourceServersRequestFilters.getter(DescribeSourceServersRequestFilters::replicationTypesAsStrings)).setter(DescribeSourceServersRequestFilters.setter(Builder::replicationTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> LIFE_CYCLE_STATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("lifeCycleStates").getter(DescribeSourceServersRequestFilters.getter(DescribeSourceServersRequestFilters::lifeCycleStatesAsStrings)).setter(DescribeSourceServersRequestFilters.setter(Builder::lifeCycleStatesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifeCycleStates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> APPLICATION_I_DS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("applicationIDs").getter(DescribeSourceServersRequestFilters.getter(DescribeSourceServersRequestFilters::applicationIDs)).setter(DescribeSourceServersRequestFilters.setter(Builder::applicationIDs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("applicationIDs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_SERVER_I_DS_FIELD, IS_ARCHIVED_FIELD, REPLICATION_TYPES_FIELD, LIFE_CYCLE_STATES_FIELD, APPLICATION_I_DS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeSourceServersRequestFilters.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> sourceServerIDs;
    private final Boolean isArchived;
    private final List<String> replicationTypes;
    private final List<String> lifeCycleStates;
    private final List<String> applicationIDs;

    private DescribeSourceServersRequestFilters(BuilderImpl builder) {
        this.sourceServerIDs = builder.sourceServerIDs;
        this.isArchived = builder.isArchived;
        this.replicationTypes = builder.replicationTypes;
        this.lifeCycleStates = builder.lifeCycleStates;
        this.applicationIDs = builder.applicationIDs;
    }

    public final boolean hasSourceServerIDs() {
        return this.sourceServerIDs != null && !(this.sourceServerIDs instanceof SdkAutoConstructList);
    }

    public final List<String> sourceServerIDs() {
        return this.sourceServerIDs;
    }

    public final Boolean isArchived() {
        return this.isArchived;
    }

    public final List<ReplicationType> replicationTypes() {
        return ReplicationTypesCopier.copyStringToEnum(this.replicationTypes);
    }

    public final boolean hasReplicationTypes() {
        return this.replicationTypes != null && !(this.replicationTypes instanceof SdkAutoConstructList);
    }

    public final List<String> replicationTypesAsStrings() {
        return this.replicationTypes;
    }

    public final List<LifeCycleState> lifeCycleStates() {
        return LifeCycleStatesCopier.copyStringToEnum(this.lifeCycleStates);
    }

    public final boolean hasLifeCycleStates() {
        return this.lifeCycleStates != null && !(this.lifeCycleStates instanceof SdkAutoConstructList);
    }

    public final List<String> lifeCycleStatesAsStrings() {
        return this.lifeCycleStates;
    }

    public final boolean hasApplicationIDs() {
        return this.applicationIDs != null && !(this.applicationIDs instanceof SdkAutoConstructList);
    }

    public final List<String> applicationIDs() {
        return this.applicationIDs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceServerIDs() ? this.sourceServerIDs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.isArchived());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicationTypes() ? this.replicationTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasLifeCycleStates() ? this.lifeCycleStatesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasApplicationIDs() ? this.applicationIDs() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSourceServersRequestFilters)) {
            return false;
        }
        DescribeSourceServersRequestFilters other = (DescribeSourceServersRequestFilters)obj;
        return this.hasSourceServerIDs() == other.hasSourceServerIDs() && Objects.equals(this.sourceServerIDs(), other.sourceServerIDs()) && Objects.equals(this.isArchived(), other.isArchived()) && this.hasReplicationTypes() == other.hasReplicationTypes() && Objects.equals(this.replicationTypesAsStrings(), other.replicationTypesAsStrings()) && this.hasLifeCycleStates() == other.hasLifeCycleStates() && Objects.equals(this.lifeCycleStatesAsStrings(), other.lifeCycleStatesAsStrings()) && this.hasApplicationIDs() == other.hasApplicationIDs() && Objects.equals(this.applicationIDs(), other.applicationIDs());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeSourceServersRequestFilters").add("SourceServerIDs", this.hasSourceServerIDs() ? this.sourceServerIDs() : null).add("IsArchived", (Object)this.isArchived()).add("ReplicationTypes", this.hasReplicationTypes() ? this.replicationTypesAsStrings() : null).add("LifeCycleStates", this.hasLifeCycleStates() ? this.lifeCycleStatesAsStrings() : null).add("ApplicationIDs", this.hasApplicationIDs() ? this.applicationIDs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "sourceServerIDs": {
                return Optional.ofNullable(clazz.cast(this.sourceServerIDs()));
            }
            case "isArchived": {
                return Optional.ofNullable(clazz.cast(this.isArchived()));
            }
            case "replicationTypes": {
                return Optional.ofNullable(clazz.cast(this.replicationTypesAsStrings()));
            }
            case "lifeCycleStates": {
                return Optional.ofNullable(clazz.cast(this.lifeCycleStatesAsStrings()));
            }
            case "applicationIDs": {
                return Optional.ofNullable(clazz.cast(this.applicationIDs()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sourceServerIDs", SOURCE_SERVER_I_DS_FIELD);
        map.put("isArchived", IS_ARCHIVED_FIELD);
        map.put("replicationTypes", REPLICATION_TYPES_FIELD);
        map.put("lifeCycleStates", LIFE_CYCLE_STATES_FIELD);
        map.put("applicationIDs", APPLICATION_I_DS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeSourceServersRequestFilters, T> g) {
        return obj -> g.apply((DescribeSourceServersRequestFilters)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> sourceServerIDs = DefaultSdkAutoConstructList.getInstance();
        private Boolean isArchived;
        private List<String> replicationTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> lifeCycleStates = DefaultSdkAutoConstructList.getInstance();
        private List<String> applicationIDs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeSourceServersRequestFilters model) {
            this.sourceServerIDs(model.sourceServerIDs);
            this.isArchived(model.isArchived);
            this.replicationTypesWithStrings(model.replicationTypes);
            this.lifeCycleStatesWithStrings(model.lifeCycleStates);
            this.applicationIDs(model.applicationIDs);
        }

        public final Collection<String> getSourceServerIDs() {
            if (this.sourceServerIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceServerIDs;
        }

        public final void setSourceServerIDs(Collection<String> sourceServerIDs) {
            this.sourceServerIDs = DescribeSourceServersRequestFiltersIDsCopier.copy(sourceServerIDs);
        }

        @Override
        public final Builder sourceServerIDs(Collection<String> sourceServerIDs) {
            this.sourceServerIDs = DescribeSourceServersRequestFiltersIDsCopier.copy(sourceServerIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceServerIDs(String ... sourceServerIDs) {
            this.sourceServerIDs(Arrays.asList(sourceServerIDs));
            return this;
        }

        public final Boolean getIsArchived() {
            return this.isArchived;
        }

        public final void setIsArchived(Boolean isArchived) {
            this.isArchived = isArchived;
        }

        @Override
        public final Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final Collection<String> getReplicationTypes() {
            if (this.replicationTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.replicationTypes;
        }

        public final void setReplicationTypes(Collection<String> replicationTypes) {
            this.replicationTypes = ReplicationTypesCopier.copy(replicationTypes);
        }

        @Override
        public final Builder replicationTypesWithStrings(Collection<String> replicationTypes) {
            this.replicationTypes = ReplicationTypesCopier.copy(replicationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTypesWithStrings(String ... replicationTypes) {
            this.replicationTypesWithStrings(Arrays.asList(replicationTypes));
            return this;
        }

        @Override
        public final Builder replicationTypes(Collection<ReplicationType> replicationTypes) {
            this.replicationTypes = ReplicationTypesCopier.copyEnumToString(replicationTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicationTypes(ReplicationType ... replicationTypes) {
            this.replicationTypes(Arrays.asList(replicationTypes));
            return this;
        }

        public final Collection<String> getLifeCycleStates() {
            if (this.lifeCycleStates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.lifeCycleStates;
        }

        public final void setLifeCycleStates(Collection<String> lifeCycleStates) {
            this.lifeCycleStates = LifeCycleStatesCopier.copy(lifeCycleStates);
        }

        @Override
        public final Builder lifeCycleStatesWithStrings(Collection<String> lifeCycleStates) {
            this.lifeCycleStates = LifeCycleStatesCopier.copy(lifeCycleStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifeCycleStatesWithStrings(String ... lifeCycleStates) {
            this.lifeCycleStatesWithStrings(Arrays.asList(lifeCycleStates));
            return this;
        }

        @Override
        public final Builder lifeCycleStates(Collection<LifeCycleState> lifeCycleStates) {
            this.lifeCycleStates = LifeCycleStatesCopier.copyEnumToString(lifeCycleStates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder lifeCycleStates(LifeCycleState ... lifeCycleStates) {
            this.lifeCycleStates(Arrays.asList(lifeCycleStates));
            return this;
        }

        public final Collection<String> getApplicationIDs() {
            if (this.applicationIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return this.applicationIDs;
        }

        public final void setApplicationIDs(Collection<String> applicationIDs) {
            this.applicationIDs = DescribeSourceServersRequestApplicationIDsCopier.copy(applicationIDs);
        }

        @Override
        public final Builder applicationIDs(Collection<String> applicationIDs) {
            this.applicationIDs = DescribeSourceServersRequestApplicationIDsCopier.copy(applicationIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder applicationIDs(String ... applicationIDs) {
            this.applicationIDs(Arrays.asList(applicationIDs));
            return this;
        }

        public DescribeSourceServersRequestFilters build() {
            return new DescribeSourceServersRequestFilters(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DescribeSourceServersRequestFilters> {
        public Builder sourceServerIDs(Collection<String> var1);

        public Builder sourceServerIDs(String ... var1);

        public Builder isArchived(Boolean var1);

        public Builder replicationTypesWithStrings(Collection<String> var1);

        public Builder replicationTypesWithStrings(String ... var1);

        public Builder replicationTypes(Collection<ReplicationType> var1);

        public Builder replicationTypes(ReplicationType ... var1);

        public Builder lifeCycleStatesWithStrings(Collection<String> var1);

        public Builder lifeCycleStatesWithStrings(String ... var1);

        public Builder lifeCycleStates(Collection<LifeCycleState> var1);

        public Builder lifeCycleStates(LifeCycleState ... var1);

        public Builder applicationIDs(Collection<String> var1);

        public Builder applicationIDs(String ... var1);
    }
}

