/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mgn.model.DataReplicationError;
import software.amazon.awssdk.services.mgn.model.DataReplicationInfoReplicatedDisk;
import software.amazon.awssdk.services.mgn.model.DataReplicationInfoReplicatedDisksCopier;
import software.amazon.awssdk.services.mgn.model.DataReplicationInitiation;
import software.amazon.awssdk.services.mgn.model.DataReplicationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataReplicationInfo
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataReplicationInfo> {
    private static final SdkField<String> LAG_DURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lagDuration").getter(DataReplicationInfo.getter(DataReplicationInfo::lagDuration)).setter(DataReplicationInfo.setter(Builder::lagDuration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lagDuration").build()}).build();
    private static final SdkField<String> ETA_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("etaDateTime").getter(DataReplicationInfo.getter(DataReplicationInfo::etaDateTime)).setter(DataReplicationInfo.setter(Builder::etaDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("etaDateTime").build()}).build();
    private static final SdkField<List<DataReplicationInfoReplicatedDisk>> REPLICATED_DISKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("replicatedDisks").getter(DataReplicationInfo.getter(DataReplicationInfo::replicatedDisks)).setter(DataReplicationInfo.setter(Builder::replicatedDisks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatedDisks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(DataReplicationInfoReplicatedDisk::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> DATA_REPLICATION_STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("dataReplicationState").getter(DataReplicationInfo.getter(DataReplicationInfo::dataReplicationStateAsString)).setter(DataReplicationInfo.setter(Builder::dataReplicationState)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationState").build()}).build();
    private static final SdkField<DataReplicationInitiation> DATA_REPLICATION_INITIATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataReplicationInitiation").getter(DataReplicationInfo.getter(DataReplicationInfo::dataReplicationInitiation)).setter(DataReplicationInfo.setter(Builder::dataReplicationInitiation)).constructor(DataReplicationInitiation::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationInitiation").build()}).build();
    private static final SdkField<DataReplicationError> DATA_REPLICATION_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataReplicationError").getter(DataReplicationInfo.getter(DataReplicationInfo::dataReplicationError)).setter(DataReplicationInfo.setter(Builder::dataReplicationError)).constructor(DataReplicationError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationError").build()}).build();
    private static final SdkField<String> LAST_SNAPSHOT_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastSnapshotDateTime").getter(DataReplicationInfo.getter(DataReplicationInfo::lastSnapshotDateTime)).setter(DataReplicationInfo.setter(Builder::lastSnapshotDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastSnapshotDateTime").build()}).build();
    private static final SdkField<String> REPLICATOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicatorId").getter(DataReplicationInfo.getter(DataReplicationInfo::replicatorId)).setter(DataReplicationInfo.setter(Builder::replicatorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicatorId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAG_DURATION_FIELD, ETA_DATE_TIME_FIELD, REPLICATED_DISKS_FIELD, DATA_REPLICATION_STATE_FIELD, DATA_REPLICATION_INITIATION_FIELD, DATA_REPLICATION_ERROR_FIELD, LAST_SNAPSHOT_DATE_TIME_FIELD, REPLICATOR_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataReplicationInfo.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String lagDuration;
    private final String etaDateTime;
    private final List<DataReplicationInfoReplicatedDisk> replicatedDisks;
    private final String dataReplicationState;
    private final DataReplicationInitiation dataReplicationInitiation;
    private final DataReplicationError dataReplicationError;
    private final String lastSnapshotDateTime;
    private final String replicatorId;

    private DataReplicationInfo(BuilderImpl builder) {
        this.lagDuration = builder.lagDuration;
        this.etaDateTime = builder.etaDateTime;
        this.replicatedDisks = builder.replicatedDisks;
        this.dataReplicationState = builder.dataReplicationState;
        this.dataReplicationInitiation = builder.dataReplicationInitiation;
        this.dataReplicationError = builder.dataReplicationError;
        this.lastSnapshotDateTime = builder.lastSnapshotDateTime;
        this.replicatorId = builder.replicatorId;
    }

    public final String lagDuration() {
        return this.lagDuration;
    }

    public final String etaDateTime() {
        return this.etaDateTime;
    }

    public final boolean hasReplicatedDisks() {
        return this.replicatedDisks != null && !(this.replicatedDisks instanceof SdkAutoConstructList);
    }

    public final List<DataReplicationInfoReplicatedDisk> replicatedDisks() {
        return this.replicatedDisks;
    }

    public final DataReplicationState dataReplicationState() {
        return DataReplicationState.fromValue(this.dataReplicationState);
    }

    public final String dataReplicationStateAsString() {
        return this.dataReplicationState;
    }

    public final DataReplicationInitiation dataReplicationInitiation() {
        return this.dataReplicationInitiation;
    }

    public final DataReplicationError dataReplicationError() {
        return this.dataReplicationError;
    }

    public final String lastSnapshotDateTime() {
        return this.lastSnapshotDateTime;
    }

    public final String replicatorId() {
        return this.replicatorId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.lagDuration());
        hashCode = 31 * hashCode + Objects.hashCode(this.etaDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasReplicatedDisks() ? this.replicatedDisks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataReplicationStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataReplicationInitiation());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataReplicationError());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastSnapshotDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicatorId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataReplicationInfo)) {
            return false;
        }
        DataReplicationInfo other = (DataReplicationInfo)obj;
        return Objects.equals(this.lagDuration(), other.lagDuration()) && Objects.equals(this.etaDateTime(), other.etaDateTime()) && this.hasReplicatedDisks() == other.hasReplicatedDisks() && Objects.equals(this.replicatedDisks(), other.replicatedDisks()) && Objects.equals(this.dataReplicationStateAsString(), other.dataReplicationStateAsString()) && Objects.equals(this.dataReplicationInitiation(), other.dataReplicationInitiation()) && Objects.equals(this.dataReplicationError(), other.dataReplicationError()) && Objects.equals(this.lastSnapshotDateTime(), other.lastSnapshotDateTime()) && Objects.equals(this.replicatorId(), other.replicatorId());
    }

    public final String toString() {
        return ToString.builder((String)"DataReplicationInfo").add("LagDuration", (Object)this.lagDuration()).add("EtaDateTime", (Object)this.etaDateTime()).add("ReplicatedDisks", this.hasReplicatedDisks() ? this.replicatedDisks() : null).add("DataReplicationState", (Object)this.dataReplicationStateAsString()).add("DataReplicationInitiation", (Object)this.dataReplicationInitiation()).add("DataReplicationError", (Object)this.dataReplicationError()).add("LastSnapshotDateTime", (Object)this.lastSnapshotDateTime()).add("ReplicatorId", (Object)this.replicatorId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "lagDuration": {
                return Optional.ofNullable(clazz.cast(this.lagDuration()));
            }
            case "etaDateTime": {
                return Optional.ofNullable(clazz.cast(this.etaDateTime()));
            }
            case "replicatedDisks": {
                return Optional.ofNullable(clazz.cast(this.replicatedDisks()));
            }
            case "dataReplicationState": {
                return Optional.ofNullable(clazz.cast(this.dataReplicationStateAsString()));
            }
            case "dataReplicationInitiation": {
                return Optional.ofNullable(clazz.cast(this.dataReplicationInitiation()));
            }
            case "dataReplicationError": {
                return Optional.ofNullable(clazz.cast(this.dataReplicationError()));
            }
            case "lastSnapshotDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastSnapshotDateTime()));
            }
            case "replicatorId": {
                return Optional.ofNullable(clazz.cast(this.replicatorId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("lagDuration", LAG_DURATION_FIELD);
        map.put("etaDateTime", ETA_DATE_TIME_FIELD);
        map.put("replicatedDisks", REPLICATED_DISKS_FIELD);
        map.put("dataReplicationState", DATA_REPLICATION_STATE_FIELD);
        map.put("dataReplicationInitiation", DATA_REPLICATION_INITIATION_FIELD);
        map.put("dataReplicationError", DATA_REPLICATION_ERROR_FIELD);
        map.put("lastSnapshotDateTime", LAST_SNAPSHOT_DATE_TIME_FIELD);
        map.put("replicatorId", REPLICATOR_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataReplicationInfo, T> g) {
        return obj -> g.apply((DataReplicationInfo)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String lagDuration;
        private String etaDateTime;
        private List<DataReplicationInfoReplicatedDisk> replicatedDisks = DefaultSdkAutoConstructList.getInstance();
        private String dataReplicationState;
        private DataReplicationInitiation dataReplicationInitiation;
        private DataReplicationError dataReplicationError;
        private String lastSnapshotDateTime;
        private String replicatorId;

        private BuilderImpl() {
        }

        private BuilderImpl(DataReplicationInfo model) {
            this.lagDuration(model.lagDuration);
            this.etaDateTime(model.etaDateTime);
            this.replicatedDisks(model.replicatedDisks);
            this.dataReplicationState(model.dataReplicationState);
            this.dataReplicationInitiation(model.dataReplicationInitiation);
            this.dataReplicationError(model.dataReplicationError);
            this.lastSnapshotDateTime(model.lastSnapshotDateTime);
            this.replicatorId(model.replicatorId);
        }

        public final String getLagDuration() {
            return this.lagDuration;
        }

        public final void setLagDuration(String lagDuration) {
            this.lagDuration = lagDuration;
        }

        @Override
        public final Builder lagDuration(String lagDuration) {
            this.lagDuration = lagDuration;
            return this;
        }

        public final String getEtaDateTime() {
            return this.etaDateTime;
        }

        public final void setEtaDateTime(String etaDateTime) {
            this.etaDateTime = etaDateTime;
        }

        @Override
        public final Builder etaDateTime(String etaDateTime) {
            this.etaDateTime = etaDateTime;
            return this;
        }

        public final List<DataReplicationInfoReplicatedDisk.Builder> getReplicatedDisks() {
            List<DataReplicationInfoReplicatedDisk.Builder> result = DataReplicationInfoReplicatedDisksCopier.copyToBuilder(this.replicatedDisks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setReplicatedDisks(Collection<DataReplicationInfoReplicatedDisk.BuilderImpl> replicatedDisks) {
            this.replicatedDisks = DataReplicationInfoReplicatedDisksCopier.copyFromBuilder(replicatedDisks);
        }

        @Override
        public final Builder replicatedDisks(Collection<DataReplicationInfoReplicatedDisk> replicatedDisks) {
            this.replicatedDisks = DataReplicationInfoReplicatedDisksCopier.copy(replicatedDisks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicatedDisks(DataReplicationInfoReplicatedDisk ... replicatedDisks) {
            this.replicatedDisks(Arrays.asList(replicatedDisks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder replicatedDisks(Consumer<DataReplicationInfoReplicatedDisk.Builder> ... replicatedDisks) {
            this.replicatedDisks(Stream.of(replicatedDisks).map(c -> (DataReplicationInfoReplicatedDisk)((DataReplicationInfoReplicatedDisk.Builder)DataReplicationInfoReplicatedDisk.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getDataReplicationState() {
            return this.dataReplicationState;
        }

        public final void setDataReplicationState(String dataReplicationState) {
            this.dataReplicationState = dataReplicationState;
        }

        @Override
        public final Builder dataReplicationState(String dataReplicationState) {
            this.dataReplicationState = dataReplicationState;
            return this;
        }

        @Override
        public final Builder dataReplicationState(DataReplicationState dataReplicationState) {
            this.dataReplicationState(dataReplicationState == null ? null : dataReplicationState.toString());
            return this;
        }

        public final DataReplicationInitiation.Builder getDataReplicationInitiation() {
            return this.dataReplicationInitiation != null ? this.dataReplicationInitiation.toBuilder() : null;
        }

        public final void setDataReplicationInitiation(DataReplicationInitiation.BuilderImpl dataReplicationInitiation) {
            this.dataReplicationInitiation = dataReplicationInitiation != null ? dataReplicationInitiation.build() : null;
        }

        @Override
        public final Builder dataReplicationInitiation(DataReplicationInitiation dataReplicationInitiation) {
            this.dataReplicationInitiation = dataReplicationInitiation;
            return this;
        }

        public final DataReplicationError.Builder getDataReplicationError() {
            return this.dataReplicationError != null ? this.dataReplicationError.toBuilder() : null;
        }

        public final void setDataReplicationError(DataReplicationError.BuilderImpl dataReplicationError) {
            this.dataReplicationError = dataReplicationError != null ? dataReplicationError.build() : null;
        }

        @Override
        public final Builder dataReplicationError(DataReplicationError dataReplicationError) {
            this.dataReplicationError = dataReplicationError;
            return this;
        }

        public final String getLastSnapshotDateTime() {
            return this.lastSnapshotDateTime;
        }

        public final void setLastSnapshotDateTime(String lastSnapshotDateTime) {
            this.lastSnapshotDateTime = lastSnapshotDateTime;
        }

        @Override
        public final Builder lastSnapshotDateTime(String lastSnapshotDateTime) {
            this.lastSnapshotDateTime = lastSnapshotDateTime;
            return this;
        }

        public final String getReplicatorId() {
            return this.replicatorId;
        }

        public final void setReplicatorId(String replicatorId) {
            this.replicatorId = replicatorId;
        }

        @Override
        public final Builder replicatorId(String replicatorId) {
            this.replicatorId = replicatorId;
            return this;
        }

        public DataReplicationInfo build() {
            return new DataReplicationInfo(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataReplicationInfo> {
        public Builder lagDuration(String var1);

        public Builder etaDateTime(String var1);

        public Builder replicatedDisks(Collection<DataReplicationInfoReplicatedDisk> var1);

        public Builder replicatedDisks(DataReplicationInfoReplicatedDisk ... var1);

        public Builder replicatedDisks(Consumer<DataReplicationInfoReplicatedDisk.Builder> ... var1);

        public Builder dataReplicationState(String var1);

        public Builder dataReplicationState(DataReplicationState var1);

        public Builder dataReplicationInitiation(DataReplicationInitiation var1);

        default public Builder dataReplicationInitiation(Consumer<DataReplicationInitiation.Builder> dataReplicationInitiation) {
            return this.dataReplicationInitiation((DataReplicationInitiation)((DataReplicationInitiation.Builder)DataReplicationInitiation.builder().applyMutation(dataReplicationInitiation)).build());
        }

        public Builder dataReplicationError(DataReplicationError var1);

        default public Builder dataReplicationError(Consumer<DataReplicationError.Builder> dataReplicationError) {
            return this.dataReplicationError((DataReplicationError)((DataReplicationError.Builder)DataReplicationError.builder().applyMutation(dataReplicationError)).build());
        }

        public Builder lastSnapshotDateTime(String var1);

        public Builder replicatorId(String var1);
    }
}

