/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.ConnectorSsmCommandConfig;
import software.amazon.awssdk.services.mgn.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Connector
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Connector> {
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorID").getter(Connector.getter(Connector::connectorID)).setter(Connector.setter(Builder::connectorID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorID").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(Connector.getter(Connector::name)).setter(Connector.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> SSM_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ssmInstanceID").getter(Connector.getter(Connector::ssmInstanceID)).setter(Connector.setter(Builder::ssmInstanceID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmInstanceID").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(Connector.getter(Connector::arn)).setter(Connector.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(Connector.getter(Connector::tags)).setter(Connector.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<ConnectorSsmCommandConfig> SSM_COMMAND_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ssmCommandConfig").getter(Connector.getter(Connector::ssmCommandConfig)).setter(Connector.setter(Builder::ssmCommandConfig)).constructor(ConnectorSsmCommandConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmCommandConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ID_FIELD, NAME_FIELD, SSM_INSTANCE_ID_FIELD, ARN_FIELD, TAGS_FIELD, SSM_COMMAND_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Connector.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String connectorID;
    private final String name;
    private final String ssmInstanceID;
    private final String arn;
    private final Map<String, String> tags;
    private final ConnectorSsmCommandConfig ssmCommandConfig;

    private Connector(BuilderImpl builder) {
        this.connectorID = builder.connectorID;
        this.name = builder.name;
        this.ssmInstanceID = builder.ssmInstanceID;
        this.arn = builder.arn;
        this.tags = builder.tags;
        this.ssmCommandConfig = builder.ssmCommandConfig;
    }

    public final String connectorID() {
        return this.connectorID;
    }

    public final String name() {
        return this.name;
    }

    public final String ssmInstanceID() {
        return this.ssmInstanceID;
    }

    public final String arn() {
        return this.arn;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public final ConnectorSsmCommandConfig ssmCommandConfig() {
        return this.ssmCommandConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorID());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssmInstanceID());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ssmCommandConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Connector)) {
            return false;
        }
        Connector other = (Connector)obj;
        return Objects.equals(this.connectorID(), other.connectorID()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ssmInstanceID(), other.ssmInstanceID()) && Objects.equals(this.arn(), other.arn()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.ssmCommandConfig(), other.ssmCommandConfig());
    }

    public final String toString() {
        return ToString.builder((String)"Connector").add("ConnectorID", (Object)this.connectorID()).add("Name", (Object)this.name()).add("SsmInstanceID", (Object)this.ssmInstanceID()).add("Arn", (Object)this.arn()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).add("SsmCommandConfig", (Object)this.ssmCommandConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorID": {
                return Optional.ofNullable(clazz.cast(this.connectorID()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ssmInstanceID": {
                return Optional.ofNullable(clazz.cast(this.ssmInstanceID()));
            }
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "ssmCommandConfig": {
                return Optional.ofNullable(clazz.cast(this.ssmCommandConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("connectorID", CONNECTOR_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("ssmInstanceID", SSM_INSTANCE_ID_FIELD);
        map.put("arn", ARN_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("ssmCommandConfig", SSM_COMMAND_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Connector, T> g) {
        return obj -> g.apply((Connector)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String connectorID;
        private String name;
        private String ssmInstanceID;
        private String arn;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private ConnectorSsmCommandConfig ssmCommandConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Connector model) {
            this.connectorID(model.connectorID);
            this.name(model.name);
            this.ssmInstanceID(model.ssmInstanceID);
            this.arn(model.arn);
            this.tags(model.tags);
            this.ssmCommandConfig(model.ssmCommandConfig);
        }

        public final String getConnectorID() {
            return this.connectorID;
        }

        public final void setConnectorID(String connectorID) {
            this.connectorID = connectorID;
        }

        @Override
        public final Builder connectorID(String connectorID) {
            this.connectorID = connectorID;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getSsmInstanceID() {
            return this.ssmInstanceID;
        }

        public final void setSsmInstanceID(String ssmInstanceID) {
            this.ssmInstanceID = ssmInstanceID;
        }

        @Override
        public final Builder ssmInstanceID(String ssmInstanceID) {
            this.ssmInstanceID = ssmInstanceID;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public final ConnectorSsmCommandConfig.Builder getSsmCommandConfig() {
            return this.ssmCommandConfig != null ? this.ssmCommandConfig.toBuilder() : null;
        }

        public final void setSsmCommandConfig(ConnectorSsmCommandConfig.BuilderImpl ssmCommandConfig) {
            this.ssmCommandConfig = ssmCommandConfig != null ? ssmCommandConfig.build() : null;
        }

        @Override
        public final Builder ssmCommandConfig(ConnectorSsmCommandConfig ssmCommandConfig) {
            this.ssmCommandConfig = ssmCommandConfig;
            return this;
        }

        public Connector build() {
            return new Connector(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Connector> {
        public Builder connectorID(String var1);

        public Builder name(String var1);

        public Builder ssmInstanceID(String var1);

        public Builder arn(String var1);

        public Builder tags(Map<String, String> var1);

        public Builder ssmCommandConfig(ConnectorSsmCommandConfig var1);

        default public Builder ssmCommandConfig(Consumer<ConnectorSsmCommandConfig.Builder> ssmCommandConfig) {
            return this.ssmCommandConfig((ConnectorSsmCommandConfig)((ConnectorSsmCommandConfig.Builder)ConnectorSsmCommandConfig.builder().applyMutation(ssmCommandConfig)).build());
        }
    }
}

