/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Start export response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartExportResponse extends MgnResponse implements
        ToCopyableBuilder<StartExportResponse.Builder, StartExportResponse> {
    private static final SdkField<ExportTask> EXPORT_TASK_FIELD = SdkField.<ExportTask> builder(MarshallingType.SDK_POJO)
            .memberName("exportTask").getter(getter(StartExportResponse::exportTask)).setter(setter(Builder::exportTask))
            .constructor(ExportTask::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportTask").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_TASK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ExportTask exportTask;

    private StartExportResponse(BuilderImpl builder) {
        super(builder);
        this.exportTask = builder.exportTask;
    }

    /**
     * <p>
     * Start export response export task.
     * </p>
     * 
     * @return Start export response export task.
     */
    public final ExportTask exportTask() {
        return exportTask;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(exportTask());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartExportResponse)) {
            return false;
        }
        StartExportResponse other = (StartExportResponse) obj;
        return Objects.equals(exportTask(), other.exportTask());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartExportResponse").add("ExportTask", exportTask()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exportTask":
            return Optional.ofNullable(clazz.cast(exportTask()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("exportTask", EXPORT_TASK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartExportResponse, T> g) {
        return obj -> g.apply((StartExportResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MgnResponse.Builder, SdkPojo, CopyableBuilder<Builder, StartExportResponse> {
        /**
         * <p>
         * Start export response export task.
         * </p>
         * 
         * @param exportTask
         *        Start export response export task.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportTask(ExportTask exportTask);

        /**
         * <p>
         * Start export response export task.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExportTask.Builder} avoiding the need to
         * create one manually via {@link ExportTask#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExportTask.Builder#build()} is called immediately and its result
         * is passed to {@link #exportTask(ExportTask)}.
         * 
         * @param exportTask
         *        a consumer that will call methods on {@link ExportTask.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #exportTask(ExportTask)
         */
        default Builder exportTask(Consumer<ExportTask.Builder> exportTask) {
            return exportTask(ExportTask.builder().applyMutation(exportTask).build());
        }
    }

    static final class BuilderImpl extends MgnResponse.BuilderImpl implements Builder {
        private ExportTask exportTask;

        private BuilderImpl() {
        }

        private BuilderImpl(StartExportResponse model) {
            super(model);
            exportTask(model.exportTask);
        }

        public final ExportTask.Builder getExportTask() {
            return exportTask != null ? exportTask.toBuilder() : null;
        }

        public final void setExportTask(ExportTask.BuilderImpl exportTask) {
            this.exportTask = exportTask != null ? exportTask.build() : null;
        }

        @Override
        public final Builder exportTask(ExportTask exportTask) {
            this.exportTask = exportTask;
            return this;
        }

        @Override
        public StartExportResponse build() {
            return new StartExportResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
