/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Job log data
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobLogEventData implements SdkPojo, Serializable, ToCopyableBuilder<JobLogEventData.Builder, JobLogEventData> {
    private static final SdkField<String> CONVERSION_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("conversionServerID").getter(getter(JobLogEventData::conversionServerID))
            .setter(setter(Builder::conversionServerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conversionServerID").build())
            .build();

    private static final SdkField<String> RAW_ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("rawError").getter(getter(JobLogEventData::rawError)).setter(setter(Builder::rawError))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawError").build()).build();

    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceServerID").getter(getter(JobLogEventData::sourceServerID)).setter(setter(Builder::sourceServerID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()).build();

    private static final SdkField<String> TARGET_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetInstanceID").getter(getter(JobLogEventData::targetInstanceID))
            .setter(setter(Builder::targetInstanceID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetInstanceID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONVERSION_SERVER_ID_FIELD,
            RAW_ERROR_FIELD, SOURCE_SERVER_ID_FIELD, TARGET_INSTANCE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String conversionServerID;

    private final String rawError;

    private final String sourceServerID;

    private final String targetInstanceID;

    private JobLogEventData(BuilderImpl builder) {
        this.conversionServerID = builder.conversionServerID;
        this.rawError = builder.rawError;
        this.sourceServerID = builder.sourceServerID;
        this.targetInstanceID = builder.targetInstanceID;
    }

    /**
     * <p>
     * Job Event conversion Server ID.
     * </p>
     * 
     * @return Job Event conversion Server ID.
     */
    public final String conversionServerID() {
        return conversionServerID;
    }

    /**
     * <p>
     * Job error.
     * </p>
     * 
     * @return Job error.
     */
    public final String rawError() {
        return rawError;
    }

    /**
     * <p>
     * Job Event Source Server ID.
     * </p>
     * 
     * @return Job Event Source Server ID.
     */
    public final String sourceServerID() {
        return sourceServerID;
    }

    /**
     * <p>
     * Job Event Target instance ID.
     * </p>
     * 
     * @return Job Event Target instance ID.
     */
    public final String targetInstanceID() {
        return targetInstanceID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(conversionServerID());
        hashCode = 31 * hashCode + Objects.hashCode(rawError());
        hashCode = 31 * hashCode + Objects.hashCode(sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(targetInstanceID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobLogEventData)) {
            return false;
        }
        JobLogEventData other = (JobLogEventData) obj;
        return Objects.equals(conversionServerID(), other.conversionServerID()) && Objects.equals(rawError(), other.rawError())
                && Objects.equals(sourceServerID(), other.sourceServerID())
                && Objects.equals(targetInstanceID(), other.targetInstanceID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobLogEventData").add("ConversionServerID", conversionServerID()).add("RawError", rawError())
                .add("SourceServerID", sourceServerID()).add("TargetInstanceID", targetInstanceID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "conversionServerID":
            return Optional.ofNullable(clazz.cast(conversionServerID()));
        case "rawError":
            return Optional.ofNullable(clazz.cast(rawError()));
        case "sourceServerID":
            return Optional.ofNullable(clazz.cast(sourceServerID()));
        case "targetInstanceID":
            return Optional.ofNullable(clazz.cast(targetInstanceID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("conversionServerID", CONVERSION_SERVER_ID_FIELD);
        map.put("rawError", RAW_ERROR_FIELD);
        map.put("sourceServerID", SOURCE_SERVER_ID_FIELD);
        map.put("targetInstanceID", TARGET_INSTANCE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobLogEventData, T> g) {
        return obj -> g.apply((JobLogEventData) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobLogEventData> {
        /**
         * <p>
         * Job Event conversion Server ID.
         * </p>
         * 
         * @param conversionServerID
         *        Job Event conversion Server ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conversionServerID(String conversionServerID);

        /**
         * <p>
         * Job error.
         * </p>
         * 
         * @param rawError
         *        Job error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rawError(String rawError);

        /**
         * <p>
         * Job Event Source Server ID.
         * </p>
         * 
         * @param sourceServerID
         *        Job Event Source Server ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceServerID(String sourceServerID);

        /**
         * <p>
         * Job Event Target instance ID.
         * </p>
         * 
         * @param targetInstanceID
         *        Job Event Target instance ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetInstanceID(String targetInstanceID);
    }

    static final class BuilderImpl implements Builder {
        private String conversionServerID;

        private String rawError;

        private String sourceServerID;

        private String targetInstanceID;

        private BuilderImpl() {
        }

        private BuilderImpl(JobLogEventData model) {
            conversionServerID(model.conversionServerID);
            rawError(model.rawError);
            sourceServerID(model.sourceServerID);
            targetInstanceID(model.targetInstanceID);
        }

        public final String getConversionServerID() {
            return conversionServerID;
        }

        public final void setConversionServerID(String conversionServerID) {
            this.conversionServerID = conversionServerID;
        }

        @Override
        public final Builder conversionServerID(String conversionServerID) {
            this.conversionServerID = conversionServerID;
            return this;
        }

        public final String getRawError() {
            return rawError;
        }

        public final void setRawError(String rawError) {
            this.rawError = rawError;
        }

        @Override
        public final Builder rawError(String rawError) {
            this.rawError = rawError;
            return this;
        }

        public final String getSourceServerID() {
            return sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final String getTargetInstanceID() {
            return targetInstanceID;
        }

        public final void setTargetInstanceID(String targetInstanceID) {
            this.targetInstanceID = targetInstanceID;
        }

        @Override
        public final Builder targetInstanceID(String targetInstanceID) {
            this.targetInstanceID = targetInstanceID;
            return this;
        }

        @Override
        public JobLogEventData build() {
            return new JobLogEventData(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
