/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteJobRequest extends MgnRequest implements ToCopyableBuilder<DeleteJobRequest.Builder, DeleteJobRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("accountID").getter(getter(DeleteJobRequest::accountID)).setter(setter(Builder::accountID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountID").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobID")
            .getter(getter(DeleteJobRequest::jobID)).setter(setter(Builder::jobID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(ACCOUNT_ID_FIELD, JOB_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String accountID;

    private final String jobID;

    private DeleteJobRequest(BuilderImpl builder) {
        super(builder);
        this.accountID = builder.accountID;
        this.jobID = builder.jobID;
    }

    /**
     * <p>
     * Request to delete Job from service by Account ID.
     * </p>
     * 
     * @return Request to delete Job from service by Account ID.
     */
    public final String accountID() {
        return accountID;
    }

    /**
     * <p>
     * Request to delete Job from service by Job ID.
     * </p>
     * 
     * @return Request to delete Job from service by Job ID.
     */
    public final String jobID() {
        return jobID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(accountID());
        hashCode = 31 * hashCode + Objects.hashCode(jobID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteJobRequest)) {
            return false;
        }
        DeleteJobRequest other = (DeleteJobRequest) obj;
        return Objects.equals(accountID(), other.accountID()) && Objects.equals(jobID(), other.jobID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteJobRequest").add("AccountID", accountID()).add("JobID", jobID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "accountID":
            return Optional.ofNullable(clazz.cast(accountID()));
        case "jobID":
            return Optional.ofNullable(clazz.cast(jobID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("accountID", ACCOUNT_ID_FIELD);
        map.put("jobID", JOB_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteJobRequest, T> g) {
        return obj -> g.apply((DeleteJobRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MgnRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteJobRequest> {
        /**
         * <p>
         * Request to delete Job from service by Account ID.
         * </p>
         * 
         * @param accountID
         *        Request to delete Job from service by Account ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountID(String accountID);

        /**
         * <p>
         * Request to delete Job from service by Job ID.
         * </p>
         * 
         * @param jobID
         *        Request to delete Job from service by Job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobID(String jobID);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MgnRequest.BuilderImpl implements Builder {
        private String accountID;

        private String jobID;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteJobRequest model) {
            super(model);
            accountID(model.accountID);
            jobID(model.jobID);
        }

        public final String getAccountID() {
            return accountID;
        }

        public final void setAccountID(String accountID) {
            this.accountID = accountID;
        }

        @Override
        public final Builder accountID(String accountID) {
            this.accountID = accountID;
            return this;
        }

        public final String getJobID() {
            return jobID;
        }

        public final void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @Override
        public final Builder jobID(String jobID) {
            this.jobID = jobID;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteJobRequest build() {
            return new DeleteJobRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
