/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnAsyncClient;
import software.amazon.awssdk.services.mgn.internal.UserAgentUtils;
import software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest;
import software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse;
import software.amazon.awssdk.services.mgn.model.SourceServer;

public class DescribeSourceServersPublisher
implements SdkPublisher<DescribeSourceServersResponse> {
    private final MgnAsyncClient client;
    private final DescribeSourceServersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSourceServersPublisher(MgnAsyncClient client, DescribeSourceServersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSourceServersPublisher(MgnAsyncClient client, DescribeSourceServersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSourceServersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSourceServersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SourceServer> items() {
        Function<DescribeSourceServersResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSourceServersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeSourceServersResponseFetcher
    implements AsyncPageFetcher<DescribeSourceServersResponse> {
        private DescribeSourceServersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSourceServersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSourceServersResponse> nextPage(DescribeSourceServersResponse previousPage) {
            if (previousPage == null) {
                return DescribeSourceServersPublisher.this.client.describeSourceServers(DescribeSourceServersPublisher.this.firstRequest);
            }
            return DescribeSourceServersPublisher.this.client.describeSourceServers((DescribeSourceServersRequest)((Object)DescribeSourceServersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

