/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mgn.model.MgnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteJobRequest
extends MgnRequest
implements ToCopyableBuilder<Builder, DeleteJobRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountID").getter(DeleteJobRequest.getter(DeleteJobRequest::accountID)).setter(DeleteJobRequest.setter(Builder::accountID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountID").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobID").getter(DeleteJobRequest.getter(DeleteJobRequest::jobID)).setter(DeleteJobRequest.setter(Builder::jobID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, JOB_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteJobRequest.memberNameToFieldInitializer();
    private final String accountID;
    private final String jobID;

    private DeleteJobRequest(BuilderImpl builder) {
        super(builder);
        this.accountID = builder.accountID;
        this.jobID = builder.jobID;
    }

    public final String accountID() {
        return this.accountID;
    }

    public final String jobID() {
        return this.jobID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountID());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobID());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteJobRequest)) {
            return false;
        }
        DeleteJobRequest other = (DeleteJobRequest)((Object)obj);
        return Objects.equals(this.accountID(), other.accountID()) && Objects.equals(this.jobID(), other.jobID());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteJobRequest").add("AccountID", (Object)this.accountID()).add("JobID", (Object)this.jobID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountID": {
                return Optional.ofNullable(clazz.cast(this.accountID()));
            }
            case "jobID": {
                return Optional.ofNullable(clazz.cast(this.jobID()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("accountID", ACCOUNT_ID_FIELD);
        map.put("jobID", JOB_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteJobRequest, T> g) {
        return obj -> g.apply((DeleteJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnRequest.BuilderImpl
    implements Builder {
        private String accountID;
        private String jobID;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteJobRequest model) {
            super(model);
            this.accountID(model.accountID);
            this.jobID(model.jobID);
        }

        public final String getAccountID() {
            return this.accountID;
        }

        public final void setAccountID(String accountID) {
            this.accountID = accountID;
        }

        @Override
        public final Builder accountID(String accountID) {
            this.accountID = accountID;
            return this;
        }

        public final String getJobID() {
            return this.jobID;
        }

        public final void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @Override
        public final Builder jobID(String jobID) {
            this.jobID = jobID;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteJobRequest build() {
            return new DeleteJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MgnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteJobRequest> {
        public Builder accountID(String var1);

        public Builder jobID(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

