/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mgn.model.ConnectorSsmCommandConfig;
import software.amazon.awssdk.services.mgn.model.MgnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateConnectorRequest
extends MgnRequest
implements ToCopyableBuilder<Builder, UpdateConnectorRequest> {
    private static final SdkField<String> CONNECTOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("connectorID").getter(UpdateConnectorRequest.getter(UpdateConnectorRequest::connectorID)).setter(UpdateConnectorRequest.setter(Builder::connectorID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("connectorID").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(UpdateConnectorRequest.getter(UpdateConnectorRequest::name)).setter(UpdateConnectorRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<ConnectorSsmCommandConfig> SSM_COMMAND_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ssmCommandConfig").getter(UpdateConnectorRequest.getter(UpdateConnectorRequest::ssmCommandConfig)).setter(UpdateConnectorRequest.setter(Builder::ssmCommandConfig)).constructor(ConnectorSsmCommandConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmCommandConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONNECTOR_ID_FIELD, NAME_FIELD, SSM_COMMAND_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateConnectorRequest.memberNameToFieldInitializer();
    private final String connectorID;
    private final String name;
    private final ConnectorSsmCommandConfig ssmCommandConfig;

    private UpdateConnectorRequest(BuilderImpl builder) {
        super(builder);
        this.connectorID = builder.connectorID;
        this.name = builder.name;
        this.ssmCommandConfig = builder.ssmCommandConfig;
    }

    public final String connectorID() {
        return this.connectorID;
    }

    public final String name() {
        return this.name;
    }

    public final ConnectorSsmCommandConfig ssmCommandConfig() {
        return this.ssmCommandConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.connectorID());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.ssmCommandConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateConnectorRequest)) {
            return false;
        }
        UpdateConnectorRequest other = (UpdateConnectorRequest)((Object)obj);
        return Objects.equals(this.connectorID(), other.connectorID()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.ssmCommandConfig(), other.ssmCommandConfig());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateConnectorRequest").add("ConnectorID", (Object)this.connectorID()).add("Name", (Object)this.name()).add("SsmCommandConfig", (Object)this.ssmCommandConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "connectorID": {
                return Optional.ofNullable(clazz.cast(this.connectorID()));
            }
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ssmCommandConfig": {
                return Optional.ofNullable(clazz.cast(this.ssmCommandConfig()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("connectorID", CONNECTOR_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("ssmCommandConfig", SSM_COMMAND_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateConnectorRequest, T> g) {
        return obj -> g.apply((UpdateConnectorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnRequest.BuilderImpl
    implements Builder {
        private String connectorID;
        private String name;
        private ConnectorSsmCommandConfig ssmCommandConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateConnectorRequest model) {
            super(model);
            this.connectorID(model.connectorID);
            this.name(model.name);
            this.ssmCommandConfig(model.ssmCommandConfig);
        }

        public final String getConnectorID() {
            return this.connectorID;
        }

        public final void setConnectorID(String connectorID) {
            this.connectorID = connectorID;
        }

        @Override
        public final Builder connectorID(String connectorID) {
            this.connectorID = connectorID;
            return this;
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final ConnectorSsmCommandConfig.Builder getSsmCommandConfig() {
            return this.ssmCommandConfig != null ? this.ssmCommandConfig.toBuilder() : null;
        }

        public final void setSsmCommandConfig(ConnectorSsmCommandConfig.BuilderImpl ssmCommandConfig) {
            this.ssmCommandConfig = ssmCommandConfig != null ? ssmCommandConfig.build() : null;
        }

        @Override
        public final Builder ssmCommandConfig(ConnectorSsmCommandConfig ssmCommandConfig) {
            this.ssmCommandConfig = ssmCommandConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateConnectorRequest build() {
            return new UpdateConnectorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MgnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateConnectorRequest> {
        public Builder connectorID(String var1);

        public Builder name(String var1);

        public Builder ssmCommandConfig(ConnectorSsmCommandConfig var1);

        default public Builder ssmCommandConfig(Consumer<ConnectorSsmCommandConfig.Builder> ssmCommandConfig) {
            return this.ssmCommandConfig((ConnectorSsmCommandConfig)((ConnectorSsmCommandConfig.Builder)ConnectorSsmCommandConfig.builder().applyMutation(ssmCommandConfig)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

