/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mgn.model.WaveHealthStatus;
import software.amazon.awssdk.services.mgn.model.WaveProgressStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WaveAggregatedStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WaveAggregatedStatus> {
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("healthStatus").getter(WaveAggregatedStatus.getter(WaveAggregatedStatus::healthStatusAsString)).setter(WaveAggregatedStatus.setter(Builder::healthStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthStatus").build()}).build();
    private static final SdkField<String> LAST_UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdateDateTime").getter(WaveAggregatedStatus.getter(WaveAggregatedStatus::lastUpdateDateTime)).setter(WaveAggregatedStatus.setter(Builder::lastUpdateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateDateTime").build()}).build();
    private static final SdkField<String> PROGRESS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("progressStatus").getter(WaveAggregatedStatus.getter(WaveAggregatedStatus::progressStatusAsString)).setter(WaveAggregatedStatus.setter(Builder::progressStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressStatus").build()}).build();
    private static final SdkField<String> REPLICATION_STARTED_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("replicationStartedDateTime").getter(WaveAggregatedStatus.getter(WaveAggregatedStatus::replicationStartedDateTime)).setter(WaveAggregatedStatus.setter(Builder::replicationStartedDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("replicationStartedDateTime").build()}).build();
    private static final SdkField<Long> TOTAL_APPLICATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalApplications").getter(WaveAggregatedStatus.getter(WaveAggregatedStatus::totalApplications)).setter(WaveAggregatedStatus.setter(Builder::totalApplications)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalApplications").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_STATUS_FIELD, LAST_UPDATE_DATE_TIME_FIELD, PROGRESS_STATUS_FIELD, REPLICATION_STARTED_DATE_TIME_FIELD, TOTAL_APPLICATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WaveAggregatedStatus.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String healthStatus;
    private final String lastUpdateDateTime;
    private final String progressStatus;
    private final String replicationStartedDateTime;
    private final Long totalApplications;

    private WaveAggregatedStatus(BuilderImpl builder) {
        this.healthStatus = builder.healthStatus;
        this.lastUpdateDateTime = builder.lastUpdateDateTime;
        this.progressStatus = builder.progressStatus;
        this.replicationStartedDateTime = builder.replicationStartedDateTime;
        this.totalApplications = builder.totalApplications;
    }

    public final WaveHealthStatus healthStatus() {
        return WaveHealthStatus.fromValue(this.healthStatus);
    }

    public final String healthStatusAsString() {
        return this.healthStatus;
    }

    public final String lastUpdateDateTime() {
        return this.lastUpdateDateTime;
    }

    public final WaveProgressStatus progressStatus() {
        return WaveProgressStatus.fromValue(this.progressStatus);
    }

    public final String progressStatusAsString() {
        return this.progressStatus;
    }

    public final String replicationStartedDateTime() {
        return this.replicationStartedDateTime;
    }

    public final Long totalApplications() {
        return this.totalApplications;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicationStartedDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalApplications());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WaveAggregatedStatus)) {
            return false;
        }
        WaveAggregatedStatus other = (WaveAggregatedStatus)obj;
        return Objects.equals(this.healthStatusAsString(), other.healthStatusAsString()) && Objects.equals(this.lastUpdateDateTime(), other.lastUpdateDateTime()) && Objects.equals(this.progressStatusAsString(), other.progressStatusAsString()) && Objects.equals(this.replicationStartedDateTime(), other.replicationStartedDateTime()) && Objects.equals(this.totalApplications(), other.totalApplications());
    }

    public final String toString() {
        return ToString.builder((String)"WaveAggregatedStatus").add("HealthStatus", (Object)this.healthStatusAsString()).add("LastUpdateDateTime", (Object)this.lastUpdateDateTime()).add("ProgressStatus", (Object)this.progressStatusAsString()).add("ReplicationStartedDateTime", (Object)this.replicationStartedDateTime()).add("TotalApplications", (Object)this.totalApplications()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "healthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatusAsString()));
            }
            case "lastUpdateDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateDateTime()));
            }
            case "progressStatus": {
                return Optional.ofNullable(clazz.cast(this.progressStatusAsString()));
            }
            case "replicationStartedDateTime": {
                return Optional.ofNullable(clazz.cast(this.replicationStartedDateTime()));
            }
            case "totalApplications": {
                return Optional.ofNullable(clazz.cast(this.totalApplications()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("healthStatus", HEALTH_STATUS_FIELD);
        map.put("lastUpdateDateTime", LAST_UPDATE_DATE_TIME_FIELD);
        map.put("progressStatus", PROGRESS_STATUS_FIELD);
        map.put("replicationStartedDateTime", REPLICATION_STARTED_DATE_TIME_FIELD);
        map.put("totalApplications", TOTAL_APPLICATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WaveAggregatedStatus, T> g) {
        return obj -> g.apply((WaveAggregatedStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String healthStatus;
        private String lastUpdateDateTime;
        private String progressStatus;
        private String replicationStartedDateTime;
        private Long totalApplications;

        private BuilderImpl() {
        }

        private BuilderImpl(WaveAggregatedStatus model) {
            this.healthStatus(model.healthStatus);
            this.lastUpdateDateTime(model.lastUpdateDateTime);
            this.progressStatus(model.progressStatus);
            this.replicationStartedDateTime(model.replicationStartedDateTime);
            this.totalApplications(model.totalApplications);
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(WaveHealthStatus healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public final String getLastUpdateDateTime() {
            return this.lastUpdateDateTime;
        }

        public final void setLastUpdateDateTime(String lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
        }

        @Override
        public final Builder lastUpdateDateTime(String lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
            return this;
        }

        public final String getProgressStatus() {
            return this.progressStatus;
        }

        public final void setProgressStatus(String progressStatus) {
            this.progressStatus = progressStatus;
        }

        @Override
        public final Builder progressStatus(String progressStatus) {
            this.progressStatus = progressStatus;
            return this;
        }

        @Override
        public final Builder progressStatus(WaveProgressStatus progressStatus) {
            this.progressStatus(progressStatus == null ? null : progressStatus.toString());
            return this;
        }

        public final String getReplicationStartedDateTime() {
            return this.replicationStartedDateTime;
        }

        public final void setReplicationStartedDateTime(String replicationStartedDateTime) {
            this.replicationStartedDateTime = replicationStartedDateTime;
        }

        @Override
        public final Builder replicationStartedDateTime(String replicationStartedDateTime) {
            this.replicationStartedDateTime = replicationStartedDateTime;
            return this;
        }

        public final Long getTotalApplications() {
            return this.totalApplications;
        }

        public final void setTotalApplications(Long totalApplications) {
            this.totalApplications = totalApplications;
        }

        @Override
        public final Builder totalApplications(Long totalApplications) {
            this.totalApplications = totalApplications;
            return this;
        }

        public WaveAggregatedStatus build() {
            return new WaveAggregatedStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WaveAggregatedStatus> {
        public Builder healthStatus(String var1);

        public Builder healthStatus(WaveHealthStatus var1);

        public Builder lastUpdateDateTime(String var1);

        public Builder progressStatus(String var1);

        public Builder progressStatus(WaveProgressStatus var1);

        public Builder replicationStartedDateTime(String var1);

        public Builder totalApplications(Long var1);
    }
}

