/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnClient;
import software.amazon.awssdk.services.mgn.internal.UserAgentUtils;
import software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesRequest;
import software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesResponse;
import software.amazon.awssdk.services.mgn.model.LaunchConfigurationTemplate;

public class DescribeLaunchConfigurationTemplatesIterable
implements SdkIterable<DescribeLaunchConfigurationTemplatesResponse> {
    private final MgnClient client;
    private final DescribeLaunchConfigurationTemplatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeLaunchConfigurationTemplatesIterable(MgnClient client, DescribeLaunchConfigurationTemplatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new DescribeLaunchConfigurationTemplatesResponseFetcher();
    }

    public Iterator<DescribeLaunchConfigurationTemplatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LaunchConfigurationTemplate> items() {
        Function<DescribeLaunchConfigurationTemplatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeLaunchConfigurationTemplatesResponseFetcher
    implements SyncPageFetcher<DescribeLaunchConfigurationTemplatesResponse> {
        private DescribeLaunchConfigurationTemplatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeLaunchConfigurationTemplatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeLaunchConfigurationTemplatesResponse nextPage(DescribeLaunchConfigurationTemplatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeLaunchConfigurationTemplatesIterable.this.client.describeLaunchConfigurationTemplates(DescribeLaunchConfigurationTemplatesIterable.this.firstRequest);
            }
            return DescribeLaunchConfigurationTemplatesIterable.this.client.describeLaunchConfigurationTemplates((DescribeLaunchConfigurationTemplatesRequest)((Object)DescribeLaunchConfigurationTemplatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

