/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.mgn.model.PostLaunchActionsDeploymentType;
import software.amazon.awssdk.services.mgn.model.SsmDocument;
import software.amazon.awssdk.services.mgn.model.SsmDocumentsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PostLaunchActions
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PostLaunchActions> {
    private static final SdkField<String> CLOUD_WATCH_LOG_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cloudWatchLogGroupName").getter(PostLaunchActions.getter(PostLaunchActions::cloudWatchLogGroupName)).setter(PostLaunchActions.setter(Builder::cloudWatchLogGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogGroupName").build()}).build();
    private static final SdkField<String> DEPLOYMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deployment").getter(PostLaunchActions.getter(PostLaunchActions::deploymentAsString)).setter(PostLaunchActions.setter(Builder::deployment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployment").build()}).build();
    private static final SdkField<String> S3_LOG_BUCKET_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3LogBucket").getter(PostLaunchActions.getter(PostLaunchActions::s3LogBucket)).setter(PostLaunchActions.setter(Builder::s3LogBucket)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3LogBucket").build()}).build();
    private static final SdkField<String> S3_OUTPUT_KEY_PREFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("s3OutputKeyPrefix").getter(PostLaunchActions.getter(PostLaunchActions::s3OutputKeyPrefix)).setter(PostLaunchActions.setter(Builder::s3OutputKeyPrefix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3OutputKeyPrefix").build()}).build();
    private static final SdkField<List<SsmDocument>> SSM_DOCUMENTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ssmDocuments").getter(PostLaunchActions.getter(PostLaunchActions::ssmDocuments)).setter(PostLaunchActions.setter(Builder::ssmDocuments)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ssmDocuments").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SsmDocument::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOG_GROUP_NAME_FIELD, DEPLOYMENT_FIELD, S3_LOG_BUCKET_FIELD, S3_OUTPUT_KEY_PREFIX_FIELD, SSM_DOCUMENTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PostLaunchActions.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String cloudWatchLogGroupName;
    private final String deployment;
    private final String s3LogBucket;
    private final String s3OutputKeyPrefix;
    private final List<SsmDocument> ssmDocuments;

    private PostLaunchActions(BuilderImpl builder) {
        this.cloudWatchLogGroupName = builder.cloudWatchLogGroupName;
        this.deployment = builder.deployment;
        this.s3LogBucket = builder.s3LogBucket;
        this.s3OutputKeyPrefix = builder.s3OutputKeyPrefix;
        this.ssmDocuments = builder.ssmDocuments;
    }

    public final String cloudWatchLogGroupName() {
        return this.cloudWatchLogGroupName;
    }

    public final PostLaunchActionsDeploymentType deployment() {
        return PostLaunchActionsDeploymentType.fromValue(this.deployment);
    }

    public final String deploymentAsString() {
        return this.deployment;
    }

    public final String s3LogBucket() {
        return this.s3LogBucket;
    }

    public final String s3OutputKeyPrefix() {
        return this.s3OutputKeyPrefix;
    }

    public final boolean hasSsmDocuments() {
        return this.ssmDocuments != null && !(this.ssmDocuments instanceof SdkAutoConstructList);
    }

    public final List<SsmDocument> ssmDocuments() {
        return this.ssmDocuments;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.deploymentAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3LogBucket());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3OutputKeyPrefix());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSsmDocuments() ? this.ssmDocuments() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PostLaunchActions)) {
            return false;
        }
        PostLaunchActions other = (PostLaunchActions)obj;
        return Objects.equals(this.cloudWatchLogGroupName(), other.cloudWatchLogGroupName()) && Objects.equals(this.deploymentAsString(), other.deploymentAsString()) && Objects.equals(this.s3LogBucket(), other.s3LogBucket()) && Objects.equals(this.s3OutputKeyPrefix(), other.s3OutputKeyPrefix()) && this.hasSsmDocuments() == other.hasSsmDocuments() && Objects.equals(this.ssmDocuments(), other.ssmDocuments());
    }

    public final String toString() {
        return ToString.builder((String)"PostLaunchActions").add("CloudWatchLogGroupName", (Object)this.cloudWatchLogGroupName()).add("Deployment", (Object)this.deploymentAsString()).add("S3LogBucket", (Object)this.s3LogBucket()).add("S3OutputKeyPrefix", (Object)this.s3OutputKeyPrefix()).add("SsmDocuments", this.hasSsmDocuments() ? this.ssmDocuments() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudWatchLogGroupName": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogGroupName()));
            }
            case "deployment": {
                return Optional.ofNullable(clazz.cast(this.deploymentAsString()));
            }
            case "s3LogBucket": {
                return Optional.ofNullable(clazz.cast(this.s3LogBucket()));
            }
            case "s3OutputKeyPrefix": {
                return Optional.ofNullable(clazz.cast(this.s3OutputKeyPrefix()));
            }
            case "ssmDocuments": {
                return Optional.ofNullable(clazz.cast(this.ssmDocuments()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cloudWatchLogGroupName", CLOUD_WATCH_LOG_GROUP_NAME_FIELD);
        map.put("deployment", DEPLOYMENT_FIELD);
        map.put("s3LogBucket", S3_LOG_BUCKET_FIELD);
        map.put("s3OutputKeyPrefix", S3_OUTPUT_KEY_PREFIX_FIELD);
        map.put("ssmDocuments", SSM_DOCUMENTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PostLaunchActions, T> g) {
        return obj -> g.apply((PostLaunchActions)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String cloudWatchLogGroupName;
        private String deployment;
        private String s3LogBucket;
        private String s3OutputKeyPrefix;
        private List<SsmDocument> ssmDocuments = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PostLaunchActions model) {
            this.cloudWatchLogGroupName(model.cloudWatchLogGroupName);
            this.deployment(model.deployment);
            this.s3LogBucket(model.s3LogBucket);
            this.s3OutputKeyPrefix(model.s3OutputKeyPrefix);
            this.ssmDocuments(model.ssmDocuments);
        }

        public final String getCloudWatchLogGroupName() {
            return this.cloudWatchLogGroupName;
        }

        public final void setCloudWatchLogGroupName(String cloudWatchLogGroupName) {
            this.cloudWatchLogGroupName = cloudWatchLogGroupName;
        }

        @Override
        public final Builder cloudWatchLogGroupName(String cloudWatchLogGroupName) {
            this.cloudWatchLogGroupName = cloudWatchLogGroupName;
            return this;
        }

        public final String getDeployment() {
            return this.deployment;
        }

        public final void setDeployment(String deployment) {
            this.deployment = deployment;
        }

        @Override
        public final Builder deployment(String deployment) {
            this.deployment = deployment;
            return this;
        }

        @Override
        public final Builder deployment(PostLaunchActionsDeploymentType deployment) {
            this.deployment(deployment == null ? null : deployment.toString());
            return this;
        }

        public final String getS3LogBucket() {
            return this.s3LogBucket;
        }

        public final void setS3LogBucket(String s3LogBucket) {
            this.s3LogBucket = s3LogBucket;
        }

        @Override
        public final Builder s3LogBucket(String s3LogBucket) {
            this.s3LogBucket = s3LogBucket;
            return this;
        }

        public final String getS3OutputKeyPrefix() {
            return this.s3OutputKeyPrefix;
        }

        public final void setS3OutputKeyPrefix(String s3OutputKeyPrefix) {
            this.s3OutputKeyPrefix = s3OutputKeyPrefix;
        }

        @Override
        public final Builder s3OutputKeyPrefix(String s3OutputKeyPrefix) {
            this.s3OutputKeyPrefix = s3OutputKeyPrefix;
            return this;
        }

        public final List<SsmDocument.Builder> getSsmDocuments() {
            List<SsmDocument.Builder> result = SsmDocumentsCopier.copyToBuilder(this.ssmDocuments);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSsmDocuments(Collection<SsmDocument.BuilderImpl> ssmDocuments) {
            this.ssmDocuments = SsmDocumentsCopier.copyFromBuilder(ssmDocuments);
        }

        @Override
        public final Builder ssmDocuments(Collection<SsmDocument> ssmDocuments) {
            this.ssmDocuments = SsmDocumentsCopier.copy(ssmDocuments);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ssmDocuments(SsmDocument ... ssmDocuments) {
            this.ssmDocuments(Arrays.asList(ssmDocuments));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder ssmDocuments(Consumer<SsmDocument.Builder> ... ssmDocuments) {
            this.ssmDocuments(Stream.of(ssmDocuments).map(c -> (SsmDocument)((SsmDocument.Builder)SsmDocument.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PostLaunchActions build() {
            return new PostLaunchActions(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PostLaunchActions> {
        public Builder cloudWatchLogGroupName(String var1);

        public Builder deployment(String var1);

        public Builder deployment(PostLaunchActionsDeploymentType var1);

        public Builder s3LogBucket(String var1);

        public Builder s3OutputKeyPrefix(String var1);

        public Builder ssmDocuments(Collection<SsmDocument> var1);

        public Builder ssmDocuments(SsmDocument ... var1);

        public Builder ssmDocuments(Consumer<SsmDocument.Builder> ... var1);
    }
}

