/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mgn.model.LaunchStatus;
import software.amazon.awssdk.services.mgn.model.PostLaunchActionsStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ParticipatingServer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ParticipatingServer> {
    private static final SdkField<String> LAUNCH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchStatus").getter(ParticipatingServer.getter(ParticipatingServer::launchStatusAsString)).setter(ParticipatingServer.setter(Builder::launchStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchStatus").build()}).build();
    private static final SdkField<String> LAUNCHED_EC2_INSTANCE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchedEc2InstanceID").getter(ParticipatingServer.getter(ParticipatingServer::launchedEc2InstanceID)).setter(ParticipatingServer.setter(Builder::launchedEc2InstanceID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchedEc2InstanceID").build()}).build();
    private static final SdkField<PostLaunchActionsStatus> POST_LAUNCH_ACTIONS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("postLaunchActionsStatus").getter(ParticipatingServer.getter(ParticipatingServer::postLaunchActionsStatus)).setter(ParticipatingServer.setter(Builder::postLaunchActionsStatus)).constructor(PostLaunchActionsStatus::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postLaunchActionsStatus").build()}).build();
    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceServerID").getter(ParticipatingServer.getter(ParticipatingServer::sourceServerID)).setter(ParticipatingServer.setter(Builder::sourceServerID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LAUNCH_STATUS_FIELD, LAUNCHED_EC2_INSTANCE_ID_FIELD, POST_LAUNCH_ACTIONS_STATUS_FIELD, SOURCE_SERVER_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ParticipatingServer.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String launchStatus;
    private final String launchedEc2InstanceID;
    private final PostLaunchActionsStatus postLaunchActionsStatus;
    private final String sourceServerID;

    private ParticipatingServer(BuilderImpl builder) {
        this.launchStatus = builder.launchStatus;
        this.launchedEc2InstanceID = builder.launchedEc2InstanceID;
        this.postLaunchActionsStatus = builder.postLaunchActionsStatus;
        this.sourceServerID = builder.sourceServerID;
    }

    public final LaunchStatus launchStatus() {
        return LaunchStatus.fromValue(this.launchStatus);
    }

    public final String launchStatusAsString() {
        return this.launchStatus;
    }

    public final String launchedEc2InstanceID() {
        return this.launchedEc2InstanceID;
    }

    public final PostLaunchActionsStatus postLaunchActionsStatus() {
        return this.postLaunchActionsStatus;
    }

    public final String sourceServerID() {
        return this.sourceServerID;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.launchStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchedEc2InstanceID());
        hashCode = 31 * hashCode + Objects.hashCode(this.postLaunchActionsStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceServerID());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ParticipatingServer)) {
            return false;
        }
        ParticipatingServer other = (ParticipatingServer)obj;
        return Objects.equals(this.launchStatusAsString(), other.launchStatusAsString()) && Objects.equals(this.launchedEc2InstanceID(), other.launchedEc2InstanceID()) && Objects.equals(this.postLaunchActionsStatus(), other.postLaunchActionsStatus()) && Objects.equals(this.sourceServerID(), other.sourceServerID());
    }

    public final String toString() {
        return ToString.builder((String)"ParticipatingServer").add("LaunchStatus", (Object)this.launchStatusAsString()).add("LaunchedEc2InstanceID", (Object)this.launchedEc2InstanceID()).add("PostLaunchActionsStatus", (Object)this.postLaunchActionsStatus()).add("SourceServerID", (Object)this.sourceServerID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "launchStatus": {
                return Optional.ofNullable(clazz.cast(this.launchStatusAsString()));
            }
            case "launchedEc2InstanceID": {
                return Optional.ofNullable(clazz.cast(this.launchedEc2InstanceID()));
            }
            case "postLaunchActionsStatus": {
                return Optional.ofNullable(clazz.cast(this.postLaunchActionsStatus()));
            }
            case "sourceServerID": {
                return Optional.ofNullable(clazz.cast(this.sourceServerID()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("launchStatus", LAUNCH_STATUS_FIELD);
        map.put("launchedEc2InstanceID", LAUNCHED_EC2_INSTANCE_ID_FIELD);
        map.put("postLaunchActionsStatus", POST_LAUNCH_ACTIONS_STATUS_FIELD);
        map.put("sourceServerID", SOURCE_SERVER_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ParticipatingServer, T> g) {
        return obj -> g.apply((ParticipatingServer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String launchStatus;
        private String launchedEc2InstanceID;
        private PostLaunchActionsStatus postLaunchActionsStatus;
        private String sourceServerID;

        private BuilderImpl() {
        }

        private BuilderImpl(ParticipatingServer model) {
            this.launchStatus(model.launchStatus);
            this.launchedEc2InstanceID(model.launchedEc2InstanceID);
            this.postLaunchActionsStatus(model.postLaunchActionsStatus);
            this.sourceServerID(model.sourceServerID);
        }

        public final String getLaunchStatus() {
            return this.launchStatus;
        }

        public final void setLaunchStatus(String launchStatus) {
            this.launchStatus = launchStatus;
        }

        @Override
        public final Builder launchStatus(String launchStatus) {
            this.launchStatus = launchStatus;
            return this;
        }

        @Override
        public final Builder launchStatus(LaunchStatus launchStatus) {
            this.launchStatus(launchStatus == null ? null : launchStatus.toString());
            return this;
        }

        public final String getLaunchedEc2InstanceID() {
            return this.launchedEc2InstanceID;
        }

        public final void setLaunchedEc2InstanceID(String launchedEc2InstanceID) {
            this.launchedEc2InstanceID = launchedEc2InstanceID;
        }

        @Override
        public final Builder launchedEc2InstanceID(String launchedEc2InstanceID) {
            this.launchedEc2InstanceID = launchedEc2InstanceID;
            return this;
        }

        public final PostLaunchActionsStatus.Builder getPostLaunchActionsStatus() {
            return this.postLaunchActionsStatus != null ? this.postLaunchActionsStatus.toBuilder() : null;
        }

        public final void setPostLaunchActionsStatus(PostLaunchActionsStatus.BuilderImpl postLaunchActionsStatus) {
            this.postLaunchActionsStatus = postLaunchActionsStatus != null ? postLaunchActionsStatus.build() : null;
        }

        @Override
        public final Builder postLaunchActionsStatus(PostLaunchActionsStatus postLaunchActionsStatus) {
            this.postLaunchActionsStatus = postLaunchActionsStatus;
            return this;
        }

        public final String getSourceServerID() {
            return this.sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public ParticipatingServer build() {
            return new ParticipatingServer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ParticipatingServer> {
        public Builder launchStatus(String var1);

        public Builder launchStatus(LaunchStatus var1);

        public Builder launchedEc2InstanceID(String var1);

        public Builder postLaunchActionsStatus(PostLaunchActionsStatus var1);

        default public Builder postLaunchActionsStatus(Consumer<PostLaunchActionsStatus.Builder> postLaunchActionsStatus) {
            return this.postLaunchActionsStatus((PostLaunchActionsStatus)((PostLaunchActionsStatus.Builder)PostLaunchActionsStatus.builder().applyMutation(postLaunchActionsStatus)).build());
        }

        public Builder sourceServerID(String var1);
    }
}

