/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mgn.model.ApplicationHealthStatus;
import software.amazon.awssdk.services.mgn.model.ApplicationProgressStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApplicationAggregatedStatus
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ApplicationAggregatedStatus> {
    private static final SdkField<String> HEALTH_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("healthStatus").getter(ApplicationAggregatedStatus.getter(ApplicationAggregatedStatus::healthStatusAsString)).setter(ApplicationAggregatedStatus.setter(Builder::healthStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthStatus").build()}).build();
    private static final SdkField<String> LAST_UPDATE_DATE_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lastUpdateDateTime").getter(ApplicationAggregatedStatus.getter(ApplicationAggregatedStatus::lastUpdateDateTime)).setter(ApplicationAggregatedStatus.setter(Builder::lastUpdateDateTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdateDateTime").build()}).build();
    private static final SdkField<String> PROGRESS_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("progressStatus").getter(ApplicationAggregatedStatus.getter(ApplicationAggregatedStatus::progressStatusAsString)).setter(ApplicationAggregatedStatus.setter(Builder::progressStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("progressStatus").build()}).build();
    private static final SdkField<Long> TOTAL_SOURCE_SERVERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("totalSourceServers").getter(ApplicationAggregatedStatus.getter(ApplicationAggregatedStatus::totalSourceServers)).setter(ApplicationAggregatedStatus.setter(Builder::totalSourceServers)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("totalSourceServers").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_STATUS_FIELD, LAST_UPDATE_DATE_TIME_FIELD, PROGRESS_STATUS_FIELD, TOTAL_SOURCE_SERVERS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("healthStatus", HEALTH_STATUS_FIELD);
            this.put("lastUpdateDateTime", LAST_UPDATE_DATE_TIME_FIELD);
            this.put("progressStatus", PROGRESS_STATUS_FIELD);
            this.put("totalSourceServers", TOTAL_SOURCE_SERVERS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String healthStatus;
    private final String lastUpdateDateTime;
    private final String progressStatus;
    private final Long totalSourceServers;

    private ApplicationAggregatedStatus(BuilderImpl builder) {
        this.healthStatus = builder.healthStatus;
        this.lastUpdateDateTime = builder.lastUpdateDateTime;
        this.progressStatus = builder.progressStatus;
        this.totalSourceServers = builder.totalSourceServers;
    }

    public final ApplicationHealthStatus healthStatus() {
        return ApplicationHealthStatus.fromValue(this.healthStatus);
    }

    public final String healthStatusAsString() {
        return this.healthStatus;
    }

    public final String lastUpdateDateTime() {
        return this.lastUpdateDateTime;
    }

    public final ApplicationProgressStatus progressStatus() {
        return ApplicationProgressStatus.fromValue(this.progressStatus);
    }

    public final String progressStatusAsString() {
        return this.progressStatus;
    }

    public final Long totalSourceServers() {
        return this.totalSourceServers;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.healthStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdateDateTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.progressStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.totalSourceServers());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationAggregatedStatus)) {
            return false;
        }
        ApplicationAggregatedStatus other = (ApplicationAggregatedStatus)obj;
        return Objects.equals(this.healthStatusAsString(), other.healthStatusAsString()) && Objects.equals(this.lastUpdateDateTime(), other.lastUpdateDateTime()) && Objects.equals(this.progressStatusAsString(), other.progressStatusAsString()) && Objects.equals(this.totalSourceServers(), other.totalSourceServers());
    }

    public final String toString() {
        return ToString.builder((String)"ApplicationAggregatedStatus").add("HealthStatus", (Object)this.healthStatusAsString()).add("LastUpdateDateTime", (Object)this.lastUpdateDateTime()).add("ProgressStatus", (Object)this.progressStatusAsString()).add("TotalSourceServers", (Object)this.totalSourceServers()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "healthStatus": {
                return Optional.ofNullable(clazz.cast(this.healthStatusAsString()));
            }
            case "lastUpdateDateTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdateDateTime()));
            }
            case "progressStatus": {
                return Optional.ofNullable(clazz.cast(this.progressStatusAsString()));
            }
            case "totalSourceServers": {
                return Optional.ofNullable(clazz.cast(this.totalSourceServers()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationAggregatedStatus, T> g) {
        return obj -> g.apply((ApplicationAggregatedStatus)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String healthStatus;
        private String lastUpdateDateTime;
        private String progressStatus;
        private Long totalSourceServers;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationAggregatedStatus model) {
            this.healthStatus(model.healthStatus);
            this.lastUpdateDateTime(model.lastUpdateDateTime);
            this.progressStatus(model.progressStatus);
            this.totalSourceServers(model.totalSourceServers);
        }

        public final String getHealthStatus() {
            return this.healthStatus;
        }

        public final void setHealthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
        }

        @Override
        public final Builder healthStatus(String healthStatus) {
            this.healthStatus = healthStatus;
            return this;
        }

        @Override
        public final Builder healthStatus(ApplicationHealthStatus healthStatus) {
            this.healthStatus(healthStatus == null ? null : healthStatus.toString());
            return this;
        }

        public final String getLastUpdateDateTime() {
            return this.lastUpdateDateTime;
        }

        public final void setLastUpdateDateTime(String lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
        }

        @Override
        public final Builder lastUpdateDateTime(String lastUpdateDateTime) {
            this.lastUpdateDateTime = lastUpdateDateTime;
            return this;
        }

        public final String getProgressStatus() {
            return this.progressStatus;
        }

        public final void setProgressStatus(String progressStatus) {
            this.progressStatus = progressStatus;
        }

        @Override
        public final Builder progressStatus(String progressStatus) {
            this.progressStatus = progressStatus;
            return this;
        }

        @Override
        public final Builder progressStatus(ApplicationProgressStatus progressStatus) {
            this.progressStatus(progressStatus == null ? null : progressStatus.toString());
            return this;
        }

        public final Long getTotalSourceServers() {
            return this.totalSourceServers;
        }

        public final void setTotalSourceServers(Long totalSourceServers) {
            this.totalSourceServers = totalSourceServers;
        }

        @Override
        public final Builder totalSourceServers(Long totalSourceServers) {
            this.totalSourceServers = totalSourceServers;
            return this;
        }

        public ApplicationAggregatedStatus build() {
            return new ApplicationAggregatedStatus(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ApplicationAggregatedStatus> {
        public Builder healthStatus(String var1);

        public Builder healthStatus(ApplicationHealthStatus var1);

        public Builder lastUpdateDateTime(String var1);

        public Builder progressStatus(String var1);

        public Builder progressStatus(ApplicationProgressStatus var1);

        public Builder totalSourceServers(Long var1);
    }
}

