/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum SsmDocumentType {
    AUTOMATION("AUTOMATION"),
    COMMAND("COMMAND"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, SsmDocumentType> VALUE_MAP;
    private final String value;

    private SsmDocumentType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static SsmDocumentType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<SsmDocumentType> knownValues() {
        EnumSet<SsmDocumentType> knownValues = EnumSet.allOf(SsmDocumentType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(SsmDocumentType.class, SsmDocumentType::toString);
    }
}

