/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnClient;
import software.amazon.awssdk.services.mgn.internal.UserAgentUtils;
import software.amazon.awssdk.services.mgn.model.Connector;
import software.amazon.awssdk.services.mgn.model.ListConnectorsRequest;
import software.amazon.awssdk.services.mgn.model.ListConnectorsResponse;

public class ListConnectorsIterable
implements SdkIterable<ListConnectorsResponse> {
    private final MgnClient client;
    private final ListConnectorsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListConnectorsIterable(MgnClient client, ListConnectorsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListConnectorsResponseFetcher();
    }

    public Iterator<ListConnectorsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Connector> items() {
        Function<ListConnectorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListConnectorsResponseFetcher
    implements SyncPageFetcher<ListConnectorsResponse> {
        private ListConnectorsResponseFetcher() {
        }

        public boolean hasNextPage(ListConnectorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListConnectorsResponse nextPage(ListConnectorsResponse previousPage) {
            if (previousPage == null) {
                return ListConnectorsIterable.this.client.listConnectors(ListConnectorsIterable.this.firstRequest);
            }
            return ListConnectorsIterable.this.client.listConnectors((ListConnectorsRequest)((Object)ListConnectorsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

