/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mgn.model.MgnRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteWaveRequest
extends MgnRequest
implements ToCopyableBuilder<Builder, DeleteWaveRequest> {
    private static final SdkField<String> ACCOUNT_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("accountID").getter(DeleteWaveRequest.getter(DeleteWaveRequest::accountID)).setter(DeleteWaveRequest.setter(Builder::accountID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("accountID").build()}).build();
    private static final SdkField<String> WAVE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("waveID").getter(DeleteWaveRequest.getter(DeleteWaveRequest::waveID)).setter(DeleteWaveRequest.setter(Builder::waveID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("waveID").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_ID_FIELD, WAVE_ID_FIELD));
    private final String accountID;
    private final String waveID;

    private DeleteWaveRequest(BuilderImpl builder) {
        super(builder);
        this.accountID = builder.accountID;
        this.waveID = builder.waveID;
    }

    public final String accountID() {
        return this.accountID;
    }

    public final String waveID() {
        return this.waveID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accountID());
        hashCode = 31 * hashCode + Objects.hashCode(this.waveID());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteWaveRequest)) {
            return false;
        }
        DeleteWaveRequest other = (DeleteWaveRequest)((Object)obj);
        return Objects.equals(this.accountID(), other.accountID()) && Objects.equals(this.waveID(), other.waveID());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteWaveRequest").add("AccountID", (Object)this.accountID()).add("WaveID", (Object)this.waveID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "accountID": {
                return Optional.ofNullable(clazz.cast(this.accountID()));
            }
            case "waveID": {
                return Optional.ofNullable(clazz.cast(this.waveID()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeleteWaveRequest, T> g) {
        return obj -> g.apply((DeleteWaveRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnRequest.BuilderImpl
    implements Builder {
        private String accountID;
        private String waveID;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteWaveRequest model) {
            super(model);
            this.accountID(model.accountID);
            this.waveID(model.waveID);
        }

        public final String getAccountID() {
            return this.accountID;
        }

        public final void setAccountID(String accountID) {
            this.accountID = accountID;
        }

        @Override
        public final Builder accountID(String accountID) {
            this.accountID = accountID;
            return this;
        }

        public final String getWaveID() {
            return this.waveID;
        }

        public final void setWaveID(String waveID) {
            this.waveID = waveID;
        }

        @Override
        public final Builder waveID(String waveID) {
            this.waveID = waveID;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteWaveRequest build() {
            return new DeleteWaveRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MgnRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteWaveRequest> {
        public Builder accountID(String var1);

        public Builder waveID(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

