/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mgn.model.DataReplicationErrorString;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataReplicationError
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataReplicationError> {
    private static final SdkField<String> ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("error").getter(DataReplicationError.getter(DataReplicationError::errorAsString)).setter(DataReplicationError.setter(Builder::error)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()}).build();
    private static final SdkField<String> RAW_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("rawError").getter(DataReplicationError.getter(DataReplicationError::rawError)).setter(DataReplicationError.setter(Builder::rawError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rawError").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD, RAW_ERROR_FIELD));
    private static final long serialVersionUID = 1L;
    private final String error;
    private final String rawError;

    private DataReplicationError(BuilderImpl builder) {
        this.error = builder.error;
        this.rawError = builder.rawError;
    }

    public final DataReplicationErrorString error() {
        return DataReplicationErrorString.fromValue(this.error);
    }

    public final String errorAsString() {
        return this.error;
    }

    public final String rawError() {
        return this.rawError;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.errorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rawError());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataReplicationError)) {
            return false;
        }
        DataReplicationError other = (DataReplicationError)obj;
        return Objects.equals(this.errorAsString(), other.errorAsString()) && Objects.equals(this.rawError(), other.rawError());
    }

    public final String toString() {
        return ToString.builder((String)"DataReplicationError").add("Error", (Object)this.errorAsString()).add("RawError", (Object)this.rawError()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "error": {
                return Optional.ofNullable(clazz.cast(this.errorAsString()));
            }
            case "rawError": {
                return Optional.ofNullable(clazz.cast(this.rawError()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataReplicationError, T> g) {
        return obj -> g.apply((DataReplicationError)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String error;
        private String rawError;

        private BuilderImpl() {
        }

        private BuilderImpl(DataReplicationError model) {
            this.error(model.error);
            this.rawError(model.rawError);
        }

        public final String getError() {
            return this.error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public final Builder error(DataReplicationErrorString error) {
            this.error(error == null ? null : error.toString());
            return this;
        }

        public final String getRawError() {
            return this.rawError;
        }

        public final void setRawError(String rawError) {
            this.rawError = rawError;
        }

        @Override
        public final Builder rawError(String rawError) {
            this.rawError = rawError;
            return this;
        }

        public DataReplicationError build() {
            return new DataReplicationError(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataReplicationError> {
        public Builder error(String var1);

        public Builder error(DataReplicationErrorString var1);

        public Builder rawError(String var1);
    }
}

