/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.mgn.model.VolumeType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchTemplateDiskConf
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchTemplateDiskConf> {
    private static final SdkField<Long> IOPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("iops").getter(LaunchTemplateDiskConf.getter(LaunchTemplateDiskConf::iops)).setter(LaunchTemplateDiskConf.setter(Builder::iops)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iops").build()}).build();
    private static final SdkField<Long> THROUGHPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LONG).memberName("throughput").getter(LaunchTemplateDiskConf.getter(LaunchTemplateDiskConf::throughput)).setter(LaunchTemplateDiskConf.setter(Builder::throughput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("throughput").build()}).build();
    private static final SdkField<String> VOLUME_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("volumeType").getter(LaunchTemplateDiskConf.getter(LaunchTemplateDiskConf::volumeTypeAsString)).setter(LaunchTemplateDiskConf.setter(Builder::volumeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("volumeType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IOPS_FIELD, THROUGHPUT_FIELD, VOLUME_TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final Long iops;
    private final Long throughput;
    private final String volumeType;

    private LaunchTemplateDiskConf(BuilderImpl builder) {
        this.iops = builder.iops;
        this.throughput = builder.throughput;
        this.volumeType = builder.volumeType;
    }

    public final Long iops() {
        return this.iops;
    }

    public final Long throughput() {
        return this.throughput;
    }

    public final VolumeType volumeType() {
        return VolumeType.fromValue(this.volumeType);
    }

    public final String volumeTypeAsString() {
        return this.volumeType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.iops());
        hashCode = 31 * hashCode + Objects.hashCode(this.throughput());
        hashCode = 31 * hashCode + Objects.hashCode(this.volumeTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchTemplateDiskConf)) {
            return false;
        }
        LaunchTemplateDiskConf other = (LaunchTemplateDiskConf)obj;
        return Objects.equals(this.iops(), other.iops()) && Objects.equals(this.throughput(), other.throughput()) && Objects.equals(this.volumeTypeAsString(), other.volumeTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchTemplateDiskConf").add("Iops", (Object)this.iops()).add("Throughput", (Object)this.throughput()).add("VolumeType", (Object)this.volumeTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "iops": {
                return Optional.ofNullable(clazz.cast(this.iops()));
            }
            case "throughput": {
                return Optional.ofNullable(clazz.cast(this.throughput()));
            }
            case "volumeType": {
                return Optional.ofNullable(clazz.cast(this.volumeTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchTemplateDiskConf, T> g) {
        return obj -> g.apply((LaunchTemplateDiskConf)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Long iops;
        private Long throughput;
        private String volumeType;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchTemplateDiskConf model) {
            this.iops(model.iops);
            this.throughput(model.throughput);
            this.volumeType(model.volumeType);
        }

        public final Long getIops() {
            return this.iops;
        }

        public final void setIops(Long iops) {
            this.iops = iops;
        }

        @Override
        public final Builder iops(Long iops) {
            this.iops = iops;
            return this;
        }

        public final Long getThroughput() {
            return this.throughput;
        }

        public final void setThroughput(Long throughput) {
            this.throughput = throughput;
        }

        @Override
        public final Builder throughput(Long throughput) {
            this.throughput = throughput;
            return this;
        }

        public final String getVolumeType() {
            return this.volumeType;
        }

        public final void setVolumeType(String volumeType) {
            this.volumeType = volumeType;
        }

        @Override
        public final Builder volumeType(String volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        @Override
        public final Builder volumeType(VolumeType volumeType) {
            this.volumeType(volumeType == null ? null : volumeType.toString());
            return this;
        }

        public LaunchTemplateDiskConf build() {
            return new LaunchTemplateDiskConf(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchTemplateDiskConf> {
        public Builder iops(Long var1);

        public Builder throughput(Long var1);

        public Builder volumeType(String var1);

        public Builder volumeType(VolumeType var1);
    }
}

