/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnAsyncClient;
import software.amazon.awssdk.services.mgn.internal.UserAgentUtils;
import software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest;
import software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse;
import software.amazon.awssdk.services.mgn.model.JobLog;

public class DescribeJobLogItemsPublisher
implements SdkPublisher<DescribeJobLogItemsResponse> {
    private final MgnAsyncClient client;
    private final DescribeJobLogItemsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeJobLogItemsPublisher(MgnAsyncClient client, DescribeJobLogItemsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeJobLogItemsPublisher(MgnAsyncClient client, DescribeJobLogItemsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeJobLogItemsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeJobLogItemsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<JobLog> items() {
        Function<DescribeJobLogItemsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeJobLogItemsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeJobLogItemsResponseFetcher
    implements AsyncPageFetcher<DescribeJobLogItemsResponse> {
        private DescribeJobLogItemsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeJobLogItemsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeJobLogItemsResponse> nextPage(DescribeJobLogItemsResponse previousPage) {
            if (previousPage == null) {
                return DescribeJobLogItemsPublisher.this.client.describeJobLogItems(DescribeJobLogItemsPublisher.this.firstRequest);
            }
            return DescribeJobLogItemsPublisher.this.client.describeJobLogItems((DescribeJobLogItemsRequest)((Object)DescribeJobLogItemsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

