/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnAsyncClient;
import software.amazon.awssdk.services.mgn.internal.UserAgentUtils;
import software.amazon.awssdk.services.mgn.model.ImportTaskError;
import software.amazon.awssdk.services.mgn.model.ListImportErrorsRequest;
import software.amazon.awssdk.services.mgn.model.ListImportErrorsResponse;

public class ListImportErrorsPublisher
implements SdkPublisher<ListImportErrorsResponse> {
    private final MgnAsyncClient client;
    private final ListImportErrorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListImportErrorsPublisher(MgnAsyncClient client, ListImportErrorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListImportErrorsPublisher(MgnAsyncClient client, ListImportErrorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListImportErrorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListImportErrorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ImportTaskError> items() {
        Function<ListImportErrorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListImportErrorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListImportErrorsResponseFetcher
    implements AsyncPageFetcher<ListImportErrorsResponse> {
        private ListImportErrorsResponseFetcher() {
        }

        public boolean hasNextPage(ListImportErrorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListImportErrorsResponse> nextPage(ListImportErrorsResponse previousPage) {
            if (previousPage == null) {
                return ListImportErrorsPublisher.this.client.listImportErrors(ListImportErrorsPublisher.this.firstRequest);
            }
            return ListImportErrorsPublisher.this.client.listImportErrors((ListImportErrorsRequest)((Object)ListImportErrorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

