/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.mgn.model.AccessDeniedException;
import software.amazon.awssdk.services.mgn.model.ArchiveApplicationRequest;
import software.amazon.awssdk.services.mgn.model.ArchiveApplicationResponse;
import software.amazon.awssdk.services.mgn.model.ArchiveWaveRequest;
import software.amazon.awssdk.services.mgn.model.ArchiveWaveResponse;
import software.amazon.awssdk.services.mgn.model.AssociateApplicationsRequest;
import software.amazon.awssdk.services.mgn.model.AssociateApplicationsResponse;
import software.amazon.awssdk.services.mgn.model.AssociateSourceServersRequest;
import software.amazon.awssdk.services.mgn.model.AssociateSourceServersResponse;
import software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateRequest;
import software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateResponse;
import software.amazon.awssdk.services.mgn.model.ConflictException;
import software.amazon.awssdk.services.mgn.model.CreateApplicationRequest;
import software.amazon.awssdk.services.mgn.model.CreateApplicationResponse;
import software.amazon.awssdk.services.mgn.model.CreateLaunchConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.CreateLaunchConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.CreateReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.CreateReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.CreateWaveRequest;
import software.amazon.awssdk.services.mgn.model.CreateWaveResponse;
import software.amazon.awssdk.services.mgn.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.mgn.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.mgn.model.DeleteJobRequest;
import software.amazon.awssdk.services.mgn.model.DeleteJobResponse;
import software.amazon.awssdk.services.mgn.model.DeleteLaunchConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.DeleteLaunchConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.DeleteReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.DeleteReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.DeleteSourceServerRequest;
import software.amazon.awssdk.services.mgn.model.DeleteSourceServerResponse;
import software.amazon.awssdk.services.mgn.model.DeleteVcenterClientRequest;
import software.amazon.awssdk.services.mgn.model.DeleteVcenterClientResponse;
import software.amazon.awssdk.services.mgn.model.DeleteWaveRequest;
import software.amazon.awssdk.services.mgn.model.DeleteWaveResponse;
import software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest;
import software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse;
import software.amazon.awssdk.services.mgn.model.DescribeJobsRequest;
import software.amazon.awssdk.services.mgn.model.DescribeJobsResponse;
import software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesRequest;
import software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesResponse;
import software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest;
import software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse;
import software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest;
import software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse;
import software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest;
import software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsResponse;
import software.amazon.awssdk.services.mgn.model.DisassociateApplicationsRequest;
import software.amazon.awssdk.services.mgn.model.DisassociateApplicationsResponse;
import software.amazon.awssdk.services.mgn.model.DisassociateSourceServersRequest;
import software.amazon.awssdk.services.mgn.model.DisassociateSourceServersResponse;
import software.amazon.awssdk.services.mgn.model.DisconnectFromServiceRequest;
import software.amazon.awssdk.services.mgn.model.DisconnectFromServiceResponse;
import software.amazon.awssdk.services.mgn.model.FinalizeCutoverRequest;
import software.amazon.awssdk.services.mgn.model.FinalizeCutoverResponse;
import software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.InitializeServiceRequest;
import software.amazon.awssdk.services.mgn.model.InitializeServiceResponse;
import software.amazon.awssdk.services.mgn.model.InternalServerException;
import software.amazon.awssdk.services.mgn.model.ListApplicationsRequest;
import software.amazon.awssdk.services.mgn.model.ListApplicationsResponse;
import software.amazon.awssdk.services.mgn.model.ListExportErrorsRequest;
import software.amazon.awssdk.services.mgn.model.ListExportErrorsResponse;
import software.amazon.awssdk.services.mgn.model.ListExportsRequest;
import software.amazon.awssdk.services.mgn.model.ListExportsResponse;
import software.amazon.awssdk.services.mgn.model.ListImportErrorsRequest;
import software.amazon.awssdk.services.mgn.model.ListImportErrorsResponse;
import software.amazon.awssdk.services.mgn.model.ListImportsRequest;
import software.amazon.awssdk.services.mgn.model.ListImportsResponse;
import software.amazon.awssdk.services.mgn.model.ListManagedAccountsRequest;
import software.amazon.awssdk.services.mgn.model.ListManagedAccountsResponse;
import software.amazon.awssdk.services.mgn.model.ListSourceServerActionsRequest;
import software.amazon.awssdk.services.mgn.model.ListSourceServerActionsResponse;
import software.amazon.awssdk.services.mgn.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mgn.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mgn.model.ListTemplateActionsRequest;
import software.amazon.awssdk.services.mgn.model.ListTemplateActionsResponse;
import software.amazon.awssdk.services.mgn.model.ListWavesRequest;
import software.amazon.awssdk.services.mgn.model.ListWavesResponse;
import software.amazon.awssdk.services.mgn.model.MarkAsArchivedRequest;
import software.amazon.awssdk.services.mgn.model.MarkAsArchivedResponse;
import software.amazon.awssdk.services.mgn.model.MgnException;
import software.amazon.awssdk.services.mgn.model.PauseReplicationRequest;
import software.amazon.awssdk.services.mgn.model.PauseReplicationResponse;
import software.amazon.awssdk.services.mgn.model.PutSourceServerActionRequest;
import software.amazon.awssdk.services.mgn.model.PutSourceServerActionResponse;
import software.amazon.awssdk.services.mgn.model.PutTemplateActionRequest;
import software.amazon.awssdk.services.mgn.model.PutTemplateActionResponse;
import software.amazon.awssdk.services.mgn.model.RemoveSourceServerActionRequest;
import software.amazon.awssdk.services.mgn.model.RemoveSourceServerActionResponse;
import software.amazon.awssdk.services.mgn.model.RemoveTemplateActionRequest;
import software.amazon.awssdk.services.mgn.model.RemoveTemplateActionResponse;
import software.amazon.awssdk.services.mgn.model.ResourceNotFoundException;
import software.amazon.awssdk.services.mgn.model.ResumeReplicationRequest;
import software.amazon.awssdk.services.mgn.model.ResumeReplicationResponse;
import software.amazon.awssdk.services.mgn.model.RetryDataReplicationRequest;
import software.amazon.awssdk.services.mgn.model.RetryDataReplicationResponse;
import software.amazon.awssdk.services.mgn.model.ServiceQuotaExceededException;
import software.amazon.awssdk.services.mgn.model.StartCutoverRequest;
import software.amazon.awssdk.services.mgn.model.StartCutoverResponse;
import software.amazon.awssdk.services.mgn.model.StartExportRequest;
import software.amazon.awssdk.services.mgn.model.StartExportResponse;
import software.amazon.awssdk.services.mgn.model.StartImportRequest;
import software.amazon.awssdk.services.mgn.model.StartImportResponse;
import software.amazon.awssdk.services.mgn.model.StartReplicationRequest;
import software.amazon.awssdk.services.mgn.model.StartReplicationResponse;
import software.amazon.awssdk.services.mgn.model.StartTestRequest;
import software.amazon.awssdk.services.mgn.model.StartTestResponse;
import software.amazon.awssdk.services.mgn.model.StopReplicationRequest;
import software.amazon.awssdk.services.mgn.model.StopReplicationResponse;
import software.amazon.awssdk.services.mgn.model.TagResourceRequest;
import software.amazon.awssdk.services.mgn.model.TagResourceResponse;
import software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesRequest;
import software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesResponse;
import software.amazon.awssdk.services.mgn.model.ThrottlingException;
import software.amazon.awssdk.services.mgn.model.UnarchiveApplicationRequest;
import software.amazon.awssdk.services.mgn.model.UnarchiveApplicationResponse;
import software.amazon.awssdk.services.mgn.model.UnarchiveWaveRequest;
import software.amazon.awssdk.services.mgn.model.UnarchiveWaveResponse;
import software.amazon.awssdk.services.mgn.model.UninitializedAccountException;
import software.amazon.awssdk.services.mgn.model.UntagResourceRequest;
import software.amazon.awssdk.services.mgn.model.UntagResourceResponse;
import software.amazon.awssdk.services.mgn.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.mgn.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.UpdateSourceServerReplicationTypeRequest;
import software.amazon.awssdk.services.mgn.model.UpdateSourceServerReplicationTypeResponse;
import software.amazon.awssdk.services.mgn.model.UpdateWaveRequest;
import software.amazon.awssdk.services.mgn.model.UpdateWaveResponse;
import software.amazon.awssdk.services.mgn.model.ValidationException;
import software.amazon.awssdk.services.mgn.paginators.DescribeJobLogItemsIterable;
import software.amazon.awssdk.services.mgn.paginators.DescribeJobsIterable;
import software.amazon.awssdk.services.mgn.paginators.DescribeLaunchConfigurationTemplatesIterable;
import software.amazon.awssdk.services.mgn.paginators.DescribeReplicationConfigurationTemplatesIterable;
import software.amazon.awssdk.services.mgn.paginators.DescribeSourceServersIterable;
import software.amazon.awssdk.services.mgn.paginators.DescribeVcenterClientsIterable;
import software.amazon.awssdk.services.mgn.paginators.ListApplicationsIterable;
import software.amazon.awssdk.services.mgn.paginators.ListExportErrorsIterable;
import software.amazon.awssdk.services.mgn.paginators.ListExportsIterable;
import software.amazon.awssdk.services.mgn.paginators.ListImportErrorsIterable;
import software.amazon.awssdk.services.mgn.paginators.ListImportsIterable;
import software.amazon.awssdk.services.mgn.paginators.ListManagedAccountsIterable;
import software.amazon.awssdk.services.mgn.paginators.ListSourceServerActionsIterable;
import software.amazon.awssdk.services.mgn.paginators.ListTemplateActionsIterable;
import software.amazon.awssdk.services.mgn.paginators.ListWavesIterable;

/**
 * Service client for accessing mgn. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * The Application Migration Service service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MgnClient extends AwsClient {
    String SERVICE_NAME = "mgn";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "mgn";

    /**
     * <p>
     * Archive application.
     * </p>
     *
     * @param archiveApplicationRequest
     * @return Result of the ArchiveApplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ArchiveApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ArchiveApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default ArchiveApplicationResponse archiveApplication(ArchiveApplicationRequest archiveApplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Archive application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ArchiveApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link ArchiveApplicationRequest#builder()}
     * </p>
     *
     * @param archiveApplicationRequest
     *        A {@link Consumer} that will call methods on {@link ArchiveApplicationRequest.Builder} to create a
     *        request.
     * @return Result of the ArchiveApplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ArchiveApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ArchiveApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default ArchiveApplicationResponse archiveApplication(Consumer<ArchiveApplicationRequest.Builder> archiveApplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        return archiveApplication(ArchiveApplicationRequest.builder().applyMutation(archiveApplicationRequest).build());
    }

    /**
     * <p>
     * Archive wave.
     * </p>
     *
     * @param archiveWaveRequest
     * @return Result of the ArchiveWave operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ArchiveWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ArchiveWave" target="_top">AWS API
     *      Documentation</a>
     */
    default ArchiveWaveResponse archiveWave(ArchiveWaveRequest archiveWaveRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException,
            MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Archive wave.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ArchiveWaveRequest.Builder} avoiding the need to
     * create one manually via {@link ArchiveWaveRequest#builder()}
     * </p>
     *
     * @param archiveWaveRequest
     *        A {@link Consumer} that will call methods on {@link ArchiveWaveRequest.Builder} to create a request.
     * @return Result of the ArchiveWave operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ArchiveWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ArchiveWave" target="_top">AWS API
     *      Documentation</a>
     */
    default ArchiveWaveResponse archiveWave(Consumer<ArchiveWaveRequest.Builder> archiveWaveRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        return archiveWave(ArchiveWaveRequest.builder().applyMutation(archiveWaveRequest).build());
    }

    /**
     * <p>
     * Associate applications to wave.
     * </p>
     *
     * @param associateApplicationsRequest
     * @return Result of the AssociateApplications operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.AssociateApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/AssociateApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateApplicationsResponse associateApplications(AssociateApplicationsRequest associateApplicationsRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate applications to wave.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateApplicationsRequest#builder()}
     * </p>
     *
     * @param associateApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link AssociateApplicationsRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateApplications operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.AssociateApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/AssociateApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateApplicationsResponse associateApplications(
            Consumer<AssociateApplicationsRequest.Builder> associateApplicationsRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException,
            MgnException {
        return associateApplications(AssociateApplicationsRequest.builder().applyMutation(associateApplicationsRequest).build());
    }

    /**
     * <p>
     * Associate source servers to application.
     * </p>
     *
     * @param associateSourceServersRequest
     * @return Result of the AssociateSourceServers operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.AssociateSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/AssociateSourceServers" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateSourceServersResponse associateSourceServers(AssociateSourceServersRequest associateSourceServersRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ServiceQuotaExceededException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate source servers to application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSourceServersRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateSourceServersRequest#builder()}
     * </p>
     *
     * @param associateSourceServersRequest
     *        A {@link Consumer} that will call methods on {@link AssociateSourceServersRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateSourceServers operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.AssociateSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/AssociateSourceServers" target="_top">AWS
     *      API Documentation</a>
     */
    default AssociateSourceServersResponse associateSourceServers(
            Consumer<AssociateSourceServersRequest.Builder> associateSourceServersRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException,
            MgnException {
        return associateSourceServers(AssociateSourceServersRequest.builder().applyMutation(associateSourceServersRequest)
                .build());
    }

    /**
     * <p>
     * Allows the user to set the SourceServer.LifeCycle.state property for specific Source Server IDs to one of the
     * following: READY_FOR_TEST or READY_FOR_CUTOVER. This command only works if the Source Server is already
     * launchable (dataReplicationInfo.lagDuration is not null.)
     * </p>
     *
     * @param changeServerLifeCycleStateRequest
     * @return Result of the ChangeServerLifeCycleState operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ChangeServerLifeCycleState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ChangeServerLifeCycleState"
     *      target="_top">AWS API Documentation</a>
     */
    default ChangeServerLifeCycleStateResponse changeServerLifeCycleState(
            ChangeServerLifeCycleStateRequest changeServerLifeCycleStateRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the user to set the SourceServer.LifeCycle.state property for specific Source Server IDs to one of the
     * following: READY_FOR_TEST or READY_FOR_CUTOVER. This command only works if the Source Server is already
     * launchable (dataReplicationInfo.lagDuration is not null.)
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ChangeServerLifeCycleStateRequest.Builder} avoiding
     * the need to create one manually via {@link ChangeServerLifeCycleStateRequest#builder()}
     * </p>
     *
     * @param changeServerLifeCycleStateRequest
     *        A {@link Consumer} that will call methods on {@link ChangeServerLifeCycleStateRequest.Builder} to create a
     *        request.
     * @return Result of the ChangeServerLifeCycleState operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ChangeServerLifeCycleState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ChangeServerLifeCycleState"
     *      target="_top">AWS API Documentation</a>
     */
    default ChangeServerLifeCycleStateResponse changeServerLifeCycleState(
            Consumer<ChangeServerLifeCycleStateRequest.Builder> changeServerLifeCycleStateRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        return changeServerLifeCycleState(ChangeServerLifeCycleStateRequest.builder()
                .applyMutation(changeServerLifeCycleStateRequest).build());
    }

    /**
     * <p>
     * Create application.
     * </p>
     *
     * @param createApplicationRequest
     * @return Result of the CreateApplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest)
            throws UninitializedAccountException, ServiceQuotaExceededException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateApplicationRequest.Builder} to create a request.
     * @return Result of the CreateApplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateApplicationResponse createApplication(Consumer<CreateApplicationRequest.Builder> createApplicationRequest)
            throws UninitializedAccountException, ServiceQuotaExceededException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Creates a new Launch Configuration Template.
     * </p>
     *
     * @param createLaunchConfigurationTemplateRequest
     * @return Result of the CreateLaunchConfigurationTemplate operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.CreateLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLaunchConfigurationTemplateResponse createLaunchConfigurationTemplate(
            CreateLaunchConfigurationTemplateRequest createLaunchConfigurationTemplateRequest)
            throws UninitializedAccountException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Launch Configuration Template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLaunchConfigurationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link CreateLaunchConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param createLaunchConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateLaunchConfigurationTemplateRequest.Builder} to
     *        create a request.
     * @return Result of the CreateLaunchConfigurationTemplate operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.CreateLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateLaunchConfigurationTemplateResponse createLaunchConfigurationTemplate(
            Consumer<CreateLaunchConfigurationTemplateRequest.Builder> createLaunchConfigurationTemplateRequest)
            throws UninitializedAccountException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, MgnException {
        return createLaunchConfigurationTemplate(CreateLaunchConfigurationTemplateRequest.builder()
                .applyMutation(createLaunchConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a new ReplicationConfigurationTemplate.
     * </p>
     *
     * @param createReplicationConfigurationTemplateRequest
     * @return Result of the CreateReplicationConfigurationTemplate operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.CreateReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateReplicationConfigurationTemplateResponse createReplicationConfigurationTemplate(
            CreateReplicationConfigurationTemplateRequest createReplicationConfigurationTemplateRequest)
            throws UninitializedAccountException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new ReplicationConfigurationTemplate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateReplicationConfigurationTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link CreateReplicationConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param createReplicationConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateReplicationConfigurationTemplateRequest.Builder}
     *        to create a request.
     * @return Result of the CreateReplicationConfigurationTemplate operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.CreateReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateReplicationConfigurationTemplateResponse createReplicationConfigurationTemplate(
            Consumer<CreateReplicationConfigurationTemplateRequest.Builder> createReplicationConfigurationTemplateRequest)
            throws UninitializedAccountException, ValidationException, AccessDeniedException, AwsServiceException,
            SdkClientException, MgnException {
        return createReplicationConfigurationTemplate(CreateReplicationConfigurationTemplateRequest.builder()
                .applyMutation(createReplicationConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Create wave.
     * </p>
     *
     * @param createWaveRequest
     * @return Result of the CreateWave operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.CreateWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateWave" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWaveResponse createWave(CreateWaveRequest createWaveRequest) throws UninitializedAccountException,
            ServiceQuotaExceededException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create wave.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWaveRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWaveRequest#builder()}
     * </p>
     *
     * @param createWaveRequest
     *        A {@link Consumer} that will call methods on {@link CreateWaveRequest.Builder} to create a request.
     * @return Result of the CreateWave operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.CreateWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateWave" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateWaveResponse createWave(Consumer<CreateWaveRequest.Builder> createWaveRequest)
            throws UninitializedAccountException, ServiceQuotaExceededException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        return createWave(CreateWaveRequest.builder().applyMutation(createWaveRequest).build());
    }

    /**
     * <p>
     * Delete application.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationRequest.Builder} to create a request.
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteApplicationResponse deleteApplication(Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes a single Job by ID.
     * </p>
     *
     * @param deleteJobRequest
     * @return Result of the DeleteJob operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteJobResponse deleteJob(DeleteJobRequest deleteJobRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a single Job by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteJobRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteJobRequest#builder()}
     * </p>
     *
     * @param deleteJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteJobRequest.Builder} to create a request.
     * @return Result of the DeleteJob operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteJob" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteJobResponse deleteJob(Consumer<DeleteJobRequest.Builder> deleteJobRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        return deleteJob(DeleteJobRequest.builder().applyMutation(deleteJobRequest).build());
    }

    /**
     * <p>
     * Deletes a single Launch Configuration Template by ID.
     * </p>
     *
     * @param deleteLaunchConfigurationTemplateRequest
     * @return Result of the DeleteLaunchConfigurationTemplate operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLaunchConfigurationTemplateResponse deleteLaunchConfigurationTemplate(
            DeleteLaunchConfigurationTemplateRequest deleteLaunchConfigurationTemplateRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a single Launch Configuration Template by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLaunchConfigurationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteLaunchConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param deleteLaunchConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLaunchConfigurationTemplateRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteLaunchConfigurationTemplate operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteLaunchConfigurationTemplateResponse deleteLaunchConfigurationTemplate(
            Consumer<DeleteLaunchConfigurationTemplateRequest.Builder> deleteLaunchConfigurationTemplateRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        return deleteLaunchConfigurationTemplate(DeleteLaunchConfigurationTemplateRequest.builder()
                .applyMutation(deleteLaunchConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a single Replication Configuration Template by ID
     * </p>
     *
     * @param deleteReplicationConfigurationTemplateRequest
     * @return Result of the DeleteReplicationConfigurationTemplate operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteReplicationConfigurationTemplateResponse deleteReplicationConfigurationTemplate(
            DeleteReplicationConfigurationTemplateRequest deleteReplicationConfigurationTemplateRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a single Replication Configuration Template by ID
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteReplicationConfigurationTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteReplicationConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param deleteReplicationConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReplicationConfigurationTemplateRequest.Builder}
     *        to create a request.
     * @return Result of the DeleteReplicationConfigurationTemplate operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteReplicationConfigurationTemplateResponse deleteReplicationConfigurationTemplate(
            Consumer<DeleteReplicationConfigurationTemplateRequest.Builder> deleteReplicationConfigurationTemplateRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        return deleteReplicationConfigurationTemplate(DeleteReplicationConfigurationTemplateRequest.builder()
                .applyMutation(deleteReplicationConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a single source server by ID.
     * </p>
     *
     * @param deleteSourceServerRequest
     * @return Result of the DeleteSourceServer operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteSourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteSourceServer" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSourceServerResponse deleteSourceServer(DeleteSourceServerRequest deleteSourceServerRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a single source server by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSourceServerRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSourceServerRequest#builder()}
     * </p>
     *
     * @param deleteSourceServerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSourceServerRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteSourceServer operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteSourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteSourceServer" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteSourceServerResponse deleteSourceServer(Consumer<DeleteSourceServerRequest.Builder> deleteSourceServerRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        return deleteSourceServer(DeleteSourceServerRequest.builder().applyMutation(deleteSourceServerRequest).build());
    }

    /**
     * <p>
     * Deletes a given vCenter client by ID.
     * </p>
     *
     * @param deleteVcenterClientRequest
     * @return Result of the DeleteVcenterClient operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteVcenterClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteVcenterClient" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVcenterClientResponse deleteVcenterClient(DeleteVcenterClientRequest deleteVcenterClientRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a given vCenter client by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVcenterClientRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVcenterClientRequest#builder()}
     * </p>
     *
     * @param deleteVcenterClientRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVcenterClientRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteVcenterClient operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteVcenterClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteVcenterClient" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteVcenterClientResponse deleteVcenterClient(
            Consumer<DeleteVcenterClientRequest.Builder> deleteVcenterClientRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return deleteVcenterClient(DeleteVcenterClientRequest.builder().applyMutation(deleteVcenterClientRequest).build());
    }

    /**
     * <p>
     * Delete wave.
     * </p>
     *
     * @param deleteWaveRequest
     * @return Result of the DeleteWave operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteWave" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWaveResponse deleteWave(DeleteWaveRequest deleteWaveRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete wave.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWaveRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWaveRequest#builder()}
     * </p>
     *
     * @param deleteWaveRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWaveRequest.Builder} to create a request.
     * @return Result of the DeleteWave operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DeleteWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteWave" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteWaveResponse deleteWave(Consumer<DeleteWaveRequest.Builder> deleteWaveRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        return deleteWave(DeleteWaveRequest.builder().applyMutation(deleteWaveRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed job log items with paging.
     * </p>
     *
     * @param describeJobLogItemsRequest
     * @return Result of the DescribeJobLogItems operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeJobLogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobLogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobLogItemsResponse describeJobLogItems(DescribeJobLogItemsRequest describeJobLogItemsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed job log items with paging.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobLogItemsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeJobLogItemsRequest#builder()}
     * </p>
     *
     * @param describeJobLogItemsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobLogItemsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeJobLogItems operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeJobLogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobLogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobLogItemsResponse describeJobLogItems(
            Consumer<DescribeJobLogItemsRequest.Builder> describeJobLogItemsRequest) throws UninitializedAccountException,
            ValidationException, AwsServiceException, SdkClientException, MgnException {
        return describeJobLogItems(DescribeJobLogItemsRequest.builder().applyMutation(describeJobLogItemsRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed job log items with paging.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeJobLogItems(software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobLogItemsIterable responses = client.describeJobLogItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.DescribeJobLogItemsIterable responses = client
     *             .describeJobLogItemsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobLogItemsIterable responses = client.describeJobLogItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeJobLogItems(software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest)} operation.</b>
     * </p>
     *
     * @param describeJobLogItemsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeJobLogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobLogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobLogItemsIterable describeJobLogItemsPaginator(DescribeJobLogItemsRequest describeJobLogItemsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return new DescribeJobLogItemsIterable(this, describeJobLogItemsRequest);
    }

    /**
     * <p>
     * Retrieves detailed job log items with paging.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeJobLogItems(software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobLogItemsIterable responses = client.describeJobLogItemsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.DescribeJobLogItemsIterable responses = client
     *             .describeJobLogItemsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobLogItemsIterable responses = client.describeJobLogItemsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeJobLogItems(software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobLogItemsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeJobLogItemsRequest#builder()}
     * </p>
     *
     * @param describeJobLogItemsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobLogItemsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeJobLogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobLogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobLogItemsIterable describeJobLogItemsPaginator(
            Consumer<DescribeJobLogItemsRequest.Builder> describeJobLogItemsRequest) throws UninitializedAccountException,
            ValidationException, AwsServiceException, SdkClientException, MgnException {
        return describeJobLogItemsPaginator(DescribeJobLogItemsRequest.builder().applyMutation(describeJobLogItemsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of Jobs. Use the JobsID and fromDate and toData filters to limit which jobs are returned. The
     * response is sorted by creationDataTime - latest date first. Jobs are normally created by the StartTest,
     * StartCutover, and TerminateTargetInstances APIs. Jobs are also created by DiagnosticLaunch and
     * TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant
     * support tickets.
     * </p>
     *
     * @param describeJobsRequest
     * @return Result of the DescribeJobs operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobsResponse describeJobs(DescribeJobsRequest describeJobsRequest) throws UninitializedAccountException,
            ValidationException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Jobs. Use the JobsID and fromDate and toData filters to limit which jobs are returned. The
     * response is sorted by creationDataTime - latest date first. Jobs are normally created by the StartTest,
     * StartCutover, and TerminateTargetInstances APIs. Jobs are also created by DiagnosticLaunch and
     * TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant
     * support tickets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeJobsRequest#builder()}
     * </p>
     *
     * @param describeJobsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobsRequest.Builder} to create a request.
     * @return Result of the DescribeJobs operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobsResponse describeJobs(Consumer<DescribeJobsRequest.Builder> describeJobsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return describeJobs(DescribeJobsRequest.builder().applyMutation(describeJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Jobs. Use the JobsID and fromDate and toData filters to limit which jobs are returned. The
     * response is sorted by creationDataTime - latest date first. Jobs are normally created by the StartTest,
     * StartCutover, and TerminateTargetInstances APIs. Jobs are also created by DiagnosticLaunch and
     * TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant
     * support tickets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeJobs(software.amazon.awssdk.services.mgn.model.DescribeJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobsIterable responses = client.describeJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.DescribeJobsIterable responses = client.describeJobsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.DescribeJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobsIterable responses = client.describeJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeJobs(software.amazon.awssdk.services.mgn.model.DescribeJobsRequest)} operation.</b>
     * </p>
     *
     * @param describeJobsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobsIterable describeJobsPaginator(DescribeJobsRequest describeJobsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return new DescribeJobsIterable(this, describeJobsRequest);
    }

    /**
     * <p>
     * Returns a list of Jobs. Use the JobsID and fromDate and toData filters to limit which jobs are returned. The
     * response is sorted by creationDataTime - latest date first. Jobs are normally created by the StartTest,
     * StartCutover, and TerminateTargetInstances APIs. Jobs are also created by DiagnosticLaunch and
     * TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant
     * support tickets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeJobs(software.amazon.awssdk.services.mgn.model.DescribeJobsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobsIterable responses = client.describeJobsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.DescribeJobsIterable responses = client.describeJobsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.DescribeJobsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobsIterable responses = client.describeJobsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeJobs(software.amazon.awssdk.services.mgn.model.DescribeJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeJobsRequest#builder()}
     * </p>
     *
     * @param describeJobsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobsIterable describeJobsPaginator(Consumer<DescribeJobsRequest.Builder> describeJobsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return describeJobsPaginator(DescribeJobsRequest.builder().applyMutation(describeJobsRequest).build());
    }

    /**
     * <p>
     * Lists all Launch Configuration Templates, filtered by Launch Configuration Template IDs
     * </p>
     *
     * @param describeLaunchConfigurationTemplatesRequest
     * @return Result of the DescribeLaunchConfigurationTemplates operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeLaunchConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeLaunchConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationTemplatesResponse describeLaunchConfigurationTemplates(
            DescribeLaunchConfigurationTemplatesRequest describeLaunchConfigurationTemplatesRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Launch Configuration Templates, filtered by Launch Configuration Template IDs
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeLaunchConfigurationTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeLaunchConfigurationTemplatesRequest#builder()}
     * </p>
     *
     * @param describeLaunchConfigurationTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLaunchConfigurationTemplatesRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeLaunchConfigurationTemplates operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeLaunchConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeLaunchConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationTemplatesResponse describeLaunchConfigurationTemplates(
            Consumer<DescribeLaunchConfigurationTemplatesRequest.Builder> describeLaunchConfigurationTemplatesRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        return describeLaunchConfigurationTemplates(DescribeLaunchConfigurationTemplatesRequest.builder()
                .applyMutation(describeLaunchConfigurationTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all Launch Configuration Templates, filtered by Launch Configuration Template IDs
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLaunchConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeLaunchConfigurationTemplatesIterable responses = client.describeLaunchConfigurationTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.DescribeLaunchConfigurationTemplatesIterable responses = client
     *             .describeLaunchConfigurationTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeLaunchConfigurationTemplatesIterable responses = client.describeLaunchConfigurationTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLaunchConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLaunchConfigurationTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeLaunchConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeLaunchConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationTemplatesIterable describeLaunchConfigurationTemplatesPaginator(
            DescribeLaunchConfigurationTemplatesRequest describeLaunchConfigurationTemplatesRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        return new DescribeLaunchConfigurationTemplatesIterable(this, describeLaunchConfigurationTemplatesRequest);
    }

    /**
     * <p>
     * Lists all Launch Configuration Templates, filtered by Launch Configuration Template IDs
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLaunchConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeLaunchConfigurationTemplatesIterable responses = client.describeLaunchConfigurationTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.DescribeLaunchConfigurationTemplatesIterable responses = client
     *             .describeLaunchConfigurationTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeLaunchConfigurationTemplatesIterable responses = client.describeLaunchConfigurationTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLaunchConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeLaunchConfigurationTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeLaunchConfigurationTemplatesRequest#builder()}
     * </p>
     *
     * @param describeLaunchConfigurationTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLaunchConfigurationTemplatesRequest.Builder}
     *        to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeLaunchConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeLaunchConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationTemplatesIterable describeLaunchConfigurationTemplatesPaginator(
            Consumer<DescribeLaunchConfigurationTemplatesRequest.Builder> describeLaunchConfigurationTemplatesRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        return describeLaunchConfigurationTemplatesPaginator(DescribeLaunchConfigurationTemplatesRequest.builder()
                .applyMutation(describeLaunchConfigurationTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
     * </p>
     *
     * @param describeReplicationConfigurationTemplatesRequest
     * @return Result of the DescribeReplicationConfigurationTemplates operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeReplicationConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeReplicationConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigurationTemplatesResponse describeReplicationConfigurationTemplates(
            DescribeReplicationConfigurationTemplatesRequest describeReplicationConfigurationTemplatesRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationConfigurationTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationConfigurationTemplatesRequest#builder()}
     * </p>
     *
     * @param describeReplicationConfigurationTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeReplicationConfigurationTemplatesRequest.Builder} to create a request.
     * @return Result of the DescribeReplicationConfigurationTemplates operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeReplicationConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeReplicationConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigurationTemplatesResponse describeReplicationConfigurationTemplates(
            Consumer<DescribeReplicationConfigurationTemplatesRequest.Builder> describeReplicationConfigurationTemplatesRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        return describeReplicationConfigurationTemplates(DescribeReplicationConfigurationTemplatesRequest.builder()
                .applyMutation(describeReplicationConfigurationTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeReplicationConfigurationTemplatesIterable responses = client.describeReplicationConfigurationTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.DescribeReplicationConfigurationTemplatesIterable responses = client
     *             .describeReplicationConfigurationTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeReplicationConfigurationTemplatesIterable responses = client.describeReplicationConfigurationTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationConfigurationTemplatesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeReplicationConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeReplicationConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigurationTemplatesIterable describeReplicationConfigurationTemplatesPaginator(
            DescribeReplicationConfigurationTemplatesRequest describeReplicationConfigurationTemplatesRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        return new DescribeReplicationConfigurationTemplatesIterable(this, describeReplicationConfigurationTemplatesRequest);
    }

    /**
     * <p>
     * Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeReplicationConfigurationTemplatesIterable responses = client.describeReplicationConfigurationTemplatesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.DescribeReplicationConfigurationTemplatesIterable responses = client
     *             .describeReplicationConfigurationTemplatesPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeReplicationConfigurationTemplatesIterable responses = client.describeReplicationConfigurationTemplatesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationConfigurationTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationConfigurationTemplatesRequest#builder()}
     * </p>
     *
     * @param describeReplicationConfigurationTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeReplicationConfigurationTemplatesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeReplicationConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeReplicationConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigurationTemplatesIterable describeReplicationConfigurationTemplatesPaginator(
            Consumer<DescribeReplicationConfigurationTemplatesRequest.Builder> describeReplicationConfigurationTemplatesRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        return describeReplicationConfigurationTemplatesPaginator(DescribeReplicationConfigurationTemplatesRequest.builder()
                .applyMutation(describeReplicationConfigurationTemplatesRequest).build());
    }

    /**
     * <p>
     * Retrieves all SourceServers or multiple SourceServers by ID.
     * </p>
     *
     * @param describeSourceServersRequest
     * @return Result of the DescribeSourceServers operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeSourceServers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSourceServersResponse describeSourceServers(DescribeSourceServersRequest describeSourceServersRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all SourceServers or multiple SourceServers by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSourceServersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSourceServersRequest#builder()}
     * </p>
     *
     * @param describeSourceServersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSourceServersRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeSourceServers operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeSourceServers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSourceServersResponse describeSourceServers(
            Consumer<DescribeSourceServersRequest.Builder> describeSourceServersRequest) throws UninitializedAccountException,
            ValidationException, AwsServiceException, SdkClientException, MgnException {
        return describeSourceServers(DescribeSourceServersRequest.builder().applyMutation(describeSourceServersRequest).build());
    }

    /**
     * <p>
     * Retrieves all SourceServers or multiple SourceServers by ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSourceServers(software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeSourceServersIterable responses = client.describeSourceServersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.DescribeSourceServersIterable responses = client
     *             .describeSourceServersPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeSourceServersIterable responses = client.describeSourceServersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSourceServers(software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSourceServersRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeSourceServers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSourceServersIterable describeSourceServersPaginator(DescribeSourceServersRequest describeSourceServersRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return new DescribeSourceServersIterable(this, describeSourceServersRequest);
    }

    /**
     * <p>
     * Retrieves all SourceServers or multiple SourceServers by ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSourceServers(software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeSourceServersIterable responses = client.describeSourceServersPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.DescribeSourceServersIterable responses = client
     *             .describeSourceServersPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeSourceServersIterable responses = client.describeSourceServersPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSourceServers(software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSourceServersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSourceServersRequest#builder()}
     * </p>
     *
     * @param describeSourceServersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSourceServersRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeSourceServers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSourceServersIterable describeSourceServersPaginator(
            Consumer<DescribeSourceServersRequest.Builder> describeSourceServersRequest) throws UninitializedAccountException,
            ValidationException, AwsServiceException, SdkClientException, MgnException {
        return describeSourceServersPaginator(DescribeSourceServersRequest.builder().applyMutation(describeSourceServersRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the installed vCenter clients.
     * </p>
     *
     * @param describeVcenterClientsRequest
     * @return Result of the DescribeVcenterClients operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeVcenterClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeVcenterClients" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeVcenterClientsResponse describeVcenterClients(DescribeVcenterClientsRequest describeVcenterClientsRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the installed vCenter clients.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVcenterClientsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeVcenterClientsRequest#builder()}
     * </p>
     *
     * @param describeVcenterClientsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeVcenterClientsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeVcenterClients operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeVcenterClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeVcenterClients" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeVcenterClientsResponse describeVcenterClients(
            Consumer<DescribeVcenterClientsRequest.Builder> describeVcenterClientsRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return describeVcenterClients(DescribeVcenterClientsRequest.builder().applyMutation(describeVcenterClientsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the installed vCenter clients.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeVcenterClients(software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeVcenterClientsIterable responses = client.describeVcenterClientsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.DescribeVcenterClientsIterable responses = client
     *             .describeVcenterClientsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeVcenterClientsIterable responses = client.describeVcenterClientsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeVcenterClients(software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeVcenterClientsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeVcenterClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeVcenterClients" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeVcenterClientsIterable describeVcenterClientsPaginator(
            DescribeVcenterClientsRequest describeVcenterClientsRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return new DescribeVcenterClientsIterable(this, describeVcenterClientsRequest);
    }

    /**
     * <p>
     * Returns a list of the installed vCenter clients.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeVcenterClients(software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeVcenterClientsIterable responses = client.describeVcenterClientsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.DescribeVcenterClientsIterable responses = client
     *             .describeVcenterClientsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeVcenterClientsIterable responses = client.describeVcenterClientsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeVcenterClients(software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVcenterClientsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeVcenterClientsRequest#builder()}
     * </p>
     *
     * @param describeVcenterClientsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeVcenterClientsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DescribeVcenterClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeVcenterClients" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeVcenterClientsIterable describeVcenterClientsPaginator(
            Consumer<DescribeVcenterClientsRequest.Builder> describeVcenterClientsRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return describeVcenterClientsPaginator(DescribeVcenterClientsRequest.builder()
                .applyMutation(describeVcenterClientsRequest).build());
    }

    /**
     * <p>
     * Disassociate applications from wave.
     * </p>
     *
     * @param disassociateApplicationsRequest
     * @return Result of the DisassociateApplications operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DisassociateApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DisassociateApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateApplicationsResponse disassociateApplications(
            DisassociateApplicationsRequest disassociateApplicationsRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociate applications from wave.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateApplicationsRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateApplicationsRequest#builder()}
     * </p>
     *
     * @param disassociateApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateApplicationsRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateApplications operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DisassociateApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DisassociateApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateApplicationsResponse disassociateApplications(
            Consumer<DisassociateApplicationsRequest.Builder> disassociateApplicationsRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        return disassociateApplications(DisassociateApplicationsRequest.builder().applyMutation(disassociateApplicationsRequest)
                .build());
    }

    /**
     * <p>
     * Disassociate source servers from application.
     * </p>
     *
     * @param disassociateSourceServersRequest
     * @return Result of the DisassociateSourceServers operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DisassociateSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DisassociateSourceServers" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateSourceServersResponse disassociateSourceServers(
            DisassociateSourceServersRequest disassociateSourceServersRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociate source servers from application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateSourceServersRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateSourceServersRequest#builder()}
     * </p>
     *
     * @param disassociateSourceServersRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateSourceServersRequest.Builder} to create a
     *        request.
     * @return Result of the DisassociateSourceServers operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DisassociateSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DisassociateSourceServers" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateSourceServersResponse disassociateSourceServers(
            Consumer<DisassociateSourceServersRequest.Builder> disassociateSourceServersRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        return disassociateSourceServers(DisassociateSourceServersRequest.builder()
                .applyMutation(disassociateSourceServersRequest).build());
    }

    /**
     * <p>
     * Disconnects specific Source Servers from Application Migration Service. Data replication is stopped immediately.
     * All AWS resources created by Application Migration Service for enabling the replication of these source servers
     * will be terminated / deleted within 90 minutes. Launched Test or Cutover instances will NOT be terminated. If the
     * agent on the source server has not been prevented from communicating with the Application Migration Service
     * service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following
     * properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be set
     * to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to
     * zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.
     * </p>
     *
     * @param disconnectFromServiceRequest
     * @return Result of the DisconnectFromService operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DisconnectFromService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DisconnectFromService" target="_top">AWS API
     *      Documentation</a>
     */
    default DisconnectFromServiceResponse disconnectFromService(DisconnectFromServiceRequest disconnectFromServiceRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disconnects specific Source Servers from Application Migration Service. Data replication is stopped immediately.
     * All AWS resources created by Application Migration Service for enabling the replication of these source servers
     * will be terminated / deleted within 90 minutes. Launched Test or Cutover instances will NOT be terminated. If the
     * agent on the source server has not been prevented from communicating with the Application Migration Service
     * service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following
     * properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be set
     * to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to
     * zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisconnectFromServiceRequest.Builder} avoiding the
     * need to create one manually via {@link DisconnectFromServiceRequest#builder()}
     * </p>
     *
     * @param disconnectFromServiceRequest
     *        A {@link Consumer} that will call methods on {@link DisconnectFromServiceRequest.Builder} to create a
     *        request.
     * @return Result of the DisconnectFromService operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.DisconnectFromService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DisconnectFromService" target="_top">AWS API
     *      Documentation</a>
     */
    default DisconnectFromServiceResponse disconnectFromService(
            Consumer<DisconnectFromServiceRequest.Builder> disconnectFromServiceRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        return disconnectFromService(DisconnectFromServiceRequest.builder().applyMutation(disconnectFromServiceRequest).build());
    }

    /**
     * <p>
     * Finalizes the cutover immediately for specific Source Servers. All AWS resources created by Application Migration
     * Service for enabling the replication of these source servers will be terminated / deleted within 90 minutes.
     * Launched Test or Cutover instances will NOT be terminated. The AWS Replication Agent will receive a command to
     * uninstall itself (within 10 minutes). The following properties of the SourceServer will be changed immediately:
     * dataReplicationInfo.dataReplicationState will be changed to DISCONNECTED; The SourceServer.lifeCycle.state will
     * be changed to CUTOVER; The totalStorageBytes property fo each of dataReplicationInfo.replicatedDisks will be set
     * to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.
     * </p>
     *
     * @param finalizeCutoverRequest
     * @return Result of the FinalizeCutover operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.FinalizeCutover
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/FinalizeCutover" target="_top">AWS API
     *      Documentation</a>
     */
    default FinalizeCutoverResponse finalizeCutover(FinalizeCutoverRequest finalizeCutoverRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Finalizes the cutover immediately for specific Source Servers. All AWS resources created by Application Migration
     * Service for enabling the replication of these source servers will be terminated / deleted within 90 minutes.
     * Launched Test or Cutover instances will NOT be terminated. The AWS Replication Agent will receive a command to
     * uninstall itself (within 10 minutes). The following properties of the SourceServer will be changed immediately:
     * dataReplicationInfo.dataReplicationState will be changed to DISCONNECTED; The SourceServer.lifeCycle.state will
     * be changed to CUTOVER; The totalStorageBytes property fo each of dataReplicationInfo.replicatedDisks will be set
     * to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FinalizeCutoverRequest.Builder} avoiding the need
     * to create one manually via {@link FinalizeCutoverRequest#builder()}
     * </p>
     *
     * @param finalizeCutoverRequest
     *        A {@link Consumer} that will call methods on {@link FinalizeCutoverRequest.Builder} to create a request.
     * @return Result of the FinalizeCutover operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.FinalizeCutover
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/FinalizeCutover" target="_top">AWS API
     *      Documentation</a>
     */
    default FinalizeCutoverResponse finalizeCutover(Consumer<FinalizeCutoverRequest.Builder> finalizeCutoverRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        return finalizeCutover(FinalizeCutoverRequest.builder().applyMutation(finalizeCutoverRequest).build());
    }

    /**
     * <p>
     * Lists all LaunchConfigurations available, filtered by Source Server IDs.
     * </p>
     *
     * @param getLaunchConfigurationRequest
     * @return Result of the GetLaunchConfiguration operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.GetLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/GetLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLaunchConfigurationResponse getLaunchConfiguration(GetLaunchConfigurationRequest getLaunchConfigurationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all LaunchConfigurations available, filtered by Source Server IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLaunchConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetLaunchConfigurationRequest#builder()}
     * </p>
     *
     * @param getLaunchConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetLaunchConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the GetLaunchConfiguration operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.GetLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/GetLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default GetLaunchConfigurationResponse getLaunchConfiguration(
            Consumer<GetLaunchConfigurationRequest.Builder> getLaunchConfigurationRequest) throws UninitializedAccountException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MgnException {
        return getLaunchConfiguration(GetLaunchConfigurationRequest.builder().applyMutation(getLaunchConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Lists all ReplicationConfigurations, filtered by Source Server ID.
     * </p>
     *
     * @param getReplicationConfigurationRequest
     * @return Result of the GetReplicationConfiguration operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.GetReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/GetReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetReplicationConfigurationResponse getReplicationConfiguration(
            GetReplicationConfigurationRequest getReplicationConfigurationRequest) throws UninitializedAccountException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all ReplicationConfigurations, filtered by Source Server ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReplicationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetReplicationConfigurationRequest#builder()}
     * </p>
     *
     * @param getReplicationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetReplicationConfigurationRequest.Builder} to create
     *        a request.
     * @return Result of the GetReplicationConfiguration operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.GetReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/GetReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default GetReplicationConfigurationResponse getReplicationConfiguration(
            Consumer<GetReplicationConfigurationRequest.Builder> getReplicationConfigurationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MgnException {
        return getReplicationConfiguration(GetReplicationConfigurationRequest.builder()
                .applyMutation(getReplicationConfigurationRequest).build());
    }

    /**
     * <p>
     * Initialize Application Migration Service.
     * </p>
     *
     * @param initializeServiceRequest
     * @return Result of the InitializeService operation returned by the service.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.InitializeService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/InitializeService" target="_top">AWS API
     *      Documentation</a>
     */
    default InitializeServiceResponse initializeService(InitializeServiceRequest initializeServiceRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initialize Application Migration Service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitializeServiceRequest.Builder} avoiding the need
     * to create one manually via {@link InitializeServiceRequest#builder()}
     * </p>
     *
     * @param initializeServiceRequest
     *        A {@link Consumer} that will call methods on {@link InitializeServiceRequest.Builder} to create a request.
     * @return Result of the InitializeService operation returned by the service.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.InitializeService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/InitializeService" target="_top">AWS API
     *      Documentation</a>
     */
    default InitializeServiceResponse initializeService(Consumer<InitializeServiceRequest.Builder> initializeServiceRequest)
            throws ValidationException, AccessDeniedException, AwsServiceException, SdkClientException, MgnException {
        return initializeService(InitializeServiceRequest.builder().applyMutation(initializeServiceRequest).build());
    }

    /**
     * <p>
     * Retrieves all applications or multiple applications by ID.
     * </p>
     *
     * @param listApplicationsRequest
     * @return Result of the ListApplications operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default ListApplicationsResponse listApplications(ListApplicationsRequest listApplicationsRequest)
            throws UninitializedAccountException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all applications or multiple applications by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationsRequest.Builder} to create a request.
     * @return Result of the ListApplications operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default ListApplicationsResponse listApplications(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest)
            throws UninitializedAccountException, AwsServiceException, SdkClientException, MgnException {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Retrieves all applications or multiple applications by ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listApplications(software.amazon.awssdk.services.mgn.model.ListApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.mgn.model.ListApplicationsRequest)} operation.</b>
     * </p>
     *
     * @param listApplicationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest)
            throws UninitializedAccountException, AwsServiceException, SdkClientException, MgnException {
        return new ListApplicationsIterable(this, listApplicationsRequest);
    }

    /**
     * <p>
     * Retrieves all applications or multiple applications by ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listApplications(software.amazon.awssdk.services.mgn.model.ListApplicationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.ListApplicationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListApplicationsIterable responses = client.listApplicationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.mgn.model.ListApplicationsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default ListApplicationsIterable listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest)
            throws UninitializedAccountException, AwsServiceException, SdkClientException, MgnException {
        return listApplicationsPaginator(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * List export errors.
     * </p>
     *
     * @param listExportErrorsRequest
     *        List export errors request.
     * @return Result of the ListExportErrors operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListExportErrors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListExportErrors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportErrorsResponse listExportErrors(ListExportErrorsRequest listExportErrorsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List export errors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportErrorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListExportErrorsRequest#builder()}
     * </p>
     *
     * @param listExportErrorsRequest
     *        A {@link Consumer} that will call methods on {@link ListExportErrorsRequest.Builder} to create a request.
     *        List export errors request.
     * @return Result of the ListExportErrors operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListExportErrors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListExportErrors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportErrorsResponse listExportErrors(Consumer<ListExportErrorsRequest.Builder> listExportErrorsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return listExportErrors(ListExportErrorsRequest.builder().applyMutation(listExportErrorsRequest).build());
    }

    /**
     * <p>
     * List export errors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listExportErrors(software.amazon.awssdk.services.mgn.model.ListExportErrorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListExportErrorsIterable responses = client.listExportErrorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.ListExportErrorsIterable responses = client.listExportErrorsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.ListExportErrorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListExportErrorsIterable responses = client.listExportErrorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExportErrors(software.amazon.awssdk.services.mgn.model.ListExportErrorsRequest)} operation.</b>
     * </p>
     *
     * @param listExportErrorsRequest
     *        List export errors request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListExportErrors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListExportErrors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportErrorsIterable listExportErrorsPaginator(ListExportErrorsRequest listExportErrorsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return new ListExportErrorsIterable(this, listExportErrorsRequest);
    }

    /**
     * <p>
     * List export errors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listExportErrors(software.amazon.awssdk.services.mgn.model.ListExportErrorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListExportErrorsIterable responses = client.listExportErrorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.ListExportErrorsIterable responses = client.listExportErrorsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.ListExportErrorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListExportErrorsIterable responses = client.listExportErrorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExportErrors(software.amazon.awssdk.services.mgn.model.ListExportErrorsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportErrorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListExportErrorsRequest#builder()}
     * </p>
     *
     * @param listExportErrorsRequest
     *        A {@link Consumer} that will call methods on {@link ListExportErrorsRequest.Builder} to create a request.
     *        List export errors request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListExportErrors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListExportErrors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportErrorsIterable listExportErrorsPaginator(Consumer<ListExportErrorsRequest.Builder> listExportErrorsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return listExportErrorsPaginator(ListExportErrorsRequest.builder().applyMutation(listExportErrorsRequest).build());
    }

    /**
     * <p>
     * List exports.
     * </p>
     *
     * @param listExportsRequest
     *        List export request.
     * @return Result of the ListExports operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportsResponse listExports(ListExportsRequest listExportsRequest) throws UninitializedAccountException,
            AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List exports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportsRequest#builder()}
     * </p>
     *
     * @param listExportsRequest
     *        A {@link Consumer} that will call methods on {@link ListExportsRequest.Builder} to create a request. List
     *        export request.
     * @return Result of the ListExports operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportsResponse listExports(Consumer<ListExportsRequest.Builder> listExportsRequest)
            throws UninitializedAccountException, AwsServiceException, SdkClientException, MgnException {
        return listExports(ListExportsRequest.builder().applyMutation(listExportsRequest).build());
    }

    /**
     * <p>
     * List exports.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listExports(software.amazon.awssdk.services.mgn.model.ListExportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.ListExportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.mgn.model.ListExportsRequest)} operation.</b>
     * </p>
     *
     * @param listExportsRequest
     *        List export request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportsIterable listExportsPaginator(ListExportsRequest listExportsRequest) throws UninitializedAccountException,
            AwsServiceException, SdkClientException, MgnException {
        return new ListExportsIterable(this, listExportsRequest);
    }

    /**
     * <p>
     * List exports.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listExports(software.amazon.awssdk.services.mgn.model.ListExportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.ListExportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListExportsIterable responses = client.listExportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.mgn.model.ListExportsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportsRequest#builder()}
     * </p>
     *
     * @param listExportsRequest
     *        A {@link Consumer} that will call methods on {@link ListExportsRequest.Builder} to create a request. List
     *        export request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportsIterable listExportsPaginator(Consumer<ListExportsRequest.Builder> listExportsRequest)
            throws UninitializedAccountException, AwsServiceException, SdkClientException, MgnException {
        return listExportsPaginator(ListExportsRequest.builder().applyMutation(listExportsRequest).build());
    }

    /**
     * <p>
     * List import errors.
     * </p>
     *
     * @param listImportErrorsRequest
     *        List import errors request.
     * @return Result of the ListImportErrors operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListImportErrors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListImportErrors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportErrorsResponse listImportErrors(ListImportErrorsRequest listImportErrorsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List import errors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportErrorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListImportErrorsRequest#builder()}
     * </p>
     *
     * @param listImportErrorsRequest
     *        A {@link Consumer} that will call methods on {@link ListImportErrorsRequest.Builder} to create a request.
     *        List import errors request.
     * @return Result of the ListImportErrors operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListImportErrors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListImportErrors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportErrorsResponse listImportErrors(Consumer<ListImportErrorsRequest.Builder> listImportErrorsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return listImportErrors(ListImportErrorsRequest.builder().applyMutation(listImportErrorsRequest).build());
    }

    /**
     * <p>
     * List import errors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImportErrors(software.amazon.awssdk.services.mgn.model.ListImportErrorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListImportErrorsIterable responses = client.listImportErrorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.ListImportErrorsIterable responses = client.listImportErrorsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.ListImportErrorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListImportErrorsIterable responses = client.listImportErrorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportErrors(software.amazon.awssdk.services.mgn.model.ListImportErrorsRequest)} operation.</b>
     * </p>
     *
     * @param listImportErrorsRequest
     *        List import errors request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListImportErrors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListImportErrors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportErrorsIterable listImportErrorsPaginator(ListImportErrorsRequest listImportErrorsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return new ListImportErrorsIterable(this, listImportErrorsRequest);
    }

    /**
     * <p>
     * List import errors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImportErrors(software.amazon.awssdk.services.mgn.model.ListImportErrorsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListImportErrorsIterable responses = client.listImportErrorsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.ListImportErrorsIterable responses = client.listImportErrorsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.ListImportErrorsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListImportErrorsIterable responses = client.listImportErrorsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportErrors(software.amazon.awssdk.services.mgn.model.ListImportErrorsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportErrorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListImportErrorsRequest#builder()}
     * </p>
     *
     * @param listImportErrorsRequest
     *        A {@link Consumer} that will call methods on {@link ListImportErrorsRequest.Builder} to create a request.
     *        List import errors request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListImportErrors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListImportErrors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportErrorsIterable listImportErrorsPaginator(Consumer<ListImportErrorsRequest.Builder> listImportErrorsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return listImportErrorsPaginator(ListImportErrorsRequest.builder().applyMutation(listImportErrorsRequest).build());
    }

    /**
     * <p>
     * List imports.
     * </p>
     *
     * @param listImportsRequest
     *        List imports request.
     * @return Result of the ListImports operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsResponse listImports(ListImportsRequest listImportsRequest) throws UninitializedAccountException,
            ValidationException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List imports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on {@link ListImportsRequest.Builder} to create a request. List
     *        imports request.
     * @return Result of the ListImports operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsResponse listImports(Consumer<ListImportsRequest.Builder> listImportsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return listImports(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * List imports.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImports(software.amazon.awssdk.services.mgn.model.ListImportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListImportsIterable responses = client.listImportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.ListImportsIterable responses = client.listImportsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.ListImportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListImportsIterable responses = client.listImportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.mgn.model.ListImportsRequest)} operation.</b>
     * </p>
     *
     * @param listImportsRequest
     *        List imports request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsIterable listImportsPaginator(ListImportsRequest listImportsRequest) throws UninitializedAccountException,
            ValidationException, AwsServiceException, SdkClientException, MgnException {
        return new ListImportsIterable(this, listImportsRequest);
    }

    /**
     * <p>
     * List imports.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImports(software.amazon.awssdk.services.mgn.model.ListImportsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListImportsIterable responses = client.listImportsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.ListImportsIterable responses = client.listImportsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.ListImportsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListImportsIterable responses = client.listImportsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.mgn.model.ListImportsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on {@link ListImportsRequest.Builder} to create a request. List
     *        imports request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsIterable listImportsPaginator(Consumer<ListImportsRequest.Builder> listImportsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return listImportsPaginator(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * List Managed Accounts.
     * </p>
     *
     * @param listManagedAccountsRequest
     *        List managed accounts request.
     * @return Result of the ListManagedAccounts operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListManagedAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListManagedAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListManagedAccountsResponse listManagedAccounts(ListManagedAccountsRequest listManagedAccountsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List Managed Accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link ListManagedAccountsRequest#builder()}
     * </p>
     *
     * @param listManagedAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListManagedAccountsRequest.Builder} to create a
     *        request. List managed accounts request.
     * @return Result of the ListManagedAccounts operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListManagedAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListManagedAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListManagedAccountsResponse listManagedAccounts(
            Consumer<ListManagedAccountsRequest.Builder> listManagedAccountsRequest) throws UninitializedAccountException,
            ValidationException, AwsServiceException, SdkClientException, MgnException {
        return listManagedAccounts(ListManagedAccountsRequest.builder().applyMutation(listManagedAccountsRequest).build());
    }

    /**
     * <p>
     * List Managed Accounts.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listManagedAccounts(software.amazon.awssdk.services.mgn.model.ListManagedAccountsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListManagedAccountsIterable responses = client.listManagedAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.ListManagedAccountsIterable responses = client
     *             .listManagedAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.ListManagedAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListManagedAccountsIterable responses = client.listManagedAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedAccounts(software.amazon.awssdk.services.mgn.model.ListManagedAccountsRequest)} operation.</b>
     * </p>
     *
     * @param listManagedAccountsRequest
     *        List managed accounts request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListManagedAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListManagedAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListManagedAccountsIterable listManagedAccountsPaginator(ListManagedAccountsRequest listManagedAccountsRequest)
            throws UninitializedAccountException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return new ListManagedAccountsIterable(this, listManagedAccountsRequest);
    }

    /**
     * <p>
     * List Managed Accounts.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listManagedAccounts(software.amazon.awssdk.services.mgn.model.ListManagedAccountsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListManagedAccountsIterable responses = client.listManagedAccountsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.ListManagedAccountsIterable responses = client
     *             .listManagedAccountsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.ListManagedAccountsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListManagedAccountsIterable responses = client.listManagedAccountsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedAccounts(software.amazon.awssdk.services.mgn.model.ListManagedAccountsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link ListManagedAccountsRequest#builder()}
     * </p>
     *
     * @param listManagedAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListManagedAccountsRequest.Builder} to create a
     *        request. List managed accounts request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListManagedAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListManagedAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListManagedAccountsIterable listManagedAccountsPaginator(
            Consumer<ListManagedAccountsRequest.Builder> listManagedAccountsRequest) throws UninitializedAccountException,
            ValidationException, AwsServiceException, SdkClientException, MgnException {
        return listManagedAccountsPaginator(ListManagedAccountsRequest.builder().applyMutation(listManagedAccountsRequest)
                .build());
    }

    /**
     * <p>
     * List source server post migration custom actions.
     * </p>
     *
     * @param listSourceServerActionsRequest
     * @return Result of the ListSourceServerActions operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListSourceServerActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListSourceServerActions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSourceServerActionsResponse listSourceServerActions(ListSourceServerActionsRequest listSourceServerActionsRequest)
            throws UninitializedAccountException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List source server post migration custom actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSourceServerActionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSourceServerActionsRequest#builder()}
     * </p>
     *
     * @param listSourceServerActionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSourceServerActionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSourceServerActions operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListSourceServerActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListSourceServerActions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSourceServerActionsResponse listSourceServerActions(
            Consumer<ListSourceServerActionsRequest.Builder> listSourceServerActionsRequest)
            throws UninitializedAccountException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MgnException {
        return listSourceServerActions(ListSourceServerActionsRequest.builder().applyMutation(listSourceServerActionsRequest)
                .build());
    }

    /**
     * <p>
     * List source server post migration custom actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSourceServerActions(software.amazon.awssdk.services.mgn.model.ListSourceServerActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListSourceServerActionsIterable responses = client.listSourceServerActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.ListSourceServerActionsIterable responses = client
     *             .listSourceServerActionsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.ListSourceServerActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListSourceServerActionsIterable responses = client.listSourceServerActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSourceServerActions(software.amazon.awssdk.services.mgn.model.ListSourceServerActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSourceServerActionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListSourceServerActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListSourceServerActions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSourceServerActionsIterable listSourceServerActionsPaginator(
            ListSourceServerActionsRequest listSourceServerActionsRequest) throws UninitializedAccountException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MgnException {
        return new ListSourceServerActionsIterable(this, listSourceServerActionsRequest);
    }

    /**
     * <p>
     * List source server post migration custom actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSourceServerActions(software.amazon.awssdk.services.mgn.model.ListSourceServerActionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListSourceServerActionsIterable responses = client.listSourceServerActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.ListSourceServerActionsIterable responses = client
     *             .listSourceServerActionsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.ListSourceServerActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListSourceServerActionsIterable responses = client.listSourceServerActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSourceServerActions(software.amazon.awssdk.services.mgn.model.ListSourceServerActionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSourceServerActionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSourceServerActionsRequest#builder()}
     * </p>
     *
     * @param listSourceServerActionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSourceServerActionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListSourceServerActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListSourceServerActions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSourceServerActionsIterable listSourceServerActionsPaginator(
            Consumer<ListSourceServerActionsRequest.Builder> listSourceServerActionsRequest)
            throws UninitializedAccountException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MgnException {
        return listSourceServerActionsPaginator(ListSourceServerActionsRequest.builder()
                .applyMutation(listSourceServerActionsRequest).build());
    }

    /**
     * <p>
     * List all tags for your Application Migration Service resources.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ThrottlingException
     *         Reached throttling quota exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws InternalServerException
     *         The server encountered an unexpected condition that prevented it from fulfilling the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tags for your Application Migration Service resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ThrottlingException
     *         Reached throttling quota exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws InternalServerException
     *         The server encountered an unexpected condition that prevented it from fulfilling the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, MgnException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * List template post migration custom actions.
     * </p>
     *
     * @param listTemplateActionsRequest
     * @return Result of the ListTemplateActions operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListTemplateActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListTemplateActions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTemplateActionsResponse listTemplateActions(ListTemplateActionsRequest listTemplateActionsRequest)
            throws UninitializedAccountException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List template post migration custom actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplateActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTemplateActionsRequest#builder()}
     * </p>
     *
     * @param listTemplateActionsRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplateActionsRequest.Builder} to create a
     *        request.
     * @return Result of the ListTemplateActions operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListTemplateActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListTemplateActions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTemplateActionsResponse listTemplateActions(
            Consumer<ListTemplateActionsRequest.Builder> listTemplateActionsRequest) throws UninitializedAccountException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MgnException {
        return listTemplateActions(ListTemplateActionsRequest.builder().applyMutation(listTemplateActionsRequest).build());
    }

    /**
     * <p>
     * List template post migration custom actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateActions(software.amazon.awssdk.services.mgn.model.ListTemplateActionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListTemplateActionsIterable responses = client.listTemplateActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.ListTemplateActionsIterable responses = client
     *             .listTemplateActionsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.ListTemplateActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListTemplateActionsIterable responses = client.listTemplateActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateActions(software.amazon.awssdk.services.mgn.model.ListTemplateActionsRequest)} operation.</b>
     * </p>
     *
     * @param listTemplateActionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListTemplateActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListTemplateActions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTemplateActionsIterable listTemplateActionsPaginator(ListTemplateActionsRequest listTemplateActionsRequest)
            throws UninitializedAccountException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            MgnException {
        return new ListTemplateActionsIterable(this, listTemplateActionsRequest);
    }

    /**
     * <p>
     * List template post migration custom actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateActions(software.amazon.awssdk.services.mgn.model.ListTemplateActionsRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListTemplateActionsIterable responses = client.listTemplateActionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.ListTemplateActionsIterable responses = client
     *             .listTemplateActionsPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.ListTemplateActionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListTemplateActionsIterable responses = client.listTemplateActionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateActions(software.amazon.awssdk.services.mgn.model.ListTemplateActionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplateActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTemplateActionsRequest#builder()}
     * </p>
     *
     * @param listTemplateActionsRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplateActionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListTemplateActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListTemplateActions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTemplateActionsIterable listTemplateActionsPaginator(
            Consumer<ListTemplateActionsRequest.Builder> listTemplateActionsRequest) throws UninitializedAccountException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, MgnException {
        return listTemplateActionsPaginator(ListTemplateActionsRequest.builder().applyMutation(listTemplateActionsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves all waves or multiple waves by ID.
     * </p>
     *
     * @param listWavesRequest
     * @return Result of the ListWaves operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListWaves
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListWaves" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWavesResponse listWaves(ListWavesRequest listWavesRequest) throws UninitializedAccountException,
            AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all waves or multiple waves by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWavesRequest.Builder} avoiding the need to
     * create one manually via {@link ListWavesRequest#builder()}
     * </p>
     *
     * @param listWavesRequest
     *        A {@link Consumer} that will call methods on {@link ListWavesRequest.Builder} to create a request.
     * @return Result of the ListWaves operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListWaves
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListWaves" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWavesResponse listWaves(Consumer<ListWavesRequest.Builder> listWavesRequest)
            throws UninitializedAccountException, AwsServiceException, SdkClientException, MgnException {
        return listWaves(ListWavesRequest.builder().applyMutation(listWavesRequest).build());
    }

    /**
     * <p>
     * Retrieves all waves or multiple waves by ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWaves(software.amazon.awssdk.services.mgn.model.ListWavesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListWavesIterable responses = client.listWavesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.ListWavesIterable responses = client.listWavesPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.ListWavesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListWavesIterable responses = client.listWavesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWaves(software.amazon.awssdk.services.mgn.model.ListWavesRequest)} operation.</b>
     * </p>
     *
     * @param listWavesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListWaves
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListWaves" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWavesIterable listWavesPaginator(ListWavesRequest listWavesRequest) throws UninitializedAccountException,
            AwsServiceException, SdkClientException, MgnException {
        return new ListWavesIterable(this, listWavesRequest);
    }

    /**
     * <p>
     * Retrieves all waves or multiple waves by ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWaves(software.amazon.awssdk.services.mgn.model.ListWavesRequest)} operation.
     * The return type is a custom iterable that can be used to iterate through all the pages. SDK will internally
     * handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListWavesIterable responses = client.listWavesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.mgn.paginators.ListWavesIterable responses = client.listWavesPaginator(request);
     *     for (software.amazon.awssdk.services.mgn.model.ListWavesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListWavesIterable responses = client.listWavesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWaves(software.amazon.awssdk.services.mgn.model.ListWavesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWavesRequest.Builder} avoiding the need to
     * create one manually via {@link ListWavesRequest#builder()}
     * </p>
     *
     * @param listWavesRequest
     *        A {@link Consumer} that will call methods on {@link ListWavesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ListWaves
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListWaves" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWavesIterable listWavesPaginator(Consumer<ListWavesRequest.Builder> listWavesRequest)
            throws UninitializedAccountException, AwsServiceException, SdkClientException, MgnException {
        return listWavesPaginator(ListWavesRequest.builder().applyMutation(listWavesRequest).build());
    }

    /**
     * <p>
     * Archives specific Source Servers by setting the SourceServer.isArchived property to true for specified
     * SourceServers by ID. This command only works for SourceServers with a lifecycle. state which equals DISCONNECTED
     * or CUTOVER.
     * </p>
     *
     * @param markAsArchivedRequest
     * @return Result of the MarkAsArchived operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.MarkAsArchived
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/MarkAsArchived" target="_top">AWS API
     *      Documentation</a>
     */
    default MarkAsArchivedResponse markAsArchived(MarkAsArchivedRequest markAsArchivedRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Archives specific Source Servers by setting the SourceServer.isArchived property to true for specified
     * SourceServers by ID. This command only works for SourceServers with a lifecycle. state which equals DISCONNECTED
     * or CUTOVER.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MarkAsArchivedRequest.Builder} avoiding the need to
     * create one manually via {@link MarkAsArchivedRequest#builder()}
     * </p>
     *
     * @param markAsArchivedRequest
     *        A {@link Consumer} that will call methods on {@link MarkAsArchivedRequest.Builder} to create a request.
     * @return Result of the MarkAsArchived operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.MarkAsArchived
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/MarkAsArchived" target="_top">AWS API
     *      Documentation</a>
     */
    default MarkAsArchivedResponse markAsArchived(Consumer<MarkAsArchivedRequest.Builder> markAsArchivedRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        return markAsArchived(MarkAsArchivedRequest.builder().applyMutation(markAsArchivedRequest).build());
    }

    /**
     * <p>
     * Pause Replication.
     * </p>
     *
     * @param pauseReplicationRequest
     * @return Result of the PauseReplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.PauseReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/PauseReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default PauseReplicationResponse pauseReplication(PauseReplicationRequest pauseReplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException,
            ConflictException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Pause Replication.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PauseReplicationRequest.Builder} avoiding the need
     * to create one manually via {@link PauseReplicationRequest#builder()}
     * </p>
     *
     * @param pauseReplicationRequest
     *        A {@link Consumer} that will call methods on {@link PauseReplicationRequest.Builder} to create a request.
     * @return Result of the PauseReplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.PauseReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/PauseReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default PauseReplicationResponse pauseReplication(Consumer<PauseReplicationRequest.Builder> pauseReplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException,
            ConflictException, AwsServiceException, SdkClientException, MgnException {
        return pauseReplication(PauseReplicationRequest.builder().applyMutation(pauseReplicationRequest).build());
    }

    /**
     * <p>
     * Put source server post migration custom action.
     * </p>
     *
     * @param putSourceServerActionRequest
     * @return Result of the PutSourceServerAction operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.PutSourceServerAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/PutSourceServerAction" target="_top">AWS API
     *      Documentation</a>
     */
    default PutSourceServerActionResponse putSourceServerAction(PutSourceServerActionRequest putSourceServerActionRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Put source server post migration custom action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutSourceServerActionRequest.Builder} avoiding the
     * need to create one manually via {@link PutSourceServerActionRequest#builder()}
     * </p>
     *
     * @param putSourceServerActionRequest
     *        A {@link Consumer} that will call methods on {@link PutSourceServerActionRequest.Builder} to create a
     *        request.
     * @return Result of the PutSourceServerAction operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.PutSourceServerAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/PutSourceServerAction" target="_top">AWS API
     *      Documentation</a>
     */
    default PutSourceServerActionResponse putSourceServerAction(
            Consumer<PutSourceServerActionRequest.Builder> putSourceServerActionRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            MgnException {
        return putSourceServerAction(PutSourceServerActionRequest.builder().applyMutation(putSourceServerActionRequest).build());
    }

    /**
     * <p>
     * Put template post migration custom action.
     * </p>
     *
     * @param putTemplateActionRequest
     * @return Result of the PutTemplateAction operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.PutTemplateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/PutTemplateAction" target="_top">AWS API
     *      Documentation</a>
     */
    default PutTemplateActionResponse putTemplateAction(PutTemplateActionRequest putTemplateActionRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Put template post migration custom action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutTemplateActionRequest.Builder} avoiding the need
     * to create one manually via {@link PutTemplateActionRequest#builder()}
     * </p>
     *
     * @param putTemplateActionRequest
     *        A {@link Consumer} that will call methods on {@link PutTemplateActionRequest.Builder} to create a request.
     * @return Result of the PutTemplateAction operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.PutTemplateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/PutTemplateAction" target="_top">AWS API
     *      Documentation</a>
     */
    default PutTemplateActionResponse putTemplateAction(Consumer<PutTemplateActionRequest.Builder> putTemplateActionRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        return putTemplateAction(PutTemplateActionRequest.builder().applyMutation(putTemplateActionRequest).build());
    }

    /**
     * <p>
     * Remove source server post migration custom action.
     * </p>
     *
     * @param removeSourceServerActionRequest
     * @return Result of the RemoveSourceServerAction operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.RemoveSourceServerAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/RemoveSourceServerAction" target="_top">AWS
     *      API Documentation</a>
     */
    default RemoveSourceServerActionResponse removeSourceServerAction(
            RemoveSourceServerActionRequest removeSourceServerActionRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove source server post migration custom action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveSourceServerActionRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveSourceServerActionRequest#builder()}
     * </p>
     *
     * @param removeSourceServerActionRequest
     *        A {@link Consumer} that will call methods on {@link RemoveSourceServerActionRequest.Builder} to create a
     *        request.
     * @return Result of the RemoveSourceServerAction operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.RemoveSourceServerAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/RemoveSourceServerAction" target="_top">AWS
     *      API Documentation</a>
     */
    default RemoveSourceServerActionResponse removeSourceServerAction(
            Consumer<RemoveSourceServerActionRequest.Builder> removeSourceServerActionRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        return removeSourceServerAction(RemoveSourceServerActionRequest.builder().applyMutation(removeSourceServerActionRequest)
                .build());
    }

    /**
     * <p>
     * Remove template post migration custom action.
     * </p>
     *
     * @param removeTemplateActionRequest
     * @return Result of the RemoveTemplateAction operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.RemoveTemplateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/RemoveTemplateAction" target="_top">AWS API
     *      Documentation</a>
     */
    default RemoveTemplateActionResponse removeTemplateAction(RemoveTemplateActionRequest removeTemplateActionRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove template post migration custom action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTemplateActionRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveTemplateActionRequest#builder()}
     * </p>
     *
     * @param removeTemplateActionRequest
     *        A {@link Consumer} that will call methods on {@link RemoveTemplateActionRequest.Builder} to create a
     *        request.
     * @return Result of the RemoveTemplateAction operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.RemoveTemplateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/RemoveTemplateAction" target="_top">AWS API
     *      Documentation</a>
     */
    default RemoveTemplateActionResponse removeTemplateAction(
            Consumer<RemoveTemplateActionRequest.Builder> removeTemplateActionRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return removeTemplateAction(RemoveTemplateActionRequest.builder().applyMutation(removeTemplateActionRequest).build());
    }

    /**
     * <p>
     * Resume Replication.
     * </p>
     *
     * @param resumeReplicationRequest
     * @return Result of the ResumeReplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ResumeReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ResumeReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default ResumeReplicationResponse resumeReplication(ResumeReplicationRequest resumeReplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException,
            ConflictException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resume Replication.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResumeReplicationRequest.Builder} avoiding the need
     * to create one manually via {@link ResumeReplicationRequest#builder()}
     * </p>
     *
     * @param resumeReplicationRequest
     *        A {@link Consumer} that will call methods on {@link ResumeReplicationRequest.Builder} to create a request.
     * @return Result of the ResumeReplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.ResumeReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ResumeReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default ResumeReplicationResponse resumeReplication(Consumer<ResumeReplicationRequest.Builder> resumeReplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException,
            ConflictException, AwsServiceException, SdkClientException, MgnException {
        return resumeReplication(ResumeReplicationRequest.builder().applyMutation(resumeReplicationRequest).build());
    }

    /**
     * <p>
     * Causes the data replication initiation sequence to begin immediately upon next Handshake for specified
     * SourceServer IDs, regardless of when the previous initiation started. This command will not work if the
     * SourceServer is not stalled or is in a DISCONNECTED or STOPPED state.
     * </p>
     *
     * @param retryDataReplicationRequest
     * @return Result of the RetryDataReplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.RetryDataReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/RetryDataReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default RetryDataReplicationResponse retryDataReplication(RetryDataReplicationRequest retryDataReplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Causes the data replication initiation sequence to begin immediately upon next Handshake for specified
     * SourceServer IDs, regardless of when the previous initiation started. This command will not work if the
     * SourceServer is not stalled or is in a DISCONNECTED or STOPPED state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetryDataReplicationRequest.Builder} avoiding the
     * need to create one manually via {@link RetryDataReplicationRequest#builder()}
     * </p>
     *
     * @param retryDataReplicationRequest
     *        A {@link Consumer} that will call methods on {@link RetryDataReplicationRequest.Builder} to create a
     *        request.
     * @return Result of the RetryDataReplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.RetryDataReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/RetryDataReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default RetryDataReplicationResponse retryDataReplication(
            Consumer<RetryDataReplicationRequest.Builder> retryDataReplicationRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ValidationException, AwsServiceException, SdkClientException, MgnException {
        return retryDataReplication(RetryDataReplicationRequest.builder().applyMutation(retryDataReplicationRequest).build());
    }

    /**
     * <p>
     * Launches a Cutover Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy
     * property is StartCutover and changes the SourceServer.lifeCycle.state property to CUTTING_OVER.
     * </p>
     *
     * @param startCutoverRequest
     * @return Result of the StartCutover operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.StartCutover
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartCutover" target="_top">AWS API
     *      Documentation</a>
     */
    default StartCutoverResponse startCutover(StartCutoverRequest startCutoverRequest) throws UninitializedAccountException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Launches a Cutover Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy
     * property is StartCutover and changes the SourceServer.lifeCycle.state property to CUTTING_OVER.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCutoverRequest.Builder} avoiding the need to
     * create one manually via {@link StartCutoverRequest#builder()}
     * </p>
     *
     * @param startCutoverRequest
     *        A {@link Consumer} that will call methods on {@link StartCutoverRequest.Builder} to create a request.
     * @return Result of the StartCutover operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.StartCutover
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartCutover" target="_top">AWS API
     *      Documentation</a>
     */
    default StartCutoverResponse startCutover(Consumer<StartCutoverRequest.Builder> startCutoverRequest)
            throws UninitializedAccountException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        return startCutover(StartCutoverRequest.builder().applyMutation(startCutoverRequest).build());
    }

    /**
     * <p>
     * Start export.
     * </p>
     *
     * @param startExportRequest
     *        Start export request.
     * @return Result of the StartExport operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.StartExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartExport" target="_top">AWS API
     *      Documentation</a>
     */
    default StartExportResponse startExport(StartExportRequest startExportRequest) throws UninitializedAccountException,
            ValidationException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start export.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartExportRequest.Builder} avoiding the need to
     * create one manually via {@link StartExportRequest#builder()}
     * </p>
     *
     * @param startExportRequest
     *        A {@link Consumer} that will call methods on {@link StartExportRequest.Builder} to create a request. Start
     *        export request.
     * @return Result of the StartExport operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.StartExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartExport" target="_top">AWS API
     *      Documentation</a>
     */
    default StartExportResponse startExport(Consumer<StartExportRequest.Builder> startExportRequest)
            throws UninitializedAccountException, ValidationException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, MgnException {
        return startExport(StartExportRequest.builder().applyMutation(startExportRequest).build());
    }

    /**
     * <p>
     * Start import.
     * </p>
     *
     * @param startImportRequest
     *        Start import request.
     * @return Result of the StartImport operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.StartImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartImport" target="_top">AWS API
     *      Documentation</a>
     */
    default StartImportResponse startImport(StartImportRequest startImportRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ValidationException, ServiceQuotaExceededException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start import.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImportRequest.Builder} avoiding the need to
     * create one manually via {@link StartImportRequest#builder()}
     * </p>
     *
     * @param startImportRequest
     *        A {@link Consumer} that will call methods on {@link StartImportRequest.Builder} to create a request. Start
     *        import request.
     * @return Result of the StartImport operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.StartImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartImport" target="_top">AWS API
     *      Documentation</a>
     */
    default StartImportResponse startImport(Consumer<StartImportRequest.Builder> startImportRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException,
            ConflictException, AwsServiceException, SdkClientException, MgnException {
        return startImport(StartImportRequest.builder().applyMutation(startImportRequest).build());
    }

    /**
     * <p>
     * Starts replication for SNAPSHOT_SHIPPING agents.
     * </p>
     *
     * @param startReplicationRequest
     * @return Result of the StartReplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.StartReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default StartReplicationResponse startReplication(StartReplicationRequest startReplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException,
            ConflictException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts replication for SNAPSHOT_SHIPPING agents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReplicationRequest.Builder} avoiding the need
     * to create one manually via {@link StartReplicationRequest#builder()}
     * </p>
     *
     * @param startReplicationRequest
     *        A {@link Consumer} that will call methods on {@link StartReplicationRequest.Builder} to create a request.
     * @return Result of the StartReplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.StartReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default StartReplicationResponse startReplication(Consumer<StartReplicationRequest.Builder> startReplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException,
            ConflictException, AwsServiceException, SdkClientException, MgnException {
        return startReplication(StartReplicationRequest.builder().applyMutation(startReplicationRequest).build());
    }

    /**
     * <p>
     * Launches a Test Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy property
     * is StartTest and changes the SourceServer.lifeCycle.state property to TESTING.
     * </p>
     *
     * @param startTestRequest
     * @return Result of the StartTest operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.StartTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartTest" target="_top">AWS API
     *      Documentation</a>
     */
    default StartTestResponse startTest(StartTestRequest startTestRequest) throws UninitializedAccountException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Launches a Test Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy property
     * is StartTest and changes the SourceServer.lifeCycle.state property to TESTING.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTestRequest.Builder} avoiding the need to
     * create one manually via {@link StartTestRequest#builder()}
     * </p>
     *
     * @param startTestRequest
     *        A {@link Consumer} that will call methods on {@link StartTestRequest.Builder} to create a request.
     * @return Result of the StartTest operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.StartTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartTest" target="_top">AWS API
     *      Documentation</a>
     */
    default StartTestResponse startTest(Consumer<StartTestRequest.Builder> startTestRequest)
            throws UninitializedAccountException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        return startTest(StartTestRequest.builder().applyMutation(startTestRequest).build());
    }

    /**
     * <p>
     * Stop Replication.
     * </p>
     *
     * @param stopReplicationRequest
     * @return Result of the StopReplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.StopReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StopReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default StopReplicationResponse stopReplication(StopReplicationRequest stopReplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException,
            ConflictException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stop Replication.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopReplicationRequest.Builder} avoiding the need
     * to create one manually via {@link StopReplicationRequest#builder()}
     * </p>
     *
     * @param stopReplicationRequest
     *        A {@link Consumer} that will call methods on {@link StopReplicationRequest.Builder} to create a request.
     * @return Result of the StopReplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.StopReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StopReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default StopReplicationResponse stopReplication(Consumer<StopReplicationRequest.Builder> stopReplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ServiceQuotaExceededException,
            ConflictException, AwsServiceException, SdkClientException, MgnException {
        return stopReplication(StopReplicationRequest.builder().applyMutation(stopReplicationRequest).build());
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Application Migration Service resource or resources.
     * When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a
     * maximum of 50 tags. Each tag consists of a key and optional value.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ThrottlingException
     *         Reached throttling quota exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws InternalServerException
     *         The server encountered an unexpected condition that prevented it from fulfilling the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Application Migration Service resource or resources.
     * When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a
     * maximum of 50 tags. Each tag consists of a key and optional value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ThrottlingException
     *         Reached throttling quota exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws InternalServerException
     *         The server encountered an unexpected condition that prevented it from fulfilling the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, MgnException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Starts a job that terminates specific launched EC2 Test and Cutover instances. This command will not work for any
     * Source Server with a lifecycle.state of TESTING, CUTTING_OVER, or CUTOVER.
     * </p>
     *
     * @param terminateTargetInstancesRequest
     * @return Result of the TerminateTargetInstances operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.TerminateTargetInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/TerminateTargetInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default TerminateTargetInstancesResponse terminateTargetInstances(
            TerminateTargetInstancesRequest terminateTargetInstancesRequest) throws UninitializedAccountException,
            ValidationException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a job that terminates specific launched EC2 Test and Cutover instances. This command will not work for any
     * Source Server with a lifecycle.state of TESTING, CUTTING_OVER, or CUTOVER.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateTargetInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link TerminateTargetInstancesRequest#builder()}
     * </p>
     *
     * @param terminateTargetInstancesRequest
     *        A {@link Consumer} that will call methods on {@link TerminateTargetInstancesRequest.Builder} to create a
     *        request.
     * @return Result of the TerminateTargetInstances operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.TerminateTargetInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/TerminateTargetInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default TerminateTargetInstancesResponse terminateTargetInstances(
            Consumer<TerminateTargetInstancesRequest.Builder> terminateTargetInstancesRequest)
            throws UninitializedAccountException, ValidationException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        return terminateTargetInstances(TerminateTargetInstancesRequest.builder().applyMutation(terminateTargetInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Unarchive application.
     * </p>
     *
     * @param unarchiveApplicationRequest
     * @return Result of the UnarchiveApplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UnarchiveApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UnarchiveApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default UnarchiveApplicationResponse unarchiveApplication(UnarchiveApplicationRequest unarchiveApplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Unarchive application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnarchiveApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link UnarchiveApplicationRequest#builder()}
     * </p>
     *
     * @param unarchiveApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UnarchiveApplicationRequest.Builder} to create a
     *        request.
     * @return Result of the UnarchiveApplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UnarchiveApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UnarchiveApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default UnarchiveApplicationResponse unarchiveApplication(
            Consumer<UnarchiveApplicationRequest.Builder> unarchiveApplicationRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MgnException {
        return unarchiveApplication(UnarchiveApplicationRequest.builder().applyMutation(unarchiveApplicationRequest).build());
    }

    /**
     * <p>
     * Unarchive wave.
     * </p>
     *
     * @param unarchiveWaveRequest
     * @return Result of the UnarchiveWave operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UnarchiveWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UnarchiveWave" target="_top">AWS API
     *      Documentation</a>
     */
    default UnarchiveWaveResponse unarchiveWave(UnarchiveWaveRequest unarchiveWaveRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Unarchive wave.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnarchiveWaveRequest.Builder} avoiding the need to
     * create one manually via {@link UnarchiveWaveRequest#builder()}
     * </p>
     *
     * @param unarchiveWaveRequest
     *        A {@link Consumer} that will call methods on {@link UnarchiveWaveRequest.Builder} to create a request.
     * @return Result of the UnarchiveWave operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ServiceQuotaExceededException
     *         The request could not be completed because its exceeded the service quota.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UnarchiveWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UnarchiveWave" target="_top">AWS API
     *      Documentation</a>
     */
    default UnarchiveWaveResponse unarchiveWave(Consumer<UnarchiveWaveRequest.Builder> unarchiveWaveRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ServiceQuotaExceededException, AwsServiceException,
            SdkClientException, MgnException {
        return unarchiveWave(UnarchiveWaveRequest.builder().applyMutation(unarchiveWaveRequest).build());
    }

    /**
     * <p>
     * Deletes the specified set of tags from the specified set of Application Migration Service resources.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ThrottlingException
     *         Reached throttling quota exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws InternalServerException
     *         The server encountered an unexpected condition that prevented it from fulfilling the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            ThrottlingException, ValidationException, AccessDeniedException, InternalServerException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified set of tags from the specified set of Application Migration Service resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ThrottlingException
     *         Reached throttling quota exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws InternalServerException
     *         The server encountered an unexpected condition that prevented it from fulfilling the request.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, ThrottlingException, ValidationException, AccessDeniedException,
            InternalServerException, AwsServiceException, SdkClientException, MgnException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update application.
     * </p>
     *
     * @param updateApplicationRequest
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApplicationRequest.Builder} to create a request.
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Updates multiple LaunchConfigurations by Source Server ID.
     * </p>
     *
     * @param updateLaunchConfigurationRequest
     * @return Result of the UpdateLaunchConfiguration operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateLaunchConfigurationResponse updateLaunchConfiguration(
            UpdateLaunchConfigurationRequest updateLaunchConfigurationRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ValidationException, ConflictException, AwsServiceException, SdkClientException,
            MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates multiple LaunchConfigurations by Source Server ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLaunchConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLaunchConfigurationRequest#builder()}
     * </p>
     *
     * @param updateLaunchConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLaunchConfigurationRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateLaunchConfiguration operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateLaunchConfigurationResponse updateLaunchConfiguration(
            Consumer<UpdateLaunchConfigurationRequest.Builder> updateLaunchConfigurationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        return updateLaunchConfiguration(UpdateLaunchConfigurationRequest.builder()
                .applyMutation(updateLaunchConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an existing Launch Configuration Template by ID.
     * </p>
     *
     * @param updateLaunchConfigurationTemplateRequest
     * @return Result of the UpdateLaunchConfigurationTemplate operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLaunchConfigurationTemplateResponse updateLaunchConfigurationTemplate(
            UpdateLaunchConfigurationTemplateRequest updateLaunchConfigurationTemplateRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Launch Configuration Template by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLaunchConfigurationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateLaunchConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param updateLaunchConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLaunchConfigurationTemplateRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateLaunchConfigurationTemplate operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateLaunchConfigurationTemplateResponse updateLaunchConfigurationTemplate(
            Consumer<UpdateLaunchConfigurationTemplateRequest.Builder> updateLaunchConfigurationTemplateRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, MgnException {
        return updateLaunchConfigurationTemplate(UpdateLaunchConfigurationTemplateRequest.builder()
                .applyMutation(updateLaunchConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Allows you to update multiple ReplicationConfigurations by Source Server ID.
     * </p>
     *
     * @param updateReplicationConfigurationRequest
     * @return Result of the UpdateReplicationConfiguration operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateReplicationConfigurationResponse updateReplicationConfiguration(
            UpdateReplicationConfigurationRequest updateReplicationConfigurationRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ValidationException, AccessDeniedException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to update multiple ReplicationConfigurations by Source Server ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReplicationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateReplicationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateReplicationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateReplicationConfigurationRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateReplicationConfiguration operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateReplicationConfigurationResponse updateReplicationConfiguration(
            Consumer<UpdateReplicationConfigurationRequest.Builder> updateReplicationConfigurationRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            ConflictException, AwsServiceException, SdkClientException, MgnException {
        return updateReplicationConfiguration(UpdateReplicationConfigurationRequest.builder()
                .applyMutation(updateReplicationConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates multiple ReplicationConfigurationTemplates by ID.
     * </p>
     *
     * @param updateReplicationConfigurationTemplateRequest
     * @return Result of the UpdateReplicationConfigurationTemplate operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateReplicationConfigurationTemplateResponse updateReplicationConfigurationTemplate(
            UpdateReplicationConfigurationTemplateRequest updateReplicationConfigurationTemplateRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates multiple ReplicationConfigurationTemplates by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateReplicationConfigurationTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateReplicationConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param updateReplicationConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateReplicationConfigurationTemplateRequest.Builder}
     *        to create a request.
     * @return Result of the UpdateReplicationConfigurationTemplate operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws AccessDeniedException
     *         Operating denied due to a file permission or access check error.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateReplicationConfigurationTemplateResponse updateReplicationConfigurationTemplate(
            Consumer<UpdateReplicationConfigurationTemplateRequest.Builder> updateReplicationConfigurationTemplateRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, AccessDeniedException,
            AwsServiceException, SdkClientException, MgnException {
        return updateReplicationConfigurationTemplate(UpdateReplicationConfigurationTemplateRequest.builder()
                .applyMutation(updateReplicationConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Allows you to change between the AGENT_BASED replication type and the SNAPSHOT_SHIPPING replication type.
     * </p>
     *
     * @param updateSourceServerReplicationTypeRequest
     * @return Result of the UpdateSourceServerReplicationType operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateSourceServerReplicationType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateSourceServerReplicationType"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSourceServerReplicationTypeResponse updateSourceServerReplicationType(
            UpdateSourceServerReplicationTypeRequest updateSourceServerReplicationTypeRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to change between the AGENT_BASED replication type and the SNAPSHOT_SHIPPING replication type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSourceServerReplicationTypeRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSourceServerReplicationTypeRequest#builder()}
     * </p>
     *
     * @param updateSourceServerReplicationTypeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSourceServerReplicationTypeRequest.Builder} to
     *        create a request.
     * @return Result of the UpdateSourceServerReplicationType operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ValidationException
     *         Validate exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateSourceServerReplicationType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateSourceServerReplicationType"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSourceServerReplicationTypeResponse updateSourceServerReplicationType(
            Consumer<UpdateSourceServerReplicationTypeRequest.Builder> updateSourceServerReplicationTypeRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ValidationException, ConflictException,
            AwsServiceException, SdkClientException, MgnException {
        return updateSourceServerReplicationType(UpdateSourceServerReplicationTypeRequest.builder()
                .applyMutation(updateSourceServerReplicationTypeRequest).build());
    }

    /**
     * <p>
     * Update wave.
     * </p>
     *
     * @param updateWaveRequest
     * @return Result of the UpdateWave operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateWave" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateWaveResponse updateWave(UpdateWaveRequest updateWaveRequest) throws UninitializedAccountException,
            ResourceNotFoundException, ConflictException, AwsServiceException, SdkClientException, MgnException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update wave.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWaveRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateWaveRequest#builder()}
     * </p>
     *
     * @param updateWaveRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWaveRequest.Builder} to create a request.
     * @return Result of the UpdateWave operation returned by the service.
     * @throws UninitializedAccountException
     *         Uninitialized account exception.
     * @throws ResourceNotFoundException
     *         Resource not found exception.
     * @throws ConflictException
     *         The request could not be completed due to a conflict with the current state of the target resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws MgnException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample MgnClient.UpdateWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateWave" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateWaveResponse updateWave(Consumer<UpdateWaveRequest.Builder> updateWaveRequest)
            throws UninitializedAccountException, ResourceNotFoundException, ConflictException, AwsServiceException,
            SdkClientException, MgnException {
        return updateWave(UpdateWaveRequest.builder().applyMutation(updateWaveRequest).build());
    }

    /**
     * Create a {@link MgnClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MgnClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MgnClient}.
     */
    static MgnClientBuilder builder() {
        return new DefaultMgnClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default MgnServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
