/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.mgn.MgnClient;
import software.amazon.awssdk.services.mgn.model.ExportTask;
import software.amazon.awssdk.services.mgn.model.ListExportsRequest;
import software.amazon.awssdk.services.mgn.model.ListExportsResponse;

public class ListExportsIterable
implements SdkIterable<ListExportsResponse> {
    private final MgnClient client;
    private final ListExportsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListExportsIterable(MgnClient client, ListExportsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListExportsResponseFetcher();
    }

    public Iterator<ListExportsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExportTask> items() {
        Function<ListExportsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListExportsResponseFetcher
    implements SyncPageFetcher<ListExportsResponse> {
        private ListExportsResponseFetcher() {
        }

        public boolean hasNextPage(ListExportsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListExportsResponse nextPage(ListExportsResponse previousPage) {
            if (previousPage == null) {
                return ListExportsIterable.this.client.listExports(ListExportsIterable.this.firstRequest);
            }
            return ListExportsIterable.this.client.listExports((ListExportsRequest)((Object)ListExportsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

