/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.ActionCategory;
import software.amazon.awssdk.services.mgn.model.MgnResponse;
import software.amazon.awssdk.services.mgn.model.SsmDocumentExternalParametersCopier;
import software.amazon.awssdk.services.mgn.model.SsmDocumentParametersCopier;
import software.amazon.awssdk.services.mgn.model.SsmExternalParameter;
import software.amazon.awssdk.services.mgn.model.SsmParameterStoreParameter;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PutSourceServerActionResponse
extends MgnResponse
implements ToCopyableBuilder<Builder, PutSourceServerActionResponse> {
    private static final SdkField<String> ACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionID").getter(PutSourceServerActionResponse.getter(PutSourceServerActionResponse::actionID)).setter(PutSourceServerActionResponse.setter(Builder::actionID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionID").build()}).build();
    private static final SdkField<String> ACTION_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("actionName").getter(PutSourceServerActionResponse.getter(PutSourceServerActionResponse::actionName)).setter(PutSourceServerActionResponse.setter(Builder::actionName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionName").build()}).build();
    private static final SdkField<Boolean> ACTIVE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("active").getter(PutSourceServerActionResponse.getter(PutSourceServerActionResponse::active)).setter(PutSourceServerActionResponse.setter(Builder::active)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("active").build()}).build();
    private static final SdkField<String> CATEGORY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("category").getter(PutSourceServerActionResponse.getter(PutSourceServerActionResponse::categoryAsString)).setter(PutSourceServerActionResponse.setter(Builder::category)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("category").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(PutSourceServerActionResponse.getter(PutSourceServerActionResponse::description)).setter(PutSourceServerActionResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<String> DOCUMENT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("documentIdentifier").getter(PutSourceServerActionResponse.getter(PutSourceServerActionResponse::documentIdentifier)).setter(PutSourceServerActionResponse.setter(Builder::documentIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentIdentifier").build()}).build();
    private static final SdkField<String> DOCUMENT_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("documentVersion").getter(PutSourceServerActionResponse.getter(PutSourceServerActionResponse::documentVersion)).setter(PutSourceServerActionResponse.setter(Builder::documentVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentVersion").build()}).build();
    private static final SdkField<Map<String, SsmExternalParameter>> EXTERNAL_PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("externalParameters").getter(PutSourceServerActionResponse.getter(PutSourceServerActionResponse::externalParameters)).setter(PutSourceServerActionResponse.setter(Builder::externalParameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalParameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SsmExternalParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Boolean> MUST_SUCCEED_FOR_CUTOVER_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("mustSucceedForCutover").getter(PutSourceServerActionResponse.getter(PutSourceServerActionResponse::mustSucceedForCutover)).setter(PutSourceServerActionResponse.setter(Builder::mustSucceedForCutover)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mustSucceedForCutover").build()}).build();
    private static final SdkField<Integer> ORDER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("order").getter(PutSourceServerActionResponse.getter(PutSourceServerActionResponse::order)).setter(PutSourceServerActionResponse.setter(Builder::order)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("order").build()}).build();
    private static final SdkField<Map<String, List<SsmParameterStoreParameter>>> PARAMETERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("parameters").getter(PutSourceServerActionResponse.getter(PutSourceServerActionResponse::parameters)).setter(PutSourceServerActionResponse.setter(Builder::parameters)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameters").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.LIST).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SsmParameterStoreParameter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build()).build()}).build();
    private static final SdkField<Integer> TIMEOUT_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutSeconds").getter(PutSourceServerActionResponse.getter(PutSourceServerActionResponse::timeoutSeconds)).setter(PutSourceServerActionResponse.setter(Builder::timeoutSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_ID_FIELD, ACTION_NAME_FIELD, ACTIVE_FIELD, CATEGORY_FIELD, DESCRIPTION_FIELD, DOCUMENT_IDENTIFIER_FIELD, DOCUMENT_VERSION_FIELD, EXTERNAL_PARAMETERS_FIELD, MUST_SUCCEED_FOR_CUTOVER_FIELD, ORDER_FIELD, PARAMETERS_FIELD, TIMEOUT_SECONDS_FIELD));
    private final String actionID;
    private final String actionName;
    private final Boolean active;
    private final String category;
    private final String description;
    private final String documentIdentifier;
    private final String documentVersion;
    private final Map<String, SsmExternalParameter> externalParameters;
    private final Boolean mustSucceedForCutover;
    private final Integer order;
    private final Map<String, List<SsmParameterStoreParameter>> parameters;
    private final Integer timeoutSeconds;

    private PutSourceServerActionResponse(BuilderImpl builder) {
        super(builder);
        this.actionID = builder.actionID;
        this.actionName = builder.actionName;
        this.active = builder.active;
        this.category = builder.category;
        this.description = builder.description;
        this.documentIdentifier = builder.documentIdentifier;
        this.documentVersion = builder.documentVersion;
        this.externalParameters = builder.externalParameters;
        this.mustSucceedForCutover = builder.mustSucceedForCutover;
        this.order = builder.order;
        this.parameters = builder.parameters;
        this.timeoutSeconds = builder.timeoutSeconds;
    }

    public final String actionID() {
        return this.actionID;
    }

    public final String actionName() {
        return this.actionName;
    }

    public final Boolean active() {
        return this.active;
    }

    public final ActionCategory category() {
        return ActionCategory.fromValue(this.category);
    }

    public final String categoryAsString() {
        return this.category;
    }

    public final String description() {
        return this.description;
    }

    public final String documentIdentifier() {
        return this.documentIdentifier;
    }

    public final String documentVersion() {
        return this.documentVersion;
    }

    public final boolean hasExternalParameters() {
        return this.externalParameters != null && !(this.externalParameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, SsmExternalParameter> externalParameters() {
        return this.externalParameters;
    }

    public final Boolean mustSucceedForCutover() {
        return this.mustSucceedForCutover;
    }

    public final Integer order() {
        return this.order;
    }

    public final boolean hasParameters() {
        return this.parameters != null && !(this.parameters instanceof SdkAutoConstructMap);
    }

    public final Map<String, List<SsmParameterStoreParameter>> parameters() {
        return this.parameters;
    }

    public final Integer timeoutSeconds() {
        return this.timeoutSeconds;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.actionID());
        hashCode = 31 * hashCode + Objects.hashCode(this.actionName());
        hashCode = 31 * hashCode + Objects.hashCode(this.active());
        hashCode = 31 * hashCode + Objects.hashCode(this.categoryAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExternalParameters() ? this.externalParameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.mustSucceedForCutover());
        hashCode = 31 * hashCode + Objects.hashCode(this.order());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasParameters() ? this.parameters() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutSeconds());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PutSourceServerActionResponse)) {
            return false;
        }
        PutSourceServerActionResponse other = (PutSourceServerActionResponse)((Object)obj);
        return Objects.equals(this.actionID(), other.actionID()) && Objects.equals(this.actionName(), other.actionName()) && Objects.equals(this.active(), other.active()) && Objects.equals(this.categoryAsString(), other.categoryAsString()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.documentIdentifier(), other.documentIdentifier()) && Objects.equals(this.documentVersion(), other.documentVersion()) && this.hasExternalParameters() == other.hasExternalParameters() && Objects.equals(this.externalParameters(), other.externalParameters()) && Objects.equals(this.mustSucceedForCutover(), other.mustSucceedForCutover()) && Objects.equals(this.order(), other.order()) && this.hasParameters() == other.hasParameters() && Objects.equals(this.parameters(), other.parameters()) && Objects.equals(this.timeoutSeconds(), other.timeoutSeconds());
    }

    public final String toString() {
        return ToString.builder((String)"PutSourceServerActionResponse").add("ActionID", (Object)this.actionID()).add("ActionName", (Object)this.actionName()).add("Active", (Object)this.active()).add("Category", (Object)this.categoryAsString()).add("Description", (Object)this.description()).add("DocumentIdentifier", (Object)this.documentIdentifier()).add("DocumentVersion", (Object)this.documentVersion()).add("ExternalParameters", this.hasExternalParameters() ? this.externalParameters() : null).add("MustSucceedForCutover", (Object)this.mustSucceedForCutover()).add("Order", (Object)this.order()).add("Parameters", this.hasParameters() ? this.parameters() : null).add("TimeoutSeconds", (Object)this.timeoutSeconds()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionID": {
                return Optional.ofNullable(clazz.cast(this.actionID()));
            }
            case "actionName": {
                return Optional.ofNullable(clazz.cast(this.actionName()));
            }
            case "active": {
                return Optional.ofNullable(clazz.cast(this.active()));
            }
            case "category": {
                return Optional.ofNullable(clazz.cast(this.categoryAsString()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "documentIdentifier": {
                return Optional.ofNullable(clazz.cast(this.documentIdentifier()));
            }
            case "documentVersion": {
                return Optional.ofNullable(clazz.cast(this.documentVersion()));
            }
            case "externalParameters": {
                return Optional.ofNullable(clazz.cast(this.externalParameters()));
            }
            case "mustSucceedForCutover": {
                return Optional.ofNullable(clazz.cast(this.mustSucceedForCutover()));
            }
            case "order": {
                return Optional.ofNullable(clazz.cast(this.order()));
            }
            case "parameters": {
                return Optional.ofNullable(clazz.cast(this.parameters()));
            }
            case "timeoutSeconds": {
                return Optional.ofNullable(clazz.cast(this.timeoutSeconds()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<PutSourceServerActionResponse, T> g) {
        return obj -> g.apply((PutSourceServerActionResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MgnResponse.BuilderImpl
    implements Builder {
        private String actionID;
        private String actionName;
        private Boolean active;
        private String category;
        private String description;
        private String documentIdentifier;
        private String documentVersion;
        private Map<String, SsmExternalParameter> externalParameters = DefaultSdkAutoConstructMap.getInstance();
        private Boolean mustSucceedForCutover;
        private Integer order;
        private Map<String, List<SsmParameterStoreParameter>> parameters = DefaultSdkAutoConstructMap.getInstance();
        private Integer timeoutSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(PutSourceServerActionResponse model) {
            super(model);
            this.actionID(model.actionID);
            this.actionName(model.actionName);
            this.active(model.active);
            this.category(model.category);
            this.description(model.description);
            this.documentIdentifier(model.documentIdentifier);
            this.documentVersion(model.documentVersion);
            this.externalParameters(model.externalParameters);
            this.mustSucceedForCutover(model.mustSucceedForCutover);
            this.order(model.order);
            this.parameters(model.parameters);
            this.timeoutSeconds(model.timeoutSeconds);
        }

        public final String getActionID() {
            return this.actionID;
        }

        public final void setActionID(String actionID) {
            this.actionID = actionID;
        }

        @Override
        public final Builder actionID(String actionID) {
            this.actionID = actionID;
            return this;
        }

        public final String getActionName() {
            return this.actionName;
        }

        public final void setActionName(String actionName) {
            this.actionName = actionName;
        }

        @Override
        public final Builder actionName(String actionName) {
            this.actionName = actionName;
            return this;
        }

        public final Boolean getActive() {
            return this.active;
        }

        public final void setActive(Boolean active) {
            this.active = active;
        }

        @Override
        public final Builder active(Boolean active) {
            this.active = active;
            return this;
        }

        public final String getCategory() {
            return this.category;
        }

        public final void setCategory(String category) {
            this.category = category;
        }

        @Override
        public final Builder category(String category) {
            this.category = category;
            return this;
        }

        @Override
        public final Builder category(ActionCategory category) {
            this.category(category == null ? null : category.toString());
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDocumentIdentifier() {
            return this.documentIdentifier;
        }

        public final void setDocumentIdentifier(String documentIdentifier) {
            this.documentIdentifier = documentIdentifier;
        }

        @Override
        public final Builder documentIdentifier(String documentIdentifier) {
            this.documentIdentifier = documentIdentifier;
            return this;
        }

        public final String getDocumentVersion() {
            return this.documentVersion;
        }

        public final void setDocumentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
        }

        @Override
        public final Builder documentVersion(String documentVersion) {
            this.documentVersion = documentVersion;
            return this;
        }

        public final Map<String, SsmExternalParameter.Builder> getExternalParameters() {
            Map<String, SsmExternalParameter.Builder> result = SsmDocumentExternalParametersCopier.copyToBuilder(this.externalParameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setExternalParameters(Map<String, SsmExternalParameter.BuilderImpl> externalParameters) {
            this.externalParameters = SsmDocumentExternalParametersCopier.copyFromBuilder(externalParameters);
        }

        @Override
        public final Builder externalParameters(Map<String, SsmExternalParameter> externalParameters) {
            this.externalParameters = SsmDocumentExternalParametersCopier.copy(externalParameters);
            return this;
        }

        public final Boolean getMustSucceedForCutover() {
            return this.mustSucceedForCutover;
        }

        public final void setMustSucceedForCutover(Boolean mustSucceedForCutover) {
            this.mustSucceedForCutover = mustSucceedForCutover;
        }

        @Override
        public final Builder mustSucceedForCutover(Boolean mustSucceedForCutover) {
            this.mustSucceedForCutover = mustSucceedForCutover;
            return this;
        }

        public final Integer getOrder() {
            return this.order;
        }

        public final void setOrder(Integer order) {
            this.order = order;
        }

        @Override
        public final Builder order(Integer order) {
            this.order = order;
            return this;
        }

        public final Map<String, List<SsmParameterStoreParameter.Builder>> getParameters() {
            Map<String, List<SsmParameterStoreParameter.Builder>> result = SsmDocumentParametersCopier.copyToBuilder(this.parameters);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setParameters(Map<String, ? extends Collection<SsmParameterStoreParameter.BuilderImpl>> parameters) {
            this.parameters = SsmDocumentParametersCopier.copyFromBuilder(parameters);
        }

        @Override
        public final Builder parameters(Map<String, ? extends Collection<SsmParameterStoreParameter>> parameters) {
            this.parameters = SsmDocumentParametersCopier.copy(parameters);
            return this;
        }

        public final Integer getTimeoutSeconds() {
            return this.timeoutSeconds;
        }

        public final void setTimeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
        }

        @Override
        public final Builder timeoutSeconds(Integer timeoutSeconds) {
            this.timeoutSeconds = timeoutSeconds;
            return this;
        }

        @Override
        public PutSourceServerActionResponse build() {
            return new PutSourceServerActionResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MgnResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PutSourceServerActionResponse> {
        public Builder actionID(String var1);

        public Builder actionName(String var1);

        public Builder active(Boolean var1);

        public Builder category(String var1);

        public Builder category(ActionCategory var1);

        public Builder description(String var1);

        public Builder documentIdentifier(String var1);

        public Builder documentVersion(String var1);

        public Builder externalParameters(Map<String, SsmExternalParameter> var1);

        public Builder mustSucceedForCutover(Boolean var1);

        public Builder order(Integer var1);

        public Builder parameters(Map<String, ? extends Collection<SsmParameterStoreParameter>> var1);

        public Builder timeoutSeconds(Integer var1);
    }
}

