/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * List exports request filters.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListExportsRequestFilters implements SdkPojo, Serializable,
        ToCopyableBuilder<ListExportsRequestFilters.Builder, ListExportsRequestFilters> {
    private static final SdkField<List<String>> EXPORT_I_DS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("exportIDs")
            .getter(getter(ListExportsRequestFilters::exportIDs))
            .setter(setter(Builder::exportIDs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("exportIDs").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPORT_I_DS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<String> exportIDs;

    private ListExportsRequestFilters(BuilderImpl builder) {
        this.exportIDs = builder.exportIDs;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExportIDs property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasExportIDs() {
        return exportIDs != null && !(exportIDs instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List exports request filters export ids.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExportIDs} method.
     * </p>
     * 
     * @return List exports request filters export ids.
     */
    public final List<String> exportIDs() {
        return exportIDs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasExportIDs() ? exportIDs() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListExportsRequestFilters)) {
            return false;
        }
        ListExportsRequestFilters other = (ListExportsRequestFilters) obj;
        return hasExportIDs() == other.hasExportIDs() && Objects.equals(exportIDs(), other.exportIDs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListExportsRequestFilters").add("ExportIDs", hasExportIDs() ? exportIDs() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "exportIDs":
            return Optional.ofNullable(clazz.cast(exportIDs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListExportsRequestFilters, T> g) {
        return obj -> g.apply((ListExportsRequestFilters) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ListExportsRequestFilters> {
        /**
         * <p>
         * List exports request filters export ids.
         * </p>
         * 
         * @param exportIDs
         *        List exports request filters export ids.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportIDs(Collection<String> exportIDs);

        /**
         * <p>
         * List exports request filters export ids.
         * </p>
         * 
         * @param exportIDs
         *        List exports request filters export ids.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder exportIDs(String... exportIDs);
    }

    static final class BuilderImpl implements Builder {
        private List<String> exportIDs = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListExportsRequestFilters model) {
            exportIDs(model.exportIDs);
        }

        public final Collection<String> getExportIDs() {
            if (exportIDs instanceof SdkAutoConstructList) {
                return null;
            }
            return exportIDs;
        }

        public final void setExportIDs(Collection<String> exportIDs) {
            this.exportIDs = ListExportsRequestFiltersExportIDsCopier.copy(exportIDs);
        }

        @Override
        public final Builder exportIDs(Collection<String> exportIDs) {
            this.exportIDs = ListExportsRequestFiltersExportIDsCopier.copy(exportIDs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder exportIDs(String... exportIDs) {
            exportIDs(Arrays.asList(exportIDs));
            return this;
        }

        @Override
        public ListExportsRequestFilters build() {
            return new ListExportsRequestFilters(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
