/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Launched instance.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LaunchedInstance implements SdkPojo, Serializable,
        ToCopyableBuilder<LaunchedInstance.Builder, LaunchedInstance> {
    private static final SdkField<String> EC2_INSTANCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ec2InstanceID").getter(getter(LaunchedInstance::ec2InstanceID)).setter(setter(Builder::ec2InstanceID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2InstanceID").build()).build();

    private static final SdkField<String> FIRST_BOOT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("firstBoot").getter(getter(LaunchedInstance::firstBootAsString)).setter(setter(Builder::firstBoot))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("firstBoot").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobID")
            .getter(getter(LaunchedInstance::jobID)).setter(setter(Builder::jobID))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobID").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EC2_INSTANCE_ID_FIELD,
            FIRST_BOOT_FIELD, JOB_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String ec2InstanceID;

    private final String firstBoot;

    private final String jobID;

    private LaunchedInstance(BuilderImpl builder) {
        this.ec2InstanceID = builder.ec2InstanceID;
        this.firstBoot = builder.firstBoot;
        this.jobID = builder.jobID;
    }

    /**
     * <p>
     * Launched instance EC2 ID.
     * </p>
     * 
     * @return Launched instance EC2 ID.
     */
    public final String ec2InstanceID() {
        return ec2InstanceID;
    }

    /**
     * <p>
     * Launched instance first boot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #firstBoot} will
     * return {@link FirstBoot#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #firstBootAsString}.
     * </p>
     * 
     * @return Launched instance first boot.
     * @see FirstBoot
     */
    public final FirstBoot firstBoot() {
        return FirstBoot.fromValue(firstBoot);
    }

    /**
     * <p>
     * Launched instance first boot.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #firstBoot} will
     * return {@link FirstBoot#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #firstBootAsString}.
     * </p>
     * 
     * @return Launched instance first boot.
     * @see FirstBoot
     */
    public final String firstBootAsString() {
        return firstBoot;
    }

    /**
     * <p>
     * Launched instance Job ID.
     * </p>
     * 
     * @return Launched instance Job ID.
     */
    public final String jobID() {
        return jobID;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ec2InstanceID());
        hashCode = 31 * hashCode + Objects.hashCode(firstBootAsString());
        hashCode = 31 * hashCode + Objects.hashCode(jobID());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchedInstance)) {
            return false;
        }
        LaunchedInstance other = (LaunchedInstance) obj;
        return Objects.equals(ec2InstanceID(), other.ec2InstanceID())
                && Objects.equals(firstBootAsString(), other.firstBootAsString()) && Objects.equals(jobID(), other.jobID());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LaunchedInstance").add("Ec2InstanceID", ec2InstanceID()).add("FirstBoot", firstBootAsString())
                .add("JobID", jobID()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ec2InstanceID":
            return Optional.ofNullable(clazz.cast(ec2InstanceID()));
        case "firstBoot":
            return Optional.ofNullable(clazz.cast(firstBootAsString()));
        case "jobID":
            return Optional.ofNullable(clazz.cast(jobID()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchedInstance, T> g) {
        return obj -> g.apply((LaunchedInstance) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LaunchedInstance> {
        /**
         * <p>
         * Launched instance EC2 ID.
         * </p>
         * 
         * @param ec2InstanceID
         *        Launched instance EC2 ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2InstanceID(String ec2InstanceID);

        /**
         * <p>
         * Launched instance first boot.
         * </p>
         * 
         * @param firstBoot
         *        Launched instance first boot.
         * @see FirstBoot
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirstBoot
         */
        Builder firstBoot(String firstBoot);

        /**
         * <p>
         * Launched instance first boot.
         * </p>
         * 
         * @param firstBoot
         *        Launched instance first boot.
         * @see FirstBoot
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FirstBoot
         */
        Builder firstBoot(FirstBoot firstBoot);

        /**
         * <p>
         * Launched instance Job ID.
         * </p>
         * 
         * @param jobID
         *        Launched instance Job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobID(String jobID);
    }

    static final class BuilderImpl implements Builder {
        private String ec2InstanceID;

        private String firstBoot;

        private String jobID;

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchedInstance model) {
            ec2InstanceID(model.ec2InstanceID);
            firstBoot(model.firstBoot);
            jobID(model.jobID);
        }

        public final String getEc2InstanceID() {
            return ec2InstanceID;
        }

        public final void setEc2InstanceID(String ec2InstanceID) {
            this.ec2InstanceID = ec2InstanceID;
        }

        @Override
        public final Builder ec2InstanceID(String ec2InstanceID) {
            this.ec2InstanceID = ec2InstanceID;
            return this;
        }

        public final String getFirstBoot() {
            return firstBoot;
        }

        public final void setFirstBoot(String firstBoot) {
            this.firstBoot = firstBoot;
        }

        @Override
        public final Builder firstBoot(String firstBoot) {
            this.firstBoot = firstBoot;
            return this;
        }

        @Override
        public final Builder firstBoot(FirstBoot firstBoot) {
            this.firstBoot(firstBoot == null ? null : firstBoot.toString());
            return this;
        }

        public final String getJobID() {
            return jobID;
        }

        public final void setJobID(String jobID) {
            this.jobID = jobID;
        }

        @Override
        public final Builder jobID(String jobID) {
            this.jobID = jobID;
            return this;
        }

        @Override
        public LaunchedInstance build() {
            return new LaunchedInstance(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
