/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mgn;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.mgn.model.ArchiveApplicationRequest;
import software.amazon.awssdk.services.mgn.model.ArchiveApplicationResponse;
import software.amazon.awssdk.services.mgn.model.ArchiveWaveRequest;
import software.amazon.awssdk.services.mgn.model.ArchiveWaveResponse;
import software.amazon.awssdk.services.mgn.model.AssociateApplicationsRequest;
import software.amazon.awssdk.services.mgn.model.AssociateApplicationsResponse;
import software.amazon.awssdk.services.mgn.model.AssociateSourceServersRequest;
import software.amazon.awssdk.services.mgn.model.AssociateSourceServersResponse;
import software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateRequest;
import software.amazon.awssdk.services.mgn.model.ChangeServerLifeCycleStateResponse;
import software.amazon.awssdk.services.mgn.model.CreateApplicationRequest;
import software.amazon.awssdk.services.mgn.model.CreateApplicationResponse;
import software.amazon.awssdk.services.mgn.model.CreateLaunchConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.CreateLaunchConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.CreateReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.CreateReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.CreateWaveRequest;
import software.amazon.awssdk.services.mgn.model.CreateWaveResponse;
import software.amazon.awssdk.services.mgn.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.mgn.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.mgn.model.DeleteJobRequest;
import software.amazon.awssdk.services.mgn.model.DeleteJobResponse;
import software.amazon.awssdk.services.mgn.model.DeleteLaunchConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.DeleteLaunchConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.DeleteReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.DeleteReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.DeleteSourceServerRequest;
import software.amazon.awssdk.services.mgn.model.DeleteSourceServerResponse;
import software.amazon.awssdk.services.mgn.model.DeleteVcenterClientRequest;
import software.amazon.awssdk.services.mgn.model.DeleteVcenterClientResponse;
import software.amazon.awssdk.services.mgn.model.DeleteWaveRequest;
import software.amazon.awssdk.services.mgn.model.DeleteWaveResponse;
import software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest;
import software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse;
import software.amazon.awssdk.services.mgn.model.DescribeJobsRequest;
import software.amazon.awssdk.services.mgn.model.DescribeJobsResponse;
import software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesRequest;
import software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesResponse;
import software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest;
import software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse;
import software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest;
import software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse;
import software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest;
import software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsResponse;
import software.amazon.awssdk.services.mgn.model.DisassociateApplicationsRequest;
import software.amazon.awssdk.services.mgn.model.DisassociateApplicationsResponse;
import software.amazon.awssdk.services.mgn.model.DisassociateSourceServersRequest;
import software.amazon.awssdk.services.mgn.model.DisassociateSourceServersResponse;
import software.amazon.awssdk.services.mgn.model.DisconnectFromServiceRequest;
import software.amazon.awssdk.services.mgn.model.DisconnectFromServiceResponse;
import software.amazon.awssdk.services.mgn.model.FinalizeCutoverRequest;
import software.amazon.awssdk.services.mgn.model.FinalizeCutoverResponse;
import software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.GetLaunchConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.GetReplicationConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.InitializeServiceRequest;
import software.amazon.awssdk.services.mgn.model.InitializeServiceResponse;
import software.amazon.awssdk.services.mgn.model.ListApplicationsRequest;
import software.amazon.awssdk.services.mgn.model.ListApplicationsResponse;
import software.amazon.awssdk.services.mgn.model.ListExportErrorsRequest;
import software.amazon.awssdk.services.mgn.model.ListExportErrorsResponse;
import software.amazon.awssdk.services.mgn.model.ListExportsRequest;
import software.amazon.awssdk.services.mgn.model.ListExportsResponse;
import software.amazon.awssdk.services.mgn.model.ListImportErrorsRequest;
import software.amazon.awssdk.services.mgn.model.ListImportErrorsResponse;
import software.amazon.awssdk.services.mgn.model.ListImportsRequest;
import software.amazon.awssdk.services.mgn.model.ListImportsResponse;
import software.amazon.awssdk.services.mgn.model.ListManagedAccountsRequest;
import software.amazon.awssdk.services.mgn.model.ListManagedAccountsResponse;
import software.amazon.awssdk.services.mgn.model.ListSourceServerActionsRequest;
import software.amazon.awssdk.services.mgn.model.ListSourceServerActionsResponse;
import software.amazon.awssdk.services.mgn.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.mgn.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.mgn.model.ListTemplateActionsRequest;
import software.amazon.awssdk.services.mgn.model.ListTemplateActionsResponse;
import software.amazon.awssdk.services.mgn.model.ListWavesRequest;
import software.amazon.awssdk.services.mgn.model.ListWavesResponse;
import software.amazon.awssdk.services.mgn.model.MarkAsArchivedRequest;
import software.amazon.awssdk.services.mgn.model.MarkAsArchivedResponse;
import software.amazon.awssdk.services.mgn.model.PauseReplicationRequest;
import software.amazon.awssdk.services.mgn.model.PauseReplicationResponse;
import software.amazon.awssdk.services.mgn.model.PutSourceServerActionRequest;
import software.amazon.awssdk.services.mgn.model.PutSourceServerActionResponse;
import software.amazon.awssdk.services.mgn.model.PutTemplateActionRequest;
import software.amazon.awssdk.services.mgn.model.PutTemplateActionResponse;
import software.amazon.awssdk.services.mgn.model.RemoveSourceServerActionRequest;
import software.amazon.awssdk.services.mgn.model.RemoveSourceServerActionResponse;
import software.amazon.awssdk.services.mgn.model.RemoveTemplateActionRequest;
import software.amazon.awssdk.services.mgn.model.RemoveTemplateActionResponse;
import software.amazon.awssdk.services.mgn.model.ResumeReplicationRequest;
import software.amazon.awssdk.services.mgn.model.ResumeReplicationResponse;
import software.amazon.awssdk.services.mgn.model.RetryDataReplicationRequest;
import software.amazon.awssdk.services.mgn.model.RetryDataReplicationResponse;
import software.amazon.awssdk.services.mgn.model.StartCutoverRequest;
import software.amazon.awssdk.services.mgn.model.StartCutoverResponse;
import software.amazon.awssdk.services.mgn.model.StartExportRequest;
import software.amazon.awssdk.services.mgn.model.StartExportResponse;
import software.amazon.awssdk.services.mgn.model.StartImportRequest;
import software.amazon.awssdk.services.mgn.model.StartImportResponse;
import software.amazon.awssdk.services.mgn.model.StartReplicationRequest;
import software.amazon.awssdk.services.mgn.model.StartReplicationResponse;
import software.amazon.awssdk.services.mgn.model.StartTestRequest;
import software.amazon.awssdk.services.mgn.model.StartTestResponse;
import software.amazon.awssdk.services.mgn.model.StopReplicationRequest;
import software.amazon.awssdk.services.mgn.model.StopReplicationResponse;
import software.amazon.awssdk.services.mgn.model.TagResourceRequest;
import software.amazon.awssdk.services.mgn.model.TagResourceResponse;
import software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesRequest;
import software.amazon.awssdk.services.mgn.model.TerminateTargetInstancesResponse;
import software.amazon.awssdk.services.mgn.model.UnarchiveApplicationRequest;
import software.amazon.awssdk.services.mgn.model.UnarchiveApplicationResponse;
import software.amazon.awssdk.services.mgn.model.UnarchiveWaveRequest;
import software.amazon.awssdk.services.mgn.model.UnarchiveWaveResponse;
import software.amazon.awssdk.services.mgn.model.UntagResourceRequest;
import software.amazon.awssdk.services.mgn.model.UntagResourceResponse;
import software.amazon.awssdk.services.mgn.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.mgn.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.UpdateLaunchConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationRequest;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationResponse;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationTemplateRequest;
import software.amazon.awssdk.services.mgn.model.UpdateReplicationConfigurationTemplateResponse;
import software.amazon.awssdk.services.mgn.model.UpdateSourceServerReplicationTypeRequest;
import software.amazon.awssdk.services.mgn.model.UpdateSourceServerReplicationTypeResponse;
import software.amazon.awssdk.services.mgn.model.UpdateWaveRequest;
import software.amazon.awssdk.services.mgn.model.UpdateWaveResponse;
import software.amazon.awssdk.services.mgn.paginators.DescribeJobLogItemsPublisher;
import software.amazon.awssdk.services.mgn.paginators.DescribeJobsPublisher;
import software.amazon.awssdk.services.mgn.paginators.DescribeLaunchConfigurationTemplatesPublisher;
import software.amazon.awssdk.services.mgn.paginators.DescribeReplicationConfigurationTemplatesPublisher;
import software.amazon.awssdk.services.mgn.paginators.DescribeSourceServersPublisher;
import software.amazon.awssdk.services.mgn.paginators.DescribeVcenterClientsPublisher;
import software.amazon.awssdk.services.mgn.paginators.ListApplicationsPublisher;
import software.amazon.awssdk.services.mgn.paginators.ListExportErrorsPublisher;
import software.amazon.awssdk.services.mgn.paginators.ListExportsPublisher;
import software.amazon.awssdk.services.mgn.paginators.ListImportErrorsPublisher;
import software.amazon.awssdk.services.mgn.paginators.ListImportsPublisher;
import software.amazon.awssdk.services.mgn.paginators.ListManagedAccountsPublisher;
import software.amazon.awssdk.services.mgn.paginators.ListSourceServerActionsPublisher;
import software.amazon.awssdk.services.mgn.paginators.ListTemplateActionsPublisher;
import software.amazon.awssdk.services.mgn.paginators.ListWavesPublisher;

/**
 * Service client for accessing mgn asynchronously. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * The Application Migration Service service.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface MgnAsyncClient extends AwsClient {
    String SERVICE_NAME = "mgn";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "mgn";

    /**
     * <p>
     * Archive application.
     * </p>
     *
     * @param archiveApplicationRequest
     * @return A Java Future containing the result of the ArchiveApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ArchiveApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ArchiveApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ArchiveApplicationResponse> archiveApplication(ArchiveApplicationRequest archiveApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Archive application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ArchiveApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link ArchiveApplicationRequest#builder()}
     * </p>
     *
     * @param archiveApplicationRequest
     *        A {@link Consumer} that will call methods on {@link ArchiveApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ArchiveApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ArchiveApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ArchiveApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ArchiveApplicationResponse> archiveApplication(
            Consumer<ArchiveApplicationRequest.Builder> archiveApplicationRequest) {
        return archiveApplication(ArchiveApplicationRequest.builder().applyMutation(archiveApplicationRequest).build());
    }

    /**
     * <p>
     * Archive wave.
     * </p>
     *
     * @param archiveWaveRequest
     * @return A Java Future containing the result of the ArchiveWave operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ArchiveWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ArchiveWave" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ArchiveWaveResponse> archiveWave(ArchiveWaveRequest archiveWaveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Archive wave.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ArchiveWaveRequest.Builder} avoiding the need to
     * create one manually via {@link ArchiveWaveRequest#builder()}
     * </p>
     *
     * @param archiveWaveRequest
     *        A {@link Consumer} that will call methods on {@link ArchiveWaveRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ArchiveWave operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ArchiveWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ArchiveWave" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ArchiveWaveResponse> archiveWave(Consumer<ArchiveWaveRequest.Builder> archiveWaveRequest) {
        return archiveWave(ArchiveWaveRequest.builder().applyMutation(archiveWaveRequest).build());
    }

    /**
     * <p>
     * Associate applications to wave.
     * </p>
     *
     * @param associateApplicationsRequest
     * @return A Java Future containing the result of the AssociateApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.AssociateApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/AssociateApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateApplicationsResponse> associateApplications(
            AssociateApplicationsRequest associateApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate applications to wave.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateApplicationsRequest#builder()}
     * </p>
     *
     * @param associateApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link AssociateApplicationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.AssociateApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/AssociateApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<AssociateApplicationsResponse> associateApplications(
            Consumer<AssociateApplicationsRequest.Builder> associateApplicationsRequest) {
        return associateApplications(AssociateApplicationsRequest.builder().applyMutation(associateApplicationsRequest).build());
    }

    /**
     * <p>
     * Associate source servers to application.
     * </p>
     *
     * @param associateSourceServersRequest
     * @return A Java Future containing the result of the AssociateSourceServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.AssociateSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/AssociateSourceServers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateSourceServersResponse> associateSourceServers(
            AssociateSourceServersRequest associateSourceServersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associate source servers to application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSourceServersRequest.Builder} avoiding the
     * need to create one manually via {@link AssociateSourceServersRequest#builder()}
     * </p>
     *
     * @param associateSourceServersRequest
     *        A {@link Consumer} that will call methods on {@link AssociateSourceServersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the AssociateSourceServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.AssociateSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/AssociateSourceServers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<AssociateSourceServersResponse> associateSourceServers(
            Consumer<AssociateSourceServersRequest.Builder> associateSourceServersRequest) {
        return associateSourceServers(AssociateSourceServersRequest.builder().applyMutation(associateSourceServersRequest)
                .build());
    }

    /**
     * <p>
     * Allows the user to set the SourceServer.LifeCycle.state property for specific Source Server IDs to one of the
     * following: READY_FOR_TEST or READY_FOR_CUTOVER. This command only works if the Source Server is already
     * launchable (dataReplicationInfo.lagDuration is not null.)
     * </p>
     *
     * @param changeServerLifeCycleStateRequest
     * @return A Java Future containing the result of the ChangeServerLifeCycleState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ChangeServerLifeCycleState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ChangeServerLifeCycleState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ChangeServerLifeCycleStateResponse> changeServerLifeCycleState(
            ChangeServerLifeCycleStateRequest changeServerLifeCycleStateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows the user to set the SourceServer.LifeCycle.state property for specific Source Server IDs to one of the
     * following: READY_FOR_TEST or READY_FOR_CUTOVER. This command only works if the Source Server is already
     * launchable (dataReplicationInfo.lagDuration is not null.)
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ChangeServerLifeCycleStateRequest.Builder} avoiding
     * the need to create one manually via {@link ChangeServerLifeCycleStateRequest#builder()}
     * </p>
     *
     * @param changeServerLifeCycleStateRequest
     *        A {@link Consumer} that will call methods on {@link ChangeServerLifeCycleStateRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ChangeServerLifeCycleState operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ChangeServerLifeCycleState
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ChangeServerLifeCycleState"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ChangeServerLifeCycleStateResponse> changeServerLifeCycleState(
            Consumer<ChangeServerLifeCycleStateRequest.Builder> changeServerLifeCycleStateRequest) {
        return changeServerLifeCycleState(ChangeServerLifeCycleStateRequest.builder()
                .applyMutation(changeServerLifeCycleStateRequest).build());
    }

    /**
     * <p>
     * Create application.
     * </p>
     *
     * @param createApplicationRequest
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(CreateApplicationRequest createApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateApplicationResponse> createApplication(
            Consumer<CreateApplicationRequest.Builder> createApplicationRequest) {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Creates a new Launch Configuration Template.
     * </p>
     *
     * @param createLaunchConfigurationTemplateRequest
     * @return A Java Future containing the result of the CreateLaunchConfigurationTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.CreateLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLaunchConfigurationTemplateResponse> createLaunchConfigurationTemplate(
            CreateLaunchConfigurationTemplateRequest createLaunchConfigurationTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new Launch Configuration Template.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateLaunchConfigurationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link CreateLaunchConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param createLaunchConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateLaunchConfigurationTemplateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the CreateLaunchConfigurationTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.CreateLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateLaunchConfigurationTemplateResponse> createLaunchConfigurationTemplate(
            Consumer<CreateLaunchConfigurationTemplateRequest.Builder> createLaunchConfigurationTemplateRequest) {
        return createLaunchConfigurationTemplate(CreateLaunchConfigurationTemplateRequest.builder()
                .applyMutation(createLaunchConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Creates a new ReplicationConfigurationTemplate.
     * </p>
     *
     * @param createReplicationConfigurationTemplateRequest
     * @return A Java Future containing the result of the CreateReplicationConfigurationTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.CreateReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReplicationConfigurationTemplateResponse> createReplicationConfigurationTemplate(
            CreateReplicationConfigurationTemplateRequest createReplicationConfigurationTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new ReplicationConfigurationTemplate.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link CreateReplicationConfigurationTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link CreateReplicationConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param createReplicationConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link CreateReplicationConfigurationTemplateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the CreateReplicationConfigurationTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.CreateReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<CreateReplicationConfigurationTemplateResponse> createReplicationConfigurationTemplate(
            Consumer<CreateReplicationConfigurationTemplateRequest.Builder> createReplicationConfigurationTemplateRequest) {
        return createReplicationConfigurationTemplate(CreateReplicationConfigurationTemplateRequest.builder()
                .applyMutation(createReplicationConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Create wave.
     * </p>
     *
     * @param createWaveRequest
     * @return A Java Future containing the result of the CreateWave operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.CreateWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateWave" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWaveResponse> createWave(CreateWaveRequest createWaveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Create wave.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateWaveRequest.Builder} avoiding the need to
     * create one manually via {@link CreateWaveRequest#builder()}
     * </p>
     *
     * @param createWaveRequest
     *        A {@link Consumer} that will call methods on {@link CreateWaveRequest.Builder} to create a request.
     * @return A Java Future containing the result of the CreateWave operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.CreateWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/CreateWave" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<CreateWaveResponse> createWave(Consumer<CreateWaveRequest.Builder> createWaveRequest) {
        return createWave(CreateWaveRequest.builder().applyMutation(createWaveRequest).build());
    }

    /**
     * <p>
     * Delete application.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(DeleteApplicationRequest deleteApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteApplicationResponse> deleteApplication(
            Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest) {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes a single Job by ID.
     * </p>
     *
     * @param deleteJobRequest
     * @return A Java Future containing the result of the DeleteJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteJobResponse> deleteJob(DeleteJobRequest deleteJobRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a single Job by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteJobRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteJobRequest#builder()}
     * </p>
     *
     * @param deleteJobRequest
     *        A {@link Consumer} that will call methods on {@link DeleteJobRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteJob operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteJob
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteJob" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteJobResponse> deleteJob(Consumer<DeleteJobRequest.Builder> deleteJobRequest) {
        return deleteJob(DeleteJobRequest.builder().applyMutation(deleteJobRequest).build());
    }

    /**
     * <p>
     * Deletes a single Launch Configuration Template by ID.
     * </p>
     *
     * @param deleteLaunchConfigurationTemplateRequest
     * @return A Java Future containing the result of the DeleteLaunchConfigurationTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLaunchConfigurationTemplateResponse> deleteLaunchConfigurationTemplate(
            DeleteLaunchConfigurationTemplateRequest deleteLaunchConfigurationTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a single Launch Configuration Template by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteLaunchConfigurationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteLaunchConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param deleteLaunchConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteLaunchConfigurationTemplateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the DeleteLaunchConfigurationTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteLaunchConfigurationTemplateResponse> deleteLaunchConfigurationTemplate(
            Consumer<DeleteLaunchConfigurationTemplateRequest.Builder> deleteLaunchConfigurationTemplateRequest) {
        return deleteLaunchConfigurationTemplate(DeleteLaunchConfigurationTemplateRequest.builder()
                .applyMutation(deleteLaunchConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a single Replication Configuration Template by ID
     * </p>
     *
     * @param deleteReplicationConfigurationTemplateRequest
     * @return A Java Future containing the result of the DeleteReplicationConfigurationTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteReplicationConfigurationTemplateResponse> deleteReplicationConfigurationTemplate(
            DeleteReplicationConfigurationTemplateRequest deleteReplicationConfigurationTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a single Replication Configuration Template by ID
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DeleteReplicationConfigurationTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link DeleteReplicationConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param deleteReplicationConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link DeleteReplicationConfigurationTemplateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DeleteReplicationConfigurationTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DeleteReplicationConfigurationTemplateResponse> deleteReplicationConfigurationTemplate(
            Consumer<DeleteReplicationConfigurationTemplateRequest.Builder> deleteReplicationConfigurationTemplateRequest) {
        return deleteReplicationConfigurationTemplate(DeleteReplicationConfigurationTemplateRequest.builder()
                .applyMutation(deleteReplicationConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Deletes a single source server by ID.
     * </p>
     *
     * @param deleteSourceServerRequest
     * @return A Java Future containing the result of the DeleteSourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteSourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteSourceServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSourceServerResponse> deleteSourceServer(DeleteSourceServerRequest deleteSourceServerRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a single source server by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteSourceServerRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteSourceServerRequest#builder()}
     * </p>
     *
     * @param deleteSourceServerRequest
     *        A {@link Consumer} that will call methods on {@link DeleteSourceServerRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteSourceServer operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteSourceServer
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteSourceServer" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteSourceServerResponse> deleteSourceServer(
            Consumer<DeleteSourceServerRequest.Builder> deleteSourceServerRequest) {
        return deleteSourceServer(DeleteSourceServerRequest.builder().applyMutation(deleteSourceServerRequest).build());
    }

    /**
     * <p>
     * Deletes a given vCenter client by ID.
     * </p>
     *
     * @param deleteVcenterClientRequest
     * @return A Java Future containing the result of the DeleteVcenterClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteVcenterClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteVcenterClient" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVcenterClientResponse> deleteVcenterClient(
            DeleteVcenterClientRequest deleteVcenterClientRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a given vCenter client by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteVcenterClientRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteVcenterClientRequest#builder()}
     * </p>
     *
     * @param deleteVcenterClientRequest
     *        A {@link Consumer} that will call methods on {@link DeleteVcenterClientRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DeleteVcenterClient operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteVcenterClient
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteVcenterClient" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteVcenterClientResponse> deleteVcenterClient(
            Consumer<DeleteVcenterClientRequest.Builder> deleteVcenterClientRequest) {
        return deleteVcenterClient(DeleteVcenterClientRequest.builder().applyMutation(deleteVcenterClientRequest).build());
    }

    /**
     * <p>
     * Delete wave.
     * </p>
     *
     * @param deleteWaveRequest
     * @return A Java Future containing the result of the DeleteWave operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteWave" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWaveResponse> deleteWave(DeleteWaveRequest deleteWaveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Delete wave.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteWaveRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteWaveRequest#builder()}
     * </p>
     *
     * @param deleteWaveRequest
     *        A {@link Consumer} that will call methods on {@link DeleteWaveRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DeleteWave operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DeleteWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DeleteWave" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DeleteWaveResponse> deleteWave(Consumer<DeleteWaveRequest.Builder> deleteWaveRequest) {
        return deleteWave(DeleteWaveRequest.builder().applyMutation(deleteWaveRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed job log items with paging.
     * </p>
     *
     * @param describeJobLogItemsRequest
     * @return A Java Future containing the result of the DescribeJobLogItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeJobLogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobLogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeJobLogItemsResponse> describeJobLogItems(
            DescribeJobLogItemsRequest describeJobLogItemsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves detailed job log items with paging.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobLogItemsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeJobLogItemsRequest#builder()}
     * </p>
     *
     * @param describeJobLogItemsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobLogItemsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeJobLogItems operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeJobLogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobLogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeJobLogItemsResponse> describeJobLogItems(
            Consumer<DescribeJobLogItemsRequest.Builder> describeJobLogItemsRequest) {
        return describeJobLogItems(DescribeJobLogItemsRequest.builder().applyMutation(describeJobLogItemsRequest).build());
    }

    /**
     * <p>
     * Retrieves detailed job log items with paging.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeJobLogItems(software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobLogItemsPublisher publisher = client.describeJobLogItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobLogItemsPublisher publisher = client.describeJobLogItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeJobLogItems(software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest)} operation.</b>
     * </p>
     *
     * @param describeJobLogItemsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeJobLogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobLogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobLogItemsPublisher describeJobLogItemsPaginator(DescribeJobLogItemsRequest describeJobLogItemsRequest) {
        return new DescribeJobLogItemsPublisher(this, describeJobLogItemsRequest);
    }

    /**
     * <p>
     * Retrieves detailed job log items with paging.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeJobLogItems(software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobLogItemsPublisher publisher = client.describeJobLogItemsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobLogItemsPublisher publisher = client.describeJobLogItemsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeJobLogItems(software.amazon.awssdk.services.mgn.model.DescribeJobLogItemsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobLogItemsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeJobLogItemsRequest#builder()}
     * </p>
     *
     * @param describeJobLogItemsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobLogItemsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeJobLogItems
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobLogItems" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobLogItemsPublisher describeJobLogItemsPaginator(
            Consumer<DescribeJobLogItemsRequest.Builder> describeJobLogItemsRequest) {
        return describeJobLogItemsPaginator(DescribeJobLogItemsRequest.builder().applyMutation(describeJobLogItemsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of Jobs. Use the JobsID and fromDate and toData filters to limit which jobs are returned. The
     * response is sorted by creationDataTime - latest date first. Jobs are normally created by the StartTest,
     * StartCutover, and TerminateTargetInstances APIs. Jobs are also created by DiagnosticLaunch and
     * TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant
     * support tickets.
     * </p>
     *
     * @param describeJobsRequest
     * @return A Java Future containing the result of the DescribeJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeJobsResponse> describeJobs(DescribeJobsRequest describeJobsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of Jobs. Use the JobsID and fromDate and toData filters to limit which jobs are returned. The
     * response is sorted by creationDataTime - latest date first. Jobs are normally created by the StartTest,
     * StartCutover, and TerminateTargetInstances APIs. Jobs are also created by DiagnosticLaunch and
     * TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant
     * support tickets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeJobsRequest#builder()}
     * </p>
     *
     * @param describeJobsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeJobs operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeJobsResponse> describeJobs(Consumer<DescribeJobsRequest.Builder> describeJobsRequest) {
        return describeJobs(DescribeJobsRequest.builder().applyMutation(describeJobsRequest).build());
    }

    /**
     * <p>
     * Returns a list of Jobs. Use the JobsID and fromDate and toData filters to limit which jobs are returned. The
     * response is sorted by creationDataTime - latest date first. Jobs are normally created by the StartTest,
     * StartCutover, and TerminateTargetInstances APIs. Jobs are also created by DiagnosticLaunch and
     * TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant
     * support tickets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeJobs(software.amazon.awssdk.services.mgn.model.DescribeJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobsPublisher publisher = client.describeJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobsPublisher publisher = client.describeJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeJobs(software.amazon.awssdk.services.mgn.model.DescribeJobsRequest)} operation.</b>
     * </p>
     *
     * @param describeJobsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobsPublisher describeJobsPaginator(DescribeJobsRequest describeJobsRequest) {
        return new DescribeJobsPublisher(this, describeJobsRequest);
    }

    /**
     * <p>
     * Returns a list of Jobs. Use the JobsID and fromDate and toData filters to limit which jobs are returned. The
     * response is sorted by creationDataTime - latest date first. Jobs are normally created by the StartTest,
     * StartCutover, and TerminateTargetInstances APIs. Jobs are also created by DiagnosticLaunch and
     * TerminateDiagnosticInstances, which are APIs available only to *Support* and only used in response to relevant
     * support tickets.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #describeJobs(software.amazon.awssdk.services.mgn.model.DescribeJobsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobsPublisher publisher = client.describeJobsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeJobsPublisher publisher = client.describeJobsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeJobsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeJobsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeJobs(software.amazon.awssdk.services.mgn.model.DescribeJobsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeJobsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeJobsRequest#builder()}
     * </p>
     *
     * @param describeJobsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeJobsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeJobs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeJobs" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeJobsPublisher describeJobsPaginator(Consumer<DescribeJobsRequest.Builder> describeJobsRequest) {
        return describeJobsPaginator(DescribeJobsRequest.builder().applyMutation(describeJobsRequest).build());
    }

    /**
     * <p>
     * Lists all Launch Configuration Templates, filtered by Launch Configuration Template IDs
     * </p>
     *
     * @param describeLaunchConfigurationTemplatesRequest
     * @return A Java Future containing the result of the DescribeLaunchConfigurationTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeLaunchConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeLaunchConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLaunchConfigurationTemplatesResponse> describeLaunchConfigurationTemplates(
            DescribeLaunchConfigurationTemplatesRequest describeLaunchConfigurationTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all Launch Configuration Templates, filtered by Launch Configuration Template IDs
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeLaunchConfigurationTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeLaunchConfigurationTemplatesRequest#builder()}
     * </p>
     *
     * @param describeLaunchConfigurationTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLaunchConfigurationTemplatesRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the DescribeLaunchConfigurationTemplates operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeLaunchConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeLaunchConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeLaunchConfigurationTemplatesResponse> describeLaunchConfigurationTemplates(
            Consumer<DescribeLaunchConfigurationTemplatesRequest.Builder> describeLaunchConfigurationTemplatesRequest) {
        return describeLaunchConfigurationTemplates(DescribeLaunchConfigurationTemplatesRequest.builder()
                .applyMutation(describeLaunchConfigurationTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all Launch Configuration Templates, filtered by Launch Configuration Template IDs
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLaunchConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeLaunchConfigurationTemplatesPublisher publisher = client.describeLaunchConfigurationTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeLaunchConfigurationTemplatesPublisher publisher = client.describeLaunchConfigurationTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLaunchConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeLaunchConfigurationTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeLaunchConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeLaunchConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationTemplatesPublisher describeLaunchConfigurationTemplatesPaginator(
            DescribeLaunchConfigurationTemplatesRequest describeLaunchConfigurationTemplatesRequest) {
        return new DescribeLaunchConfigurationTemplatesPublisher(this, describeLaunchConfigurationTemplatesRequest);
    }

    /**
     * <p>
     * Lists all Launch Configuration Templates, filtered by Launch Configuration Template IDs
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeLaunchConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeLaunchConfigurationTemplatesPublisher publisher = client.describeLaunchConfigurationTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeLaunchConfigurationTemplatesPublisher publisher = client.describeLaunchConfigurationTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeLaunchConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeLaunchConfigurationTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeLaunchConfigurationTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeLaunchConfigurationTemplatesRequest#builder()}
     * </p>
     *
     * @param describeLaunchConfigurationTemplatesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeLaunchConfigurationTemplatesRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeLaunchConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeLaunchConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeLaunchConfigurationTemplatesPublisher describeLaunchConfigurationTemplatesPaginator(
            Consumer<DescribeLaunchConfigurationTemplatesRequest.Builder> describeLaunchConfigurationTemplatesRequest) {
        return describeLaunchConfigurationTemplatesPaginator(DescribeLaunchConfigurationTemplatesRequest.builder()
                .applyMutation(describeLaunchConfigurationTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
     * </p>
     *
     * @param describeReplicationConfigurationTemplatesRequest
     * @return A Java Future containing the result of the DescribeReplicationConfigurationTemplates operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeReplicationConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeReplicationConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationConfigurationTemplatesResponse> describeReplicationConfigurationTemplates(
            DescribeReplicationConfigurationTemplatesRequest describeReplicationConfigurationTemplatesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationConfigurationTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationConfigurationTemplatesRequest#builder()}
     * </p>
     *
     * @param describeReplicationConfigurationTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeReplicationConfigurationTemplatesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the DescribeReplicationConfigurationTemplates operation returned
     *         by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeReplicationConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeReplicationConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<DescribeReplicationConfigurationTemplatesResponse> describeReplicationConfigurationTemplates(
            Consumer<DescribeReplicationConfigurationTemplatesRequest.Builder> describeReplicationConfigurationTemplatesRequest) {
        return describeReplicationConfigurationTemplates(DescribeReplicationConfigurationTemplatesRequest.builder()
                .applyMutation(describeReplicationConfigurationTemplatesRequest).build());
    }

    /**
     * <p>
     * Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeReplicationConfigurationTemplatesPublisher publisher = client.describeReplicationConfigurationTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeReplicationConfigurationTemplatesPublisher publisher = client.describeReplicationConfigurationTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeReplicationConfigurationTemplatesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeReplicationConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeReplicationConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigurationTemplatesPublisher describeReplicationConfigurationTemplatesPaginator(
            DescribeReplicationConfigurationTemplatesRequest describeReplicationConfigurationTemplatesRequest) {
        return new DescribeReplicationConfigurationTemplatesPublisher(this, describeReplicationConfigurationTemplatesRequest);
    }

    /**
     * <p>
     * Lists all ReplicationConfigurationTemplates, filtered by Source Server IDs.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeReplicationConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeReplicationConfigurationTemplatesPublisher publisher = client.describeReplicationConfigurationTemplatesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeReplicationConfigurationTemplatesPublisher publisher = client.describeReplicationConfigurationTemplatesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeReplicationConfigurationTemplates(software.amazon.awssdk.services.mgn.model.DescribeReplicationConfigurationTemplatesRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeReplicationConfigurationTemplatesRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeReplicationConfigurationTemplatesRequest#builder()}
     * </p>
     *
     * @param describeReplicationConfigurationTemplatesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link DescribeReplicationConfigurationTemplatesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeReplicationConfigurationTemplates
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeReplicationConfigurationTemplates"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeReplicationConfigurationTemplatesPublisher describeReplicationConfigurationTemplatesPaginator(
            Consumer<DescribeReplicationConfigurationTemplatesRequest.Builder> describeReplicationConfigurationTemplatesRequest) {
        return describeReplicationConfigurationTemplatesPaginator(DescribeReplicationConfigurationTemplatesRequest.builder()
                .applyMutation(describeReplicationConfigurationTemplatesRequest).build());
    }

    /**
     * <p>
     * Retrieves all SourceServers or multiple SourceServers by ID.
     * </p>
     *
     * @param describeSourceServersRequest
     * @return A Java Future containing the result of the DescribeSourceServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeSourceServers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSourceServersResponse> describeSourceServers(
            DescribeSourceServersRequest describeSourceServersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all SourceServers or multiple SourceServers by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSourceServersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSourceServersRequest#builder()}
     * </p>
     *
     * @param describeSourceServersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSourceServersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeSourceServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeSourceServers" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DescribeSourceServersResponse> describeSourceServers(
            Consumer<DescribeSourceServersRequest.Builder> describeSourceServersRequest) {
        return describeSourceServers(DescribeSourceServersRequest.builder().applyMutation(describeSourceServersRequest).build());
    }

    /**
     * <p>
     * Retrieves all SourceServers or multiple SourceServers by ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSourceServers(software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeSourceServersPublisher publisher = client.describeSourceServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeSourceServersPublisher publisher = client.describeSourceServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSourceServers(software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeSourceServersRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeSourceServers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSourceServersPublisher describeSourceServersPaginator(
            DescribeSourceServersRequest describeSourceServersRequest) {
        return new DescribeSourceServersPublisher(this, describeSourceServersRequest);
    }

    /**
     * <p>
     * Retrieves all SourceServers or multiple SourceServers by ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeSourceServers(software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeSourceServersPublisher publisher = client.describeSourceServersPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeSourceServersPublisher publisher = client.describeSourceServersPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeSourceServersResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeSourceServers(software.amazon.awssdk.services.mgn.model.DescribeSourceServersRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSourceServersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeSourceServersRequest#builder()}
     * </p>
     *
     * @param describeSourceServersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSourceServersRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeSourceServers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeSourceServersPublisher describeSourceServersPaginator(
            Consumer<DescribeSourceServersRequest.Builder> describeSourceServersRequest) {
        return describeSourceServersPaginator(DescribeSourceServersRequest.builder().applyMutation(describeSourceServersRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the installed vCenter clients.
     * </p>
     *
     * @param describeVcenterClientsRequest
     * @return A Java Future containing the result of the DescribeVcenterClients operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeVcenterClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeVcenterClients" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeVcenterClientsResponse> describeVcenterClients(
            DescribeVcenterClientsRequest describeVcenterClientsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Returns a list of the installed vCenter clients.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVcenterClientsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeVcenterClientsRequest#builder()}
     * </p>
     *
     * @param describeVcenterClientsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeVcenterClientsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DescribeVcenterClients operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeVcenterClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeVcenterClients" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DescribeVcenterClientsResponse> describeVcenterClients(
            Consumer<DescribeVcenterClientsRequest.Builder> describeVcenterClientsRequest) {
        return describeVcenterClients(DescribeVcenterClientsRequest.builder().applyMutation(describeVcenterClientsRequest)
                .build());
    }

    /**
     * <p>
     * Returns a list of the installed vCenter clients.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeVcenterClients(software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeVcenterClientsPublisher publisher = client.describeVcenterClientsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeVcenterClientsPublisher publisher = client.describeVcenterClientsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeVcenterClients(software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeVcenterClientsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeVcenterClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeVcenterClients" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeVcenterClientsPublisher describeVcenterClientsPaginator(
            DescribeVcenterClientsRequest describeVcenterClientsRequest) {
        return new DescribeVcenterClientsPublisher(this, describeVcenterClientsRequest);
    }

    /**
     * <p>
     * Returns a list of the installed vCenter clients.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeVcenterClients(software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeVcenterClientsPublisher publisher = client.describeVcenterClientsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.DescribeVcenterClientsPublisher publisher = client.describeVcenterClientsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeVcenterClients(software.amazon.awssdk.services.mgn.model.DescribeVcenterClientsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeVcenterClientsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeVcenterClientsRequest#builder()}
     * </p>
     *
     * @param describeVcenterClientsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeVcenterClientsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DescribeVcenterClients
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DescribeVcenterClients" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeVcenterClientsPublisher describeVcenterClientsPaginator(
            Consumer<DescribeVcenterClientsRequest.Builder> describeVcenterClientsRequest) {
        return describeVcenterClientsPaginator(DescribeVcenterClientsRequest.builder()
                .applyMutation(describeVcenterClientsRequest).build());
    }

    /**
     * <p>
     * Disassociate applications from wave.
     * </p>
     *
     * @param disassociateApplicationsRequest
     * @return A Java Future containing the result of the DisassociateApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DisassociateApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DisassociateApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateApplicationsResponse> disassociateApplications(
            DisassociateApplicationsRequest disassociateApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociate applications from wave.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateApplicationsRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateApplicationsRequest#builder()}
     * </p>
     *
     * @param disassociateApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateApplicationsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DisassociateApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DisassociateApplications" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateApplicationsResponse> disassociateApplications(
            Consumer<DisassociateApplicationsRequest.Builder> disassociateApplicationsRequest) {
        return disassociateApplications(DisassociateApplicationsRequest.builder().applyMutation(disassociateApplicationsRequest)
                .build());
    }

    /**
     * <p>
     * Disassociate source servers from application.
     * </p>
     *
     * @param disassociateSourceServersRequest
     * @return A Java Future containing the result of the DisassociateSourceServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DisassociateSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DisassociateSourceServers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateSourceServersResponse> disassociateSourceServers(
            DisassociateSourceServersRequest disassociateSourceServersRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociate source servers from application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateSourceServersRequest.Builder} avoiding
     * the need to create one manually via {@link DisassociateSourceServersRequest#builder()}
     * </p>
     *
     * @param disassociateSourceServersRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateSourceServersRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisassociateSourceServers operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DisassociateSourceServers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DisassociateSourceServers" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<DisassociateSourceServersResponse> disassociateSourceServers(
            Consumer<DisassociateSourceServersRequest.Builder> disassociateSourceServersRequest) {
        return disassociateSourceServers(DisassociateSourceServersRequest.builder()
                .applyMutation(disassociateSourceServersRequest).build());
    }

    /**
     * <p>
     * Disconnects specific Source Servers from Application Migration Service. Data replication is stopped immediately.
     * All AWS resources created by Application Migration Service for enabling the replication of these source servers
     * will be terminated / deleted within 90 minutes. Launched Test or Cutover instances will NOT be terminated. If the
     * agent on the source server has not been prevented from communicating with the Application Migration Service
     * service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following
     * properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be set
     * to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to
     * zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.
     * </p>
     *
     * @param disconnectFromServiceRequest
     * @return A Java Future containing the result of the DisconnectFromService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DisconnectFromService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DisconnectFromService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisconnectFromServiceResponse> disconnectFromService(
            DisconnectFromServiceRequest disconnectFromServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disconnects specific Source Servers from Application Migration Service. Data replication is stopped immediately.
     * All AWS resources created by Application Migration Service for enabling the replication of these source servers
     * will be terminated / deleted within 90 minutes. Launched Test or Cutover instances will NOT be terminated. If the
     * agent on the source server has not been prevented from communicating with the Application Migration Service
     * service, then it will receive a command to uninstall itself (within approximately 10 minutes). The following
     * properties of the SourceServer will be changed immediately: dataReplicationInfo.dataReplicationState will be set
     * to DISCONNECTED; The totalStorageBytes property for each of dataReplicationInfo.replicatedDisks will be set to
     * zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisconnectFromServiceRequest.Builder} avoiding the
     * need to create one manually via {@link DisconnectFromServiceRequest#builder()}
     * </p>
     *
     * @param disconnectFromServiceRequest
     *        A {@link Consumer} that will call methods on {@link DisconnectFromServiceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the DisconnectFromService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.DisconnectFromService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/DisconnectFromService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<DisconnectFromServiceResponse> disconnectFromService(
            Consumer<DisconnectFromServiceRequest.Builder> disconnectFromServiceRequest) {
        return disconnectFromService(DisconnectFromServiceRequest.builder().applyMutation(disconnectFromServiceRequest).build());
    }

    /**
     * <p>
     * Finalizes the cutover immediately for specific Source Servers. All AWS resources created by Application Migration
     * Service for enabling the replication of these source servers will be terminated / deleted within 90 minutes.
     * Launched Test or Cutover instances will NOT be terminated. The AWS Replication Agent will receive a command to
     * uninstall itself (within 10 minutes). The following properties of the SourceServer will be changed immediately:
     * dataReplicationInfo.dataReplicationState will be changed to DISCONNECTED; The SourceServer.lifeCycle.state will
     * be changed to CUTOVER; The totalStorageBytes property fo each of dataReplicationInfo.replicatedDisks will be set
     * to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.
     * </p>
     *
     * @param finalizeCutoverRequest
     * @return A Java Future containing the result of the FinalizeCutover operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.FinalizeCutover
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/FinalizeCutover" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<FinalizeCutoverResponse> finalizeCutover(FinalizeCutoverRequest finalizeCutoverRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Finalizes the cutover immediately for specific Source Servers. All AWS resources created by Application Migration
     * Service for enabling the replication of these source servers will be terminated / deleted within 90 minutes.
     * Launched Test or Cutover instances will NOT be terminated. The AWS Replication Agent will receive a command to
     * uninstall itself (within 10 minutes). The following properties of the SourceServer will be changed immediately:
     * dataReplicationInfo.dataReplicationState will be changed to DISCONNECTED; The SourceServer.lifeCycle.state will
     * be changed to CUTOVER; The totalStorageBytes property fo each of dataReplicationInfo.replicatedDisks will be set
     * to zero; dataReplicationInfo.lagDuration and dataReplicationInfo.lagDuration will be nullified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FinalizeCutoverRequest.Builder} avoiding the need
     * to create one manually via {@link FinalizeCutoverRequest#builder()}
     * </p>
     *
     * @param finalizeCutoverRequest
     *        A {@link Consumer} that will call methods on {@link FinalizeCutoverRequest.Builder} to create a request.
     * @return A Java Future containing the result of the FinalizeCutover operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.FinalizeCutover
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/FinalizeCutover" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<FinalizeCutoverResponse> finalizeCutover(
            Consumer<FinalizeCutoverRequest.Builder> finalizeCutoverRequest) {
        return finalizeCutover(FinalizeCutoverRequest.builder().applyMutation(finalizeCutoverRequest).build());
    }

    /**
     * <p>
     * Lists all LaunchConfigurations available, filtered by Source Server IDs.
     * </p>
     *
     * @param getLaunchConfigurationRequest
     * @return A Java Future containing the result of the GetLaunchConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.GetLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/GetLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLaunchConfigurationResponse> getLaunchConfiguration(
            GetLaunchConfigurationRequest getLaunchConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all LaunchConfigurations available, filtered by Source Server IDs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetLaunchConfigurationRequest.Builder} avoiding the
     * need to create one manually via {@link GetLaunchConfigurationRequest#builder()}
     * </p>
     *
     * @param getLaunchConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetLaunchConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the GetLaunchConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.GetLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/GetLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<GetLaunchConfigurationResponse> getLaunchConfiguration(
            Consumer<GetLaunchConfigurationRequest.Builder> getLaunchConfigurationRequest) {
        return getLaunchConfiguration(GetLaunchConfigurationRequest.builder().applyMutation(getLaunchConfigurationRequest)
                .build());
    }

    /**
     * <p>
     * Lists all ReplicationConfigurations, filtered by Source Server ID.
     * </p>
     *
     * @param getReplicationConfigurationRequest
     * @return A Java Future containing the result of the GetReplicationConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.GetReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/GetReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReplicationConfigurationResponse> getReplicationConfiguration(
            GetReplicationConfigurationRequest getReplicationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all ReplicationConfigurations, filtered by Source Server ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetReplicationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link GetReplicationConfigurationRequest#builder()}
     * </p>
     *
     * @param getReplicationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link GetReplicationConfigurationRequest.Builder} to create
     *        a request.
     * @return A Java Future containing the result of the GetReplicationConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.GetReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/GetReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetReplicationConfigurationResponse> getReplicationConfiguration(
            Consumer<GetReplicationConfigurationRequest.Builder> getReplicationConfigurationRequest) {
        return getReplicationConfiguration(GetReplicationConfigurationRequest.builder()
                .applyMutation(getReplicationConfigurationRequest).build());
    }

    /**
     * <p>
     * Initialize Application Migration Service.
     * </p>
     *
     * @param initializeServiceRequest
     * @return A Java Future containing the result of the InitializeService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.InitializeService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/InitializeService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InitializeServiceResponse> initializeService(InitializeServiceRequest initializeServiceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initialize Application Migration Service.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link InitializeServiceRequest.Builder} avoiding the need
     * to create one manually via {@link InitializeServiceRequest#builder()}
     * </p>
     *
     * @param initializeServiceRequest
     *        A {@link Consumer} that will call methods on {@link InitializeServiceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the InitializeService operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.InitializeService
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/InitializeService" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<InitializeServiceResponse> initializeService(
            Consumer<InitializeServiceRequest.Builder> initializeServiceRequest) {
        return initializeService(InitializeServiceRequest.builder().applyMutation(initializeServiceRequest).build());
    }

    /**
     * <p>
     * Retrieves all applications or multiple applications by ID.
     * </p>
     *
     * @param listApplicationsRequest
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(ListApplicationsRequest listApplicationsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all applications or multiple applications by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationsRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListApplications operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListApplicationsResponse> listApplications(
            Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplications(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * Retrieves all applications or multiple applications by ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listApplications(software.amazon.awssdk.services.mgn.model.ListApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.mgn.model.ListApplicationsRequest)} operation.</b>
     * </p>
     *
     * @param listApplicationsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(ListApplicationsRequest listApplicationsRequest) {
        return new ListApplicationsPublisher(this, listApplicationsRequest);
    }

    /**
     * <p>
     * Retrieves all applications or multiple applications by ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listApplications(software.amazon.awssdk.services.mgn.model.ListApplicationsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListApplicationsPublisher publisher = client.listApplicationsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.ListApplicationsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.ListApplicationsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApplications(software.amazon.awssdk.services.mgn.model.ListApplicationsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApplicationsRequest.Builder} avoiding the need
     * to create one manually via {@link ListApplicationsRequest#builder()}
     * </p>
     *
     * @param listApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListApplicationsRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListApplications" target="_top">AWS API
     *      Documentation</a>
     */
    default ListApplicationsPublisher listApplicationsPaginator(Consumer<ListApplicationsRequest.Builder> listApplicationsRequest) {
        return listApplicationsPaginator(ListApplicationsRequest.builder().applyMutation(listApplicationsRequest).build());
    }

    /**
     * <p>
     * List export errors.
     * </p>
     *
     * @param listExportErrorsRequest
     *        List export errors request.
     * @return A Java Future containing the result of the ListExportErrors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListExportErrors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListExportErrors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExportErrorsResponse> listExportErrors(ListExportErrorsRequest listExportErrorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List export errors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportErrorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListExportErrorsRequest#builder()}
     * </p>
     *
     * @param listExportErrorsRequest
     *        A {@link Consumer} that will call methods on {@link ListExportErrorsRequest.Builder} to create a request.
     *        List export errors request.
     * @return A Java Future containing the result of the ListExportErrors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListExportErrors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListExportErrors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExportErrorsResponse> listExportErrors(
            Consumer<ListExportErrorsRequest.Builder> listExportErrorsRequest) {
        return listExportErrors(ListExportErrorsRequest.builder().applyMutation(listExportErrorsRequest).build());
    }

    /**
     * <p>
     * List export errors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listExportErrors(software.amazon.awssdk.services.mgn.model.ListExportErrorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListExportErrorsPublisher publisher = client.listExportErrorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListExportErrorsPublisher publisher = client.listExportErrorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.ListExportErrorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.ListExportErrorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExportErrors(software.amazon.awssdk.services.mgn.model.ListExportErrorsRequest)} operation.</b>
     * </p>
     *
     * @param listExportErrorsRequest
     *        List export errors request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListExportErrors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListExportErrors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportErrorsPublisher listExportErrorsPaginator(ListExportErrorsRequest listExportErrorsRequest) {
        return new ListExportErrorsPublisher(this, listExportErrorsRequest);
    }

    /**
     * <p>
     * List export errors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listExportErrors(software.amazon.awssdk.services.mgn.model.ListExportErrorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListExportErrorsPublisher publisher = client.listExportErrorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListExportErrorsPublisher publisher = client.listExportErrorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.ListExportErrorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.ListExportErrorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExportErrors(software.amazon.awssdk.services.mgn.model.ListExportErrorsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportErrorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListExportErrorsRequest#builder()}
     * </p>
     *
     * @param listExportErrorsRequest
     *        A {@link Consumer} that will call methods on {@link ListExportErrorsRequest.Builder} to create a request.
     *        List export errors request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListExportErrors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListExportErrors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportErrorsPublisher listExportErrorsPaginator(Consumer<ListExportErrorsRequest.Builder> listExportErrorsRequest) {
        return listExportErrorsPaginator(ListExportErrorsRequest.builder().applyMutation(listExportErrorsRequest).build());
    }

    /**
     * <p>
     * List exports.
     * </p>
     *
     * @param listExportsRequest
     *        List export request.
     * @return A Java Future containing the result of the ListExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExportsResponse> listExports(ListExportsRequest listExportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List exports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportsRequest#builder()}
     * </p>
     *
     * @param listExportsRequest
     *        A {@link Consumer} that will call methods on {@link ListExportsRequest.Builder} to create a request. List
     *        export request.
     * @return A Java Future containing the result of the ListExports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListExportsResponse> listExports(Consumer<ListExportsRequest.Builder> listExportsRequest) {
        return listExports(ListExportsRequest.builder().applyMutation(listExportsRequest).build());
    }

    /**
     * <p>
     * List exports.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listExports(software.amazon.awssdk.services.mgn.model.ListExportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.ListExportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.ListExportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.mgn.model.ListExportsRequest)} operation.</b>
     * </p>
     *
     * @param listExportsRequest
     *        List export request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportsPublisher listExportsPaginator(ListExportsRequest listExportsRequest) {
        return new ListExportsPublisher(this, listExportsRequest);
    }

    /**
     * <p>
     * List exports.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listExports(software.amazon.awssdk.services.mgn.model.ListExportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListExportsPublisher publisher = client.listExportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.ListExportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.ListExportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listExports(software.amazon.awssdk.services.mgn.model.ListExportsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListExportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListExportsRequest#builder()}
     * </p>
     *
     * @param listExportsRequest
     *        A {@link Consumer} that will call methods on {@link ListExportsRequest.Builder} to create a request. List
     *        export request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListExports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListExports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListExportsPublisher listExportsPaginator(Consumer<ListExportsRequest.Builder> listExportsRequest) {
        return listExportsPaginator(ListExportsRequest.builder().applyMutation(listExportsRequest).build());
    }

    /**
     * <p>
     * List import errors.
     * </p>
     *
     * @param listImportErrorsRequest
     *        List import errors request.
     * @return A Java Future containing the result of the ListImportErrors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListImportErrors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListImportErrors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportErrorsResponse> listImportErrors(ListImportErrorsRequest listImportErrorsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List import errors.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportErrorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListImportErrorsRequest#builder()}
     * </p>
     *
     * @param listImportErrorsRequest
     *        A {@link Consumer} that will call methods on {@link ListImportErrorsRequest.Builder} to create a request.
     *        List import errors request.
     * @return A Java Future containing the result of the ListImportErrors operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListImportErrors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListImportErrors" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportErrorsResponse> listImportErrors(
            Consumer<ListImportErrorsRequest.Builder> listImportErrorsRequest) {
        return listImportErrors(ListImportErrorsRequest.builder().applyMutation(listImportErrorsRequest).build());
    }

    /**
     * <p>
     * List import errors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImportErrors(software.amazon.awssdk.services.mgn.model.ListImportErrorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListImportErrorsPublisher publisher = client.listImportErrorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListImportErrorsPublisher publisher = client.listImportErrorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.ListImportErrorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.ListImportErrorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportErrors(software.amazon.awssdk.services.mgn.model.ListImportErrorsRequest)} operation.</b>
     * </p>
     *
     * @param listImportErrorsRequest
     *        List import errors request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListImportErrors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListImportErrors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportErrorsPublisher listImportErrorsPaginator(ListImportErrorsRequest listImportErrorsRequest) {
        return new ListImportErrorsPublisher(this, listImportErrorsRequest);
    }

    /**
     * <p>
     * List import errors.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImportErrors(software.amazon.awssdk.services.mgn.model.ListImportErrorsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListImportErrorsPublisher publisher = client.listImportErrorsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListImportErrorsPublisher publisher = client.listImportErrorsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.ListImportErrorsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.ListImportErrorsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImportErrors(software.amazon.awssdk.services.mgn.model.ListImportErrorsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportErrorsRequest.Builder} avoiding the need
     * to create one manually via {@link ListImportErrorsRequest#builder()}
     * </p>
     *
     * @param listImportErrorsRequest
     *        A {@link Consumer} that will call methods on {@link ListImportErrorsRequest.Builder} to create a request.
     *        List import errors request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListImportErrors
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListImportErrors" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportErrorsPublisher listImportErrorsPaginator(Consumer<ListImportErrorsRequest.Builder> listImportErrorsRequest) {
        return listImportErrorsPaginator(ListImportErrorsRequest.builder().applyMutation(listImportErrorsRequest).build());
    }

    /**
     * <p>
     * List imports.
     * </p>
     *
     * @param listImportsRequest
     *        List imports request.
     * @return A Java Future containing the result of the ListImports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportsResponse> listImports(ListImportsRequest listImportsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List imports.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on {@link ListImportsRequest.Builder} to create a request. List
     *        imports request.
     * @return A Java Future containing the result of the ListImports operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListImportsResponse> listImports(Consumer<ListImportsRequest.Builder> listImportsRequest) {
        return listImports(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * List imports.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImports(software.amazon.awssdk.services.mgn.model.ListImportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.ListImportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.ListImportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.mgn.model.ListImportsRequest)} operation.</b>
     * </p>
     *
     * @param listImportsRequest
     *        List imports request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsPublisher listImportsPaginator(ListImportsRequest listImportsRequest) {
        return new ListImportsPublisher(this, listImportsRequest);
    }

    /**
     * <p>
     * List imports.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listImports(software.amazon.awssdk.services.mgn.model.ListImportsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListImportsPublisher publisher = client.listImportsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.ListImportsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.ListImportsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listImports(software.amazon.awssdk.services.mgn.model.ListImportsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListImportsRequest.Builder} avoiding the need to
     * create one manually via {@link ListImportsRequest#builder()}
     * </p>
     *
     * @param listImportsRequest
     *        A {@link Consumer} that will call methods on {@link ListImportsRequest.Builder} to create a request. List
     *        imports request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListImports
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListImports" target="_top">AWS API
     *      Documentation</a>
     */
    default ListImportsPublisher listImportsPaginator(Consumer<ListImportsRequest.Builder> listImportsRequest) {
        return listImportsPaginator(ListImportsRequest.builder().applyMutation(listImportsRequest).build());
    }

    /**
     * <p>
     * List Managed Accounts.
     * </p>
     *
     * @param listManagedAccountsRequest
     *        List managed accounts request.
     * @return A Java Future containing the result of the ListManagedAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListManagedAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListManagedAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListManagedAccountsResponse> listManagedAccounts(
            ListManagedAccountsRequest listManagedAccountsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List Managed Accounts.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link ListManagedAccountsRequest#builder()}
     * </p>
     *
     * @param listManagedAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListManagedAccountsRequest.Builder} to create a
     *        request. List managed accounts request.
     * @return A Java Future containing the result of the ListManagedAccounts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListManagedAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListManagedAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListManagedAccountsResponse> listManagedAccounts(
            Consumer<ListManagedAccountsRequest.Builder> listManagedAccountsRequest) {
        return listManagedAccounts(ListManagedAccountsRequest.builder().applyMutation(listManagedAccountsRequest).build());
    }

    /**
     * <p>
     * List Managed Accounts.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listManagedAccounts(software.amazon.awssdk.services.mgn.model.ListManagedAccountsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListManagedAccountsPublisher publisher = client.listManagedAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListManagedAccountsPublisher publisher = client.listManagedAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.ListManagedAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.ListManagedAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedAccounts(software.amazon.awssdk.services.mgn.model.ListManagedAccountsRequest)} operation.</b>
     * </p>
     *
     * @param listManagedAccountsRequest
     *        List managed accounts request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListManagedAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListManagedAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListManagedAccountsPublisher listManagedAccountsPaginator(ListManagedAccountsRequest listManagedAccountsRequest) {
        return new ListManagedAccountsPublisher(this, listManagedAccountsRequest);
    }

    /**
     * <p>
     * List Managed Accounts.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listManagedAccounts(software.amazon.awssdk.services.mgn.model.ListManagedAccountsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListManagedAccountsPublisher publisher = client.listManagedAccountsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListManagedAccountsPublisher publisher = client.listManagedAccountsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.ListManagedAccountsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.ListManagedAccountsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listManagedAccounts(software.amazon.awssdk.services.mgn.model.ListManagedAccountsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListManagedAccountsRequest.Builder} avoiding the
     * need to create one manually via {@link ListManagedAccountsRequest#builder()}
     * </p>
     *
     * @param listManagedAccountsRequest
     *        A {@link Consumer} that will call methods on {@link ListManagedAccountsRequest.Builder} to create a
     *        request. List managed accounts request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListManagedAccounts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListManagedAccounts" target="_top">AWS API
     *      Documentation</a>
     */
    default ListManagedAccountsPublisher listManagedAccountsPaginator(
            Consumer<ListManagedAccountsRequest.Builder> listManagedAccountsRequest) {
        return listManagedAccountsPaginator(ListManagedAccountsRequest.builder().applyMutation(listManagedAccountsRequest)
                .build());
    }

    /**
     * <p>
     * List source server post migration custom actions.
     * </p>
     *
     * @param listSourceServerActionsRequest
     * @return A Java Future containing the result of the ListSourceServerActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListSourceServerActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListSourceServerActions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSourceServerActionsResponse> listSourceServerActions(
            ListSourceServerActionsRequest listSourceServerActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List source server post migration custom actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSourceServerActionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSourceServerActionsRequest#builder()}
     * </p>
     *
     * @param listSourceServerActionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSourceServerActionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListSourceServerActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListSourceServerActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListSourceServerActions" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<ListSourceServerActionsResponse> listSourceServerActions(
            Consumer<ListSourceServerActionsRequest.Builder> listSourceServerActionsRequest) {
        return listSourceServerActions(ListSourceServerActionsRequest.builder().applyMutation(listSourceServerActionsRequest)
                .build());
    }

    /**
     * <p>
     * List source server post migration custom actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSourceServerActions(software.amazon.awssdk.services.mgn.model.ListSourceServerActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListSourceServerActionsPublisher publisher = client.listSourceServerActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListSourceServerActionsPublisher publisher = client.listSourceServerActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.ListSourceServerActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.ListSourceServerActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSourceServerActions(software.amazon.awssdk.services.mgn.model.ListSourceServerActionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSourceServerActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListSourceServerActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListSourceServerActions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSourceServerActionsPublisher listSourceServerActionsPaginator(
            ListSourceServerActionsRequest listSourceServerActionsRequest) {
        return new ListSourceServerActionsPublisher(this, listSourceServerActionsRequest);
    }

    /**
     * <p>
     * List source server post migration custom actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listSourceServerActions(software.amazon.awssdk.services.mgn.model.ListSourceServerActionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListSourceServerActionsPublisher publisher = client.listSourceServerActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListSourceServerActionsPublisher publisher = client.listSourceServerActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.ListSourceServerActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.ListSourceServerActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSourceServerActions(software.amazon.awssdk.services.mgn.model.ListSourceServerActionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSourceServerActionsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSourceServerActionsRequest#builder()}
     * </p>
     *
     * @param listSourceServerActionsRequest
     *        A {@link Consumer} that will call methods on {@link ListSourceServerActionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListSourceServerActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListSourceServerActions" target="_top">AWS
     *      API Documentation</a>
     */
    default ListSourceServerActionsPublisher listSourceServerActionsPaginator(
            Consumer<ListSourceServerActionsRequest.Builder> listSourceServerActionsRequest) {
        return listSourceServerActionsPaginator(ListSourceServerActionsRequest.builder()
                .applyMutation(listSourceServerActionsRequest).build());
    }

    /**
     * <p>
     * List all tags for your Application Migration Service resources.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ThrottlingException Reached throttling quota exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>InternalServerException The server encountered an unexpected condition that prevented it from
     *         fulfilling the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            ListTagsForResourceRequest listTagsForResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List all tags for your Application Migration Service resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTagsForResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ThrottlingException Reached throttling quota exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>InternalServerException The server encountered an unexpected condition that prevented it from
     *         fulfilling the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListTagsForResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTagsForResourceResponse> listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * List template post migration custom actions.
     * </p>
     *
     * @param listTemplateActionsRequest
     * @return A Java Future containing the result of the ListTemplateActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListTemplateActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListTemplateActions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTemplateActionsResponse> listTemplateActions(
            ListTemplateActionsRequest listTemplateActionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List template post migration custom actions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplateActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTemplateActionsRequest#builder()}
     * </p>
     *
     * @param listTemplateActionsRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplateActionsRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the ListTemplateActions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListTemplateActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListTemplateActions" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListTemplateActionsResponse> listTemplateActions(
            Consumer<ListTemplateActionsRequest.Builder> listTemplateActionsRequest) {
        return listTemplateActions(ListTemplateActionsRequest.builder().applyMutation(listTemplateActionsRequest).build());
    }

    /**
     * <p>
     * List template post migration custom actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateActions(software.amazon.awssdk.services.mgn.model.ListTemplateActionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListTemplateActionsPublisher publisher = client.listTemplateActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListTemplateActionsPublisher publisher = client.listTemplateActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.ListTemplateActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.ListTemplateActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateActions(software.amazon.awssdk.services.mgn.model.ListTemplateActionsRequest)} operation.</b>
     * </p>
     *
     * @param listTemplateActionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListTemplateActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListTemplateActions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTemplateActionsPublisher listTemplateActionsPaginator(ListTemplateActionsRequest listTemplateActionsRequest) {
        return new ListTemplateActionsPublisher(this, listTemplateActionsRequest);
    }

    /**
     * <p>
     * List template post migration custom actions.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #listTemplateActions(software.amazon.awssdk.services.mgn.model.ListTemplateActionsRequest)} operation. The
     * return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListTemplateActionsPublisher publisher = client.listTemplateActionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListTemplateActionsPublisher publisher = client.listTemplateActionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.ListTemplateActionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.ListTemplateActionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTemplateActions(software.amazon.awssdk.services.mgn.model.ListTemplateActionsRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTemplateActionsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTemplateActionsRequest#builder()}
     * </p>
     *
     * @param listTemplateActionsRequest
     *        A {@link Consumer} that will call methods on {@link ListTemplateActionsRequest.Builder} to create a
     *        request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListTemplateActions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListTemplateActions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTemplateActionsPublisher listTemplateActionsPaginator(
            Consumer<ListTemplateActionsRequest.Builder> listTemplateActionsRequest) {
        return listTemplateActionsPaginator(ListTemplateActionsRequest.builder().applyMutation(listTemplateActionsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves all waves or multiple waves by ID.
     * </p>
     *
     * @param listWavesRequest
     * @return A Java Future containing the result of the ListWaves operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListWaves
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListWaves" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWavesResponse> listWaves(ListWavesRequest listWavesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves all waves or multiple waves by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWavesRequest.Builder} avoiding the need to
     * create one manually via {@link ListWavesRequest#builder()}
     * </p>
     *
     * @param listWavesRequest
     *        A {@link Consumer} that will call methods on {@link ListWavesRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ListWaves operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListWaves
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListWaves" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ListWavesResponse> listWaves(Consumer<ListWavesRequest.Builder> listWavesRequest) {
        return listWaves(ListWavesRequest.builder().applyMutation(listWavesRequest).build());
    }

    /**
     * <p>
     * Retrieves all waves or multiple waves by ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWaves(software.amazon.awssdk.services.mgn.model.ListWavesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListWavesPublisher publisher = client.listWavesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListWavesPublisher publisher = client.listWavesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.ListWavesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.ListWavesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWaves(software.amazon.awssdk.services.mgn.model.ListWavesRequest)} operation.</b>
     * </p>
     *
     * @param listWavesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListWaves
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListWaves" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWavesPublisher listWavesPaginator(ListWavesRequest listWavesRequest) {
        return new ListWavesPublisher(this, listWavesRequest);
    }

    /**
     * <p>
     * Retrieves all waves or multiple waves by ID.
     * </p>
     * <br/>
     * <p>
     * This is a variant of {@link #listWaves(software.amazon.awssdk.services.mgn.model.ListWavesRequest)} operation.
     * The return type is a custom publisher that can be subscribed to request a stream of response pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListWavesPublisher publisher = client.listWavesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.mgn.paginators.ListWavesPublisher publisher = client.listWavesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.mgn.model.ListWavesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.mgn.model.ListWavesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listWaves(software.amazon.awssdk.services.mgn.model.ListWavesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link ListWavesRequest.Builder} avoiding the need to
     * create one manually via {@link ListWavesRequest#builder()}
     * </p>
     *
     * @param listWavesRequest
     *        A {@link Consumer} that will call methods on {@link ListWavesRequest.Builder} to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ListWaves
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ListWaves" target="_top">AWS API
     *      Documentation</a>
     */
    default ListWavesPublisher listWavesPaginator(Consumer<ListWavesRequest.Builder> listWavesRequest) {
        return listWavesPaginator(ListWavesRequest.builder().applyMutation(listWavesRequest).build());
    }

    /**
     * <p>
     * Archives specific Source Servers by setting the SourceServer.isArchived property to true for specified
     * SourceServers by ID. This command only works for SourceServers with a lifecycle. state which equals DISCONNECTED
     * or CUTOVER.
     * </p>
     *
     * @param markAsArchivedRequest
     * @return A Java Future containing the result of the MarkAsArchived operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.MarkAsArchived
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/MarkAsArchived" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<MarkAsArchivedResponse> markAsArchived(MarkAsArchivedRequest markAsArchivedRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Archives specific Source Servers by setting the SourceServer.isArchived property to true for specified
     * SourceServers by ID. This command only works for SourceServers with a lifecycle. state which equals DISCONNECTED
     * or CUTOVER.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link MarkAsArchivedRequest.Builder} avoiding the need to
     * create one manually via {@link MarkAsArchivedRequest#builder()}
     * </p>
     *
     * @param markAsArchivedRequest
     *        A {@link Consumer} that will call methods on {@link MarkAsArchivedRequest.Builder} to create a request.
     * @return A Java Future containing the result of the MarkAsArchived operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.MarkAsArchived
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/MarkAsArchived" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<MarkAsArchivedResponse> markAsArchived(Consumer<MarkAsArchivedRequest.Builder> markAsArchivedRequest) {
        return markAsArchived(MarkAsArchivedRequest.builder().applyMutation(markAsArchivedRequest).build());
    }

    /**
     * <p>
     * Pause Replication.
     * </p>
     *
     * @param pauseReplicationRequest
     * @return A Java Future containing the result of the PauseReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.PauseReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/PauseReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PauseReplicationResponse> pauseReplication(PauseReplicationRequest pauseReplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Pause Replication.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PauseReplicationRequest.Builder} avoiding the need
     * to create one manually via {@link PauseReplicationRequest#builder()}
     * </p>
     *
     * @param pauseReplicationRequest
     *        A {@link Consumer} that will call methods on {@link PauseReplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PauseReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.PauseReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/PauseReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PauseReplicationResponse> pauseReplication(
            Consumer<PauseReplicationRequest.Builder> pauseReplicationRequest) {
        return pauseReplication(PauseReplicationRequest.builder().applyMutation(pauseReplicationRequest).build());
    }

    /**
     * <p>
     * Put source server post migration custom action.
     * </p>
     *
     * @param putSourceServerActionRequest
     * @return A Java Future containing the result of the PutSourceServerAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.PutSourceServerAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/PutSourceServerAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutSourceServerActionResponse> putSourceServerAction(
            PutSourceServerActionRequest putSourceServerActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Put source server post migration custom action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutSourceServerActionRequest.Builder} avoiding the
     * need to create one manually via {@link PutSourceServerActionRequest#builder()}
     * </p>
     *
     * @param putSourceServerActionRequest
     *        A {@link Consumer} that will call methods on {@link PutSourceServerActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the PutSourceServerAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.PutSourceServerAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/PutSourceServerAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutSourceServerActionResponse> putSourceServerAction(
            Consumer<PutSourceServerActionRequest.Builder> putSourceServerActionRequest) {
        return putSourceServerAction(PutSourceServerActionRequest.builder().applyMutation(putSourceServerActionRequest).build());
    }

    /**
     * <p>
     * Put template post migration custom action.
     * </p>
     *
     * @param putTemplateActionRequest
     * @return A Java Future containing the result of the PutTemplateAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.PutTemplateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/PutTemplateAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutTemplateActionResponse> putTemplateAction(PutTemplateActionRequest putTemplateActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Put template post migration custom action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutTemplateActionRequest.Builder} avoiding the need
     * to create one manually via {@link PutTemplateActionRequest#builder()}
     * </p>
     *
     * @param putTemplateActionRequest
     *        A {@link Consumer} that will call methods on {@link PutTemplateActionRequest.Builder} to create a request.
     * @return A Java Future containing the result of the PutTemplateAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.PutTemplateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/PutTemplateAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<PutTemplateActionResponse> putTemplateAction(
            Consumer<PutTemplateActionRequest.Builder> putTemplateActionRequest) {
        return putTemplateAction(PutTemplateActionRequest.builder().applyMutation(putTemplateActionRequest).build());
    }

    /**
     * <p>
     * Remove source server post migration custom action.
     * </p>
     *
     * @param removeSourceServerActionRequest
     * @return A Java Future containing the result of the RemoveSourceServerAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.RemoveSourceServerAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/RemoveSourceServerAction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RemoveSourceServerActionResponse> removeSourceServerAction(
            RemoveSourceServerActionRequest removeSourceServerActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove source server post migration custom action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveSourceServerActionRequest.Builder} avoiding
     * the need to create one manually via {@link RemoveSourceServerActionRequest#builder()}
     * </p>
     *
     * @param removeSourceServerActionRequest
     *        A {@link Consumer} that will call methods on {@link RemoveSourceServerActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveSourceServerAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.RemoveSourceServerAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/RemoveSourceServerAction" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<RemoveSourceServerActionResponse> removeSourceServerAction(
            Consumer<RemoveSourceServerActionRequest.Builder> removeSourceServerActionRequest) {
        return removeSourceServerAction(RemoveSourceServerActionRequest.builder().applyMutation(removeSourceServerActionRequest)
                .build());
    }

    /**
     * <p>
     * Remove template post migration custom action.
     * </p>
     *
     * @param removeTemplateActionRequest
     * @return A Java Future containing the result of the RemoveTemplateAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.RemoveTemplateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/RemoveTemplateAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveTemplateActionResponse> removeTemplateAction(
            RemoveTemplateActionRequest removeTemplateActionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Remove template post migration custom action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RemoveTemplateActionRequest.Builder} avoiding the
     * need to create one manually via {@link RemoveTemplateActionRequest#builder()}
     * </p>
     *
     * @param removeTemplateActionRequest
     *        A {@link Consumer} that will call methods on {@link RemoveTemplateActionRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RemoveTemplateAction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.RemoveTemplateAction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/RemoveTemplateAction" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RemoveTemplateActionResponse> removeTemplateAction(
            Consumer<RemoveTemplateActionRequest.Builder> removeTemplateActionRequest) {
        return removeTemplateAction(RemoveTemplateActionRequest.builder().applyMutation(removeTemplateActionRequest).build());
    }

    /**
     * <p>
     * Resume Replication.
     * </p>
     *
     * @param resumeReplicationRequest
     * @return A Java Future containing the result of the ResumeReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ResumeReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ResumeReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ResumeReplicationResponse> resumeReplication(ResumeReplicationRequest resumeReplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Resume Replication.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ResumeReplicationRequest.Builder} avoiding the need
     * to create one manually via {@link ResumeReplicationRequest#builder()}
     * </p>
     *
     * @param resumeReplicationRequest
     *        A {@link Consumer} that will call methods on {@link ResumeReplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the ResumeReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.ResumeReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/ResumeReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<ResumeReplicationResponse> resumeReplication(
            Consumer<ResumeReplicationRequest.Builder> resumeReplicationRequest) {
        return resumeReplication(ResumeReplicationRequest.builder().applyMutation(resumeReplicationRequest).build());
    }

    /**
     * <p>
     * Causes the data replication initiation sequence to begin immediately upon next Handshake for specified
     * SourceServer IDs, regardless of when the previous initiation started. This command will not work if the
     * SourceServer is not stalled or is in a DISCONNECTED or STOPPED state.
     * </p>
     *
     * @param retryDataReplicationRequest
     * @return A Java Future containing the result of the RetryDataReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.RetryDataReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/RetryDataReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RetryDataReplicationResponse> retryDataReplication(
            RetryDataReplicationRequest retryDataReplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Causes the data replication initiation sequence to begin immediately upon next Handshake for specified
     * SourceServer IDs, regardless of when the previous initiation started. This command will not work if the
     * SourceServer is not stalled or is in a DISCONNECTED or STOPPED state.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link RetryDataReplicationRequest.Builder} avoiding the
     * need to create one manually via {@link RetryDataReplicationRequest#builder()}
     * </p>
     *
     * @param retryDataReplicationRequest
     *        A {@link Consumer} that will call methods on {@link RetryDataReplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the RetryDataReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.RetryDataReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/RetryDataReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<RetryDataReplicationResponse> retryDataReplication(
            Consumer<RetryDataReplicationRequest.Builder> retryDataReplicationRequest) {
        return retryDataReplication(RetryDataReplicationRequest.builder().applyMutation(retryDataReplicationRequest).build());
    }

    /**
     * <p>
     * Launches a Cutover Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy
     * property is StartCutover and changes the SourceServer.lifeCycle.state property to CUTTING_OVER.
     * </p>
     *
     * @param startCutoverRequest
     * @return A Java Future containing the result of the StartCutover operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.StartCutover
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartCutover" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartCutoverResponse> startCutover(StartCutoverRequest startCutoverRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Launches a Cutover Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy
     * property is StartCutover and changes the SourceServer.lifeCycle.state property to CUTTING_OVER.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartCutoverRequest.Builder} avoiding the need to
     * create one manually via {@link StartCutoverRequest#builder()}
     * </p>
     *
     * @param startCutoverRequest
     *        A {@link Consumer} that will call methods on {@link StartCutoverRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartCutover operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.StartCutover
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartCutover" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartCutoverResponse> startCutover(Consumer<StartCutoverRequest.Builder> startCutoverRequest) {
        return startCutover(StartCutoverRequest.builder().applyMutation(startCutoverRequest).build());
    }

    /**
     * <p>
     * Start export.
     * </p>
     *
     * @param startExportRequest
     *        Start export request.
     * @return A Java Future containing the result of the StartExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.StartExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartExport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartExportResponse> startExport(StartExportRequest startExportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start export.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartExportRequest.Builder} avoiding the need to
     * create one manually via {@link StartExportRequest#builder()}
     * </p>
     *
     * @param startExportRequest
     *        A {@link Consumer} that will call methods on {@link StartExportRequest.Builder} to create a request. Start
     *        export request.
     * @return A Java Future containing the result of the StartExport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.StartExport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartExport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartExportResponse> startExport(Consumer<StartExportRequest.Builder> startExportRequest) {
        return startExport(StartExportRequest.builder().applyMutation(startExportRequest).build());
    }

    /**
     * <p>
     * Start import.
     * </p>
     *
     * @param startImportRequest
     *        Start import request.
     * @return A Java Future containing the result of the StartImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.StartImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartImport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartImportResponse> startImport(StartImportRequest startImportRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Start import.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImportRequest.Builder} avoiding the need to
     * create one manually via {@link StartImportRequest#builder()}
     * </p>
     *
     * @param startImportRequest
     *        A {@link Consumer} that will call methods on {@link StartImportRequest.Builder} to create a request. Start
     *        import request.
     * @return A Java Future containing the result of the StartImport operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.StartImport
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartImport" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartImportResponse> startImport(Consumer<StartImportRequest.Builder> startImportRequest) {
        return startImport(StartImportRequest.builder().applyMutation(startImportRequest).build());
    }

    /**
     * <p>
     * Starts replication for SNAPSHOT_SHIPPING agents.
     * </p>
     *
     * @param startReplicationRequest
     * @return A Java Future containing the result of the StartReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.StartReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartReplicationResponse> startReplication(StartReplicationRequest startReplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts replication for SNAPSHOT_SHIPPING agents.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartReplicationRequest.Builder} avoiding the need
     * to create one manually via {@link StartReplicationRequest#builder()}
     * </p>
     *
     * @param startReplicationRequest
     *        A {@link Consumer} that will call methods on {@link StartReplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.StartReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartReplicationResponse> startReplication(
            Consumer<StartReplicationRequest.Builder> startReplicationRequest) {
        return startReplication(StartReplicationRequest.builder().applyMutation(startReplicationRequest).build());
    }

    /**
     * <p>
     * Launches a Test Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy property
     * is StartTest and changes the SourceServer.lifeCycle.state property to TESTING.
     * </p>
     *
     * @param startTestRequest
     * @return A Java Future containing the result of the StartTest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.StartTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartTest" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartTestResponse> startTest(StartTestRequest startTestRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Launches a Test Instance for specific Source Servers. This command starts a LAUNCH job whose initiatedBy property
     * is StartTest and changes the SourceServer.lifeCycle.state property to TESTING.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartTestRequest.Builder} avoiding the need to
     * create one manually via {@link StartTestRequest#builder()}
     * </p>
     *
     * @param startTestRequest
     *        A {@link Consumer} that will call methods on {@link StartTestRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StartTest operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.StartTest
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StartTest" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StartTestResponse> startTest(Consumer<StartTestRequest.Builder> startTestRequest) {
        return startTest(StartTestRequest.builder().applyMutation(startTestRequest).build());
    }

    /**
     * <p>
     * Stop Replication.
     * </p>
     *
     * @param stopReplicationRequest
     * @return A Java Future containing the result of the StopReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.StopReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StopReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopReplicationResponse> stopReplication(StopReplicationRequest stopReplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stop Replication.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopReplicationRequest.Builder} avoiding the need
     * to create one manually via {@link StopReplicationRequest#builder()}
     * </p>
     *
     * @param stopReplicationRequest
     *        A {@link Consumer} that will call methods on {@link StopReplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the StopReplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.StopReplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/StopReplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<StopReplicationResponse> stopReplication(
            Consumer<StopReplicationRequest.Builder> stopReplicationRequest) {
        return stopReplication(StopReplicationRequest.builder().applyMutation(stopReplicationRequest).build());
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Application Migration Service resource or resources.
     * When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a
     * maximum of 50 tags. Each tag consists of a key and optional value.
     * </p>
     *
     * @param tagResourceRequest
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ThrottlingException Reached throttling quota exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>InternalServerException The server encountered an unexpected condition that prevented it from
     *         fulfilling the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(TagResourceRequest tagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites only the specified tags for the specified Application Migration Service resource or resources.
     * When you specify an existing tag key, the value is overwritten with the new value. Each resource can have a
     * maximum of 50 tags. Each tag consists of a key and optional value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the TagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ThrottlingException Reached throttling quota exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>InternalServerException The server encountered an unexpected condition that prevented it from
     *         fulfilling the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<TagResourceResponse> tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Starts a job that terminates specific launched EC2 Test and Cutover instances. This command will not work for any
     * Source Server with a lifecycle.state of TESTING, CUTTING_OVER, or CUTOVER.
     * </p>
     *
     * @param terminateTargetInstancesRequest
     * @return A Java Future containing the result of the TerminateTargetInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.TerminateTargetInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/TerminateTargetInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TerminateTargetInstancesResponse> terminateTargetInstances(
            TerminateTargetInstancesRequest terminateTargetInstancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts a job that terminates specific launched EC2 Test and Cutover instances. This command will not work for any
     * Source Server with a lifecycle.state of TESTING, CUTTING_OVER, or CUTOVER.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TerminateTargetInstancesRequest.Builder} avoiding
     * the need to create one manually via {@link TerminateTargetInstancesRequest#builder()}
     * </p>
     *
     * @param terminateTargetInstancesRequest
     *        A {@link Consumer} that will call methods on {@link TerminateTargetInstancesRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the TerminateTargetInstances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.TerminateTargetInstances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/TerminateTargetInstances" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<TerminateTargetInstancesResponse> terminateTargetInstances(
            Consumer<TerminateTargetInstancesRequest.Builder> terminateTargetInstancesRequest) {
        return terminateTargetInstances(TerminateTargetInstancesRequest.builder().applyMutation(terminateTargetInstancesRequest)
                .build());
    }

    /**
     * <p>
     * Unarchive application.
     * </p>
     *
     * @param unarchiveApplicationRequest
     * @return A Java Future containing the result of the UnarchiveApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UnarchiveApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UnarchiveApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UnarchiveApplicationResponse> unarchiveApplication(
            UnarchiveApplicationRequest unarchiveApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Unarchive application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnarchiveApplicationRequest.Builder} avoiding the
     * need to create one manually via {@link UnarchiveApplicationRequest#builder()}
     * </p>
     *
     * @param unarchiveApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UnarchiveApplicationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UnarchiveApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UnarchiveApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UnarchiveApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UnarchiveApplicationResponse> unarchiveApplication(
            Consumer<UnarchiveApplicationRequest.Builder> unarchiveApplicationRequest) {
        return unarchiveApplication(UnarchiveApplicationRequest.builder().applyMutation(unarchiveApplicationRequest).build());
    }

    /**
     * <p>
     * Unarchive wave.
     * </p>
     *
     * @param unarchiveWaveRequest
     * @return A Java Future containing the result of the UnarchiveWave operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UnarchiveWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UnarchiveWave" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UnarchiveWaveResponse> unarchiveWave(UnarchiveWaveRequest unarchiveWaveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Unarchive wave.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UnarchiveWaveRequest.Builder} avoiding the need to
     * create one manually via {@link UnarchiveWaveRequest#builder()}
     * </p>
     *
     * @param unarchiveWaveRequest
     *        A {@link Consumer} that will call methods on {@link UnarchiveWaveRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UnarchiveWave operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ServiceQuotaExceededException The request could not be completed because its exceeded the service
     *         quota.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UnarchiveWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UnarchiveWave" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UnarchiveWaveResponse> unarchiveWave(Consumer<UnarchiveWaveRequest.Builder> unarchiveWaveRequest) {
        return unarchiveWave(UnarchiveWaveRequest.builder().applyMutation(unarchiveWaveRequest).build());
    }

    /**
     * <p>
     * Deletes the specified set of tags from the specified set of Application Migration Service resources.
     * </p>
     *
     * @param untagResourceRequest
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ThrottlingException Reached throttling quota exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>InternalServerException The server encountered an unexpected condition that prevented it from
     *         fulfilling the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(UntagResourceRequest untagResourceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified set of tags from the specified set of Application Migration Service resources.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UntagResource operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ThrottlingException Reached throttling quota exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>InternalServerException The server encountered an unexpected condition that prevented it from
     *         fulfilling the request.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UntagResourceResponse> untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest) {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Update application.
     * </p>
     *
     * @param updateApplicationRequest
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(UpdateApplicationRequest updateApplicationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApplicationRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateApplication operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateApplication" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateApplicationResponse> updateApplication(
            Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest) {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Updates multiple LaunchConfigurations by Source Server ID.
     * </p>
     *
     * @param updateLaunchConfigurationRequest
     * @return A Java Future containing the result of the UpdateLaunchConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateLaunchConfigurationResponse> updateLaunchConfiguration(
            UpdateLaunchConfigurationRequest updateLaunchConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates multiple LaunchConfigurations by Source Server ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLaunchConfigurationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateLaunchConfigurationRequest#builder()}
     * </p>
     *
     * @param updateLaunchConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLaunchConfigurationRequest.Builder} to create a
     *        request.
     * @return A Java Future containing the result of the UpdateLaunchConfiguration operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateLaunchConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateLaunchConfiguration" target="_top">AWS
     *      API Documentation</a>
     */
    default CompletableFuture<UpdateLaunchConfigurationResponse> updateLaunchConfiguration(
            Consumer<UpdateLaunchConfigurationRequest.Builder> updateLaunchConfigurationRequest) {
        return updateLaunchConfiguration(UpdateLaunchConfigurationRequest.builder()
                .applyMutation(updateLaunchConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates an existing Launch Configuration Template by ID.
     * </p>
     *
     * @param updateLaunchConfigurationTemplateRequest
     * @return A Java Future containing the result of the UpdateLaunchConfigurationTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLaunchConfigurationTemplateResponse> updateLaunchConfigurationTemplate(
            UpdateLaunchConfigurationTemplateRequest updateLaunchConfigurationTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an existing Launch Configuration Template by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateLaunchConfigurationTemplateRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateLaunchConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param updateLaunchConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateLaunchConfigurationTemplateRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateLaunchConfigurationTemplate operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateLaunchConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateLaunchConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateLaunchConfigurationTemplateResponse> updateLaunchConfigurationTemplate(
            Consumer<UpdateLaunchConfigurationTemplateRequest.Builder> updateLaunchConfigurationTemplateRequest) {
        return updateLaunchConfigurationTemplate(UpdateLaunchConfigurationTemplateRequest.builder()
                .applyMutation(updateLaunchConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Allows you to update multiple ReplicationConfigurations by Source Server ID.
     * </p>
     *
     * @param updateReplicationConfigurationRequest
     * @return A Java Future containing the result of the UpdateReplicationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReplicationConfigurationResponse> updateReplicationConfiguration(
            UpdateReplicationConfigurationRequest updateReplicationConfigurationRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to update multiple ReplicationConfigurations by Source Server ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateReplicationConfigurationRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateReplicationConfigurationRequest#builder()}
     * </p>
     *
     * @param updateReplicationConfigurationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateReplicationConfigurationRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateReplicationConfiguration operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateReplicationConfiguration
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateReplicationConfiguration"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReplicationConfigurationResponse> updateReplicationConfiguration(
            Consumer<UpdateReplicationConfigurationRequest.Builder> updateReplicationConfigurationRequest) {
        return updateReplicationConfiguration(UpdateReplicationConfigurationRequest.builder()
                .applyMutation(updateReplicationConfigurationRequest).build());
    }

    /**
     * <p>
     * Updates multiple ReplicationConfigurationTemplates by ID.
     * </p>
     *
     * @param updateReplicationConfigurationTemplateRequest
     * @return A Java Future containing the result of the UpdateReplicationConfigurationTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReplicationConfigurationTemplateResponse> updateReplicationConfigurationTemplate(
            UpdateReplicationConfigurationTemplateRequest updateReplicationConfigurationTemplateRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates multiple ReplicationConfigurationTemplates by ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link UpdateReplicationConfigurationTemplateRequest.Builder} avoiding the need to create one manually via
     * {@link UpdateReplicationConfigurationTemplateRequest#builder()}
     * </p>
     *
     * @param updateReplicationConfigurationTemplateRequest
     *        A {@link Consumer} that will call methods on {@link UpdateReplicationConfigurationTemplateRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the UpdateReplicationConfigurationTemplate operation returned by
     *         the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>AccessDeniedException Operating denied due to a file permission or access check error.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateReplicationConfigurationTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateReplicationConfigurationTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateReplicationConfigurationTemplateResponse> updateReplicationConfigurationTemplate(
            Consumer<UpdateReplicationConfigurationTemplateRequest.Builder> updateReplicationConfigurationTemplateRequest) {
        return updateReplicationConfigurationTemplate(UpdateReplicationConfigurationTemplateRequest.builder()
                .applyMutation(updateReplicationConfigurationTemplateRequest).build());
    }

    /**
     * <p>
     * Allows you to change between the AGENT_BASED replication type and the SNAPSHOT_SHIPPING replication type.
     * </p>
     *
     * @param updateSourceServerReplicationTypeRequest
     * @return A Java Future containing the result of the UpdateSourceServerReplicationType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateSourceServerReplicationType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateSourceServerReplicationType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSourceServerReplicationTypeResponse> updateSourceServerReplicationType(
            UpdateSourceServerReplicationTypeRequest updateSourceServerReplicationTypeRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Allows you to change between the AGENT_BASED replication type and the SNAPSHOT_SHIPPING replication type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSourceServerReplicationTypeRequest.Builder}
     * avoiding the need to create one manually via {@link UpdateSourceServerReplicationTypeRequest#builder()}
     * </p>
     *
     * @param updateSourceServerReplicationTypeRequest
     *        A {@link Consumer} that will call methods on {@link UpdateSourceServerReplicationTypeRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the UpdateSourceServerReplicationType operation returned by the
     *         service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ValidationException Validate exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateSourceServerReplicationType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateSourceServerReplicationType"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<UpdateSourceServerReplicationTypeResponse> updateSourceServerReplicationType(
            Consumer<UpdateSourceServerReplicationTypeRequest.Builder> updateSourceServerReplicationTypeRequest) {
        return updateSourceServerReplicationType(UpdateSourceServerReplicationTypeRequest.builder()
                .applyMutation(updateSourceServerReplicationTypeRequest).build());
    }

    /**
     * <p>
     * Update wave.
     * </p>
     *
     * @param updateWaveRequest
     * @return A Java Future containing the result of the UpdateWave operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateWave" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWaveResponse> updateWave(UpdateWaveRequest updateWaveRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Update wave.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateWaveRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateWaveRequest#builder()}
     * </p>
     *
     * @param updateWaveRequest
     *        A {@link Consumer} that will call methods on {@link UpdateWaveRequest.Builder} to create a request.
     * @return A Java Future containing the result of the UpdateWave operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>UninitializedAccountException Uninitialized account exception.</li>
     *         <li>ResourceNotFoundException Resource not found exception.</li>
     *         <li>ConflictException The request could not be completed due to a conflict with the current state of the
     *         target resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>MgnException Base class for all service exceptions. Unknown exceptions will be thrown as an instance
     *         of this type.</li>
     *         </ul>
     * @sample MgnAsyncClient.UpdateWave
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/mgn-2020-02-26/UpdateWave" target="_top">AWS API
     *      Documentation</a>
     */
    default CompletableFuture<UpdateWaveResponse> updateWave(Consumer<UpdateWaveRequest.Builder> updateWaveRequest) {
        return updateWave(UpdateWaveRequest.builder().applyMutation(updateWaveRequest).build());
    }

    @Override
    default MgnServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link MgnAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static MgnAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link MgnAsyncClient}.
     */
    static MgnAsyncClientBuilder builder() {
        return new DefaultMgnAsyncClientBuilder();
    }
}
