/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DataReplicationErrorString {
    AGENT_NOT_SEEN("AGENT_NOT_SEEN"),
    SNAPSHOTS_FAILURE("SNAPSHOTS_FAILURE"),
    NOT_CONVERGING("NOT_CONVERGING"),
    UNSTABLE_NETWORK("UNSTABLE_NETWORK"),
    FAILED_TO_CREATE_SECURITY_GROUP("FAILED_TO_CREATE_SECURITY_GROUP"),
    FAILED_TO_LAUNCH_REPLICATION_SERVER("FAILED_TO_LAUNCH_REPLICATION_SERVER"),
    FAILED_TO_BOOT_REPLICATION_SERVER("FAILED_TO_BOOT_REPLICATION_SERVER"),
    FAILED_TO_AUTHENTICATE_WITH_SERVICE("FAILED_TO_AUTHENTICATE_WITH_SERVICE"),
    FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE("FAILED_TO_DOWNLOAD_REPLICATION_SOFTWARE"),
    FAILED_TO_CREATE_STAGING_DISKS("FAILED_TO_CREATE_STAGING_DISKS"),
    FAILED_TO_ATTACH_STAGING_DISKS("FAILED_TO_ATTACH_STAGING_DISKS"),
    FAILED_TO_PAIR_REPLICATION_SERVER_WITH_AGENT("FAILED_TO_PAIR_REPLICATION_SERVER_WITH_AGENT"),
    FAILED_TO_CONNECT_AGENT_TO_REPLICATION_SERVER("FAILED_TO_CONNECT_AGENT_TO_REPLICATION_SERVER"),
    FAILED_TO_START_DATA_TRANSFER("FAILED_TO_START_DATA_TRANSFER"),
    UNSUPPORTED_VM_CONFIGURATION("UNSUPPORTED_VM_CONFIGURATION"),
    LAST_SNAPSHOT_JOB_FAILED("LAST_SNAPSHOT_JOB_FAILED"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DataReplicationErrorString> VALUE_MAP;
    private final String value;

    private DataReplicationErrorString(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DataReplicationErrorString fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DataReplicationErrorString> knownValues() {
        EnumSet<DataReplicationErrorString> knownValues = EnumSet.allOf(DataReplicationErrorString.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DataReplicationErrorString.class, DataReplicationErrorString::toString);
    }
}

