/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.PostLaunchActions;
import software.amazon.awssdk.services.mgn.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class LaunchConfigurationTemplate
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, LaunchConfigurationTemplate> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(LaunchConfigurationTemplate.getter(LaunchConfigurationTemplate::arn)).setter(LaunchConfigurationTemplate.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<String> LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("launchConfigurationTemplateID").getter(LaunchConfigurationTemplate.getter(LaunchConfigurationTemplate::launchConfigurationTemplateID)).setter(LaunchConfigurationTemplate.setter(Builder::launchConfigurationTemplateID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchConfigurationTemplateID").build()}).build();
    private static final SdkField<PostLaunchActions> POST_LAUNCH_ACTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("postLaunchActions").getter(LaunchConfigurationTemplate.getter(LaunchConfigurationTemplate::postLaunchActions)).setter(LaunchConfigurationTemplate.setter(Builder::postLaunchActions)).constructor(PostLaunchActions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("postLaunchActions").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(LaunchConfigurationTemplate.getter(LaunchConfigurationTemplate::tags)).setter(LaunchConfigurationTemplate.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, LAUNCH_CONFIGURATION_TEMPLATE_ID_FIELD, POST_LAUNCH_ACTIONS_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final String launchConfigurationTemplateID;
    private final PostLaunchActions postLaunchActions;
    private final Map<String, String> tags;

    private LaunchConfigurationTemplate(BuilderImpl builder) {
        this.arn = builder.arn;
        this.launchConfigurationTemplateID = builder.launchConfigurationTemplateID;
        this.postLaunchActions = builder.postLaunchActions;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final String launchConfigurationTemplateID() {
        return this.launchConfigurationTemplateID;
    }

    public final PostLaunchActions postLaunchActions() {
        return this.postLaunchActions;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchConfigurationTemplateID());
        hashCode = 31 * hashCode + Objects.hashCode(this.postLaunchActions());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LaunchConfigurationTemplate)) {
            return false;
        }
        LaunchConfigurationTemplate other = (LaunchConfigurationTemplate)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.launchConfigurationTemplateID(), other.launchConfigurationTemplateID()) && Objects.equals(this.postLaunchActions(), other.postLaunchActions()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"LaunchConfigurationTemplate").add("Arn", (Object)this.arn()).add("LaunchConfigurationTemplateID", (Object)this.launchConfigurationTemplateID()).add("PostLaunchActions", (Object)this.postLaunchActions()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "launchConfigurationTemplateID": {
                return Optional.ofNullable(clazz.cast(this.launchConfigurationTemplateID()));
            }
            case "postLaunchActions": {
                return Optional.ofNullable(clazz.cast(this.postLaunchActions()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<LaunchConfigurationTemplate, T> g) {
        return obj -> g.apply((LaunchConfigurationTemplate)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private String launchConfigurationTemplateID;
        private PostLaunchActions postLaunchActions;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(LaunchConfigurationTemplate model) {
            this.arn(model.arn);
            this.launchConfigurationTemplateID(model.launchConfigurationTemplateID);
            this.postLaunchActions(model.postLaunchActions);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getLaunchConfigurationTemplateID() {
            return this.launchConfigurationTemplateID;
        }

        public final void setLaunchConfigurationTemplateID(String launchConfigurationTemplateID) {
            this.launchConfigurationTemplateID = launchConfigurationTemplateID;
        }

        @Override
        public final Builder launchConfigurationTemplateID(String launchConfigurationTemplateID) {
            this.launchConfigurationTemplateID = launchConfigurationTemplateID;
            return this;
        }

        public final PostLaunchActions.Builder getPostLaunchActions() {
            return this.postLaunchActions != null ? this.postLaunchActions.toBuilder() : null;
        }

        public final void setPostLaunchActions(PostLaunchActions.BuilderImpl postLaunchActions) {
            this.postLaunchActions = postLaunchActions != null ? postLaunchActions.build() : null;
        }

        @Override
        public final Builder postLaunchActions(PostLaunchActions postLaunchActions) {
            this.postLaunchActions = postLaunchActions;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public LaunchConfigurationTemplate build() {
            return new LaunchConfigurationTemplate(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, LaunchConfigurationTemplate> {
        public Builder arn(String var1);

        public Builder launchConfigurationTemplateID(String var1);

        public Builder postLaunchActions(PostLaunchActions var1);

        default public Builder postLaunchActions(Consumer<PostLaunchActions.Builder> postLaunchActions) {
            return this.postLaunchActions((PostLaunchActions)((PostLaunchActions.Builder)PostLaunchActions.builder().applyMutation(postLaunchActions)).build());
        }

        public Builder tags(Map<String, String> var1);
    }
}

