/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.mgn.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.mgn.model.DataReplicationInfo;
import software.amazon.awssdk.services.mgn.model.LaunchedInstance;
import software.amazon.awssdk.services.mgn.model.LifeCycle;
import software.amazon.awssdk.services.mgn.model.SourceProperties;
import software.amazon.awssdk.services.mgn.model.TagsMapCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SourceServer
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SourceServer> {
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("arn").getter(SourceServer.getter(SourceServer::arn)).setter(SourceServer.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()}).build();
    private static final SdkField<DataReplicationInfo> DATA_REPLICATION_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataReplicationInfo").getter(SourceServer.getter(SourceServer::dataReplicationInfo)).setter(SourceServer.setter(Builder::dataReplicationInfo)).constructor(DataReplicationInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataReplicationInfo").build()}).build();
    private static final SdkField<Boolean> IS_ARCHIVED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("isArchived").getter(SourceServer.getter(SourceServer::isArchived)).setter(SourceServer.setter(Builder::isArchived)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("isArchived").build()}).build();
    private static final SdkField<LaunchedInstance> LAUNCHED_INSTANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("launchedInstance").getter(SourceServer.getter(SourceServer::launchedInstance)).setter(SourceServer.setter(Builder::launchedInstance)).constructor(LaunchedInstance::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("launchedInstance").build()}).build();
    private static final SdkField<LifeCycle> LIFE_CYCLE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lifeCycle").getter(SourceServer.getter(SourceServer::lifeCycle)).setter(SourceServer.setter(Builder::lifeCycle)).constructor(LifeCycle::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifeCycle").build()}).build();
    private static final SdkField<SourceProperties> SOURCE_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("sourceProperties").getter(SourceServer.getter(SourceServer::sourceProperties)).setter(SourceServer.setter(Builder::sourceProperties)).constructor(SourceProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceProperties").build()}).build();
    private static final SdkField<String> SOURCE_SERVER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceServerID").getter(SourceServer.getter(SourceServer::sourceServerID)).setter(SourceServer.setter(Builder::sourceServerID)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceServerID").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("tags").getter(SourceServer.getter(SourceServer::tags)).setter(SourceServer.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, DATA_REPLICATION_INFO_FIELD, IS_ARCHIVED_FIELD, LAUNCHED_INSTANCE_FIELD, LIFE_CYCLE_FIELD, SOURCE_PROPERTIES_FIELD, SOURCE_SERVER_ID_FIELD, TAGS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String arn;
    private final DataReplicationInfo dataReplicationInfo;
    private final Boolean isArchived;
    private final LaunchedInstance launchedInstance;
    private final LifeCycle lifeCycle;
    private final SourceProperties sourceProperties;
    private final String sourceServerID;
    private final Map<String, String> tags;

    private SourceServer(BuilderImpl builder) {
        this.arn = builder.arn;
        this.dataReplicationInfo = builder.dataReplicationInfo;
        this.isArchived = builder.isArchived;
        this.launchedInstance = builder.launchedInstance;
        this.lifeCycle = builder.lifeCycle;
        this.sourceProperties = builder.sourceProperties;
        this.sourceServerID = builder.sourceServerID;
        this.tags = builder.tags;
    }

    public final String arn() {
        return this.arn;
    }

    public final DataReplicationInfo dataReplicationInfo() {
        return this.dataReplicationInfo;
    }

    public final Boolean isArchived() {
        return this.isArchived;
    }

    public final LaunchedInstance launchedInstance() {
        return this.launchedInstance;
    }

    public final LifeCycle lifeCycle() {
        return this.lifeCycle;
    }

    public final SourceProperties sourceProperties() {
        return this.sourceProperties;
    }

    public final String sourceServerID() {
        return this.sourceServerID;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataReplicationInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.isArchived());
        hashCode = 31 * hashCode + Objects.hashCode(this.launchedInstance());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifeCycle());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceServerID());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SourceServer)) {
            return false;
        }
        SourceServer other = (SourceServer)obj;
        return Objects.equals(this.arn(), other.arn()) && Objects.equals(this.dataReplicationInfo(), other.dataReplicationInfo()) && Objects.equals(this.isArchived(), other.isArchived()) && Objects.equals(this.launchedInstance(), other.launchedInstance()) && Objects.equals(this.lifeCycle(), other.lifeCycle()) && Objects.equals(this.sourceProperties(), other.sourceProperties()) && Objects.equals(this.sourceServerID(), other.sourceServerID()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"SourceServer").add("Arn", (Object)this.arn()).add("DataReplicationInfo", (Object)this.dataReplicationInfo()).add("IsArchived", (Object)this.isArchived()).add("LaunchedInstance", (Object)this.launchedInstance()).add("LifeCycle", (Object)this.lifeCycle()).add("SourceProperties", (Object)this.sourceProperties()).add("SourceServerID", (Object)this.sourceServerID()).add("Tags", (Object)(this.tags() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "arn": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "dataReplicationInfo": {
                return Optional.ofNullable(clazz.cast(this.dataReplicationInfo()));
            }
            case "isArchived": {
                return Optional.ofNullable(clazz.cast(this.isArchived()));
            }
            case "launchedInstance": {
                return Optional.ofNullable(clazz.cast(this.launchedInstance()));
            }
            case "lifeCycle": {
                return Optional.ofNullable(clazz.cast(this.lifeCycle()));
            }
            case "sourceProperties": {
                return Optional.ofNullable(clazz.cast(this.sourceProperties()));
            }
            case "sourceServerID": {
                return Optional.ofNullable(clazz.cast(this.sourceServerID()));
            }
            case "tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<SourceServer, T> g) {
        return obj -> g.apply((SourceServer)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String arn;
        private DataReplicationInfo dataReplicationInfo;
        private Boolean isArchived;
        private LaunchedInstance launchedInstance;
        private LifeCycle lifeCycle;
        private SourceProperties sourceProperties;
        private String sourceServerID;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SourceServer model) {
            this.arn(model.arn);
            this.dataReplicationInfo(model.dataReplicationInfo);
            this.isArchived(model.isArchived);
            this.launchedInstance(model.launchedInstance);
            this.lifeCycle(model.lifeCycle);
            this.sourceProperties(model.sourceProperties);
            this.sourceServerID(model.sourceServerID);
            this.tags(model.tags);
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final DataReplicationInfo.Builder getDataReplicationInfo() {
            return this.dataReplicationInfo != null ? this.dataReplicationInfo.toBuilder() : null;
        }

        public final void setDataReplicationInfo(DataReplicationInfo.BuilderImpl dataReplicationInfo) {
            this.dataReplicationInfo = dataReplicationInfo != null ? dataReplicationInfo.build() : null;
        }

        @Override
        @Transient
        public final Builder dataReplicationInfo(DataReplicationInfo dataReplicationInfo) {
            this.dataReplicationInfo = dataReplicationInfo;
            return this;
        }

        public final Boolean getIsArchived() {
            return this.isArchived;
        }

        public final void setIsArchived(Boolean isArchived) {
            this.isArchived = isArchived;
        }

        @Override
        @Transient
        public final Builder isArchived(Boolean isArchived) {
            this.isArchived = isArchived;
            return this;
        }

        public final LaunchedInstance.Builder getLaunchedInstance() {
            return this.launchedInstance != null ? this.launchedInstance.toBuilder() : null;
        }

        public final void setLaunchedInstance(LaunchedInstance.BuilderImpl launchedInstance) {
            this.launchedInstance = launchedInstance != null ? launchedInstance.build() : null;
        }

        @Override
        @Transient
        public final Builder launchedInstance(LaunchedInstance launchedInstance) {
            this.launchedInstance = launchedInstance;
            return this;
        }

        public final LifeCycle.Builder getLifeCycle() {
            return this.lifeCycle != null ? this.lifeCycle.toBuilder() : null;
        }

        public final void setLifeCycle(LifeCycle.BuilderImpl lifeCycle) {
            this.lifeCycle = lifeCycle != null ? lifeCycle.build() : null;
        }

        @Override
        @Transient
        public final Builder lifeCycle(LifeCycle lifeCycle) {
            this.lifeCycle = lifeCycle;
            return this;
        }

        public final SourceProperties.Builder getSourceProperties() {
            return this.sourceProperties != null ? this.sourceProperties.toBuilder() : null;
        }

        public final void setSourceProperties(SourceProperties.BuilderImpl sourceProperties) {
            this.sourceProperties = sourceProperties != null ? sourceProperties.build() : null;
        }

        @Override
        @Transient
        public final Builder sourceProperties(SourceProperties sourceProperties) {
            this.sourceProperties = sourceProperties;
            return this;
        }

        public final String getSourceServerID() {
            return this.sourceServerID;
        }

        public final void setSourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
        }

        @Override
        @Transient
        public final Builder sourceServerID(String sourceServerID) {
            this.sourceServerID = sourceServerID;
            return this;
        }

        public final Map<String, String> getTags() {
            if (this.tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsMapCopier.copy(tags);
            return this;
        }

        public SourceServer build() {
            return new SourceServer(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SourceServer> {
        public Builder arn(String var1);

        public Builder dataReplicationInfo(DataReplicationInfo var1);

        default public Builder dataReplicationInfo(Consumer<DataReplicationInfo.Builder> dataReplicationInfo) {
            return this.dataReplicationInfo((DataReplicationInfo)((DataReplicationInfo.Builder)DataReplicationInfo.builder().applyMutation(dataReplicationInfo)).build());
        }

        public Builder isArchived(Boolean var1);

        public Builder launchedInstance(LaunchedInstance var1);

        default public Builder launchedInstance(Consumer<LaunchedInstance.Builder> launchedInstance) {
            return this.launchedInstance((LaunchedInstance)((LaunchedInstance.Builder)LaunchedInstance.builder().applyMutation(launchedInstance)).build());
        }

        public Builder lifeCycle(LifeCycle var1);

        default public Builder lifeCycle(Consumer<LifeCycle.Builder> lifeCycle) {
            return this.lifeCycle((LifeCycle)((LifeCycle.Builder)LifeCycle.builder().applyMutation(lifeCycle)).build());
        }

        public Builder sourceProperties(SourceProperties var1);

        default public Builder sourceProperties(Consumer<SourceProperties.Builder> sourceProperties) {
            return this.sourceProperties((SourceProperties)((SourceProperties.Builder)SourceProperties.builder().applyMutation(sourceProperties)).build());
        }

        public Builder sourceServerID(String var1);

        public Builder tags(Map<String, String> var1);
    }
}

