/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.NetworkType;
import software.amazon.awssdk.services.memorydb.model.NetworkTypeListCopier;
import software.amazon.awssdk.services.memorydb.model.Subnet;
import software.amazon.awssdk.services.memorydb.model.SubnetListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SubnetGroup
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SubnetGroup> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(SubnetGroup.getter(SubnetGroup::name)).setter(SubnetGroup.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(SubnetGroup.getter(SubnetGroup::description)).setter(SubnetGroup.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> VPC_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("VpcId").getter(SubnetGroup.getter(SubnetGroup::vpcId)).setter(SubnetGroup.setter(Builder::vpcId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcId").build()}).build();
    private static final SdkField<List<Subnet>> SUBNETS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Subnets").getter(SubnetGroup.getter(SubnetGroup::subnets)).setter(SubnetGroup.setter(Builder::subnets)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Subnets").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Subnet::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(SubnetGroup.getter(SubnetGroup::arn)).setter(SubnetGroup.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final SdkField<List<String>> SUPPORTED_NETWORK_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SupportedNetworkTypes").getter(SubnetGroup.getter(SubnetGroup::supportedNetworkTypesAsStrings)).setter(SubnetGroup.setter(Builder::supportedNetworkTypesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SupportedNetworkTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, VPC_ID_FIELD, SUBNETS_FIELD, ARN_FIELD, SUPPORTED_NETWORK_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SubnetGroup.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String vpcId;
    private final List<Subnet> subnets;
    private final String arn;
    private final List<String> supportedNetworkTypes;

    private SubnetGroup(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.vpcId = builder.vpcId;
        this.subnets = builder.subnets;
        this.arn = builder.arn;
        this.supportedNetworkTypes = builder.supportedNetworkTypes;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String vpcId() {
        return this.vpcId;
    }

    public final boolean hasSubnets() {
        return this.subnets != null && !(this.subnets instanceof SdkAutoConstructList);
    }

    public final List<Subnet> subnets() {
        return this.subnets;
    }

    public final String arn() {
        return this.arn;
    }

    public final List<NetworkType> supportedNetworkTypes() {
        return NetworkTypeListCopier.copyStringToEnum(this.supportedNetworkTypes);
    }

    public final boolean hasSupportedNetworkTypes() {
        return this.supportedNetworkTypes != null && !(this.supportedNetworkTypes instanceof SdkAutoConstructList);
    }

    public final List<String> supportedNetworkTypesAsStrings() {
        return this.supportedNetworkTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcId());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSubnets() ? this.subnets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSupportedNetworkTypes() ? this.supportedNetworkTypesAsStrings() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SubnetGroup)) {
            return false;
        }
        SubnetGroup other = (SubnetGroup)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.vpcId(), other.vpcId()) && this.hasSubnets() == other.hasSubnets() && Objects.equals(this.subnets(), other.subnets()) && Objects.equals(this.arn(), other.arn()) && this.hasSupportedNetworkTypes() == other.hasSupportedNetworkTypes() && Objects.equals(this.supportedNetworkTypesAsStrings(), other.supportedNetworkTypesAsStrings());
    }

    public final String toString() {
        return ToString.builder((String)"SubnetGroup").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("VpcId", (Object)this.vpcId()).add("Subnets", this.hasSubnets() ? this.subnets() : null).add("ARN", (Object)this.arn()).add("SupportedNetworkTypes", this.hasSupportedNetworkTypes() ? this.supportedNetworkTypesAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "VpcId": {
                return Optional.ofNullable(clazz.cast(this.vpcId()));
            }
            case "Subnets": {
                return Optional.ofNullable(clazz.cast(this.subnets()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "SupportedNetworkTypes": {
                return Optional.ofNullable(clazz.cast(this.supportedNetworkTypesAsStrings()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("VpcId", VPC_ID_FIELD);
        map.put("Subnets", SUBNETS_FIELD);
        map.put("ARN", ARN_FIELD);
        map.put("SupportedNetworkTypes", SUPPORTED_NETWORK_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SubnetGroup, T> g) {
        return obj -> g.apply((SubnetGroup)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String vpcId;
        private List<Subnet> subnets = DefaultSdkAutoConstructList.getInstance();
        private String arn;
        private List<String> supportedNetworkTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(SubnetGroup model) {
            this.name(model.name);
            this.description(model.description);
            this.vpcId(model.vpcId);
            this.subnets(model.subnets);
            this.arn(model.arn);
            this.supportedNetworkTypesWithStrings(model.supportedNetworkTypes);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getVpcId() {
            return this.vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        public final List<Subnet.Builder> getSubnets() {
            List<Subnet.Builder> result = SubnetListCopier.copyToBuilder(this.subnets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSubnets(Collection<Subnet.BuilderImpl> subnets) {
            this.subnets = SubnetListCopier.copyFromBuilder(subnets);
        }

        @Override
        public final Builder subnets(Collection<Subnet> subnets) {
            this.subnets = SubnetListCopier.copy(subnets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Subnet ... subnets) {
            this.subnets(Arrays.asList(subnets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder subnets(Consumer<Subnet.Builder> ... subnets) {
            this.subnets(Stream.of(subnets).map(c -> (Subnet)((Subnet.Builder)Subnet.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Collection<String> getSupportedNetworkTypes() {
            if (this.supportedNetworkTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.supportedNetworkTypes;
        }

        public final void setSupportedNetworkTypes(Collection<String> supportedNetworkTypes) {
            this.supportedNetworkTypes = NetworkTypeListCopier.copy(supportedNetworkTypes);
        }

        @Override
        public final Builder supportedNetworkTypesWithStrings(Collection<String> supportedNetworkTypes) {
            this.supportedNetworkTypes = NetworkTypeListCopier.copy(supportedNetworkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedNetworkTypesWithStrings(String ... supportedNetworkTypes) {
            this.supportedNetworkTypesWithStrings(Arrays.asList(supportedNetworkTypes));
            return this;
        }

        @Override
        public final Builder supportedNetworkTypes(Collection<NetworkType> supportedNetworkTypes) {
            this.supportedNetworkTypes = NetworkTypeListCopier.copyEnumToString(supportedNetworkTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder supportedNetworkTypes(NetworkType ... supportedNetworkTypes) {
            this.supportedNetworkTypes(Arrays.asList(supportedNetworkTypes));
            return this;
        }

        public SubnetGroup build() {
            return new SubnetGroup(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SubnetGroup> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder vpcId(String var1);

        public Builder subnets(Collection<Subnet> var1);

        public Builder subnets(Subnet ... var1);

        public Builder subnets(Consumer<Subnet.Builder> ... var1);

        public Builder arn(String var1);

        public Builder supportedNetworkTypesWithStrings(Collection<String> var1);

        public Builder supportedNetworkTypesWithStrings(String ... var1);

        public Builder supportedNetworkTypes(Collection<NetworkType> var1);

        public Builder supportedNetworkTypes(NetworkType ... var1);
    }
}

