/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.MemoryDbResponse;
import software.amazon.awssdk.services.memorydb.model.NodeTypeListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListAllowedMultiRegionClusterUpdatesResponse
extends MemoryDbResponse
implements ToCopyableBuilder<Builder, ListAllowedMultiRegionClusterUpdatesResponse> {
    private static final SdkField<List<String>> SCALE_UP_NODE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScaleUpNodeTypes").getter(ListAllowedMultiRegionClusterUpdatesResponse.getter(ListAllowedMultiRegionClusterUpdatesResponse::scaleUpNodeTypes)).setter(ListAllowedMultiRegionClusterUpdatesResponse.setter(Builder::scaleUpNodeTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleUpNodeTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> SCALE_DOWN_NODE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ScaleDownNodeTypes").getter(ListAllowedMultiRegionClusterUpdatesResponse.getter(ListAllowedMultiRegionClusterUpdatesResponse::scaleDownNodeTypes)).setter(ListAllowedMultiRegionClusterUpdatesResponse.setter(Builder::scaleDownNodeTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ScaleDownNodeTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SCALE_UP_NODE_TYPES_FIELD, SCALE_DOWN_NODE_TYPES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListAllowedMultiRegionClusterUpdatesResponse.memberNameToFieldInitializer();
    private final List<String> scaleUpNodeTypes;
    private final List<String> scaleDownNodeTypes;

    private ListAllowedMultiRegionClusterUpdatesResponse(BuilderImpl builder) {
        super(builder);
        this.scaleUpNodeTypes = builder.scaleUpNodeTypes;
        this.scaleDownNodeTypes = builder.scaleDownNodeTypes;
    }

    public final boolean hasScaleUpNodeTypes() {
        return this.scaleUpNodeTypes != null && !(this.scaleUpNodeTypes instanceof SdkAutoConstructList);
    }

    public final List<String> scaleUpNodeTypes() {
        return this.scaleUpNodeTypes;
    }

    public final boolean hasScaleDownNodeTypes() {
        return this.scaleDownNodeTypes != null && !(this.scaleDownNodeTypes instanceof SdkAutoConstructList);
    }

    public final List<String> scaleDownNodeTypes() {
        return this.scaleDownNodeTypes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScaleUpNodeTypes() ? this.scaleUpNodeTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasScaleDownNodeTypes() ? this.scaleDownNodeTypes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListAllowedMultiRegionClusterUpdatesResponse)) {
            return false;
        }
        ListAllowedMultiRegionClusterUpdatesResponse other = (ListAllowedMultiRegionClusterUpdatesResponse)((Object)obj);
        return this.hasScaleUpNodeTypes() == other.hasScaleUpNodeTypes() && Objects.equals(this.scaleUpNodeTypes(), other.scaleUpNodeTypes()) && this.hasScaleDownNodeTypes() == other.hasScaleDownNodeTypes() && Objects.equals(this.scaleDownNodeTypes(), other.scaleDownNodeTypes());
    }

    public final String toString() {
        return ToString.builder((String)"ListAllowedMultiRegionClusterUpdatesResponse").add("ScaleUpNodeTypes", this.hasScaleUpNodeTypes() ? this.scaleUpNodeTypes() : null).add("ScaleDownNodeTypes", this.hasScaleDownNodeTypes() ? this.scaleDownNodeTypes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ScaleUpNodeTypes": {
                return Optional.ofNullable(clazz.cast(this.scaleUpNodeTypes()));
            }
            case "ScaleDownNodeTypes": {
                return Optional.ofNullable(clazz.cast(this.scaleDownNodeTypes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<String>>> map = new HashMap<String, SdkField<List<String>>>();
        map.put("ScaleUpNodeTypes", SCALE_UP_NODE_TYPES_FIELD);
        map.put("ScaleDownNodeTypes", SCALE_DOWN_NODE_TYPES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListAllowedMultiRegionClusterUpdatesResponse, T> g) {
        return obj -> g.apply((ListAllowedMultiRegionClusterUpdatesResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbResponse.BuilderImpl
    implements Builder {
        private List<String> scaleUpNodeTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> scaleDownNodeTypes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ListAllowedMultiRegionClusterUpdatesResponse model) {
            super(model);
            this.scaleUpNodeTypes(model.scaleUpNodeTypes);
            this.scaleDownNodeTypes(model.scaleDownNodeTypes);
        }

        public final Collection<String> getScaleUpNodeTypes() {
            if (this.scaleUpNodeTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scaleUpNodeTypes;
        }

        public final void setScaleUpNodeTypes(Collection<String> scaleUpNodeTypes) {
            this.scaleUpNodeTypes = NodeTypeListCopier.copy(scaleUpNodeTypes);
        }

        @Override
        public final Builder scaleUpNodeTypes(Collection<String> scaleUpNodeTypes) {
            this.scaleUpNodeTypes = NodeTypeListCopier.copy(scaleUpNodeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scaleUpNodeTypes(String ... scaleUpNodeTypes) {
            this.scaleUpNodeTypes(Arrays.asList(scaleUpNodeTypes));
            return this;
        }

        public final Collection<String> getScaleDownNodeTypes() {
            if (this.scaleDownNodeTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.scaleDownNodeTypes;
        }

        public final void setScaleDownNodeTypes(Collection<String> scaleDownNodeTypes) {
            this.scaleDownNodeTypes = NodeTypeListCopier.copy(scaleDownNodeTypes);
        }

        @Override
        public final Builder scaleDownNodeTypes(Collection<String> scaleDownNodeTypes) {
            this.scaleDownNodeTypes = NodeTypeListCopier.copy(scaleDownNodeTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder scaleDownNodeTypes(String ... scaleDownNodeTypes) {
            this.scaleDownNodeTypes(Arrays.asList(scaleDownNodeTypes));
            return this;
        }

        @Override
        public ListAllowedMultiRegionClusterUpdatesResponse build() {
            return new ListAllowedMultiRegionClusterUpdatesResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MemoryDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListAllowedMultiRegionClusterUpdatesResponse> {
        public Builder scaleUpNodeTypes(Collection<String> var1);

        public Builder scaleUpNodeTypes(String ... var1);

        public Builder scaleDownNodeTypes(Collection<String> var1);

        public Builder scaleDownNodeTypes(String ... var1);
    }
}

