/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.MemoryDbRequest;
import software.amazon.awssdk.services.memorydb.model.Tag;
import software.amazon.awssdk.services.memorydb.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateMultiRegionClusterRequest
extends MemoryDbRequest
implements ToCopyableBuilder<Builder, CreateMultiRegionClusterRequest> {
    private static final SdkField<String> MULTI_REGION_CLUSTER_NAME_SUFFIX_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MultiRegionClusterNameSuffix").getter(CreateMultiRegionClusterRequest.getter(CreateMultiRegionClusterRequest::multiRegionClusterNameSuffix)).setter(CreateMultiRegionClusterRequest.setter(Builder::multiRegionClusterNameSuffix)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionClusterNameSuffix").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateMultiRegionClusterRequest.getter(CreateMultiRegionClusterRequest::description)).setter(CreateMultiRegionClusterRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(CreateMultiRegionClusterRequest.getter(CreateMultiRegionClusterRequest::engine)).setter(CreateMultiRegionClusterRequest.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(CreateMultiRegionClusterRequest.getter(CreateMultiRegionClusterRequest::engineVersion)).setter(CreateMultiRegionClusterRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeType").getter(CreateMultiRegionClusterRequest.getter(CreateMultiRegionClusterRequest::nodeType)).setter(CreateMultiRegionClusterRequest.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<String> MULTI_REGION_PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MultiRegionParameterGroupName").getter(CreateMultiRegionClusterRequest.getter(CreateMultiRegionClusterRequest::multiRegionParameterGroupName)).setter(CreateMultiRegionClusterRequest.setter(Builder::multiRegionParameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionParameterGroupName").build()}).build();
    private static final SdkField<Integer> NUM_SHARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumShards").getter(CreateMultiRegionClusterRequest.getter(CreateMultiRegionClusterRequest::numShards)).setter(CreateMultiRegionClusterRequest.setter(Builder::numShards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumShards").build()}).build();
    private static final SdkField<Boolean> TLS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TLSEnabled").getter(CreateMultiRegionClusterRequest.getter(CreateMultiRegionClusterRequest::tlsEnabled)).setter(CreateMultiRegionClusterRequest.setter(Builder::tlsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSEnabled").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(CreateMultiRegionClusterRequest.getter(CreateMultiRegionClusterRequest::tags)).setter(CreateMultiRegionClusterRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MULTI_REGION_CLUSTER_NAME_SUFFIX_FIELD, DESCRIPTION_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, NODE_TYPE_FIELD, MULTI_REGION_PARAMETER_GROUP_NAME_FIELD, NUM_SHARDS_FIELD, TLS_ENABLED_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateMultiRegionClusterRequest.memberNameToFieldInitializer();
    private final String multiRegionClusterNameSuffix;
    private final String description;
    private final String engine;
    private final String engineVersion;
    private final String nodeType;
    private final String multiRegionParameterGroupName;
    private final Integer numShards;
    private final Boolean tlsEnabled;
    private final List<Tag> tags;

    private CreateMultiRegionClusterRequest(BuilderImpl builder) {
        super(builder);
        this.multiRegionClusterNameSuffix = builder.multiRegionClusterNameSuffix;
        this.description = builder.description;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.nodeType = builder.nodeType;
        this.multiRegionParameterGroupName = builder.multiRegionParameterGroupName;
        this.numShards = builder.numShards;
        this.tlsEnabled = builder.tlsEnabled;
        this.tags = builder.tags;
    }

    public final String multiRegionClusterNameSuffix() {
        return this.multiRegionClusterNameSuffix;
    }

    public final String description() {
        return this.description;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String nodeType() {
        return this.nodeType;
    }

    public final String multiRegionParameterGroupName() {
        return this.multiRegionParameterGroupName;
    }

    public final Integer numShards() {
        return this.numShards;
    }

    public final Boolean tlsEnabled() {
        return this.tlsEnabled;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.multiRegionClusterNameSuffix());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiRegionParameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.numShards());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateMultiRegionClusterRequest)) {
            return false;
        }
        CreateMultiRegionClusterRequest other = (CreateMultiRegionClusterRequest)((Object)obj);
        return Objects.equals(this.multiRegionClusterNameSuffix(), other.multiRegionClusterNameSuffix()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.multiRegionParameterGroupName(), other.multiRegionParameterGroupName()) && Objects.equals(this.numShards(), other.numShards()) && Objects.equals(this.tlsEnabled(), other.tlsEnabled()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateMultiRegionClusterRequest").add("MultiRegionClusterNameSuffix", (Object)this.multiRegionClusterNameSuffix()).add("Description", (Object)this.description()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("NodeType", (Object)this.nodeType()).add("MultiRegionParameterGroupName", (Object)this.multiRegionParameterGroupName()).add("NumShards", (Object)this.numShards()).add("TLSEnabled", (Object)this.tlsEnabled()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "MultiRegionClusterNameSuffix": {
                return Optional.ofNullable(clazz.cast(this.multiRegionClusterNameSuffix()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "MultiRegionParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.multiRegionParameterGroupName()));
            }
            case "NumShards": {
                return Optional.ofNullable(clazz.cast(this.numShards()));
            }
            case "TLSEnabled": {
                return Optional.ofNullable(clazz.cast(this.tlsEnabled()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("MultiRegionClusterNameSuffix", MULTI_REGION_CLUSTER_NAME_SUFFIX_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("NodeType", NODE_TYPE_FIELD);
        map.put("MultiRegionParameterGroupName", MULTI_REGION_PARAMETER_GROUP_NAME_FIELD);
        map.put("NumShards", NUM_SHARDS_FIELD);
        map.put("TLSEnabled", TLS_ENABLED_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateMultiRegionClusterRequest, T> g) {
        return obj -> g.apply((CreateMultiRegionClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbRequest.BuilderImpl
    implements Builder {
        private String multiRegionClusterNameSuffix;
        private String description;
        private String engine;
        private String engineVersion;
        private String nodeType;
        private String multiRegionParameterGroupName;
        private Integer numShards;
        private Boolean tlsEnabled;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateMultiRegionClusterRequest model) {
            super(model);
            this.multiRegionClusterNameSuffix(model.multiRegionClusterNameSuffix);
            this.description(model.description);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.nodeType(model.nodeType);
            this.multiRegionParameterGroupName(model.multiRegionParameterGroupName);
            this.numShards(model.numShards);
            this.tlsEnabled(model.tlsEnabled);
            this.tags(model.tags);
        }

        public final String getMultiRegionClusterNameSuffix() {
            return this.multiRegionClusterNameSuffix;
        }

        public final void setMultiRegionClusterNameSuffix(String multiRegionClusterNameSuffix) {
            this.multiRegionClusterNameSuffix = multiRegionClusterNameSuffix;
        }

        @Override
        public final Builder multiRegionClusterNameSuffix(String multiRegionClusterNameSuffix) {
            this.multiRegionClusterNameSuffix = multiRegionClusterNameSuffix;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final String getMultiRegionParameterGroupName() {
            return this.multiRegionParameterGroupName;
        }

        public final void setMultiRegionParameterGroupName(String multiRegionParameterGroupName) {
            this.multiRegionParameterGroupName = multiRegionParameterGroupName;
        }

        @Override
        public final Builder multiRegionParameterGroupName(String multiRegionParameterGroupName) {
            this.multiRegionParameterGroupName = multiRegionParameterGroupName;
            return this;
        }

        public final Integer getNumShards() {
            return this.numShards;
        }

        public final void setNumShards(Integer numShards) {
            this.numShards = numShards;
        }

        @Override
        public final Builder numShards(Integer numShards) {
            this.numShards = numShards;
            return this;
        }

        public final Boolean getTlsEnabled() {
            return this.tlsEnabled;
        }

        public final void setTlsEnabled(Boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
        }

        @Override
        public final Builder tlsEnabled(Boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateMultiRegionClusterRequest build() {
            return new CreateMultiRegionClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MemoryDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateMultiRegionClusterRequest> {
        public Builder multiRegionClusterNameSuffix(String var1);

        public Builder description(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder nodeType(String var1);

        public Builder multiRegionParameterGroupName(String var1);

        public Builder numShards(Integer var1);

        public Builder tlsEnabled(Boolean var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

