/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.AZStatus;
import software.amazon.awssdk.services.memorydb.model.ClusterPendingUpdates;
import software.amazon.awssdk.services.memorydb.model.DataTieringStatus;
import software.amazon.awssdk.services.memorydb.model.Endpoint;
import software.amazon.awssdk.services.memorydb.model.IpDiscovery;
import software.amazon.awssdk.services.memorydb.model.NetworkType;
import software.amazon.awssdk.services.memorydb.model.SecurityGroupMembership;
import software.amazon.awssdk.services.memorydb.model.SecurityGroupMembershipListCopier;
import software.amazon.awssdk.services.memorydb.model.Shard;
import software.amazon.awssdk.services.memorydb.model.ShardListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Cluster
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Cluster> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(Cluster.getter(Cluster::name)).setter(Cluster.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(Cluster.getter(Cluster::description)).setter(Cluster.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(Cluster.getter(Cluster::status)).setter(Cluster.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<ClusterPendingUpdates> PENDING_UPDATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("PendingUpdates").getter(Cluster.getter(Cluster::pendingUpdates)).setter(Cluster.setter(Builder::pendingUpdates)).constructor(ClusterPendingUpdates::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PendingUpdates").build()}).build();
    private static final SdkField<String> MULTI_REGION_CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MultiRegionClusterName").getter(Cluster.getter(Cluster::multiRegionClusterName)).setter(Cluster.setter(Builder::multiRegionClusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MultiRegionClusterName").build()}).build();
    private static final SdkField<Integer> NUMBER_OF_SHARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NumberOfShards").getter(Cluster.getter(Cluster::numberOfShards)).setter(Cluster.setter(Builder::numberOfShards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NumberOfShards").build()}).build();
    private static final SdkField<List<Shard>> SHARDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Shards").getter(Cluster.getter(Cluster::shards)).setter(Cluster.setter(Builder::shards)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Shards").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Shard::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> AVAILABILITY_MODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AvailabilityMode").getter(Cluster.getter(Cluster::availabilityModeAsString)).setter(Cluster.setter(Builder::availabilityMode)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityMode").build()}).build();
    private static final SdkField<Endpoint> CLUSTER_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ClusterEndpoint").getter(Cluster.getter(Cluster::clusterEndpoint)).setter(Cluster.setter(Builder::clusterEndpoint)).constructor(Endpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterEndpoint").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeType").getter(Cluster.getter(Cluster::nodeType)).setter(Cluster.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<String> ENGINE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Engine").getter(Cluster.getter(Cluster::engine)).setter(Cluster.setter(Builder::engine)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Engine").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(Cluster.getter(Cluster::engineVersion)).setter(Cluster.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<String> ENGINE_PATCH_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EnginePatchVersion").getter(Cluster.getter(Cluster::enginePatchVersion)).setter(Cluster.setter(Builder::enginePatchVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnginePatchVersion").build()}).build();
    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterGroupName").getter(Cluster.getter(Cluster::parameterGroupName)).setter(Cluster.setter(Builder::parameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build()}).build();
    private static final SdkField<String> PARAMETER_GROUP_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterGroupStatus").getter(Cluster.getter(Cluster::parameterGroupStatus)).setter(Cluster.setter(Builder::parameterGroupStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupStatus").build()}).build();
    private static final SdkField<List<SecurityGroupMembership>> SECURITY_GROUPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroups").getter(Cluster.getter(Cluster::securityGroups)).setter(Cluster.setter(Builder::securityGroups)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroups").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SecurityGroupMembership::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> SUBNET_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SubnetGroupName").getter(Cluster.getter(Cluster::subnetGroupName)).setter(Cluster.setter(Builder::subnetGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SubnetGroupName").build()}).build();
    private static final SdkField<Boolean> TLS_ENABLED_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("TLSEnabled").getter(Cluster.getter(Cluster::tlsEnabled)).setter(Cluster.setter(Builder::tlsEnabled)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TLSEnabled").build()}).build();
    private static final SdkField<String> KMS_KEY_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("KmsKeyId").getter(Cluster.getter(Cluster::kmsKeyId)).setter(Cluster.setter(Builder::kmsKeyId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyId").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(Cluster.getter(Cluster::arn)).setter(Cluster.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsTopicArn").getter(Cluster.getter(Cluster::snsTopicArn)).setter(Cluster.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()}).build();
    private static final SdkField<String> SNS_TOPIC_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsTopicStatus").getter(Cluster.getter(Cluster::snsTopicStatus)).setter(Cluster.setter(Builder::snsTopicStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicStatus").build()}).build();
    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SnapshotRetentionLimit").getter(Cluster.getter(Cluster::snapshotRetentionLimit)).setter(Cluster.setter(Builder::snapshotRetentionLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build()}).build();
    private static final SdkField<String> MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceWindow").getter(Cluster.getter(Cluster::maintenanceWindow)).setter(Cluster.setter(Builder::maintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceWindow").build()}).build();
    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotWindow").getter(Cluster.getter(Cluster::snapshotWindow)).setter(Cluster.setter(Builder::snapshotWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()}).build();
    private static final SdkField<String> ACL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ACLName").getter(Cluster.getter(Cluster::aclName)).setter(Cluster.setter(Builder::aclName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ACLName").build()}).build();
    private static final SdkField<Boolean> AUTO_MINOR_VERSION_UPGRADE_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("AutoMinorVersionUpgrade").getter(Cluster.getter(Cluster::autoMinorVersionUpgrade)).setter(Cluster.setter(Builder::autoMinorVersionUpgrade)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AutoMinorVersionUpgrade").build()}).build();
    private static final SdkField<String> DATA_TIERING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("DataTiering").getter(Cluster.getter(Cluster::dataTieringAsString)).setter(Cluster.setter(Builder::dataTiering)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DataTiering").build()}).build();
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkType").getter(Cluster.getter(Cluster::networkTypeAsString)).setter(Cluster.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()}).build();
    private static final SdkField<String> IP_DISCOVERY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("IpDiscovery").getter(Cluster.getter(Cluster::ipDiscoveryAsString)).setter(Cluster.setter(Builder::ipDiscovery)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IpDiscovery").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, STATUS_FIELD, PENDING_UPDATES_FIELD, MULTI_REGION_CLUSTER_NAME_FIELD, NUMBER_OF_SHARDS_FIELD, SHARDS_FIELD, AVAILABILITY_MODE_FIELD, CLUSTER_ENDPOINT_FIELD, NODE_TYPE_FIELD, ENGINE_FIELD, ENGINE_VERSION_FIELD, ENGINE_PATCH_VERSION_FIELD, PARAMETER_GROUP_NAME_FIELD, PARAMETER_GROUP_STATUS_FIELD, SECURITY_GROUPS_FIELD, SUBNET_GROUP_NAME_FIELD, TLS_ENABLED_FIELD, KMS_KEY_ID_FIELD, ARN_FIELD, SNS_TOPIC_ARN_FIELD, SNS_TOPIC_STATUS_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, MAINTENANCE_WINDOW_FIELD, SNAPSHOT_WINDOW_FIELD, ACL_NAME_FIELD, AUTO_MINOR_VERSION_UPGRADE_FIELD, DATA_TIERING_FIELD, NETWORK_TYPE_FIELD, IP_DISCOVERY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Cluster.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String description;
    private final String status;
    private final ClusterPendingUpdates pendingUpdates;
    private final String multiRegionClusterName;
    private final Integer numberOfShards;
    private final List<Shard> shards;
    private final String availabilityMode;
    private final Endpoint clusterEndpoint;
    private final String nodeType;
    private final String engine;
    private final String engineVersion;
    private final String enginePatchVersion;
    private final String parameterGroupName;
    private final String parameterGroupStatus;
    private final List<SecurityGroupMembership> securityGroups;
    private final String subnetGroupName;
    private final Boolean tlsEnabled;
    private final String kmsKeyId;
    private final String arn;
    private final String snsTopicArn;
    private final String snsTopicStatus;
    private final Integer snapshotRetentionLimit;
    private final String maintenanceWindow;
    private final String snapshotWindow;
    private final String aclName;
    private final Boolean autoMinorVersionUpgrade;
    private final String dataTiering;
    private final String networkType;
    private final String ipDiscovery;

    private Cluster(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.pendingUpdates = builder.pendingUpdates;
        this.multiRegionClusterName = builder.multiRegionClusterName;
        this.numberOfShards = builder.numberOfShards;
        this.shards = builder.shards;
        this.availabilityMode = builder.availabilityMode;
        this.clusterEndpoint = builder.clusterEndpoint;
        this.nodeType = builder.nodeType;
        this.engine = builder.engine;
        this.engineVersion = builder.engineVersion;
        this.enginePatchVersion = builder.enginePatchVersion;
        this.parameterGroupName = builder.parameterGroupName;
        this.parameterGroupStatus = builder.parameterGroupStatus;
        this.securityGroups = builder.securityGroups;
        this.subnetGroupName = builder.subnetGroupName;
        this.tlsEnabled = builder.tlsEnabled;
        this.kmsKeyId = builder.kmsKeyId;
        this.arn = builder.arn;
        this.snsTopicArn = builder.snsTopicArn;
        this.snsTopicStatus = builder.snsTopicStatus;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.snapshotWindow = builder.snapshotWindow;
        this.aclName = builder.aclName;
        this.autoMinorVersionUpgrade = builder.autoMinorVersionUpgrade;
        this.dataTiering = builder.dataTiering;
        this.networkType = builder.networkType;
        this.ipDiscovery = builder.ipDiscovery;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final String status() {
        return this.status;
    }

    public final ClusterPendingUpdates pendingUpdates() {
        return this.pendingUpdates;
    }

    public final String multiRegionClusterName() {
        return this.multiRegionClusterName;
    }

    public final Integer numberOfShards() {
        return this.numberOfShards;
    }

    public final boolean hasShards() {
        return this.shards != null && !(this.shards instanceof SdkAutoConstructList);
    }

    public final List<Shard> shards() {
        return this.shards;
    }

    public final AZStatus availabilityMode() {
        return AZStatus.fromValue(this.availabilityMode);
    }

    public final String availabilityModeAsString() {
        return this.availabilityMode;
    }

    public final Endpoint clusterEndpoint() {
        return this.clusterEndpoint;
    }

    public final String nodeType() {
        return this.nodeType;
    }

    public final String engine() {
        return this.engine;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final String enginePatchVersion() {
        return this.enginePatchVersion;
    }

    public final String parameterGroupName() {
        return this.parameterGroupName;
    }

    public final String parameterGroupStatus() {
        return this.parameterGroupStatus;
    }

    public final boolean hasSecurityGroups() {
        return this.securityGroups != null && !(this.securityGroups instanceof SdkAutoConstructList);
    }

    public final List<SecurityGroupMembership> securityGroups() {
        return this.securityGroups;
    }

    public final String subnetGroupName() {
        return this.subnetGroupName;
    }

    public final Boolean tlsEnabled() {
        return this.tlsEnabled;
    }

    public final String kmsKeyId() {
        return this.kmsKeyId;
    }

    public final String arn() {
        return this.arn;
    }

    public final String snsTopicArn() {
        return this.snsTopicArn;
    }

    public final String snsTopicStatus() {
        return this.snsTopicStatus;
    }

    public final Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public final String maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public final String snapshotWindow() {
        return this.snapshotWindow;
    }

    public final String aclName() {
        return this.aclName;
    }

    public final Boolean autoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public final DataTieringStatus dataTiering() {
        return DataTieringStatus.fromValue(this.dataTiering);
    }

    public final String dataTieringAsString() {
        return this.dataTiering;
    }

    public final NetworkType networkType() {
        return NetworkType.fromValue(this.networkType);
    }

    public final String networkTypeAsString() {
        return this.networkType;
    }

    public final IpDiscovery ipDiscovery() {
        return IpDiscovery.fromValue(this.ipDiscovery);
    }

    public final String ipDiscoveryAsString() {
        return this.ipDiscovery;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.pendingUpdates());
        hashCode = 31 * hashCode + Objects.hashCode(this.multiRegionClusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.numberOfShards());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasShards() ? this.shards() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.availabilityModeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.engine());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.enginePatchVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroups() ? this.securityGroups() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.subnetGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.tlsEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(this.kmsKeyId());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.aclName());
        hashCode = 31 * hashCode + Objects.hashCode(this.autoMinorVersionUpgrade());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataTieringAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.ipDiscoveryAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Cluster)) {
            return false;
        }
        Cluster other = (Cluster)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.pendingUpdates(), other.pendingUpdates()) && Objects.equals(this.multiRegionClusterName(), other.multiRegionClusterName()) && Objects.equals(this.numberOfShards(), other.numberOfShards()) && this.hasShards() == other.hasShards() && Objects.equals(this.shards(), other.shards()) && Objects.equals(this.availabilityModeAsString(), other.availabilityModeAsString()) && Objects.equals(this.clusterEndpoint(), other.clusterEndpoint()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.engine(), other.engine()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.enginePatchVersion(), other.enginePatchVersion()) && Objects.equals(this.parameterGroupName(), other.parameterGroupName()) && Objects.equals(this.parameterGroupStatus(), other.parameterGroupStatus()) && this.hasSecurityGroups() == other.hasSecurityGroups() && Objects.equals(this.securityGroups(), other.securityGroups()) && Objects.equals(this.subnetGroupName(), other.subnetGroupName()) && Objects.equals(this.tlsEnabled(), other.tlsEnabled()) && Objects.equals(this.kmsKeyId(), other.kmsKeyId()) && Objects.equals(this.arn(), other.arn()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.snsTopicStatus(), other.snsTopicStatus()) && Objects.equals(this.snapshotRetentionLimit(), other.snapshotRetentionLimit()) && Objects.equals(this.maintenanceWindow(), other.maintenanceWindow()) && Objects.equals(this.snapshotWindow(), other.snapshotWindow()) && Objects.equals(this.aclName(), other.aclName()) && Objects.equals(this.autoMinorVersionUpgrade(), other.autoMinorVersionUpgrade()) && Objects.equals(this.dataTieringAsString(), other.dataTieringAsString()) && Objects.equals(this.networkTypeAsString(), other.networkTypeAsString()) && Objects.equals(this.ipDiscoveryAsString(), other.ipDiscoveryAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Cluster").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Status", (Object)this.status()).add("PendingUpdates", (Object)this.pendingUpdates()).add("MultiRegionClusterName", (Object)this.multiRegionClusterName()).add("NumberOfShards", (Object)this.numberOfShards()).add("Shards", this.hasShards() ? this.shards() : null).add("AvailabilityMode", (Object)this.availabilityModeAsString()).add("ClusterEndpoint", (Object)this.clusterEndpoint()).add("NodeType", (Object)this.nodeType()).add("Engine", (Object)this.engine()).add("EngineVersion", (Object)this.engineVersion()).add("EnginePatchVersion", (Object)this.enginePatchVersion()).add("ParameterGroupName", (Object)this.parameterGroupName()).add("ParameterGroupStatus", (Object)this.parameterGroupStatus()).add("SecurityGroups", this.hasSecurityGroups() ? this.securityGroups() : null).add("SubnetGroupName", (Object)this.subnetGroupName()).add("TLSEnabled", (Object)this.tlsEnabled()).add("KmsKeyId", (Object)this.kmsKeyId()).add("ARN", (Object)this.arn()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("SnsTopicStatus", (Object)this.snsTopicStatus()).add("SnapshotRetentionLimit", (Object)this.snapshotRetentionLimit()).add("MaintenanceWindow", (Object)this.maintenanceWindow()).add("SnapshotWindow", (Object)this.snapshotWindow()).add("ACLName", (Object)this.aclName()).add("AutoMinorVersionUpgrade", (Object)this.autoMinorVersionUpgrade()).add("DataTiering", (Object)this.dataTieringAsString()).add("NetworkType", (Object)this.networkTypeAsString()).add("IpDiscovery", (Object)this.ipDiscoveryAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "PendingUpdates": {
                return Optional.ofNullable(clazz.cast(this.pendingUpdates()));
            }
            case "MultiRegionClusterName": {
                return Optional.ofNullable(clazz.cast(this.multiRegionClusterName()));
            }
            case "NumberOfShards": {
                return Optional.ofNullable(clazz.cast(this.numberOfShards()));
            }
            case "Shards": {
                return Optional.ofNullable(clazz.cast(this.shards()));
            }
            case "AvailabilityMode": {
                return Optional.ofNullable(clazz.cast(this.availabilityModeAsString()));
            }
            case "ClusterEndpoint": {
                return Optional.ofNullable(clazz.cast(this.clusterEndpoint()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "Engine": {
                return Optional.ofNullable(clazz.cast(this.engine()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "EnginePatchVersion": {
                return Optional.ofNullable(clazz.cast(this.enginePatchVersion()));
            }
            case "ParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.parameterGroupName()));
            }
            case "ParameterGroupStatus": {
                return Optional.ofNullable(clazz.cast(this.parameterGroupStatus()));
            }
            case "SecurityGroups": {
                return Optional.ofNullable(clazz.cast(this.securityGroups()));
            }
            case "SubnetGroupName": {
                return Optional.ofNullable(clazz.cast(this.subnetGroupName()));
            }
            case "TLSEnabled": {
                return Optional.ofNullable(clazz.cast(this.tlsEnabled()));
            }
            case "KmsKeyId": {
                return Optional.ofNullable(clazz.cast(this.kmsKeyId()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "SnsTopicStatus": {
                return Optional.ofNullable(clazz.cast(this.snsTopicStatus()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "MaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.maintenanceWindow()));
            }
            case "SnapshotWindow": {
                return Optional.ofNullable(clazz.cast(this.snapshotWindow()));
            }
            case "ACLName": {
                return Optional.ofNullable(clazz.cast(this.aclName()));
            }
            case "AutoMinorVersionUpgrade": {
                return Optional.ofNullable(clazz.cast(this.autoMinorVersionUpgrade()));
            }
            case "DataTiering": {
                return Optional.ofNullable(clazz.cast(this.dataTieringAsString()));
            }
            case "NetworkType": {
                return Optional.ofNullable(clazz.cast(this.networkTypeAsString()));
            }
            case "IpDiscovery": {
                return Optional.ofNullable(clazz.cast(this.ipDiscoveryAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Name", NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("Status", STATUS_FIELD);
        map.put("PendingUpdates", PENDING_UPDATES_FIELD);
        map.put("MultiRegionClusterName", MULTI_REGION_CLUSTER_NAME_FIELD);
        map.put("NumberOfShards", NUMBER_OF_SHARDS_FIELD);
        map.put("Shards", SHARDS_FIELD);
        map.put("AvailabilityMode", AVAILABILITY_MODE_FIELD);
        map.put("ClusterEndpoint", CLUSTER_ENDPOINT_FIELD);
        map.put("NodeType", NODE_TYPE_FIELD);
        map.put("Engine", ENGINE_FIELD);
        map.put("EngineVersion", ENGINE_VERSION_FIELD);
        map.put("EnginePatchVersion", ENGINE_PATCH_VERSION_FIELD);
        map.put("ParameterGroupName", PARAMETER_GROUP_NAME_FIELD);
        map.put("ParameterGroupStatus", PARAMETER_GROUP_STATUS_FIELD);
        map.put("SecurityGroups", SECURITY_GROUPS_FIELD);
        map.put("SubnetGroupName", SUBNET_GROUP_NAME_FIELD);
        map.put("TLSEnabled", TLS_ENABLED_FIELD);
        map.put("KmsKeyId", KMS_KEY_ID_FIELD);
        map.put("ARN", ARN_FIELD);
        map.put("SnsTopicArn", SNS_TOPIC_ARN_FIELD);
        map.put("SnsTopicStatus", SNS_TOPIC_STATUS_FIELD);
        map.put("SnapshotRetentionLimit", SNAPSHOT_RETENTION_LIMIT_FIELD);
        map.put("MaintenanceWindow", MAINTENANCE_WINDOW_FIELD);
        map.put("SnapshotWindow", SNAPSHOT_WINDOW_FIELD);
        map.put("ACLName", ACL_NAME_FIELD);
        map.put("AutoMinorVersionUpgrade", AUTO_MINOR_VERSION_UPGRADE_FIELD);
        map.put("DataTiering", DATA_TIERING_FIELD);
        map.put("NetworkType", NETWORK_TYPE_FIELD);
        map.put("IpDiscovery", IP_DISCOVERY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Cluster, T> g) {
        return obj -> g.apply((Cluster)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String status;
        private ClusterPendingUpdates pendingUpdates;
        private String multiRegionClusterName;
        private Integer numberOfShards;
        private List<Shard> shards = DefaultSdkAutoConstructList.getInstance();
        private String availabilityMode;
        private Endpoint clusterEndpoint;
        private String nodeType;
        private String engine;
        private String engineVersion;
        private String enginePatchVersion;
        private String parameterGroupName;
        private String parameterGroupStatus;
        private List<SecurityGroupMembership> securityGroups = DefaultSdkAutoConstructList.getInstance();
        private String subnetGroupName;
        private Boolean tlsEnabled;
        private String kmsKeyId;
        private String arn;
        private String snsTopicArn;
        private String snsTopicStatus;
        private Integer snapshotRetentionLimit;
        private String maintenanceWindow;
        private String snapshotWindow;
        private String aclName;
        private Boolean autoMinorVersionUpgrade;
        private String dataTiering;
        private String networkType;
        private String ipDiscovery;

        private BuilderImpl() {
        }

        private BuilderImpl(Cluster model) {
            this.name(model.name);
            this.description(model.description);
            this.status(model.status);
            this.pendingUpdates(model.pendingUpdates);
            this.multiRegionClusterName(model.multiRegionClusterName);
            this.numberOfShards(model.numberOfShards);
            this.shards(model.shards);
            this.availabilityMode(model.availabilityMode);
            this.clusterEndpoint(model.clusterEndpoint);
            this.nodeType(model.nodeType);
            this.engine(model.engine);
            this.engineVersion(model.engineVersion);
            this.enginePatchVersion(model.enginePatchVersion);
            this.parameterGroupName(model.parameterGroupName);
            this.parameterGroupStatus(model.parameterGroupStatus);
            this.securityGroups(model.securityGroups);
            this.subnetGroupName(model.subnetGroupName);
            this.tlsEnabled(model.tlsEnabled);
            this.kmsKeyId(model.kmsKeyId);
            this.arn(model.arn);
            this.snsTopicArn(model.snsTopicArn);
            this.snsTopicStatus(model.snsTopicStatus);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.maintenanceWindow(model.maintenanceWindow);
            this.snapshotWindow(model.snapshotWindow);
            this.aclName(model.aclName);
            this.autoMinorVersionUpgrade(model.autoMinorVersionUpgrade);
            this.dataTiering(model.dataTiering);
            this.networkType(model.networkType);
            this.ipDiscovery(model.ipDiscovery);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final ClusterPendingUpdates.Builder getPendingUpdates() {
            return this.pendingUpdates != null ? this.pendingUpdates.toBuilder() : null;
        }

        public final void setPendingUpdates(ClusterPendingUpdates.BuilderImpl pendingUpdates) {
            this.pendingUpdates = pendingUpdates != null ? pendingUpdates.build() : null;
        }

        @Override
        public final Builder pendingUpdates(ClusterPendingUpdates pendingUpdates) {
            this.pendingUpdates = pendingUpdates;
            return this;
        }

        public final String getMultiRegionClusterName() {
            return this.multiRegionClusterName;
        }

        public final void setMultiRegionClusterName(String multiRegionClusterName) {
            this.multiRegionClusterName = multiRegionClusterName;
        }

        @Override
        public final Builder multiRegionClusterName(String multiRegionClusterName) {
            this.multiRegionClusterName = multiRegionClusterName;
            return this;
        }

        public final Integer getNumberOfShards() {
            return this.numberOfShards;
        }

        public final void setNumberOfShards(Integer numberOfShards) {
            this.numberOfShards = numberOfShards;
        }

        @Override
        public final Builder numberOfShards(Integer numberOfShards) {
            this.numberOfShards = numberOfShards;
            return this;
        }

        public final List<Shard.Builder> getShards() {
            List<Shard.Builder> result = ShardListCopier.copyToBuilder(this.shards);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setShards(Collection<Shard.BuilderImpl> shards) {
            this.shards = ShardListCopier.copyFromBuilder(shards);
        }

        @Override
        public final Builder shards(Collection<Shard> shards) {
            this.shards = ShardListCopier.copy(shards);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Shard ... shards) {
            this.shards(Arrays.asList(shards));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder shards(Consumer<Shard.Builder> ... shards) {
            this.shards(Stream.of(shards).map(c -> (Shard)((Shard.Builder)Shard.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getAvailabilityMode() {
            return this.availabilityMode;
        }

        public final void setAvailabilityMode(String availabilityMode) {
            this.availabilityMode = availabilityMode;
        }

        @Override
        public final Builder availabilityMode(String availabilityMode) {
            this.availabilityMode = availabilityMode;
            return this;
        }

        @Override
        public final Builder availabilityMode(AZStatus availabilityMode) {
            this.availabilityMode(availabilityMode == null ? null : availabilityMode.toString());
            return this;
        }

        public final Endpoint.Builder getClusterEndpoint() {
            return this.clusterEndpoint != null ? this.clusterEndpoint.toBuilder() : null;
        }

        public final void setClusterEndpoint(Endpoint.BuilderImpl clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint != null ? clusterEndpoint.build() : null;
        }

        @Override
        public final Builder clusterEndpoint(Endpoint clusterEndpoint) {
            this.clusterEndpoint = clusterEndpoint;
            return this;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final String getEngine() {
            return this.engine;
        }

        public final void setEngine(String engine) {
            this.engine = engine;
        }

        @Override
        public final Builder engine(String engine) {
            this.engine = engine;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final String getEnginePatchVersion() {
            return this.enginePatchVersion;
        }

        public final void setEnginePatchVersion(String enginePatchVersion) {
            this.enginePatchVersion = enginePatchVersion;
        }

        @Override
        public final Builder enginePatchVersion(String enginePatchVersion) {
            this.enginePatchVersion = enginePatchVersion;
            return this;
        }

        public final String getParameterGroupName() {
            return this.parameterGroupName;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        @Override
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final String getParameterGroupStatus() {
            return this.parameterGroupStatus;
        }

        public final void setParameterGroupStatus(String parameterGroupStatus) {
            this.parameterGroupStatus = parameterGroupStatus;
        }

        @Override
        public final Builder parameterGroupStatus(String parameterGroupStatus) {
            this.parameterGroupStatus = parameterGroupStatus;
            return this;
        }

        public final List<SecurityGroupMembership.Builder> getSecurityGroups() {
            List<SecurityGroupMembership.Builder> result = SecurityGroupMembershipListCopier.copyToBuilder(this.securityGroups);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSecurityGroups(Collection<SecurityGroupMembership.BuilderImpl> securityGroups) {
            this.securityGroups = SecurityGroupMembershipListCopier.copyFromBuilder(securityGroups);
        }

        @Override
        public final Builder securityGroups(Collection<SecurityGroupMembership> securityGroups) {
            this.securityGroups = SecurityGroupMembershipListCopier.copy(securityGroups);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(SecurityGroupMembership ... securityGroups) {
            this.securityGroups(Arrays.asList(securityGroups));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder securityGroups(Consumer<SecurityGroupMembership.Builder> ... securityGroups) {
            this.securityGroups(Stream.of(securityGroups).map(c -> (SecurityGroupMembership)((SecurityGroupMembership.Builder)SecurityGroupMembership.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getSubnetGroupName() {
            return this.subnetGroupName;
        }

        public final void setSubnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
        }

        @Override
        public final Builder subnetGroupName(String subnetGroupName) {
            this.subnetGroupName = subnetGroupName;
            return this;
        }

        public final Boolean getTlsEnabled() {
            return this.tlsEnabled;
        }

        public final void setTlsEnabled(Boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
        }

        @Override
        public final Builder tlsEnabled(Boolean tlsEnabled) {
            this.tlsEnabled = tlsEnabled;
            return this;
        }

        public final String getKmsKeyId() {
            return this.kmsKeyId;
        }

        public final void setKmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
        }

        @Override
        public final Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final String getSnsTopicStatus() {
            return this.snsTopicStatus;
        }

        public final void setSnsTopicStatus(String snsTopicStatus) {
            this.snsTopicStatus = snsTopicStatus;
        }

        @Override
        public final Builder snsTopicStatus(String snsTopicStatus) {
            this.snsTopicStatus = snsTopicStatus;
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getMaintenanceWindow() {
            return this.maintenanceWindow;
        }

        public final void setMaintenanceWindow(String maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
        }

        @Override
        public final Builder maintenanceWindow(String maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        @Override
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final String getAclName() {
            return this.aclName;
        }

        public final void setAclName(String aclName) {
            this.aclName = aclName;
        }

        @Override
        public final Builder aclName(String aclName) {
            this.aclName = aclName;
            return this;
        }

        public final Boolean getAutoMinorVersionUpgrade() {
            return this.autoMinorVersionUpgrade;
        }

        public final void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        }

        @Override
        public final Builder autoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
            this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
            return this;
        }

        public final String getDataTiering() {
            return this.dataTiering;
        }

        public final void setDataTiering(String dataTiering) {
            this.dataTiering = dataTiering;
        }

        @Override
        public final Builder dataTiering(String dataTiering) {
            this.dataTiering = dataTiering;
            return this;
        }

        @Override
        public final Builder dataTiering(DataTieringStatus dataTiering) {
            this.dataTiering(dataTiering == null ? null : dataTiering.toString());
            return this;
        }

        public final String getNetworkType() {
            return this.networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(NetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        public final String getIpDiscovery() {
            return this.ipDiscovery;
        }

        public final void setIpDiscovery(String ipDiscovery) {
            this.ipDiscovery = ipDiscovery;
        }

        @Override
        public final Builder ipDiscovery(String ipDiscovery) {
            this.ipDiscovery = ipDiscovery;
            return this;
        }

        @Override
        public final Builder ipDiscovery(IpDiscovery ipDiscovery) {
            this.ipDiscovery(ipDiscovery == null ? null : ipDiscovery.toString());
            return this;
        }

        public Cluster build() {
            return new Cluster(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Cluster> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder status(String var1);

        public Builder pendingUpdates(ClusterPendingUpdates var1);

        default public Builder pendingUpdates(Consumer<ClusterPendingUpdates.Builder> pendingUpdates) {
            return this.pendingUpdates((ClusterPendingUpdates)((ClusterPendingUpdates.Builder)ClusterPendingUpdates.builder().applyMutation(pendingUpdates)).build());
        }

        public Builder multiRegionClusterName(String var1);

        public Builder numberOfShards(Integer var1);

        public Builder shards(Collection<Shard> var1);

        public Builder shards(Shard ... var1);

        public Builder shards(Consumer<Shard.Builder> ... var1);

        public Builder availabilityMode(String var1);

        public Builder availabilityMode(AZStatus var1);

        public Builder clusterEndpoint(Endpoint var1);

        default public Builder clusterEndpoint(Consumer<Endpoint.Builder> clusterEndpoint) {
            return this.clusterEndpoint((Endpoint)((Endpoint.Builder)Endpoint.builder().applyMutation(clusterEndpoint)).build());
        }

        public Builder nodeType(String var1);

        public Builder engine(String var1);

        public Builder engineVersion(String var1);

        public Builder enginePatchVersion(String var1);

        public Builder parameterGroupName(String var1);

        public Builder parameterGroupStatus(String var1);

        public Builder securityGroups(Collection<SecurityGroupMembership> var1);

        public Builder securityGroups(SecurityGroupMembership ... var1);

        public Builder securityGroups(Consumer<SecurityGroupMembership.Builder> ... var1);

        public Builder subnetGroupName(String var1);

        public Builder tlsEnabled(Boolean var1);

        public Builder kmsKeyId(String var1);

        public Builder arn(String var1);

        public Builder snsTopicArn(String var1);

        public Builder snsTopicStatus(String var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder maintenanceWindow(String var1);

        public Builder snapshotWindow(String var1);

        public Builder aclName(String var1);

        public Builder autoMinorVersionUpgrade(Boolean var1);

        public Builder dataTiering(String var1);

        public Builder dataTiering(DataTieringStatus var1);

        public Builder networkType(String var1);

        public Builder networkType(NetworkType var1);

        public Builder ipDiscovery(String var1);

        public Builder ipDiscovery(IpDiscovery var1);
    }
}

