/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.MemoryDbRequest;
import software.amazon.awssdk.services.memorydb.model.Tag;
import software.amazon.awssdk.services.memorydb.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PurchaseReservedNodesOfferingRequest
extends MemoryDbRequest
implements ToCopyableBuilder<Builder, PurchaseReservedNodesOfferingRequest> {
    private static final SdkField<String> RESERVED_NODES_OFFERING_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservedNodesOfferingId").getter(PurchaseReservedNodesOfferingRequest.getter(PurchaseReservedNodesOfferingRequest::reservedNodesOfferingId)).setter(PurchaseReservedNodesOfferingRequest.setter(Builder::reservedNodesOfferingId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservedNodesOfferingId").build()}).build();
    private static final SdkField<String> RESERVATION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ReservationId").getter(PurchaseReservedNodesOfferingRequest.getter(PurchaseReservedNodesOfferingRequest::reservationId)).setter(PurchaseReservedNodesOfferingRequest.setter(Builder::reservationId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReservationId").build()}).build();
    private static final SdkField<Integer> NODE_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("NodeCount").getter(PurchaseReservedNodesOfferingRequest.getter(PurchaseReservedNodesOfferingRequest::nodeCount)).setter(PurchaseReservedNodesOfferingRequest.setter(Builder::nodeCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeCount").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(PurchaseReservedNodesOfferingRequest.getter(PurchaseReservedNodesOfferingRequest::tags)).setter(PurchaseReservedNodesOfferingRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESERVED_NODES_OFFERING_ID_FIELD, RESERVATION_ID_FIELD, NODE_COUNT_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = PurchaseReservedNodesOfferingRequest.memberNameToFieldInitializer();
    private final String reservedNodesOfferingId;
    private final String reservationId;
    private final Integer nodeCount;
    private final List<Tag> tags;

    private PurchaseReservedNodesOfferingRequest(BuilderImpl builder) {
        super(builder);
        this.reservedNodesOfferingId = builder.reservedNodesOfferingId;
        this.reservationId = builder.reservationId;
        this.nodeCount = builder.nodeCount;
        this.tags = builder.tags;
    }

    public final String reservedNodesOfferingId() {
        return this.reservedNodesOfferingId;
    }

    public final String reservationId() {
        return this.reservationId;
    }

    public final Integer nodeCount() {
        return this.nodeCount;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.reservedNodesOfferingId());
        hashCode = 31 * hashCode + Objects.hashCode(this.reservationId());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PurchaseReservedNodesOfferingRequest)) {
            return false;
        }
        PurchaseReservedNodesOfferingRequest other = (PurchaseReservedNodesOfferingRequest)((Object)obj);
        return Objects.equals(this.reservedNodesOfferingId(), other.reservedNodesOfferingId()) && Objects.equals(this.reservationId(), other.reservationId()) && Objects.equals(this.nodeCount(), other.nodeCount()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"PurchaseReservedNodesOfferingRequest").add("ReservedNodesOfferingId", (Object)this.reservedNodesOfferingId()).add("ReservationId", (Object)this.reservationId()).add("NodeCount", (Object)this.nodeCount()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ReservedNodesOfferingId": {
                return Optional.ofNullable(clazz.cast(this.reservedNodesOfferingId()));
            }
            case "ReservationId": {
                return Optional.ofNullable(clazz.cast(this.reservationId()));
            }
            case "NodeCount": {
                return Optional.ofNullable(clazz.cast(this.nodeCount()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ReservedNodesOfferingId", RESERVED_NODES_OFFERING_ID_FIELD);
        map.put("ReservationId", RESERVATION_ID_FIELD);
        map.put("NodeCount", NODE_COUNT_FIELD);
        map.put("Tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PurchaseReservedNodesOfferingRequest, T> g) {
        return obj -> g.apply((PurchaseReservedNodesOfferingRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbRequest.BuilderImpl
    implements Builder {
        private String reservedNodesOfferingId;
        private String reservationId;
        private Integer nodeCount;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PurchaseReservedNodesOfferingRequest model) {
            super(model);
            this.reservedNodesOfferingId(model.reservedNodesOfferingId);
            this.reservationId(model.reservationId);
            this.nodeCount(model.nodeCount);
            this.tags(model.tags);
        }

        public final String getReservedNodesOfferingId() {
            return this.reservedNodesOfferingId;
        }

        public final void setReservedNodesOfferingId(String reservedNodesOfferingId) {
            this.reservedNodesOfferingId = reservedNodesOfferingId;
        }

        @Override
        public final Builder reservedNodesOfferingId(String reservedNodesOfferingId) {
            this.reservedNodesOfferingId = reservedNodesOfferingId;
            return this;
        }

        public final String getReservationId() {
            return this.reservationId;
        }

        public final void setReservationId(String reservationId) {
            this.reservationId = reservationId;
        }

        @Override
        public final Builder reservationId(String reservationId) {
            this.reservationId = reservationId;
            return this;
        }

        public final Integer getNodeCount() {
            return this.nodeCount;
        }

        public final void setNodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
        }

        @Override
        public final Builder nodeCount(Integer nodeCount) {
            this.nodeCount = nodeCount;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public PurchaseReservedNodesOfferingRequest build() {
            return new PurchaseReservedNodesOfferingRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends MemoryDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, PurchaseReservedNodesOfferingRequest> {
        public Builder reservedNodesOfferingId(String var1);

        public Builder reservationId(String var1);

        public Builder nodeCount(Integer var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

