/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.InputAuthenticationType;
import software.amazon.awssdk.services.memorydb.model.PasswordListInputCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AuthenticationMode
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AuthenticationMode> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Type").getter(AuthenticationMode.getter(AuthenticationMode::typeAsString)).setter(AuthenticationMode.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Type").build()}).build();
    private static final SdkField<List<String>> PASSWORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Passwords").getter(AuthenticationMode.getter(AuthenticationMode::passwords)).setter(AuthenticationMode.setter(Builder::passwords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Passwords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PASSWORDS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("Type", TYPE_FIELD);
            this.put("Passwords", PASSWORDS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String type;
    private final List<String> passwords;

    private AuthenticationMode(BuilderImpl builder) {
        this.type = builder.type;
        this.passwords = builder.passwords;
    }

    public final InputAuthenticationType type() {
        return InputAuthenticationType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasPasswords() {
        return this.passwords != null && !(this.passwords instanceof SdkAutoConstructList);
    }

    public final List<String> passwords() {
        return this.passwords;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPasswords() ? this.passwords() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthenticationMode)) {
            return false;
        }
        AuthenticationMode other = (AuthenticationMode)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasPasswords() == other.hasPasswords() && Objects.equals(this.passwords(), other.passwords());
    }

    public final String toString() {
        return ToString.builder((String)"AuthenticationMode").add("Type", (Object)this.typeAsString()).add("Passwords", this.hasPasswords() ? this.passwords() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "Passwords": {
                return Optional.ofNullable(clazz.cast(this.passwords()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AuthenticationMode, T> g) {
        return obj -> g.apply((AuthenticationMode)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private List<String> passwords = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AuthenticationMode model) {
            this.type(model.type);
            this.passwords(model.passwords);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(InputAuthenticationType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Collection<String> getPasswords() {
            if (this.passwords instanceof SdkAutoConstructList) {
                return null;
            }
            return this.passwords;
        }

        public final void setPasswords(Collection<String> passwords) {
            this.passwords = PasswordListInputCopier.copy(passwords);
        }

        @Override
        public final Builder passwords(Collection<String> passwords) {
            this.passwords = PasswordListInputCopier.copy(passwords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder passwords(String ... passwords) {
            this.passwords(Arrays.asList(passwords));
            return this;
        }

        public AuthenticationMode build() {
            return new AuthenticationMode(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AuthenticationMode> {
        public Builder type(String var1);

        public Builder type(InputAuthenticationType var1);

        public Builder passwords(Collection<String> var1);

        public Builder passwords(String ... var1);
    }
}

