/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.ACLNameListCopier;
import software.amazon.awssdk.services.memorydb.model.Authentication;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class User
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, User> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(User.getter(User::name)).setter(User.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Status").getter(User.getter(User::status)).setter(User.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<String> ACCESS_STRING_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessString").getter(User.getter(User::accessString)).setter(User.setter(Builder::accessString)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessString").build()}).build();
    private static final SdkField<List<String>> ACL_NAMES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ACLNames").getter(User.getter(User::aclNames)).setter(User.setter(Builder::aclNames)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ACLNames").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MINIMUM_ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MinimumEngineVersion").getter(User.getter(User::minimumEngineVersion)).setter(User.setter(Builder::minimumEngineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MinimumEngineVersion").build()}).build();
    private static final SdkField<Authentication> AUTHENTICATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("Authentication").getter(User.getter(User::authentication)).setter(User.setter(Builder::authentication)).constructor(Authentication::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Authentication").build()}).build();
    private static final SdkField<String> ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ARN").getter(User.getter(User::arn)).setter(User.setter(Builder::arn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ARN").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD, ACCESS_STRING_FIELD, ACL_NAMES_FIELD, MINIMUM_ENGINE_VERSION_FIELD, AUTHENTICATION_FIELD, ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String name;
    private final String status;
    private final String accessString;
    private final List<String> aclNames;
    private final String minimumEngineVersion;
    private final Authentication authentication;
    private final String arn;

    private User(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.accessString = builder.accessString;
        this.aclNames = builder.aclNames;
        this.minimumEngineVersion = builder.minimumEngineVersion;
        this.authentication = builder.authentication;
        this.arn = builder.arn;
    }

    public final String name() {
        return this.name;
    }

    public final String status() {
        return this.status;
    }

    public final String accessString() {
        return this.accessString;
    }

    public final boolean hasAclNames() {
        return this.aclNames != null && !(this.aclNames instanceof SdkAutoConstructList);
    }

    public final List<String> aclNames() {
        return this.aclNames;
    }

    public final String minimumEngineVersion() {
        return this.minimumEngineVersion;
    }

    public final Authentication authentication() {
        return this.authentication;
    }

    public final String arn() {
        return this.arn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.status());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAclNames() ? this.aclNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.minimumEngineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.authentication());
        hashCode = 31 * hashCode + Objects.hashCode(this.arn());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof User)) {
            return false;
        }
        User other = (User)obj;
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.status(), other.status()) && Objects.equals(this.accessString(), other.accessString()) && this.hasAclNames() == other.hasAclNames() && Objects.equals(this.aclNames(), other.aclNames()) && Objects.equals(this.minimumEngineVersion(), other.minimumEngineVersion()) && Objects.equals(this.authentication(), other.authentication()) && Objects.equals(this.arn(), other.arn());
    }

    public final String toString() {
        return ToString.builder((String)"User").add("Name", (Object)this.name()).add("Status", (Object)this.status()).add("AccessString", (Object)this.accessString()).add("ACLNames", this.hasAclNames() ? this.aclNames() : null).add("MinimumEngineVersion", (Object)this.minimumEngineVersion()).add("Authentication", (Object)this.authentication()).add("ARN", (Object)this.arn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.status()));
            }
            case "AccessString": {
                return Optional.ofNullable(clazz.cast(this.accessString()));
            }
            case "ACLNames": {
                return Optional.ofNullable(clazz.cast(this.aclNames()));
            }
            case "MinimumEngineVersion": {
                return Optional.ofNullable(clazz.cast(this.minimumEngineVersion()));
            }
            case "Authentication": {
                return Optional.ofNullable(clazz.cast(this.authentication()));
            }
            case "ARN": {
                return Optional.ofNullable(clazz.cast(this.arn()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<User, T> g) {
        return obj -> g.apply((User)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String name;
        private String status;
        private String accessString;
        private List<String> aclNames = DefaultSdkAutoConstructList.getInstance();
        private String minimumEngineVersion;
        private Authentication authentication;
        private String arn;

        private BuilderImpl() {
        }

        private BuilderImpl(User model) {
            this.name(model.name);
            this.status(model.status);
            this.accessString(model.accessString);
            this.aclNames(model.aclNames);
            this.minimumEngineVersion(model.minimumEngineVersion);
            this.authentication(model.authentication);
            this.arn(model.arn);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        public final String getAccessString() {
            return this.accessString;
        }

        public final void setAccessString(String accessString) {
            this.accessString = accessString;
        }

        @Override
        public final Builder accessString(String accessString) {
            this.accessString = accessString;
            return this;
        }

        public final Collection<String> getAclNames() {
            if (this.aclNames instanceof SdkAutoConstructList) {
                return null;
            }
            return this.aclNames;
        }

        public final void setAclNames(Collection<String> aclNames) {
            this.aclNames = ACLNameListCopier.copy(aclNames);
        }

        @Override
        public final Builder aclNames(Collection<String> aclNames) {
            this.aclNames = ACLNameListCopier.copy(aclNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder aclNames(String ... aclNames) {
            this.aclNames(Arrays.asList(aclNames));
            return this;
        }

        public final String getMinimumEngineVersion() {
            return this.minimumEngineVersion;
        }

        public final void setMinimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
        }

        @Override
        public final Builder minimumEngineVersion(String minimumEngineVersion) {
            this.minimumEngineVersion = minimumEngineVersion;
            return this;
        }

        public final Authentication.Builder getAuthentication() {
            return this.authentication != null ? this.authentication.toBuilder() : null;
        }

        public final void setAuthentication(Authentication.BuilderImpl authentication) {
            this.authentication = authentication != null ? authentication.build() : null;
        }

        @Override
        public final Builder authentication(Authentication authentication) {
            this.authentication = authentication;
            return this;
        }

        public final String getArn() {
            return this.arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public User build() {
            return new User(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, User> {
        public Builder name(String var1);

        public Builder status(String var1);

        public Builder accessString(String var1);

        public Builder aclNames(Collection<String> var1);

        public Builder aclNames(String ... var1);

        public Builder minimumEngineVersion(String var1);

        public Builder authentication(Authentication var1);

        default public Builder authentication(Consumer<Authentication.Builder> authentication) {
            return this.authentication((Authentication)((Authentication.Builder)Authentication.builder().applyMutation(authentication)).build());
        }

        public Builder arn(String var1);
    }
}

