/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.memorydb.DefaultMemoryDbBaseClientBuilder;
import software.amazon.awssdk.services.memorydb.DefaultMemoryDbClient;
import software.amazon.awssdk.services.memorydb.MemoryDbClient;
import software.amazon.awssdk.services.memorydb.MemoryDbClientBuilder;
import software.amazon.awssdk.services.memorydb.MemoryDbServiceClientConfiguration;
import software.amazon.awssdk.services.memorydb.endpoints.MemoryDbEndpointProvider;

@SdkInternalApi
final class DefaultMemoryDbClientBuilder
extends DefaultMemoryDbBaseClientBuilder<MemoryDbClientBuilder, MemoryDbClient>
implements MemoryDbClientBuilder {
    DefaultMemoryDbClientBuilder() {
    }

    @Override
    public DefaultMemoryDbClientBuilder endpointProvider(MemoryDbEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final MemoryDbClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.syncClientConfiguration();
        DefaultMemoryDbClientBuilder.validateClientOptions(clientConfiguration);
        MemoryDbServiceClientConfiguration serviceClientConfiguration = MemoryDbServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfiguration.option((ClientOption)AwsClientOption.AWS_REGION)).build();
        return new DefaultMemoryDbClient(serviceClientConfiguration, clientConfiguration);
    }
}

