/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.memorydb.MemoryDbClient;
import software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeServiceUpdatesResponse;
import software.amazon.awssdk.services.memorydb.model.ServiceUpdate;

public class DescribeServiceUpdatesIterable
implements SdkIterable<DescribeServiceUpdatesResponse> {
    private final MemoryDbClient client;
    private final DescribeServiceUpdatesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public DescribeServiceUpdatesIterable(MemoryDbClient client, DescribeServiceUpdatesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new DescribeServiceUpdatesResponseFetcher();
    }

    public Iterator<DescribeServiceUpdatesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ServiceUpdate> serviceUpdates() {
        Function<DescribeServiceUpdatesResponse, Iterator> getIterator = response -> {
            if (response != null && response.serviceUpdates() != null) {
                return response.serviceUpdates().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class DescribeServiceUpdatesResponseFetcher
    implements SyncPageFetcher<DescribeServiceUpdatesResponse> {
        private DescribeServiceUpdatesResponseFetcher() {
        }

        public boolean hasNextPage(DescribeServiceUpdatesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public DescribeServiceUpdatesResponse nextPage(DescribeServiceUpdatesResponse previousPage) {
            if (previousPage == null) {
                return DescribeServiceUpdatesIterable.this.client.describeServiceUpdates(DescribeServiceUpdatesIterable.this.firstRequest);
            }
            return DescribeServiceUpdatesIterable.this.client.describeServiceUpdates((DescribeServiceUpdatesRequest)((Object)DescribeServiceUpdatesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

