/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.memorydb.MemoryDbAsyncClient;
import software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsRequest;
import software.amazon.awssdk.services.memorydb.model.DescribeSubnetGroupsResponse;
import software.amazon.awssdk.services.memorydb.model.SubnetGroup;

public class DescribeSubnetGroupsPublisher
implements SdkPublisher<DescribeSubnetGroupsResponse> {
    private final MemoryDbAsyncClient client;
    private final DescribeSubnetGroupsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeSubnetGroupsPublisher(MemoryDbAsyncClient client, DescribeSubnetGroupsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeSubnetGroupsPublisher(MemoryDbAsyncClient client, DescribeSubnetGroupsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeSubnetGroupsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeSubnetGroupsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<SubnetGroup> subnetGroups() {
        Function<DescribeSubnetGroupsResponse, Iterator> getIterator = response -> {
            if (response != null && response.subnetGroups() != null) {
                return response.subnetGroups().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeSubnetGroupsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeSubnetGroupsResponseFetcher
    implements AsyncPageFetcher<DescribeSubnetGroupsResponse> {
        private DescribeSubnetGroupsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeSubnetGroupsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeSubnetGroupsResponse> nextPage(DescribeSubnetGroupsResponse previousPage) {
            if (previousPage == null) {
                return DescribeSubnetGroupsPublisher.this.client.describeSubnetGroups(DescribeSubnetGroupsPublisher.this.firstRequest);
            }
            return DescribeSubnetGroupsPublisher.this.client.describeSubnetGroups((DescribeSubnetGroupsRequest)((Object)DescribeSubnetGroupsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

