/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.ACL;
import software.amazon.awssdk.services.memorydb.model.ACLListCopier;
import software.amazon.awssdk.services.memorydb.model.MemoryDbResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeAcLsResponse
extends MemoryDbResponse
implements ToCopyableBuilder<Builder, DescribeAcLsResponse> {
    private static final SdkField<List<ACL>> AC_LS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("ACLs").getter(DescribeAcLsResponse.getter(DescribeAcLsResponse::acLs)).setter(DescribeAcLsResponse.setter(Builder::acLs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ACLs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ACL::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeAcLsResponse.getter(DescribeAcLsResponse::nextToken)).setter(DescribeAcLsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AC_LS_FIELD, NEXT_TOKEN_FIELD));
    private final List<ACL> acLs;
    private final String nextToken;

    private DescribeAcLsResponse(BuilderImpl builder) {
        super(builder);
        this.acLs = builder.acLs;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasAcLs() {
        return this.acLs != null && !(this.acLs instanceof SdkAutoConstructList);
    }

    public final List<ACL> acLs() {
        return this.acLs;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAcLs() ? this.acLs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeAcLsResponse)) {
            return false;
        }
        DescribeAcLsResponse other = (DescribeAcLsResponse)((Object)obj);
        return this.hasAcLs() == other.hasAcLs() && Objects.equals(this.acLs(), other.acLs()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeAcLsResponse").add("ACLs", this.hasAcLs() ? this.acLs() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ACLs": {
                return Optional.ofNullable(clazz.cast(this.acLs()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DescribeAcLsResponse, T> g) {
        return obj -> g.apply((DescribeAcLsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbResponse.BuilderImpl
    implements Builder {
        private List<ACL> acLs = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeAcLsResponse model) {
            super(model);
            this.acLs(model.acLs);
            this.nextToken(model.nextToken);
        }

        public final List<ACL.Builder> getAcLs() {
            List<ACL.Builder> result = ACLListCopier.copyToBuilder(this.acLs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAcLs(Collection<ACL.BuilderImpl> acLs) {
            this.acLs = ACLListCopier.copyFromBuilder(acLs);
        }

        @Override
        @Transient
        public final Builder acLs(Collection<ACL> acLs) {
            this.acLs = ACLListCopier.copy(acLs);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder acLs(ACL ... acLs) {
            this.acLs(Arrays.asList(acLs));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder acLs(Consumer<ACL.Builder> ... acLs) {
            this.acLs(Stream.of(acLs).map(c -> (ACL)((ACL.Builder)ACL.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeAcLsResponse build() {
            return new DescribeAcLsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MemoryDbResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeAcLsResponse> {
        public Builder acLs(Collection<ACL> var1);

        public Builder acLs(ACL ... var1);

        public Builder acLs(Consumer<ACL.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

