/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.memorydb.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.memorydb.model.MemoryDbRequest;
import software.amazon.awssdk.services.memorydb.model.ReplicaConfigurationRequest;
import software.amazon.awssdk.services.memorydb.model.SecurityGroupIdsListCopier;
import software.amazon.awssdk.services.memorydb.model.ShardConfigurationRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateClusterRequest
extends MemoryDbRequest
implements ToCopyableBuilder<Builder, UpdateClusterRequest> {
    private static final SdkField<String> CLUSTER_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClusterName").getter(UpdateClusterRequest.getter(UpdateClusterRequest::clusterName)).setter(UpdateClusterRequest.setter(Builder::clusterName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClusterName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(UpdateClusterRequest.getter(UpdateClusterRequest::description)).setter(UpdateClusterRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<List<String>> SECURITY_GROUP_IDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("SecurityGroupIds").getter(UpdateClusterRequest.getter(UpdateClusterRequest::securityGroupIds)).setter(UpdateClusterRequest.setter(Builder::securityGroupIds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SecurityGroupIds").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> MAINTENANCE_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("MaintenanceWindow").getter(UpdateClusterRequest.getter(UpdateClusterRequest::maintenanceWindow)).setter(UpdateClusterRequest.setter(Builder::maintenanceWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaintenanceWindow").build()}).build();
    private static final SdkField<String> SNS_TOPIC_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsTopicArn").getter(UpdateClusterRequest.getter(UpdateClusterRequest::snsTopicArn)).setter(UpdateClusterRequest.setter(Builder::snsTopicArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicArn").build()}).build();
    private static final SdkField<String> SNS_TOPIC_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnsTopicStatus").getter(UpdateClusterRequest.getter(UpdateClusterRequest::snsTopicStatus)).setter(UpdateClusterRequest.setter(Builder::snsTopicStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnsTopicStatus").build()}).build();
    private static final SdkField<String> PARAMETER_GROUP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ParameterGroupName").getter(UpdateClusterRequest.getter(UpdateClusterRequest::parameterGroupName)).setter(UpdateClusterRequest.setter(Builder::parameterGroupName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ParameterGroupName").build()}).build();
    private static final SdkField<String> SNAPSHOT_WINDOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("SnapshotWindow").getter(UpdateClusterRequest.getter(UpdateClusterRequest::snapshotWindow)).setter(UpdateClusterRequest.setter(Builder::snapshotWindow)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotWindow").build()}).build();
    private static final SdkField<Integer> SNAPSHOT_RETENTION_LIMIT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SnapshotRetentionLimit").getter(UpdateClusterRequest.getter(UpdateClusterRequest::snapshotRetentionLimit)).setter(UpdateClusterRequest.setter(Builder::snapshotRetentionLimit)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SnapshotRetentionLimit").build()}).build();
    private static final SdkField<String> NODE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NodeType").getter(UpdateClusterRequest.getter(UpdateClusterRequest::nodeType)).setter(UpdateClusterRequest.setter(Builder::nodeType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NodeType").build()}).build();
    private static final SdkField<String> ENGINE_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("EngineVersion").getter(UpdateClusterRequest.getter(UpdateClusterRequest::engineVersion)).setter(UpdateClusterRequest.setter(Builder::engineVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EngineVersion").build()}).build();
    private static final SdkField<ReplicaConfigurationRequest> REPLICA_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ReplicaConfiguration").getter(UpdateClusterRequest.getter(UpdateClusterRequest::replicaConfiguration)).setter(UpdateClusterRequest.setter(Builder::replicaConfiguration)).constructor(ReplicaConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ReplicaConfiguration").build()}).build();
    private static final SdkField<ShardConfigurationRequest> SHARD_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ShardConfiguration").getter(UpdateClusterRequest.getter(UpdateClusterRequest::shardConfiguration)).setter(UpdateClusterRequest.setter(Builder::shardConfiguration)).constructor(ShardConfigurationRequest::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ShardConfiguration").build()}).build();
    private static final SdkField<String> ACL_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ACLName").getter(UpdateClusterRequest.getter(UpdateClusterRequest::aclName)).setter(UpdateClusterRequest.setter(Builder::aclName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ACLName").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLUSTER_NAME_FIELD, DESCRIPTION_FIELD, SECURITY_GROUP_IDS_FIELD, MAINTENANCE_WINDOW_FIELD, SNS_TOPIC_ARN_FIELD, SNS_TOPIC_STATUS_FIELD, PARAMETER_GROUP_NAME_FIELD, SNAPSHOT_WINDOW_FIELD, SNAPSHOT_RETENTION_LIMIT_FIELD, NODE_TYPE_FIELD, ENGINE_VERSION_FIELD, REPLICA_CONFIGURATION_FIELD, SHARD_CONFIGURATION_FIELD, ACL_NAME_FIELD));
    private final String clusterName;
    private final String description;
    private final List<String> securityGroupIds;
    private final String maintenanceWindow;
    private final String snsTopicArn;
    private final String snsTopicStatus;
    private final String parameterGroupName;
    private final String snapshotWindow;
    private final Integer snapshotRetentionLimit;
    private final String nodeType;
    private final String engineVersion;
    private final ReplicaConfigurationRequest replicaConfiguration;
    private final ShardConfigurationRequest shardConfiguration;
    private final String aclName;

    private UpdateClusterRequest(BuilderImpl builder) {
        super(builder);
        this.clusterName = builder.clusterName;
        this.description = builder.description;
        this.securityGroupIds = builder.securityGroupIds;
        this.maintenanceWindow = builder.maintenanceWindow;
        this.snsTopicArn = builder.snsTopicArn;
        this.snsTopicStatus = builder.snsTopicStatus;
        this.parameterGroupName = builder.parameterGroupName;
        this.snapshotWindow = builder.snapshotWindow;
        this.snapshotRetentionLimit = builder.snapshotRetentionLimit;
        this.nodeType = builder.nodeType;
        this.engineVersion = builder.engineVersion;
        this.replicaConfiguration = builder.replicaConfiguration;
        this.shardConfiguration = builder.shardConfiguration;
        this.aclName = builder.aclName;
    }

    public final String clusterName() {
        return this.clusterName;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasSecurityGroupIds() {
        return this.securityGroupIds != null && !(this.securityGroupIds instanceof SdkAutoConstructList);
    }

    public final List<String> securityGroupIds() {
        return this.securityGroupIds;
    }

    public final String maintenanceWindow() {
        return this.maintenanceWindow;
    }

    public final String snsTopicArn() {
        return this.snsTopicArn;
    }

    public final String snsTopicStatus() {
        return this.snsTopicStatus;
    }

    public final String parameterGroupName() {
        return this.parameterGroupName;
    }

    public final String snapshotWindow() {
        return this.snapshotWindow;
    }

    public final Integer snapshotRetentionLimit() {
        return this.snapshotRetentionLimit;
    }

    public final String nodeType() {
        return this.nodeType;
    }

    public final String engineVersion() {
        return this.engineVersion;
    }

    public final ReplicaConfigurationRequest replicaConfiguration() {
        return this.replicaConfiguration;
    }

    public final ShardConfigurationRequest shardConfiguration() {
        return this.shardConfiguration;
    }

    public final String aclName() {
        return this.aclName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clusterName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSecurityGroupIds() ? this.securityGroupIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.maintenanceWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.snsTopicStatus());
        hashCode = 31 * hashCode + Objects.hashCode(this.parameterGroupName());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotWindow());
        hashCode = 31 * hashCode + Objects.hashCode(this.snapshotRetentionLimit());
        hashCode = 31 * hashCode + Objects.hashCode(this.nodeType());
        hashCode = 31 * hashCode + Objects.hashCode(this.engineVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.replicaConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.shardConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.aclName());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateClusterRequest)) {
            return false;
        }
        UpdateClusterRequest other = (UpdateClusterRequest)((Object)obj);
        return Objects.equals(this.clusterName(), other.clusterName()) && Objects.equals(this.description(), other.description()) && this.hasSecurityGroupIds() == other.hasSecurityGroupIds() && Objects.equals(this.securityGroupIds(), other.securityGroupIds()) && Objects.equals(this.maintenanceWindow(), other.maintenanceWindow()) && Objects.equals(this.snsTopicArn(), other.snsTopicArn()) && Objects.equals(this.snsTopicStatus(), other.snsTopicStatus()) && Objects.equals(this.parameterGroupName(), other.parameterGroupName()) && Objects.equals(this.snapshotWindow(), other.snapshotWindow()) && Objects.equals(this.snapshotRetentionLimit(), other.snapshotRetentionLimit()) && Objects.equals(this.nodeType(), other.nodeType()) && Objects.equals(this.engineVersion(), other.engineVersion()) && Objects.equals(this.replicaConfiguration(), other.replicaConfiguration()) && Objects.equals(this.shardConfiguration(), other.shardConfiguration()) && Objects.equals(this.aclName(), other.aclName());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateClusterRequest").add("ClusterName", (Object)this.clusterName()).add("Description", (Object)this.description()).add("SecurityGroupIds", this.hasSecurityGroupIds() ? this.securityGroupIds() : null).add("MaintenanceWindow", (Object)this.maintenanceWindow()).add("SnsTopicArn", (Object)this.snsTopicArn()).add("SnsTopicStatus", (Object)this.snsTopicStatus()).add("ParameterGroupName", (Object)this.parameterGroupName()).add("SnapshotWindow", (Object)this.snapshotWindow()).add("SnapshotRetentionLimit", (Object)this.snapshotRetentionLimit()).add("NodeType", (Object)this.nodeType()).add("EngineVersion", (Object)this.engineVersion()).add("ReplicaConfiguration", (Object)this.replicaConfiguration()).add("ShardConfiguration", (Object)this.shardConfiguration()).add("ACLName", (Object)this.aclName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClusterName": {
                return Optional.ofNullable(clazz.cast(this.clusterName()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "SecurityGroupIds": {
                return Optional.ofNullable(clazz.cast(this.securityGroupIds()));
            }
            case "MaintenanceWindow": {
                return Optional.ofNullable(clazz.cast(this.maintenanceWindow()));
            }
            case "SnsTopicArn": {
                return Optional.ofNullable(clazz.cast(this.snsTopicArn()));
            }
            case "SnsTopicStatus": {
                return Optional.ofNullable(clazz.cast(this.snsTopicStatus()));
            }
            case "ParameterGroupName": {
                return Optional.ofNullable(clazz.cast(this.parameterGroupName()));
            }
            case "SnapshotWindow": {
                return Optional.ofNullable(clazz.cast(this.snapshotWindow()));
            }
            case "SnapshotRetentionLimit": {
                return Optional.ofNullable(clazz.cast(this.snapshotRetentionLimit()));
            }
            case "NodeType": {
                return Optional.ofNullable(clazz.cast(this.nodeType()));
            }
            case "EngineVersion": {
                return Optional.ofNullable(clazz.cast(this.engineVersion()));
            }
            case "ReplicaConfiguration": {
                return Optional.ofNullable(clazz.cast(this.replicaConfiguration()));
            }
            case "ShardConfiguration": {
                return Optional.ofNullable(clazz.cast(this.shardConfiguration()));
            }
            case "ACLName": {
                return Optional.ofNullable(clazz.cast(this.aclName()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateClusterRequest, T> g) {
        return obj -> g.apply((UpdateClusterRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MemoryDbRequest.BuilderImpl
    implements Builder {
        private String clusterName;
        private String description;
        private List<String> securityGroupIds = DefaultSdkAutoConstructList.getInstance();
        private String maintenanceWindow;
        private String snsTopicArn;
        private String snsTopicStatus;
        private String parameterGroupName;
        private String snapshotWindow;
        private Integer snapshotRetentionLimit;
        private String nodeType;
        private String engineVersion;
        private ReplicaConfigurationRequest replicaConfiguration;
        private ShardConfigurationRequest shardConfiguration;
        private String aclName;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateClusterRequest model) {
            super(model);
            this.clusterName(model.clusterName);
            this.description(model.description);
            this.securityGroupIds(model.securityGroupIds);
            this.maintenanceWindow(model.maintenanceWindow);
            this.snsTopicArn(model.snsTopicArn);
            this.snsTopicStatus(model.snsTopicStatus);
            this.parameterGroupName(model.parameterGroupName);
            this.snapshotWindow(model.snapshotWindow);
            this.snapshotRetentionLimit(model.snapshotRetentionLimit);
            this.nodeType(model.nodeType);
            this.engineVersion(model.engineVersion);
            this.replicaConfiguration(model.replicaConfiguration);
            this.shardConfiguration(model.shardConfiguration);
            this.aclName(model.aclName);
        }

        public final String getClusterName() {
            return this.clusterName;
        }

        public final void setClusterName(String clusterName) {
            this.clusterName = clusterName;
        }

        @Override
        @Transient
        public final Builder clusterName(String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getSecurityGroupIds() {
            if (this.securityGroupIds instanceof SdkAutoConstructList) {
                return null;
            }
            return this.securityGroupIds;
        }

        public final void setSecurityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
        }

        @Override
        @Transient
        public final Builder securityGroupIds(Collection<String> securityGroupIds) {
            this.securityGroupIds = SecurityGroupIdsListCopier.copy(securityGroupIds);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder securityGroupIds(String ... securityGroupIds) {
            this.securityGroupIds(Arrays.asList(securityGroupIds));
            return this;
        }

        public final String getMaintenanceWindow() {
            return this.maintenanceWindow;
        }

        public final void setMaintenanceWindow(String maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
        }

        @Override
        @Transient
        public final Builder maintenanceWindow(String maintenanceWindow) {
            this.maintenanceWindow = maintenanceWindow;
            return this;
        }

        public final String getSnsTopicArn() {
            return this.snsTopicArn;
        }

        public final void setSnsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
        }

        @Override
        @Transient
        public final Builder snsTopicArn(String snsTopicArn) {
            this.snsTopicArn = snsTopicArn;
            return this;
        }

        public final String getSnsTopicStatus() {
            return this.snsTopicStatus;
        }

        public final void setSnsTopicStatus(String snsTopicStatus) {
            this.snsTopicStatus = snsTopicStatus;
        }

        @Override
        @Transient
        public final Builder snsTopicStatus(String snsTopicStatus) {
            this.snsTopicStatus = snsTopicStatus;
            return this;
        }

        public final String getParameterGroupName() {
            return this.parameterGroupName;
        }

        public final void setParameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
        }

        @Override
        @Transient
        public final Builder parameterGroupName(String parameterGroupName) {
            this.parameterGroupName = parameterGroupName;
            return this;
        }

        public final String getSnapshotWindow() {
            return this.snapshotWindow;
        }

        public final void setSnapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
        }

        @Override
        @Transient
        public final Builder snapshotWindow(String snapshotWindow) {
            this.snapshotWindow = snapshotWindow;
            return this;
        }

        public final Integer getSnapshotRetentionLimit() {
            return this.snapshotRetentionLimit;
        }

        public final void setSnapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
        }

        @Override
        @Transient
        public final Builder snapshotRetentionLimit(Integer snapshotRetentionLimit) {
            this.snapshotRetentionLimit = snapshotRetentionLimit;
            return this;
        }

        public final String getNodeType() {
            return this.nodeType;
        }

        public final void setNodeType(String nodeType) {
            this.nodeType = nodeType;
        }

        @Override
        @Transient
        public final Builder nodeType(String nodeType) {
            this.nodeType = nodeType;
            return this;
        }

        public final String getEngineVersion() {
            return this.engineVersion;
        }

        public final void setEngineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
        }

        @Override
        @Transient
        public final Builder engineVersion(String engineVersion) {
            this.engineVersion = engineVersion;
            return this;
        }

        public final ReplicaConfigurationRequest.Builder getReplicaConfiguration() {
            return this.replicaConfiguration != null ? this.replicaConfiguration.toBuilder() : null;
        }

        public final void setReplicaConfiguration(ReplicaConfigurationRequest.BuilderImpl replicaConfiguration) {
            this.replicaConfiguration = replicaConfiguration != null ? replicaConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder replicaConfiguration(ReplicaConfigurationRequest replicaConfiguration) {
            this.replicaConfiguration = replicaConfiguration;
            return this;
        }

        public final ShardConfigurationRequest.Builder getShardConfiguration() {
            return this.shardConfiguration != null ? this.shardConfiguration.toBuilder() : null;
        }

        public final void setShardConfiguration(ShardConfigurationRequest.BuilderImpl shardConfiguration) {
            this.shardConfiguration = shardConfiguration != null ? shardConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder shardConfiguration(ShardConfigurationRequest shardConfiguration) {
            this.shardConfiguration = shardConfiguration;
            return this;
        }

        public final String getAclName() {
            return this.aclName;
        }

        public final void setAclName(String aclName) {
            this.aclName = aclName;
        }

        @Override
        @Transient
        public final Builder aclName(String aclName) {
            this.aclName = aclName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateClusterRequest build() {
            return new UpdateClusterRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends MemoryDbRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateClusterRequest> {
        public Builder clusterName(String var1);

        public Builder description(String var1);

        public Builder securityGroupIds(Collection<String> var1);

        public Builder securityGroupIds(String ... var1);

        public Builder maintenanceWindow(String var1);

        public Builder snsTopicArn(String var1);

        public Builder snsTopicStatus(String var1);

        public Builder parameterGroupName(String var1);

        public Builder snapshotWindow(String var1);

        public Builder snapshotRetentionLimit(Integer var1);

        public Builder nodeType(String var1);

        public Builder engineVersion(String var1);

        public Builder replicaConfiguration(ReplicaConfigurationRequest var1);

        default public Builder replicaConfiguration(Consumer<ReplicaConfigurationRequest.Builder> replicaConfiguration) {
            return this.replicaConfiguration((ReplicaConfigurationRequest)((ReplicaConfigurationRequest.Builder)ReplicaConfigurationRequest.builder().applyMutation(replicaConfiguration)).build());
        }

        public Builder shardConfiguration(ShardConfigurationRequest var1);

        default public Builder shardConfiguration(Consumer<ShardConfigurationRequest.Builder> shardConfiguration) {
            return this.shardConfiguration((ShardConfigurationRequest)((ShardConfigurationRequest.Builder)ShardConfigurationRequest.builder().applyMutation(shardConfiguration)).build());
        }

        public Builder aclName(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

