/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.medicalimaging.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.medicalimaging.model.DICOMImportJobProperties;
import software.amazon.awssdk.services.medicalimaging.model.MedicalImagingResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetDicomImportJobResponse
extends MedicalImagingResponse
implements ToCopyableBuilder<Builder, GetDicomImportJobResponse> {
    private static final SdkField<DICOMImportJobProperties> JOB_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("jobProperties").getter(GetDicomImportJobResponse.getter(GetDicomImportJobResponse::jobProperties)).setter(GetDicomImportJobResponse.setter(Builder::jobProperties)).constructor(DICOMImportJobProperties::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobProperties").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_PROPERTIES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetDicomImportJobResponse.memberNameToFieldInitializer();
    private final DICOMImportJobProperties jobProperties;

    private GetDicomImportJobResponse(BuilderImpl builder) {
        super(builder);
        this.jobProperties = builder.jobProperties;
    }

    public final DICOMImportJobProperties jobProperties() {
        return this.jobProperties;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.jobProperties());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetDicomImportJobResponse)) {
            return false;
        }
        GetDicomImportJobResponse other = (GetDicomImportJobResponse)((Object)obj);
        return Objects.equals(this.jobProperties(), other.jobProperties());
    }

    public final String toString() {
        return ToString.builder((String)"GetDicomImportJobResponse").add("JobProperties", (Object)this.jobProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "jobProperties": {
                return Optional.ofNullable(clazz.cast(this.jobProperties()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<DICOMImportJobProperties>> map = new HashMap<String, SdkField<DICOMImportJobProperties>>();
        map.put("jobProperties", JOB_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetDicomImportJobResponse, T> g) {
        return obj -> g.apply((GetDicomImportJobResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends MedicalImagingResponse.BuilderImpl
    implements Builder {
        private DICOMImportJobProperties jobProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(GetDicomImportJobResponse model) {
            super(model);
            this.jobProperties(model.jobProperties);
        }

        public final DICOMImportJobProperties.Builder getJobProperties() {
            return this.jobProperties != null ? this.jobProperties.toBuilder() : null;
        }

        public final void setJobProperties(DICOMImportJobProperties.BuilderImpl jobProperties) {
            this.jobProperties = jobProperties != null ? jobProperties.build() : null;
        }

        @Override
        public final Builder jobProperties(DICOMImportJobProperties jobProperties) {
            this.jobProperties = jobProperties;
            return this;
        }

        @Override
        public GetDicomImportJobResponse build() {
            return new GetDicomImportJobResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends MedicalImagingResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetDicomImportJobResponse> {
        public Builder jobProperties(DICOMImportJobProperties var1);

        default public Builder jobProperties(Consumer<DICOMImportJobProperties.Builder> jobProperties) {
            return this.jobProperties((DICOMImportJobProperties)((DICOMImportJobProperties.Builder)DICOMImportJobProperties.builder().applyMutation(jobProperties)).build());
        }
    }
}

